<?php



include "utils.php";



$dbConn = connect($db);

$personalizacion = json_decode(file_get_contents('../personalizacion.json'), true);

/*

listar todos los posts o solo uno

 */

if ($_SERVER['REQUEST_METHOD'] == 'GET') {
    if (isset($_GET["feriados"])) {

        $where = [];
        $params = [];

        // Filtro por año (extraído de fecha_i)
        if (!empty($_GET["ano"]) &&  $_GET["ano"] != "No") {
            $where[] = "YEAR(fecha_i) = :ano";
            $params[':ano'] = $_GET["ano"];
        }

        // Filtro por tipo
        if (!empty($_GET["tipo"]) &&  $_GET["tipo"] != "No") {
            $where[] = "tipo = :tipo";
            $params[':tipo'] = $_GET["tipo"];
        }

        // Construcción del SQL con filtros dinámicos
        $sqlQuery = "SELECT * FROM feriados";
        if (!empty($where)) {
            $sqlQuery .= " WHERE " . implode(" AND ", $where);
        }


        $sql = $dbConn->prepare($sqlQuery);

        // Asignar los valores a los parámetros
        foreach ($params as $key => $value) {
            $sql->bindValue($key, $value);
        }

        $sql->execute();
        $sql->setFetchMode(PDO::FETCH_ASSOC);
        $feriados = $sql->fetchAll(PDO::FETCH_OBJ);

        // Obtener ubicaciones para cada feriado
        foreach ($feriados as $f) {
            $sql = $dbConn->prepare("
            SELECT f.*, 
                   COALESCE(p.nombre, 'Ninguna') AS nombre_provincia,
                   COALESCE(l.nombre, 'Ninguna') AS nombre_localidad 
            FROM ubicacion_feriado f
            LEFT JOIN provincias p ON p.id_provincia = f.id_provincia
            LEFT JOIN localidades l ON l.id_localidad = f.id_localidad
            WHERE f.id_feriado = :id_feriado
        ");
            $sql->bindValue(':id_feriado', $f->id_feriado);
            $sql->execute();
            $sql->setFetchMode(PDO::FETCH_ASSOC);
            $f->ubis = $sql->fetchAll(PDO::FETCH_OBJ);
        }

        header("HTTP/1.1 200 OK");
        echo json_encode($feriados);
        exit();
    } else if (isset($_GET['miembros'])) {
        $sqlUsers = $dbConn->prepare("
        SELECT DISTINCT u.user_id, u.user_full_name,
        u.id_provincia,
        u.id_localidad
        FROM users u
        INNER JOIN vacaciones v ON u.user_id = v.user_id
        ");
        $sqlUsers->execute();
        $usuarios = $sqlUsers->fetchAll(PDO::FETCH_ASSOC);

        $respuesta = [];
        $hoy = new DateTime();

        foreach ($usuarios as $usuario) {
            $sqlVac = $dbConn->prepare("
            SELECT *
            FROM vacaciones
            WHERE user_id = :user_id
            ORDER BY fecha_i ASC
        ");
            $sqlVac->bindValue(':user_id', $usuario['user_id']);
            $sqlVac->execute();
            $vacaciones = $sqlVac->fetchAll(PDO::FETCH_ASSOC);





            if (count($vacaciones) > 0) {
                $diasTotales = 0;
                $diasDisfrutados = 0;
                $diasPendientes = 0;

                foreach ($vacaciones as &$v) {
                    $fecha_inicio = $v['fecha_i']; // <-- ajustá esto con tu valor real
                    $fecha_fin = $v['fecha_f'];    // <-- ajustá esto también

                    $id_provincia2 = $usuario['id_provincia'];
                    $id_localidad2 = $usuario['id_localidad'];

                    $feriados2 = [];
                    $feriadosData2 = [];

                    $queryFeriados2 = "
            SELECT DISTINCT f.*
            FROM feriados f
            INNER JOIN ubicacion_feriado uf ON f.id_feriado = uf.id_feriado
            WHERE 
            f.fecha_i BETWEEN :fecha_inicio AND :fecha_fin
                AND (
                    (uf.id_provincia IS NULL AND uf.id_localidad IS NULL)
            ";

                    // Si id_provincia tiene valor y localidad no
                    if ($id_provincia2 !== null && $id_localidad2 === null) {
                        $queryFeriados2 .= "
            OR (uf.id_provincia = :id_provincia AND uf.id_localidad IS NULL)
            ";
                    }

                    // Si ambos tienen valor
                    elseif ($id_provincia2 !== null && $id_localidad2 !== null) {
                        $queryFeriados2 .= "
            OR (uf.id_provincia = :id_provincia AND uf.id_localidad IS NULL)
            OR (uf.id_provincia = :id_provincia AND uf.id_localidad = :id_localidad)
                ";
                    }

                    // Cerrar el paréntesis de la subcondición
                    $queryFeriados2 .= ")
        
            ";

                    $sqlFeriados2 = $dbConn->prepare($queryFeriados2);

                    // Asignar valores a los parámetros

                    $sqlFeriados2->bindValue(':fecha_inicio', $fecha_inicio);
                    $sqlFeriados2->bindValue(':fecha_fin', $fecha_fin);


                    if ($id_provincia2 !== null) {
                        $sqlFeriados2->bindValue(':id_provincia', $id_provincia2, PDO::PARAM_INT);
                    }
                    if ($id_localidad2 !== null) {
                        $sqlFeriados2->bindValue(':id_localidad', $id_localidad2, PDO::PARAM_INT);
                    }

                    $sqlFeriados2->execute();
                    $feriadosData2 = $sqlFeriados2->fetchAll(PDO::FETCH_ASSOC);

                    $v["feriados"] = $feriadosData2;







                    $inicio = new DateTime($v['fecha_i']);
                    $fin = new DateTime($v['fecha_f']);
                    $dias = $inicio->diff($fin)->days + 1; // incluir ambos días
                    $diasTotales += $dias;

                    if ($fin < $hoy) {
                        $diasDisfrutados += $dias;
                    } else {
                        $diasPendientes += $dias;
                    }
                }

                $respuesta[] = [
                    'user_id' => $usuario['user_id'],
                    'nombre' => $usuario['user_full_name'],
                    'dias_totales' => $diasTotales,
                    'dias_disfrutados' => $diasDisfrutados,
                    'dias_pendientes' => $diasPendientes,
                    'periodos' => $vacaciones
                ];
            }
        }

        header('Content-Type: application/json');
        echo json_encode($respuesta);
        exit;
    } else if (isset($_GET['id_feriado'])) {

        //Mostrar un post

        $sql = $dbConn->prepare("
                SELECT * FROM feriados
            WHERE 
                id_feriado = :id_feriado
            ");

        $sql->bindValue(':id_feriado', $_GET['id_feriado']);

        $sql->execute();

        $vacacion = $sql->fetch(PDO::FETCH_ASSOC);
        header("HTTP/1.1 200 OK");

        echo json_encode($vacacion);

        exit();
    } else  if (isset($_GET['id_ubicacion_feriado'])) {

        //Mostrar un post

        $sql = $dbConn->prepare("
                SELECT * FROM ubicacion_feriado
            WHERE 
                id_ubicacion_feriado = :id_ubicacion_feriado
            ");

        $sql->bindValue(':id_ubicacion_feriado', $_GET['id_ubicacion_feriado']);

        $sql->execute();

        $vacacion = $sql->fetch(PDO::FETCH_ASSOC);
        header("HTTP/1.1 200 OK");

        echo json_encode($vacacion);

        exit();
    } else if (isset($_GET['id_vacacion'])) {

        //Mostrar un post

        $sql = $dbConn->prepare("
                SELECT 
                vacaciones.*, 
                users.user_full_name AS usuario,
                users.color AS user_color
            FROM 
                vacaciones
            INNER JOIN 
                users ON vacaciones.user_id = users.user_id
            WHERE 
                id_vacacion = :id_vacacion
            ");

        $sql->bindValue(':id_vacacion', $_GET['id_vacacion']);

        $sql->execute();

        $vacacion = $sql->fetch(PDO::FETCH_ASSOC);

        $color = $vacacion['user_color'] ?? htmlentities($personalizacion["color_elementos"], ENT_QUOTES);

        $vacacion2 = [
            'id' => $vacacion['id_vacacion'],
            'title' => $vacacion['usuario'],
            'start' => $vacacion['fecha_i'],
            'end' => date('Y-m-d', strtotime($vacacion['fecha_f'])), // FullCalendar no incluye la fecha final
            'color' => $color,
            'extendedProps' => [
                'usuario' => $vacacion['usuario'],
                'estado' => $vacacion['estado'],
                'observaciones' => $vacacion['observaciones'],
                'user_id' => $vacacion['user_id']
            ]
        ];


        header("HTTP/1.1 200 OK");

        echo json_encode($vacacion2);

        exit();
    } else {


        $filtros = [];
        $parametros = [];

        // Filtros opcionales
        if (isset($_GET['user_id']) && $_GET['user_id'] !== 'No') {
            $filtros[] = 'vacaciones.user_id = :user_id';
            $parametros[':user_id'] = $_GET['user_id'];
        }

        if (isset($_GET['estado']) && $_GET['estado'] !== 'No') {
            $filtros[] = 'vacaciones.estado = :estado';
            $parametros[':estado'] = $_GET['estado'];
        }

        // -------------------------------
        // Consulta de eventos
        // -------------------------------
        $query = "
    SELECT 
        vacaciones.*, 
        users.user_full_name AS usuario,
        users.color AS user_color,
        users.id_provincia,
        users.id_localidad

    FROM 
        vacaciones
    INNER JOIN 
        users ON vacaciones.user_id = users.user_id
";

        // Agregar condiciones si hay filtros
        if (!empty($filtros)) {
            $query .= ' WHERE ' . implode(' AND ', $filtros);
        }

        $sql = $dbConn->prepare($query);
        foreach ($parametros as $clave => $valor) {
            $sql->bindValue($clave, $valor);
        }
        $sql->execute();
        $sql->setFetchMode(PDO::FETCH_ASSOC);
        $datos = $sql->fetchAll();

        // -------------------------------
        // Construcción de eventos
        // -------------------------------
        $eventos = [];

        foreach ($datos as $vacacion) {
            $color = $vacacion['user_color'] ?? htmlentities($personalizacion["color_elementos"], ENT_QUOTES);
            $id_provincia2 = $vacacion['id_provincia'];
            $id_localidad2 = $vacacion['id_localidad'];
            $fecha_inicio = $vacacion['fecha_i']; // <-- ajustá esto con tu valor real
            $fecha_fin = $vacacion['fecha_f'];    // <-- ajustá esto también

            $feriados2 = [];
            $feriadosData2 = [];

            $queryFeriados2 = "
    SELECT DISTINCT f.*
    FROM feriados f
    INNER JOIN ubicacion_feriado uf ON f.id_feriado = uf.id_feriado
    WHERE 
        f.fecha_i BETWEEN :fecha_inicio AND :fecha_fin
        AND (
            (uf.id_provincia IS NULL AND uf.id_localidad IS NULL)
";

            // Si id_provincia tiene valor y localidad no
            if ($id_provincia2 !== null && $id_localidad2 === null) {
                $queryFeriados2 .= "
        OR (uf.id_provincia = :id_provincia AND uf.id_localidad IS NULL)
    ";
            }

            // Si ambos tienen valor
            elseif ($id_provincia2 !== null && $id_localidad2 !== null) {
                $queryFeriados2 .= "
        OR (uf.id_provincia = :id_provincia AND uf.id_localidad IS NULL)
        OR (uf.id_provincia = :id_provincia AND uf.id_localidad = :id_localidad)
    ";
            }

            // Cerrar el paréntesis de la subcondición
            $queryFeriados2 .= "
        )
";

            $sqlFeriados2 = $dbConn->prepare($queryFeriados2);

            // Asignar valores a los parámetros
            $sqlFeriados2->bindValue(':fecha_inicio', $fecha_inicio);
            $sqlFeriados2->bindValue(':fecha_fin', $fecha_fin);

            if ($id_provincia2 !== null) {
                $sqlFeriados2->bindValue(':id_provincia', $id_provincia2, PDO::PARAM_INT);
            }
            if ($id_localidad2 !== null) {
                $sqlFeriados2->bindValue(':id_localidad', $id_localidad2, PDO::PARAM_INT);
            }

            $sqlFeriados2->execute();
            $feriadosData2 = $sqlFeriados2->fetchAll(PDO::FETCH_ASSOC);
            $eventos[] = [
                'id' => $vacacion['id_vacacion'],
                'title' => $vacacion['usuario'],
                'start' => $vacacion['fecha_i'],

                'end' => date('Y-m-d', strtotime($vacacion['fecha_f'] . ' +1 day')),
                'color' => $color,
                'extendedProps' => [
                    'usuario' => $vacacion['usuario'],
                    'estado' => $vacacion['estado'],
                    'tipo' => 'eventos',
                    'observaciones' => $vacacion['observaciones'],
                    'user_id' => $vacacion['user_id'],
                    "feriados" => $feriadosData2
                ]
            ];
        }

        // -------------------------------
        // Totales
        // -------------------------------
        $today = date('Y-m-d');

        // Total de usuarios
        $sqlTotalUsers = $dbConn->prepare("SELECT COUNT(*) FROM users");
        $sqlTotalUsers->execute();
        $totalUsuarios = $sqlTotalUsers->fetchColumn();

        // Usuarios con vacaciones hoy
        $sqlConVacacionesHoy = $dbConn->prepare("
    SELECT COUNT(DISTINCT user_id)
    FROM vacaciones
    WHERE :today BETWEEN fecha_i AND fecha_f
");
        $sqlConVacacionesHoy->bindValue(':today', $today);
        $sqlConVacacionesHoy->execute();
        $usuariosConVacacionesHoy = $sqlConVacacionesHoy->fetchColumn();

        // Usuarios sin vacaciones hoy
        $usuariosSinVacacionesHoy = $totalUsuarios - $usuariosConVacacionesHoy;

        // Número de vacaciones con estado 'Pendiente'
        $sqlPendientes = $dbConn->prepare("SELECT COUNT(*) FROM vacaciones WHERE estado = 'Pendiente'");
        $sqlPendientes->execute();
        $vacacionesPendientes = $sqlPendientes->fetchColumn();

        // -------------------------------
        // Devolver respuesta
        // -------------------------------
        $id_provincia = (isset($_GET['id_provincia']) && $_GET['id_provincia'] !== 'No') ? $_GET['id_provincia'] : null;
        $id_localidad = (isset($_GET['id_localidad']) && $_GET['id_localidad'] !== 'No') ? $_GET['id_localidad'] : null;

        $feriados = [];
        $feriadosData = [];

        $queryFeriados = "
    SELECT DISTINCT f.*
    FROM feriados f
    INNER JOIN ubicacion_feriado uf ON f.id_feriado = uf.id_feriado
    WHERE 
        (uf.id_provincia IS NULL AND uf.id_localidad IS NULL)
";

        // Si id_provincia tiene valor y localidad no
        if ($id_provincia !== null && $id_localidad === null) {
            $queryFeriados .= "
        OR (uf.id_provincia = :id_provincia AND uf.id_localidad IS NULL)
    ";
        }

        // Si ambos tienen valor
        elseif ($id_provincia !== null && $id_localidad !== null) {
            $queryFeriados .= "
        OR (uf.id_provincia = :id_provincia AND uf.id_localidad IS NULL)
        OR (uf.id_provincia = :id_provincia AND uf.id_localidad = :id_localidad)
    ";
        }

        $sqlFeriados = $dbConn->prepare($queryFeriados);

        // Asignar valores si corresponde
        if ($id_provincia !== null) {
            $sqlFeriados->bindValue(':id_provincia', $id_provincia, PDO::PARAM_INT);
        }
        if ($id_localidad !== null) {
            $sqlFeriados->bindValue(':id_localidad', $id_localidad, PDO::PARAM_INT);
        }

        $sqlFeriados->execute();
        $feriadosData = $sqlFeriados->fetchAll(PDO::FETCH_ASSOC);


        $color = '#000000';
        $feriados = [];


        foreach ($feriadosData as $feriado) {
            if ($feriado['tipo'] == "Nacional") {
                $color = $personalizacion["color_nacionales"];
            }

            if ($feriado['tipo'] == "Autonómico") {
                $color = $personalizacion["color_autonomicos"];
            }

            if ($feriado['tipo'] == "Local") {
                $color = $personalizacion["color_locales"];
            }
            $color;
            $feriados[] = [
                'id' => $feriado['id_feriado'],
                'title' => $feriado['descripcion'],
                'start' => $feriado['fecha_i'],
                'end' => date('Y-m-d', strtotime($feriado['fecha_f'] . ' +1 day')),
                'color' => $color,
                'extendedProps' => [
                    'tipo' => 'feriados',
                    'tipo2' => $feriado['tipo'],
                    'descripcion' => $feriado['descripcion']
                ]
            ];
        }





        header('Content-Type: application/json');
        echo json_encode([
            'eventos' => $eventos,
            'feriados' => $feriados,
            'resumen' => [
                'usuarios_totales' => (int) $totalUsuarios,
                'usuarios_con_vacaciones_hoy' => (int) $usuariosConVacacionesHoy,
                'usuarios_sin_vacaciones_hoy' => (int) $usuariosSinVacacionesHoy,
                'vacaciones_pendientes' => (int) $vacacionesPendientes
            ]
        ]);
        exit;
    }
}















// Crear un nuevo post

if ($_SERVER['REQUEST_METHOD'] == 'POST') {

    if (
        isset($_POST["periodos"]) &&
        isset($_POST["user_id"]) &&
        isset($_POST["estado"])
    ) {
        foreach ($_POST as $key => $value) {
            $value = ($value == "") ? null : $value;
            $value = ($value == "No") ? null : $value;
            $$key = $value;
        }

        $periodos = json_decode($periodos, true);
        for ($i = 0; $i < count($periodos); $i++) {
            $startA = new DateTime($periodos[$i]['fecha_i']);
            $endA = new DateTime($periodos[$i]['fecha_f']);

            for ($j = $i + 1; $j < count($periodos); $j++) {
                $startB = new DateTime($periodos[$j]['fecha_i']);
                $endB = new DateTime($periodos[$j]['fecha_f']);

                // Si las fechas se solapan: A empieza antes de que termine B y termina después de que empieza B
                if ($startA <= $endB && $endA >= $startB) {
                    $response = [
                        'success' => false,
                        'title' => "Conflicto entre periodos",
                        'message' => "Los periodos ingresados se solapan entre sí: del {$periodos[$i]['fecha_i']} al {$periodos[$i]['fecha_f']} y del {$periodos[$j]['fecha_i']} al {$periodos[$j]['fecha_f']}."
                    ];
                    echo json_encode($response);
                    exit();
                }
            }
        }

        $dias_nuevos_count = 0;
        $all_nuevos_dias = [];
        foreach ($periodos as $periodo) {
            $dias = obtenerDiasEntreFechas($periodo['fecha_i'], $periodo['fecha_f']);
            $all_nuevos_dias = array_merge($all_nuevos_dias, $dias);
            $dias_nuevos_count += calcularDiasNetosUsuario($dbConn, $user_id, $periodo['fecha_i'], $periodo['fecha_f']);
        }

        $dias_existentes = obtenerDiasVacacionesExistentes($dbConn, $user_id, isset($id_vacacion) ? $id_vacacion : null);

        $dias_comunes = array_intersect($dias_existentes, $all_nuevos_dias);
        $dias_actuales_count = obtenerFeriadosPeriodo($dbConn, $user_id);

        // $total_dias = count(array_unique(array_merge($dias_existentes, $all_nuevos_dias)));
        $total_dias = $dias_nuevos_count + $dias_actuales_count;
        if (!empty($dias_comunes)) {
            $response = [
                'success' => false,
                'title' => "Fechas duplicadas",
                'message' => "Algunos días ya están ocupados por vacaciones existentes."
            ];
            echo json_encode($response);
            exit();
        }

        if ($total_dias > intval($personalizacion["dias_totales_vacaciones"])) {
            $response = [
                'success' => false,
                'title' => $total_dias . " son demasiados días",
                'message' => "No se pueden registrar más de " . intval($personalizacion["dias_totales_vacaciones"]) . " días de vacaciones por usuario."
            ];
            echo json_encode($response);
            exit();
        }




        foreach ($periodos as $periodo) {
            $fecha_i = $periodo['fecha_i'];
            $fecha_f = $periodo['fecha_f'];

            try {

                // INSERT
                $sql = "INSERT INTO vacaciones
                            (fecha_i, fecha_f, user_id, estado)
                        VALUES
                            (:fecha_i, :fecha_f, :user_id, :estado)";
                $statement = $dbConn->prepare($sql);


                // Valores comunes para ambas operaciones
                $statement->bindValue(':fecha_i', $fecha_i);
                $statement->bindValue(':fecha_f', $fecha_f);
                $statement->bindValue(':user_id', $user_id);
                $statement->bindValue(':estado', $estado);

                $statement->execute();
            } catch (PDOException $e) {
                $response = array(
                    'success' => false,
                    'title' => "Error en la operación.",
                    'message' => "Hubo un problema al guardar los datos: " . $e->getMessage()
                );

                header("HTTP/1.1 200 OK");
                echo json_encode($response);
                exit();
            }
        }


        $response = array(
            'success' => true,
            'title' => isset($id_vacacion) ? 'Período actualizado.' : 'Período registrado.',
            'message' => isset($id_vacacion)
                ? 'La vacación se ha actualizado correctamente.'
                : 'La vacación se ha registrado correctamente.'
        );

        header("HTTP/1.1 200 OK");
        echo json_encode($response);
        exit();

        try {
        } catch (PDOException $e) {
            $response = array(
                'success' => false,
                'title' => "Error en la operación.",
                'message' => "Hubo un problema al guardar los datos: " . $e->getMessage()
            );

            header("HTTP/1.1 200 OK");
            echo json_encode($response);
            exit();
        }
    }

    if (
        isset($_POST["fecha_i"]) &&
        isset($_POST["fecha_f"]) &&
        isset($_POST["user_id"]) &&
        isset($_POST["observaciones"]) &&
        isset($_POST["estado"])
    ) {
        foreach ($_POST as $key => $value) {
            $value = ($value == "") ? null : $value;
            $value = ($value == "No") ? null : $value;
            $$key = $value;
        }

        $all_nuevos_dias = obtenerDiasEntreFechas($fecha_i, $fecha_f);

        $dias_existentes = obtenerDiasVacacionesExistentes($dbConn, $user_id, isset($id_vacacion) ? $id_vacacion : null);
        $dias_nuevos_count = calcularDiasNetosUsuario($dbConn, $user_id, $fecha_i, $fecha_f);
        $dias_actuales_count = obtenerFeriadosPeriodo($dbConn, $user_id);
        $dias_comunes = array_intersect($dias_existentes, $all_nuevos_dias);
        //$total_dias = count(array_unique(array_merge($dias_existentes, $all_nuevos_dias)));
        $total_dias = $dias_nuevos_count + $dias_actuales_count;
        if (!empty($dias_comunes)) {
            $response = [
                'success' => false,
                'title' => "Fechas duplicadas",
                'message' => "Algunos días ya están ocupados por vacaciones existentes."
            ];
            echo json_encode($response);
            exit();
        }

        if ($total_dias > intval($personalizacion["dias_totales_vacaciones"])) {
            $response = [
                'success' => false,
                'title' => $total_dias . " son demasiados días",
                'message' => "No se pueden registrar más de " . intval($personalizacion["dias_totales_vacaciones"]) . " días de vacaciones por usuario."
            ];
            echo json_encode($response);
            exit();
        }

        try {






            if (isset($_POST["id_vacacion"])) {
                // UPDATE
                $id_vacacion = $_POST["id_vacacion"];
                $sql = "UPDATE vacaciones SET 
                        fecha_i = :fecha_i,
                        fecha_f = :fecha_f,
                         observaciones = :observaciones,
                        user_id = :user_id,
                        estado = :estado
                    WHERE id_vacacion = :id_vacacion";
                $statement = $dbConn->prepare($sql);
                $statement->bindValue(':id_vacacion', $id_vacacion);
            } else {
                // INSERT
                $sql = "INSERT INTO vacaciones
                        (fecha_i,observaciones, fecha_f, user_id, estado)
                    VALUES
                        (:fecha_i, :observaciones, :fecha_f, :user_id, :estado)";
                $statement = $dbConn->prepare($sql);
            }
            $statement->bindValue(':observaciones', $observaciones);
            // Valores comunes para ambas operaciones
            $statement->bindValue(':fecha_i', $fecha_i);
            $statement->bindValue(':fecha_f', $fecha_f);
            $statement->bindValue(':user_id', $user_id);
            $statement->bindValue(':estado', $estado);

            $statement->execute();

            $response = array(
                'success' => true,
                'title' => isset($id_vacacion) ? 'Período actualizado.' : 'Período registrado.',
                'message' => isset($id_vacacion)
                    ? 'La vacación se ha actualizado correctamente.'
                    : 'La vacación se ha registrado correctamente.'
            );

            header("HTTP/1.1 200 OK");
            echo json_encode($response);
            exit();
        } catch (PDOException $e) {
            $response = array(
                'success' => false,
                'title' => "Error en la operación.",
                'message' => "Hubo un problema al guardar los datos: " . $e->getMessage()
            );

            header("HTTP/1.1 200 OK");
            echo json_encode($response);
            exit();
        }
    } elseif (isset($_POST['import_feriados'])) {

        $jsonData = $_POST['import_feriados'];
        $items = json_decode($jsonData, true);
        $todoCorrecto = true;

        try {
            if (json_last_error() === JSON_ERROR_NONE && is_array($items)) {
                foreach ($items as $item) {
                    foreach ($item as $key => $value) {
                        $value = ($value === "" || $value === null) ? null : $value;
                        $$key = $value;
                    }

                    $Provincia = ($Provincia != "Ninguna") ? $Provincia : null;
                    $Localidad = ($Localidad != "Ninguna") ? $Localidad : null;

                    if ($Provincia == null && $Localidad == null) {
                        $tipo = "Nacional";
                    } elseif ($Provincia != null && $Localidad == null) {
                        $tipo = "Autonómico";
                    } else {
                        $tipo = "Local";
                    }

                    $fecha_i = $Fecha;
                    $fecha_f = $Fecha;
                    $descripcion = $Nombre;

                    // Insertar en feriados
                    $sql = "INSERT INTO feriados (tipo, fecha_i, fecha_f, descripcion)
                        VALUES (:tipo, :fecha_i, :fecha_f, :descripcion)";
                    $statement = $dbConn->prepare($sql);
                    $statement->bindValue(':tipo', $tipo);
                    $statement->bindValue(':fecha_i', $fecha_i);
                    $statement->bindValue(':fecha_f', $fecha_f);
                    $statement->bindValue(':descripcion', $descripcion);

                    if (!$statement->execute()) {
                        $todoCorrecto = false;
                        break;
                    }

                    $id_feriado = $dbConn->lastInsertId();

                    // Obtener id_provincia si aplica
                    $id_provincia = null;
                    if ($Provincia !== null) {
                        $stmt = $dbConn->prepare("SELECT id_provincia FROM provincias WHERE nombre = :nombre LIMIT 1");
                        $stmt->bindValue(':nombre', $Provincia);
                        $stmt->execute();
                        $id_provincia = $stmt->fetchColumn();
                    }

                    // Obtener id_localidad si aplica
                    $id_localidad = null;
                    if ($Localidad !== null) {
                        $stmt = $dbConn->prepare("SELECT id_localidad FROM localidades WHERE nombre = :nombre LIMIT 1");
                        $stmt->bindValue(':nombre', $Localidad);
                        $stmt->execute();
                        $id_localidad = $stmt->fetchColumn();
                    }

                    // Insertar en ubicacion_feriado
                    $sql = "INSERT INTO ubicacion_feriado (id_feriado, id_provincia, id_localidad)
                        VALUES (:id_feriado, :id_provincia, :id_localidad)";
                    $stmt = $dbConn->prepare($sql);
                    $stmt->bindValue(':id_feriado', $id_feriado);
                    $stmt->bindValue(':id_provincia', $id_provincia, $id_provincia !== null ? PDO::PARAM_INT : PDO::PARAM_NULL);
                    $stmt->bindValue(':id_localidad', $id_localidad, $id_localidad !== null ? PDO::PARAM_INT : PDO::PARAM_NULL);

                    if (!$stmt->execute()) {
                        $todoCorrecto = false;
                        break;
                    }
                }

                if ($todoCorrecto) {
                    header("HTTP/1.1 200 OK");
                    echo json_encode(['status' => 'success', 'message' => 'Todos los elementos se han procesado correctamente']);
                } else {
                    header("HTTP/1.1 200 OK");
                    echo json_encode(['status' => 'error', 'message' => 'Error al procesar uno o más elementos']);
                }
            } else {
                header("HTTP/1.1 400 Bad Request");
                echo json_encode(['status' => 'error', 'message' => 'Datos JSON inválidos o formato incorrecto']);
            }
        } catch (PDOException $e) {
            header("HTTP/1.1 500 Internal Server Error");
            echo json_encode(['status' => 'error', 'message' => 'Error de base de datos: ' . $e->getMessage()]);
        } catch (Exception $e) {
            header("HTTP/1.1 500 Internal Server Error");
            echo json_encode(['status' => 'error', 'message' => 'Error: ' . $e->getMessage()]);
        }

        exit();
    } elseif (isset($_POST['import_feriados2'])) {

        $jsonData = $_POST['import_feriados2'];
        $items = json_decode($jsonData, true);

        function normalizar($cadena)
        {
            $cadena = mb_strtolower($cadena, 'UTF-8');
            $cadena = strtr($cadena, [
                'á' => 'a',
                'é' => 'e',
                'í' => 'i',
                'ó' => 'o',
                'ú' => 'u',
                'ä' => 'a',
                'ë' => 'e',
                'ï' => 'i',
                'ö' => 'o',
                'ü' => 'u',
                'à' => 'a',
                'è' => 'e',
                'ì' => 'i',
                'ò' => 'o',
                'ù' => 'u',
                'ñ' => 'n'
            ]);
            return preg_replace('/[^a-z0-9]/', '', $cadena);
        }

        try {
            if (json_last_error() === JSON_ERROR_NONE && is_array($items)) {

                $provStmt = $dbConn->query("SELECT id_provincia, nombre FROM provincias");
                $provinciasRaw = $provStmt->fetchAll(PDO::FETCH_ASSOC);
                $provinciasNorm = [];
                foreach ($provinciasRaw as $row) {
                    $provinciasNorm[normalizar($row['nombre'])] = $row['id_provincia'];
                }

                $locStmt = $dbConn->query("SELECT id_localidad, nombre FROM localidades");
                $localidadesRaw = $locStmt->fetchAll(PDO::FETCH_ASSOC);
                $localidadesNorm = [];
                foreach ($localidadesRaw as $row) {
                    $localidadesNorm[normalizar($row['nombre'])] = $row['id_localidad'];
                }

                $invalidos = [];

                foreach ($items as &$item) {
                    $prov = isset($item['PROVINCIA']) ? trim($item['PROVINCIA']) : null;
                    $loc = isset($item['LOCALIDAD']) ? trim($item['LOCALIDAD']) : null;

                    $provNorm = $prov ? normalizar($prov) : null;
                    $locNorm = $loc ? normalizar($loc) : null;

                    $item['id_provincia'] = $provNorm && isset($provinciasNorm[$provNorm]) ? $provinciasNorm[$provNorm] : null;
                    $item['id_localidad'] = $locNorm && isset($localidadesNorm[$locNorm]) ? $localidadesNorm[$locNorm] : null;

                    // Si alguno no coincide y no es null → es inválido
                    if (($prov !== null && $item['id_provincia'] === null) || ($loc !== null && $item['id_localidad'] === null)) {
                        $invalidos[] = [
                            'descripcion' => $item['DESCRIPCION'] ?? null,
                            'fecha' => $item['FECHA'] ?? null,
                            'tipo' => $item['TIPO'] ?? null,
                            'provincia' => $prov,
                            'localidad' => $loc
                        ];
                    }
                }

                // Si hay inválidos, abortar
                if (!empty($invalidos)) {
                    header("HTTP/1.1 200 OK");
                    echo json_encode([
                        'status' => 'error',
                        'message' => 'Hay elementos con provincia o localidad no válidas.',
                        'no_coincidentes' => $invalidos
                    ]);
                    exit();
                }

                // Inserción de feriados únicos
                $feriadosUnicos = [];
                foreach ($items as $item) {
                    $desc = trim($item['DESCRIPCION']);
                    $fecha = trim($item['FECHA']);
                    $tipo = trim($item['TIPO']);

                    if (!$desc || !$fecha || !$tipo) continue;

                    $clave = normalizar($item['DESCRIPCION']) . '_' . $item['FECHA'] . '_' . normalizar($item['TIPO']);

                    if (!isset($feriadosUnicos[$clave])) {
                        $feriadosUnicos[$clave] = [
                            'descripcion' => $item['DESCRIPCION'],
                            'tipo' => $item['TIPO'],
                            'fecha' => $item['FECHA'],
                            'items' => []
                        ];
                    }

                    $feriadosUnicos[$clave]['items'][] = $item;
                }


                $insertados = 0;
                $ya_existian = 0;

                $nuevosItems = [];

                foreach ($feriadosUnicos as $feriado) {
                    $desc = $feriado['descripcion'];
                    $fecha = $feriado['fecha'];
                    $tipo = $feriado['tipo'];

                    $check = $dbConn->prepare("SELECT id_feriado FROM feriados WHERE descripcion = :desc AND fecha_i = :fecha");
                    $check->execute(['desc' => $desc, 'fecha' => $fecha]);
                    $id_feriado = $check->fetchColumn();

                    if (!$id_feriado) {
                        $insert = $dbConn->prepare("INSERT INTO feriados (fecha_i, fecha_f, descripcion, tipo) VALUES (:fecha, :fecha, :desc, :tipo)");
                        $insert->execute([
                            'fecha' => $fecha,
                            'desc' => $desc,
                            'tipo' => $tipo
                        ]);
                        $id_feriado = $dbConn->lastInsertId();
                        $insertados++;
                    } else {
                        $ya_existian++;
                    }

                    foreach ($feriado['items'] as $item) {
                        $item['id_feriado'] = $id_feriado;
                        $nuevosItems[] = $item;
                    }
                }


                foreach ($nuevosItems as $item) {
                    $id_feriado = $item['id_feriado'];
                    $id_provincia = $item['id_provincia'];
                    $id_localidad = $item['id_localidad'];

                    if (!$id_feriado) {
                        continue;
                    }

                    $insertUbic = $dbConn->prepare("INSERT INTO ubicacion_feriado (id_feriado, id_provincia, id_localidad) VALUES (:feriado, :provincia, :localidad)");
                    $insertUbic->execute([
                        'feriado' => $id_feriado,
                        'provincia' => $id_provincia,
                        'localidad' => $id_localidad
                    ]);
                }



                header("HTTP/1.1 200 OK");
                echo json_encode([
                    'status' => 'success',
                    'insertados' => $insertados,
                    'ya_existian' => $ya_existian,
                    'message' => 'Importación realizada correctamente'
                ]);
            } else {
                header("HTTP/1.1 400 Bad Request");
                echo json_encode(['status' => 'error', 'message' => 'JSON inválido o formato incorrecto']);
            }
        } catch (PDOException $e) {
            header("HTTP/1.1 500 Internal Server Error");
            echo json_encode(['status' => 'error', 'message' => 'Error BD: ' . $e->getMessage()]);
        } catch (Exception $e) {
            header("HTTP/1.1 500 Internal Server Error");
            echo json_encode(['status' => 'error', 'message' => 'Error: ' . $e->getMessage()]);
        }

        exit();
    } else if (
        isset($_POST["id_feriado_ubi"]) &&
        isset($_POST["id_provincia_ubi"]) &&
        isset($_POST["id_localidad_ubi"])
    ) {
        foreach ($_POST as $key => $value) {
            $value = ($value == "") ? null : $value;
            $value = ($value == "No") ? null : $value;
            $$key = $value;
        }

        try {
            if (isset($id_ubicacion_feriado_ubi)) {
                // UPDATE
                $sql = "UPDATE ubicacion_feriado 
                    SET id_feriado = :id_feriado, 
                        id_provincia = :id_provincia, 
                        id_localidad = :id_localidad 
                    WHERE id_ubicacion_feriado = :id_ubicacion";

                $stmt = $dbConn->prepare($sql);
                $stmt->bindValue(':id_feriado', $id_feriado_ubi);
                $stmt->bindValue(':id_provincia', $id_provincia_ubi, $id_provincia_ubi !== null ? PDO::PARAM_INT : PDO::PARAM_NULL);
                $stmt->bindValue(':id_localidad', $id_localidad_ubi, $id_localidad_ubi !== null ? PDO::PARAM_INT : PDO::PARAM_NULL);
                $stmt->bindValue(':id_ubicacion', $id_ubicacion_feriado_ubi, PDO::PARAM_INT);

                $stmt->execute();

                $response = array(
                    'success' => true,
                    'title' => 'Ubicación actualizada.',
                    'message' => 'Se ha actualizado la ubicación correctamente.'
                );
            } else {
                // INSERT
                $sql = "INSERT INTO ubicacion_feriado (id_feriado, id_provincia, id_localidad)
                    VALUES (:id_feriado, :id_provincia, :id_localidad)";

                $stmt = $dbConn->prepare($sql);
                $stmt->bindValue(':id_feriado', $id_feriado_ubi);
                $stmt->bindValue(':id_provincia', $id_provincia_ubi, $id_provincia_ubi !== null ? PDO::PARAM_INT : PDO::PARAM_NULL);
                $stmt->bindValue(':id_localidad', $id_localidad_ubi, $id_localidad_ubi !== null ? PDO::PARAM_INT : PDO::PARAM_NULL);

                $stmt->execute();

                $response = array(
                    'success' => true,
                    'title' => 'Ubicación agregada.',
                    'message' => 'Se ha agregado la ubicación correctamente.'
                );
            }

            header("HTTP/1.1 200 OK");
            echo json_encode($response);
            exit();
        } catch (PDOException $e) {
            $response = array(
                'success' => false,
                'title' => "Error en la operación.",
                'message' => "Hubo un problema al guardar los datos: " . $e->getMessage()
            );

            header("HTTP/1.1 200 OK");
            echo json_encode($response);
            exit();
        }
    } else if (
        isset($_POST["descripcion_feriado"]) &&
        isset($_POST["fecha_feriado"]) &&
        isset($_POST["tipo_feriado"])
    ) {
        foreach ($_POST as $key => $value) {
            $value = ($value == "") ? null : $value;
            $value = ($value == "No") ? null : $value;
            $$key = $value;
        }

        $descripcion = $descripcion_feriado;
        $fecha_i = $fecha_feriado;
        $fecha_f = $fecha_feriado;
        $tipo = $tipo_feriado;

        try {
            if (isset($id_feriado)) {
                // UPDATE
                $sql = "UPDATE feriados SET descripcion = :descripcion, fecha_i = :fecha_i, fecha_f = :fecha_f, tipo = :tipo WHERE id_feriado = :id_feriado";
                $stmt = $dbConn->prepare($sql);
                $stmt->bindValue(':descripcion', $descripcion);
                $stmt->bindValue(':fecha_i', $fecha_i);
                $stmt->bindValue(':fecha_f', $fecha_f);
                $stmt->bindValue(':tipo', $tipo);
                $stmt->bindValue(':id_feriado', $id_feriado);
                $stmt->execute();

                $response = array(
                    'success' => true,
                    'title' => 'Feriado actualizado.',
                    'message' => 'Se ha actualizado el feriado correctamente.'
                );
            } else {
                // INSERT
                $sql = "INSERT INTO feriados (descripcion, fecha_i, fecha_f, tipo)
                    VALUES (:descripcion, :fecha_i, :fecha_f, :tipo)";
                $stmt = $dbConn->prepare($sql);
                $stmt->bindValue(':descripcion', $descripcion);
                $stmt->bindValue(':fecha_i', $fecha_i);
                $stmt->bindValue(':fecha_f', $fecha_f);
                $stmt->bindValue(':tipo', $tipo);
                $stmt->execute();

                $response = array(
                    'success' => true,
                    'title' => 'Feriado agregado.',
                    'message' => 'Se ha agregado el feriado correctamente.'
                );
            }

            header("HTTP/1.1 200 OK");
            echo json_encode($response);
            exit();
        } catch (PDOException $e) {
            $response = array(
                'success' => false,
                'title' => "Error en la operación.",
                'message' => "Hubo un problema al guardar los datos: " . $e->getMessage()
            );

            header("HTTP/1.1 200 OK");
            echo json_encode($response);
            exit();
        }
    }
}





if ($_SERVER['REQUEST_METHOD'] == 'DELETE') {
    if (isset($_GET["id_feriado"])) {

        $id = $_GET['id_feriado'];

        $statement = $dbConn->prepare("DELETE FROM feriados where id_feriado = :id");

        $statement->bindValue(':id', $id);

        $statement->execute();

        header("HTTP/1.1 200 OK");


        exit();
    } else if (isset($_GET["id_vacacion"])) {
        $id = $_GET['id_vacacion'];

        $statement = $dbConn->prepare("DELETE FROM vacaciones where id_vacacion =:id");

        $statement->bindValue(':id', $id);

        $statement->execute();

        header("HTTP/1.1 200 OK");

        exit();
    } else if (isset($_GET["id_ubicacion_feriado"])) {
        $id = $_GET['id_ubicacion_feriado'];

        $statement = $dbConn->prepare("DELETE FROM ubicacion_feriado where id_ubicacion_feriado =:id");

        $statement->bindValue(':id', $id);

        $statement->execute();

        header("HTTP/1.1 200 OK");

        exit();
    }
}



//Actualizar

if ($_SERVER['REQUEST_METHOD'] == 'PUT') {

    $input = $_GET;

    $postId = $input['id'];

    $fields = getParams($input);



    $sql = "

          UPDATE posts

          SET $fields

          WHERE id='$postId'

           ";



    $statement = $dbConn->prepare($sql);

    bindAllValues($statement, $input);



    $statement->execute();

    header("HTTP/1.1 200 OK");

    exit();
}

function obtenerDiasEntreFechas($fecha_i, $fecha_f)
{
    $inicio = new DateTime($fecha_i);
    $fin = new DateTime($fecha_f);
    $dias = [];
    while ($inicio <= $fin) {
        $dias[] = $inicio->format('Y-m-d');
        $inicio->modify('+1 day');
    }
    return $dias;
}
function obtenerDiasVacacionesExistentes($dbConn, $user_id, $excluir_id = null)
{
    $sql = "SELECT fecha_i, fecha_f FROM vacaciones WHERE user_id = :user_id";
    if ($excluir_id !== null) {
        $sql .= " AND id_vacacion != :id_vacacion";
    }

    $stmt = $dbConn->prepare($sql);
    $stmt->bindValue(':user_id', $user_id);
    if ($excluir_id !== null) {
        $stmt->bindValue(':id_vacacion', $excluir_id);
    }
    $stmt->execute();
    $resultados = $stmt->fetchAll(PDO::FETCH_ASSOC);

    $dias_existentes = [];
    foreach ($resultados as $row) {
        $dias = obtenerDiasEntreFechas($row['fecha_i'], $row['fecha_f']);
        $dias_existentes = array_merge($dias_existentes, $dias);
    }

    return array_unique($dias_existentes);
}
function calcularDiasNetosUsuario($dbConn, $user_id, $fecha_i, $fecha_f)
{
    // Obtener provincia y localidad del usuario
    $stmt = $dbConn->prepare("
        SELECT id_provincia, id_localidad 
        FROM users 
        WHERE user_id = :user_id
    ");
    $stmt->bindValue(':user_id', $user_id, PDO::PARAM_INT);
    $stmt->execute();
    $user = $stmt->fetch(PDO::FETCH_ASSOC);

    if (!$user) {
        throw new Exception("Usuario no encontrado");
    }

    $id_provincia = $user['id_provincia'];
    $id_localidad = $user['id_localidad'];

    // Calcular días totales
    $diasTotales = (new DateTime($fecha_i))->diff(new DateTime($fecha_f))->days + 1;

    // Armar consulta de feriados
    $queryFeriados = "
        SELECT DISTINCT f.*
        FROM feriados f
        INNER JOIN ubicacion_feriado uf ON f.id_feriado = uf.id_feriado
        WHERE 
            f.fecha_i BETWEEN :fecha_inicio AND :fecha_fin
            AND (
                (uf.id_provincia IS NULL AND uf.id_localidad IS NULL)
    ";

    if ($id_provincia !== null && $id_localidad === null) {
        $queryFeriados .= "
            OR (uf.id_provincia = :id_provincia AND uf.id_localidad IS NULL)
        ";
    } elseif ($id_provincia !== null && $id_localidad !== null) {
        $queryFeriados .= "
            OR (uf.id_provincia = :id_provincia AND uf.id_localidad IS NULL)
            OR (uf.id_provincia = :id_provincia AND uf.id_localidad = :id_localidad)
        ";
    }

    $queryFeriados .= ")";

    $sqlFeriados = $dbConn->prepare($queryFeriados);
    $sqlFeriados->bindValue(':fecha_inicio', $fecha_i);
    $sqlFeriados->bindValue(':fecha_fin', $fecha_f);

    if ($id_provincia !== null) {
        $sqlFeriados->bindValue(':id_provincia', $id_provincia, PDO::PARAM_INT);
    }
    if ($id_localidad !== null) {
        $sqlFeriados->bindValue(':id_localidad', $id_localidad, PDO::PARAM_INT);
    }

    $sqlFeriados->execute();
    $feriados = $sqlFeriados->fetchAll(PDO::FETCH_ASSOC);

    $cantidadFeriados = count($feriados);
    $diasNetos = $diasTotales - $cantidadFeriados;


    return $diasNetos;
}

function obtenerFeriadosPeriodo($dbConn, $user_id)
{
    $sqlUsers = $dbConn->prepare("
        SELECT 
            u.user_id, 
            u.user_full_name,
            u.id_provincia,
            u.id_localidad,
            v.id_vacacion,
            v.fecha_i,
            v.fecha_f
        FROM users u
        INNER JOIN vacaciones v ON u.user_id = v.user_id
        WHERE 
            u.user_id = :user_id
        ORDER BY u.user_id, v.fecha_i;
    ");
    $sqlUsers->bindValue(':user_id', $user_id);
    $sqlUsers->execute();
    $vacaciones = $sqlUsers->fetchAll(PDO::FETCH_ASSOC);

    $totalDiasNetos = 0;

    foreach ($vacaciones as &$v) {
        $fecha_inicio = $v['fecha_i'];
        $fecha_fin = $v['fecha_f'];

        $id_provincia2 = $v['id_provincia'];
        $id_localidad2 = $v['id_localidad'];

        // Calcular días totales de vacaciones (inclusive)
        $diasTotales = (new DateTime($fecha_inicio))->diff(new DateTime($fecha_fin))->days + 1;

        // Obtener feriados aplicables en el período
        $queryFeriados2 = "
            SELECT DISTINCT f.*
            FROM feriados f
            INNER JOIN ubicacion_feriado uf ON f.id_feriado = uf.id_feriado
            WHERE 
                f.fecha_i BETWEEN :fecha_inicio AND :fecha_fin
                AND (
                    (uf.id_provincia IS NULL AND uf.id_localidad IS NULL)
        ";

        if ($id_provincia2 !== null && $id_localidad2 === null) {
            $queryFeriados2 .= "
                OR (uf.id_provincia = :id_provincia AND uf.id_localidad IS NULL)
            ";
        } elseif ($id_provincia2 !== null && $id_localidad2 !== null) {
            $queryFeriados2 .= "
                OR (uf.id_provincia = :id_provincia AND uf.id_localidad IS NULL)
                OR (uf.id_provincia = :id_provincia AND uf.id_localidad = :id_localidad)
            ";
        }

        $queryFeriados2 .= ")";

        $sqlFeriados2 = $dbConn->prepare($queryFeriados2);
        $sqlFeriados2->bindValue(':fecha_inicio', $fecha_inicio);
        $sqlFeriados2->bindValue(':fecha_fin', $fecha_fin);

        if ($id_provincia2 !== null) {
            $sqlFeriados2->bindValue(':id_provincia', $id_provincia2, PDO::PARAM_INT);
        }
        if ($id_localidad2 !== null) {
            $sqlFeriados2->bindValue(':id_localidad', $id_localidad2, PDO::PARAM_INT);
        }

        $sqlFeriados2->execute();
        $feriados = $sqlFeriados2->fetchAll(PDO::FETCH_ASSOC);

        // Restar feriados
        $diasNetos = $diasTotales - count($feriados);

        // Guardar info extra si se desea
        $v["dias_totales"] = $diasTotales;
        $v["feriados"] = $feriados;
        $v["dias_netos"] = $diasNetos;

        // Acumular total
        $totalDiasNetos += $diasNetos;
    }

    // Retorna el total neto de días
    return $totalDiasNetos;
}


//En caso de que ninguna de las opciones anteriores se haya ejecutado

header("HTTP/1.1 400 Bad Request");