<?php

require_once __DIR__ . '/../core/configuration.php';


$db = [

  'host' => DB_SERVER,

  'username' => DB_USERNAME,

  'password' => DB_PASSWORD,

  'db' => DB_NAME //Cambiar al nombre de tu base de datos

];



if (!function_exists('connect')) {

  //Abrir conexion a la base de datos

  function connect($db)

  {



    try {

      $conn = new PDO("mysql:host={$db['host']};dbname={$db['db']};charset=UTF8MB4", $db['username'], $db['password']);



      // set the PDO error mode to exception

      $conn->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);



      return $conn;

    } catch (PDOException $exception) {

      exit($exception->getMessage());

    }

  }

}



if (!function_exists('getParams')) {

  //Obtener parametros para updates

  function getParams($input)

  {

    $filterParams = [];

    foreach ($input as $param => $value) {

      $filterParams[] = "$param=:$param";

    }

    return implode(", ", $filterParams);

  }

}





if (!function_exists('bindAllValues')) {

  //Asociar todos los parametros a un sql

  function bindAllValues($statement, $params)

  {

    foreach ($params as $param => $value) {

      $statement->bindValue(':' . $param, $value);

    }

    return $statement;

  }

}



if (!function_exists('obtenerMensajeError')) {

  function obtenerMensajeError($error)

  {

    $errorMessages = [

      '23000' => [

        '1062' => [

          'title' => 'Error de Duplicación',

          'message' => 'Entrada duplicada: Ya existe un registro con este valor único en el campo "%s".'

        ],

        '1048' => [

          'title' => 'Valor Requerido',

          'message' => 'El campo "%s" no puede estar vacío.'

        ]

      ]

    ];



    $errorInfo = $error->errorInfo;



    if (isset($errorMessages[$errorInfo[0]]) && isset($errorMessages[$errorInfo[0]][$errorInfo[1]])) {

      $errorDetail = $errorMessages[$errorInfo[0]][$errorInfo[1]];



      if ($errorInfo[1] == '1048') {

        $inicio = strpos($errorInfo[2], "'");

        $final = strrpos($errorInfo[2], "'");

        if ($inicio !== false && $final !== false) {

          $valor = substr($errorInfo[2], $inicio + 1, $final - $inicio - 1);

        }

      }

      if ($errorInfo[1] == '23000') {

        if (preg_match_all("/'([^']+)'/", $errorInfo[2], $matches)) {

          $valor = $matches[1][1];

        }

      }

      $message = sprintf($errorDetail['message'], $valor);



      return ['title' => $errorDetail['title'], 'message' => $message];

    } else {

      return [

        'title' => 'Error Desconocido',

        'message' => "Error desconocido: " . $error->getMessage()

      ];

    }

  }

}