<?php



include "utils.php";

include "../libraries/maxmind/autoload.php";





include "../models/users.model.php";

require_once(__LIBRARIES__ . 'browser.php');

$dbConn = connect($db);

$GeoIP = new MaxMind\Db\Reader(__LIBRARIES__ . 'maxmind/GeoLite2-City.mmdb');



/*

  listar todos los posts o solo uno

 */

if ($_SERVER['REQUEST_METHOD'] == 'GET') {
  if (isset($_GET['comerciales'])) {
  $sql = $dbConn->prepare("
    SELECT 
      comerciales.*, 
      users.user_full_name 
    FROM 
      comerciales 
    LEFT JOIN 
      users ON comerciales.user_id = users.user_id
  ");

  $sql->execute();
  $sql->setFetchMode(PDO::FETCH_ASSOC);

  header("HTTP/1.1 200 OK");
  echo json_encode($sql->fetchAll());
  exit();
}

  if (isset($_GET['id_provincia'])) {
    $sql = "SELECT * FROM localidades where id_provincia=:id_provincia";

    $statement = $dbConn->prepare($sql);
  $statement->bindValue(':id_provincia', $_GET['id_provincia']);
    $statement->execute();
  $statement->setFetchMode(PDO::FETCH_ASSOC);

      $User_Logins = $statement->fetchAll();
    header("HTTP/1.1 200 OK");

    echo json_encode($User_Logins);

    exit();
  } elseif (isset($_GET['user_id'])) {

    if (isset($_GET['logins'])) {

      $sql = $dbConn->prepare("SELECT * FROM logins where login_user=:user_id");

      $sql->bindValue(':user_id', $_GET['user_id']);

      $sql->execute();

      $sql->setFetchMode(PDO::FETCH_ASSOC);

      $User_Logins = $sql->fetchAll();

      foreach ($User_Logins as &$Login) {

        $Record = $GeoIP->get($Login['login_ip']);

        if (isset($Record['city']['names']['es'])) {

          $City = $Record['city']['names']['es'] . ', ';
        } else if (isset($Record['city']['names']['en'])) {

          $City = $Record['city']['names']['en'] . ', ';
        } else {

          $City = '';
        }

        if (isset($Record['country']['names']['es'])) {

          $Country = $Record['country']['names']['es'];
        } else if (isset($Record['country']['names']['en'])) {

          $Country = $Record['country']['names']['en'];
        } else {

          $Country = '';
        }

        if ($City == '' && $Country == '') {

          $Country = 'Desconocido';
        }

        if (isset($City) && !empty($City) && isset($Country) && !empty($Country)) {

          $Login["localizacion"] = $Country;
        } else if (isset($Country) && !empty($Country)) {

          $Login["localizacion"] = $Country;
        } else {

          $Login["localizacion"] = "Desconocido";
        }



        $Login["navegador"] = _ParseBrowser($Login['login_agent']);
      }

      $GeoIP->close();



      header("HTTP/1.1 200 OK");

      echo json_encode($User_Logins);

      exit();
    } else {

      $sql = $dbConn->prepare("SELECT * FROM users where user_id=:user_id");

      $sql->bindValue(':user_id', $_GET['user_id']);

      $sql->execute();

      header("HTTP/1.1 200 OK");

      echo json_encode($sql->fetch(PDO::FETCH_ASSOC));

      exit();
    }
  } else {

    //Mostrar lista de post

    $sql = $dbConn->prepare("

    SELECT 

        users.*, 

        GROUP_CONCAT(user_permiso.folder_id) AS permisos

    FROM 

        users

    LEFT JOIN 

        user_permiso ON users.user_id = user_permiso.user_id

    GROUP BY 

        users.user_id

");

    $sql->execute();

    $sql->setFetchMode(PDO::FETCH_ASSOC);

    header("HTTP/1.1 200 OK");



    echo json_encode($sql->fetchAll());

    exit();
  }
}



// Crear un nuevo post

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
if (isset($_POST["codigo"]) && isset($_POST["user_id"])) {

  $codigo = $_POST["codigo"];
  $user_id = $_POST["user_id"];

  try {
    // Insertar nuevo comercial
    $sql = "INSERT INTO comerciales (codigo, user_id) VALUES (:codigo, :user_id)";
    $statement = $dbConn->prepare($sql);
    $statement->bindValue(':codigo', $codigo);
    $statement->bindValue(':user_id', $user_id);
    $statement->execute();

    // Obtener el ID recién insertado
    $id_comercial = $dbConn->lastInsertId();

    $response = array(
      "success" => true,
      "message" => "Comercial creado correctamente",
      "id" => $id_comercial,
      "codigo" => $codigo,
      "user_id" => $user_id
    );

    header("HTTP/1.1 200 OK");
    echo json_encode($response);
    exit();
  } catch (PDOException $e) {
    $response = array(
      "success" => false,
      "message" => "Error al crear el comercial: " . $e->getMessage()
    );

    header("HTTP/1.1 500 Internal Server Error");
    echo json_encode($response);
    exit();
  }
}

  if (

    isset($_POST["user_id_atributo"])

    && isset($_POST["valor"])

    && isset($_POST["atributo"])

  ) {

    $user_id_atributo = $_POST["user_id_atributo"];

    $valor = $_POST["valor"];

    $atributo = $_POST["atributo"];

    if ($valor === '') {

      $valor = null;
    }

    $sql = "UPDATE users SET $atributo = :valor WHERE user_id = :user_id_atributo";

    $statement = $dbConn->prepare($sql);

    $statement->bindValue(':user_id_atributo', $user_id_atributo);

    $statement->bindValue(':valor', $valor);



    $statement->execute();



    $input["id"] = $user_id_atributo;

    $input["valor"] = $valor;

    $input["atributo"] = $atributo;



    header("HTTP/1.1 200 OK");

    echo json_encode($input);

    exit();
  }if (

    isset($_POST["user_id"])

    && isset($_POST["id_provincia"])

    && isset($_POST["id_localidad"])

  ) {

    $user_id = $_POST["user_id"];

    $id_provincia = ($_POST["id_provincia"] != "No" ? $_POST["id_provincia"] : null);

    $id_localidad = ($_POST["id_localidad"] != "No" ? $_POST["id_localidad"] : null);

  

    $sql = "UPDATE users SET id_provincia = :id_provincia , id_localidad = :id_localidad WHERE user_id = :user_id";

    $statement = $dbConn->prepare($sql);

    $statement->bindValue(':user_id', $user_id);

    $statement->bindValue(':id_provincia', $id_provincia);
 $statement->bindValue(':id_localidad', $id_localidad);


    $statement->execute();



    $input["id"] = $user_id;




    header("HTTP/1.1 200 OK");

    echo json_encode($input);

    exit();
  }
  if (

    isset($_POST["folder_id"])

    && isset($_POST["users"])

  ) {

    $folder_id = $_POST["folder_id"];

    $users = json_decode($_POST["users"], true);



    // Eliminar todos los elementos de user_permiso con ese folder_id

    $deleteSql = "DELETE FROM user_permiso WHERE folder_id = :folder_id";

    $deleteStmt = $dbConn->prepare($deleteSql);

    $deleteStmt->bindValue(':folder_id', $folder_id);

    $deleteStmt->execute();



    // Insertar nuevos elementos en user_permiso para cada user_id

    $insertSql = "INSERT INTO user_permiso (folder_id, user_id) VALUES (:folder_id, :user_id)";

    $insertStmt = $dbConn->prepare($insertSql);



    foreach ($users as $user_id) {

      $insertStmt->bindValue(':folder_id', $folder_id);

      $insertStmt->bindValue(':user_id', $user_id);

      $insertStmt->execute();
    }



    header("HTTP/1.1 200 OK");

    echo json_encode(["message" => "Permisos actualizados correctamente"]);

    exit();
  }


  if (isset($_POST["user_id"]) && isset($_POST["nombre_user"])) {
    $user_id = $_POST["user_id"];
    $nombre = $_POST["nombre_user"];

    try {
      $sql = "UPDATE users SET user_full_name = :nombre WHERE user_id = :user_id";
      $statement = $dbConn->prepare($sql);
      $statement->bindValue(':nombre', $nombre);
      $statement->bindValue(':user_id', $user_id);
      $statement->execute();

      $response = array(
        'success' => true,
        'title' => 'Nombre actualizado',
        'message' => 'El nombre del usuario se ha actualizado correctamente.'
      );

      header("HTTP/1.1 200 OK");
      echo json_encode($response);
      exit();
    } catch (PDOException $e) {
      $response = array(
        'success' => false,
        'title' => "Error al actualizar nombre",
        'message' => "Hubo un problema al actualizar el nombre: " . $e->getMessage()
      );

      header("HTTP/1.1 200 OK");
      echo json_encode($response);
      exit();
    }
  }
}



//Borrar

if ($_SERVER['REQUEST_METHOD'] == 'DELETE') {
  if (isset($_GET['id_comercial'])) {
        $id = $_GET['id_comercial '];
        $stmt = $dbConn->prepare("DELETE FROM comerciales  WHERE id_comercial  = :id");
        $stmt->bindValue(":id", $id);
        $stmt->execute();

  header("HTTP/1.1 200 OK");
        echo json_encode(['accion' => 'evento_eliminado']);
        exit();
    }
  if (isset($_GET["user_id"])) {

    $Users = new _UsersModel($DBLink);

    $id = $_GET['user_id'];





    if ($id != $_SESSION['id']) {

      $Users->_DeleteUser($id);

      header("HTTP/1.1 200 OK");

      echo $id;

      exit();
    } else {

      $Users->_DeleteUser($id);



      $Users->_Logout();

      header("HTTP/1.1 200 OK");

      echo 0;

      exit();
    }
  }
}



//Actualizar

if ($_SERVER['REQUEST_METHOD'] == 'PUT') {

  $input = $_GET;

  $postId = $input['id'];

  $fields = getParams($input);



  $sql = "

          UPDATE posts

          SET $fields

          WHERE id='$postId'

           ";



  $statement = $dbConn->prepare($sql);

  bindAllValues($statement, $input);



  $statement->execute();

  header("HTTP/1.1 200 OK");

  exit();
}



function _ParseBrowser($UserAgent)

{

  $Browser = new Browser();

  $Browser->setUserAgent($UserAgent);



  $Nombre = $Browser->getBrowser();



  if ($Nombre == false || $Nombre == 'unknown') {

    return 'Desconocido';
  }



  $Version = $Browser->getVersion();



  if ($Version == false || $Version == 'unknown') {

    return 'Desconocido';
  }





  return $Nombre . ' ' . $Version;
}



//https://stackoverflow.com/questions/1416697/converting-timestamp-to-time-ago-in-php-e-g-1-day-ago-2-days-ago

function time_elapsed_string($datetime, $full = false)

{

  $now = new DateTime;

  $ago = new DateTime($datetime);

  $diff = $now->diff($ago);



  $diff->w = floor($diff->d / 7);

  $diff->d -= $diff->w * 7;



  $string = array(

    'y' => _('año'),

    'm' => _('mes'),

    'w' => _('semana'),

    'd' => _('día'),

    'h' => _('hora'),

    'i' => _('minuto'),

    's' => _('segundo'),

  );

  foreach ($string as $k => &$v) {

    if ($diff->$k) {

      $v = $diff->$k . ' ' . $v . ($diff->$k > 1 ? 's' : '');
    } else {

      unset($string[$k]);
    }
  }



  if (!$full)

    $string = array_slice($string, 0, 1);

  return $string ? implode(', ', $string) . _(' atrás') : _('justo ahora');
}

//En caso de que ninguna de las opciones anteriores se haya ejecutado

header("HTTP/1.1 400 Bad Request");