<?php



include "utils.php";

include "../libraries/image_upload.php";



include "../models/users.model.php";

require_once(__ROOT__ . '/vendor/autoload.php');



use PhpOffice\PhpWord\IOFactory;

use PhpOffice\PhpWord\Settings;

use Convertio\Convertio;





$dbConn = connect($db);



/*

listar todos los posts o solo uno

 */

if ($_SERVER['REQUEST_METHOD'] == 'GET') {

    if (isset($_GET['id_evento'])) {

        $id_evento = $_GET['id_evento'];

        //Mostrar un post

        $sql = $dbConn->prepare("SELECT ue.*, (

            SELECT u.user_full_name

            FROM users u

            WHERE u.user_id = ue.user_id

        ) AS user_data

        FROM user_evento ue

        WHERE ue.id_evento = :id_evento");

        $sql->bindValue(':id_evento', $id_evento);

        $sql->execute();

        $sql->setFetchMode(PDO::FETCH_ASSOC);

        header("HTTP/1.1 200 OK");

        echo json_encode($sql->fetchAll());

        exit();

    }



    if (isset($_GET['id_user_evento'])) {

        $id_user_evento = $_GET['id_user_evento'];

        $sql = $dbConn->prepare("SELECT * FROM user_evento where id_user_evento=:id_user_evento");

        $sql->bindValue(':id_user_evento', $_GET['id_user_evento']);

        $sql->execute();

        header("HTTP/1.1 200 OK");

        echo json_encode($sql->fetch(PDO::FETCH_ASSOC));

        exit();

    } else {

        //Mostrar lista de post

        $sql = $dbConn->prepare("SELECT DISTINCT u.*

        FROM users u

        INNER JOIN user_evento ue ON u.user_id = ue.user_id;");

        $sql->execute();

        $sql->setFetchMode(PDO::FETCH_ASSOC);

        $Users = $sql->fetchAll();

        foreach ($Users as &$user) {

            $sql = $dbConn->prepare("SELECT * FROM user_evento WHERE user_id = :user_id");

            $sql->bindValue(':user_id', $user["user_id"]);

            $sql->execute();

            $sql->setFetchMode(PDO::FETCH_ASSOC);

            $user_eventos = $sql->fetchAll();

            foreach ($user_eventos as &$user_evento) {

                $sql = $dbConn->prepare("SELECT * FROM eventos WHERE id_evento = :id_evento");

                $sql->bindValue(':id_evento', $user_evento["id_evento"]);

                $sql->execute();

                $sql->setFetchMode(PDO::FETCH_ASSOC);

                $evento = $sql->fetch(PDO::FETCH_ASSOC);

                $user_evento["evento"] = $evento;

            }

            $user["user_eventos"] = $user_eventos;

        }

        header("HTTP/1.1 200 OK");



        echo json_encode($Users);

        exit();

    }

}



// Crear un nuevo post

if ($_SERVER['REQUEST_METHOD'] == 'POST') {

    if (

        isset($_POST["direccion"]) &&

        isset($_POST["cp"]) &&

        isset($_POST["email"]) &&

        isset($_POST["telefono"]) &&

        isset($_POST["id_evento"]) &&

        isset($_POST["user_id"]) &&

        isset($_POST["uniforme"]) &&

        isset($_POST["nif"])

    ) {



        $uniforme = $_POST["uniforme"];

        $direccion = $_POST["direccion"];

        $cp = $_POST["cp"];

        $email = $_POST["email"];

        $telefono = $_POST["telefono"];

        $id_evento = $_POST["id_evento"];

        $user_id = $_POST["user_id"];

        $nif = $_POST["nif"];



        if ($direccion === '') {

            $direccion = null;

        }

        if ($cp === '') {

            $cp = null;

        }

        if ($email === '') {

            $email = null;

        }

        if ($telefono === '') {

            $telefono = null;

        }

        $sqlCheck = "SELECT COUNT(*) FROM user_evento WHERE user_id = :user_id AND id_evento = :id_evento";

        $statementCheck = $dbConn->prepare($sqlCheck);

        $statementCheck->bindValue(':user_id', $user_id);

        $statementCheck->bindValue(':id_evento', $id_evento);

        $statementCheck->execute();

        $count = $statementCheck->fetchColumn();

        if ($count > 0) {

            // Ya existe un registro con el mismo user_id o id_evento, retornar 0

            header("HTTP/1.1 200 OK");

            echo "0";

            exit();

        } else {

            $nombreArchivo = $_FILES['contrato']['name'];

            $tipoArchivo = $_FILES['contrato']['type'];

            $tamanoArchivo = $_FILES['contrato']['size'];

            $rutaArchivoTemporal = $_FILES['contrato']['tmp_name'];

            $directorioDestino = '../contratos/' . $id_evento . "/" . $user_id;

            $carpetaNuevaHorarios = '../horarios/' . $id_evento . "/" . $user_id;

            mkdir($directorioDestino, 0777, true);

            mkdir($carpetaNuevaHorarios, 0777, true);

            // Generar un nombre único para el archivo

            $nombreArchivoUnico = "contrato_vacio.pdf";

            // Ruta de destino completa del archivo

            $rutaArchivoDestino = $directorioDestino . "/" . $nombreArchivoUnico;

            move_uploaded_file($rutaArchivoTemporal, $rutaArchivoDestino);

            $sql = "INSERT INTO user_evento

            (id_evento,user_id,contrato,nif,direccion,cp,email,telefono

            ,uniforme)

            VALUES

            (:id_evento,:user_id,:contrato,:nif,:direccion,:cp,:email,:telefono

            ,:uniforme)";

            $statement = $dbConn->prepare($sql);







            $statement->bindValue(':uniforme', $uniforme);

            $statement->bindValue(':direccion', $direccion);

            $statement->bindValue(':cp', $cp);

            $statement->bindValue(':email', $email);

            $statement->bindValue(':telefono', $telefono);

            $statement->bindValue(':nif', $nif);

            $statement->bindValue(':id_evento', $id_evento);

            $statement->bindValue(':user_id', $user_id);

            $statement->bindValue(':contrato', $rutaArchivoDestino);

            $statement->execute();



            $postId = $dbConn->lastInsertId();



            $statement = $dbConn->prepare("SELECT COUNT(*) 

            FROM user_evento WHERE id_evento = :id_evento");

            $statement->bindValue(':id_evento', $id_evento);

            $statement->execute();

            $count = $statement->fetchColumn();

            $input['id'] = $postId;

            $input['direccion'] = $direccion;

            $input['cp'] = $cp;

            $input['email'] = $email;

            $input['telefono'] = $telefono;

            $input['id_evento'] = $id_evento;

            $input['user_id'] = $user_id;

            $input['contrato'] = htmlentities($rutaArchivoDestino, ENT_QUOTES);

            $input['nif'] = $nif;

            $input['cantidad'] = $count;



            header("HTTP/1.1 200 OK");

            echo json_encode($input);

            exit();

        }

    }



    if (

        isset($_POST["id_evento_subir"]) &&

        isset($_POST["id_user_evento_subir"]) &&

        isset($_POST["user_id_subir"])

    ) {

        $id_evento = $_POST["id_evento_subir"];

        $id_user_evento = $_POST["id_user_evento_subir"];

        $user_id = $_POST["user_id_subir"];

        if (isset($_FILES["contrato_subir"])) {

            $contrato = $_FILES["contrato_subir"];

            $nombreArchivo = $_FILES['contrato_subir']['name'];

            $tipoArchivo = $_FILES['contrato_subir']['type'];

            $tamanoArchivo = $_FILES['contrato_subir']['size'];

            $rutaArchivoTemporal = $_FILES['contrato_subir']['tmp_name'];

            $directorioDestino = '../contratos/' . $id_evento . "/" . $user_id;

            // Generar un nombre único para el archivo

            $nombreArchivoUnico = "contrato_lleno.pdf";

            // Ruta de destino completa del archivo

            $rutaArchivoDestino = $directorioDestino . "/" . $nombreArchivoUnico;

            if (file_exists($rutaArchivoDestino)) {

                unlink($rutaArchivoDestino); // Elimina el archivo existente antes de reemplazarlo

            }

            move_uploaded_file($rutaArchivoTemporal, $rutaArchivoDestino);





            $sql = "UPDATE user_evento SET 

        contrato_lleno = :contrato_lleno

        WHERE id_user_evento = :id_user_evento";

            $statement = $dbConn->prepare($sql);





            $statement->bindValue(':id_user_evento', $id_user_evento);

            $statement->bindValue(':contrato_lleno', $rutaArchivoDestino);

            $statement->execute();



            header("HTTP/1.1 200 OK");

            echo "Archivo subido";

            exit();

        }

        if (isset($_FILES["horario_subir"])) {

            $horario = $_FILES["horario_subir"];

            $nombreArchivo = $_FILES['horario_subir']['name'];

            $tipoArchivo = $_FILES['horario_subir']['type'];

            $tamanoArchivo = $_FILES['horario_subir']['size'];

            $rutaArchivoTemporal = $_FILES['horario_subir']['tmp_name'];



            $directorioDestino = '../horarios/' . $id_evento . "/" . $user_id;

            // Generar un nombre único para el archivo

            $nombreArchivoUnico = "horario_lleno.docx";

            // Ruta de destino completa del archivo

            $rutaArchivoDestino = $directorioDestino . "/" . $nombreArchivoUnico;



            $nombreArchivoUnicoPDF = "horario_lleno.pdf";

            $rutaArchivoDestinoPDF = $directorioDestino . "/" . $nombreArchivoUnicoPDF;

            if (file_exists($rutaArchivoDestino)) {

                unlink($rutaArchivoDestino); // Elimina el archivo existente antes de reemplazarlo

                unlink($rutaArchivoDestinoPDF);

            }

            move_uploaded_file($rutaArchivoTemporal, $rutaArchivoDestino);

            $API = new Convertio("e6a728f6d5fa08d8be8837f42f7b5b09");

            $API->start($rutaArchivoDestino, 'pdf')->wait()->download($rutaArchivoDestinoPDF);

            // Configurar el generador de PDF

            /*

            Settings::setPdfRendererName(Settings::PDF_RENDERER_DOMPDF);

            Settings::setPdfRendererPath('../vendor/dompdf/dompdf');

            $phpWord = IOFactory::load($rutaArchivoDestino);

            $phpWord->save($rutaArchivoDestinoPDF, 'PDF');

*/

            $sql = "UPDATE user_evento SET 

        horario_lleno = :horario_lleno

        WHERE id_user_evento = :id_user_evento";

            $statement = $dbConn->prepare($sql);





            $statement->bindValue(':id_user_evento', $id_user_evento);

            $statement->bindValue(':horario_lleno', $rutaArchivoDestinoPDF);

            $statement->execute();



            header("HTTP/1.1 200 OK");

            echo "Archivo subido";

            exit();

        }

    }

    if (

        isset($_POST["url_editar"]) &&

        isset($_POST["direccion_editar"]) &&

        isset($_POST["cp_editar"]) &&

        isset($_POST["email_editar"]) &&

        isset($_POST["telefono_editar"]) &&

        isset($_POST["id_user_evento_editar"]) &&

        isset($_FILES["contrato_editar"]) &&

        isset($_POST["nif_editar"])

    ) {

        $direccion = $_POST["direccion_editar"];

        $cp = $_POST["cp_editar"];

        $email = $_POST["email_editar"];

        $telefono = $_POST["telefono_editar"];

        $id_user_evento = $_POST["id_user_evento_editar"];

        $contrato = $_FILES["contrato_editar"];

        $nif = $_POST["nif_editar"];

        $url = $_POST["url_editar"];

        $nombreArchivo = $_FILES['contrato_editar']['name'];

        $tipoArchivo = $_FILES['contrato_editar']['type'];

        $tamanoArchivo = $_FILES['contrato_editar']['size'];

        $rutaArchivoTemporal = $_FILES['contrato_editar']['tmp_name'];

        $directorioDestino = $url;



        if ($direccion === '') {

            $direccion = null;

        }

        if ($cp === '') {

            $cp = null;

        }

        if ($email === '') {

            $email = null;

        }

        if ($telefono === '') {

            $telefono = null;

        }



        // Ruta de destino completa del archivo

        $rutaArchivoDestino = $directorioDestino;

        if (file_exists($rutaArchivoDestino)) {

            unlink($rutaArchivoDestino); // Elimina el archivo existente antes de reemplazarlo

        }

        move_uploaded_file($rutaArchivoTemporal, $rutaArchivoDestino);





        $sql = "UPDATE user_evento SET 

            direccion = :direccion,

            cp = :cp,

            email = :email,

            telefono = :telefono,

            contrato = :contrato,

             nif = :nif

            WHERE id_user_evento = :id_user_evento";

        $statement = $dbConn->prepare($sql);



        $statement->bindValue(':id_user_evento', $id_user_evento);

        $statement->bindValue(':contrato', $rutaArchivoDestino);

        $statement->bindValue(':nif', $nif);



        $statement->bindValue(':direccion', $direccion);

        $statement->bindValue(':cp', $cp);

        $statement->bindValue(':email', $email);

        $statement->bindValue(':telefono', $telefono);

        $statement->execute();



        header("HTTP/1.1 200 OK");

        echo "Archivo subido";

        exit();

    }

    if (

        isset($_POST["id_user_evento_entrega"]) &&

        isset($_POST["entrega"])

    ) {

        $id_user_evento_entrega = $_POST["id_user_evento_entrega"];

        $entrega = $_POST["entrega"];



        if ($entrega == true) {

            $entrega = 1;

        } else {

            $entrega = 0;

        }

        $sql = "UPDATE user_evento SET 

            

                entrega_uniforme = :entrega

               

                WHERE id_user_evento = :id_user_evento";

        $statement = $dbConn->prepare($sql);



        $statement->bindValue(':id_user_evento', $id_user_evento_entrega);

        $statement->bindValue(':entrega', $entrega);

        $statement->execute();



        header("HTTP/1.1 200 OK");

        echo "Entrega editada";

        exit();

    }

}



if ($_SERVER['REQUEST_METHOD'] == 'DELETE') {

    $id_user_evento = $_GET['id_user_evento'];

    $id_evento = $_GET['id_evento'];

    $user_id = $_GET['user_id'];

    $statement = $dbConn->prepare("DELETE FROM user_evento where id_user_evento =:id_user_evento");

    $statement->bindValue(':id_user_evento', $id_user_evento);



    $statement->execute();



    $statement = $dbConn->prepare("SELECT COUNT(*) 

    FROM user_evento WHERE id_evento = :id_evento");

    $statement->bindValue(':id_evento', $id_evento);

    $statement->execute();

    $count = $statement->fetchColumn();



    header("HTTP/1.1 200 OK");

    $carpetaEliminar = '../contratos/' . $id_evento . '/' . $user_id;

    eliminarCarpeta($carpetaEliminar);

    $carpetaEliminar = '../horarios/' . $id_evento . '/' . $user_id;

    eliminarCarpeta($carpetaEliminar);

    echo json_encode($count);

    exit();

}



function eliminarCarpeta($rutaCarpeta)

{

    // Obtener una lista de archivos y subcarpetas dentro de la carpeta

    $archivos = glob($rutaCarpeta . '/*');



    // Eliminar cada archivo encontrado

    foreach ($archivos as $archivo) {

        if (is_file($archivo)) {

            unlink($archivo);

        } elseif (is_dir($archivo)) {

            eliminarCarpeta($archivo);

        }

    }



    // Eliminar la carpeta

    if (is_dir($rutaCarpeta)) {

        rmdir($rutaCarpeta);

    }

}



//Actualizar

if ($_SERVER['REQUEST_METHOD'] == 'PUT') {

    $input = $_GET;

    $postId = $input['id'];

    $fields = getParams($input);



    $sql = "

          UPDATE posts

          SET $fields

          WHERE id='$postId'

           ";



    $statement = $dbConn->prepare($sql);

    bindAllValues($statement, $input);



    $statement->execute();

    header("HTTP/1.1 200 OK");

    exit();

}



//En caso de que ninguna de las opciones anteriores se haya ejecutado

header("HTTP/1.1 400 Bad Request");