<?php

include "utils.php";

$dbConn = connect($db);

/*
listar todos los posts o solo uno
 */
if ($_SERVER['REQUEST_METHOD'] == 'GET') {

    if (isset($_GET['id_sms'])) {
        //Mostrar un post
        $sql = $dbConn->prepare("SELECT * FROM sms where id_sms=:id_sms");
        $sql->bindValue(':id_sms', $_GET['id_sms']);
        $sql->execute();
        header("HTTP/1.1 200 OK");
        echo json_encode($sql->fetch(PDO::FETCH_ASSOC));
        exit();
    }
    if (isset($_GET['id_tag'])) {
        //Mostrar un post
        $sql = $dbConn->prepare("SELECT * FROM sms where id_tag=:id_tag");
        $sql->bindValue(':id_tag', $_GET['id_tag']);
        $sql->execute();
        header("HTTP/1.1 200 OK");
        echo json_encode($sql->fetchAll(), JSON_UNESCAPED_UNICODE);
        exit();
    } else {
        //Mostrar lista de post
        $sql = $dbConn->prepare("SELECT * FROM sms");
        $sql->execute();
        $sql->setFetchMode(PDO::FETCH_ASSOC);
        header("HTTP/1.1 200 OK");
        // echo var_dump($sql->fetchAll());
        echo json_encode($sql->fetchAll(), JSON_UNESCAPED_UNICODE);

        exit();
    }
}

// Crear un nuevo post
if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    if (isset($_POST["clientes_oferta"], $_POST["sms_habilitado"])) {


        // Obtener los datos enviados
        $clientes_oferta = $_POST["clientes_oferta"]; // Array de client_id
        $sms_habilitado = $_POST["sms_habilitado"];
        

      

        // Preparar la consulta SQL
        $sql = "UPDATE clientes 
                SET sms_habilitado = :sms_habilitado 
                WHERE client_id = :client_id;";
        $statement = $dbConn->prepare($sql);

        // Insertar cada cliente en la tabla
        foreach ($clientes_oferta as $client_id) {
            $statement->bindValue(':sms_habilitado', $sms_habilitado);
            $statement->bindValue(':client_id', $client_id);
          
            $statement->execute();
        }

        // Respuesta exitosa
        header("HTTP/1.1 200 OK");
        echo json_encode(["mensaje" => "Mensajes programados correctamente"]);
        exit();
    }

    if (isset($_POST["clientes"], $_POST["mensaje_sms"], $_POST["fecha_sms"])) {


        // Obtener los datos enviados
        $clientes = $_POST["clientes"]; // Array de client_id
        $mensaje_sms = trim($_POST["mensaje_sms"]);
        $fecha_programado = trim($_POST["fecha_sms"]);

        // Validar que los campos no estén vacíos
        if (empty($clientes) || empty($mensaje_sms) || empty($fecha_programado)) {
            header("HTTP/1.1 400 Bad Request");
            echo json_encode(["error" => "Todos los campos son obligatorios"]);
            exit();
        }

        // Preparar la consulta SQL
        $sql = "INSERT INTO sms (client_id, cuerpo, fecha_programado, estado) 
            VALUES (:client_id, :cuerpo, :fecha_programado, 'Pendiente')";
        $statement = $dbConn->prepare($sql);

        // Insertar cada cliente en la tabla
        foreach ($clientes as $client_id) {
            $statement->bindValue(':client_id', $client_id);
            $statement->bindValue(':cuerpo', $mensaje_sms);
            $statement->bindValue(':fecha_programado', $fecha_programado);
            $statement->execute();
        }

        // Respuesta exitosa
        header("HTTP/1.1 200 OK");
        echo json_encode(["mensaje" => "Mensajes programados correctamente"]);
        exit();
    }
}
//Borrar
if ($_SERVER['REQUEST_METHOD'] == 'DELETE') {
    $id = $_GET['id'];
    $statement = $dbConn->prepare("DELETE FROM posts where id=:id");
    $statement->bindValue(':id', $id);
    $statement->execute();
    header("HTTP/1.1 200 OK");
    exit();
}

//Actualizar
if ($_SERVER['REQUEST_METHOD'] == 'PUT') {
    $input = $_GET;
    $postId = $input['id'];
    $fields = getParams($input);

    $sql = "
          UPDATE posts
          SET $fields
          WHERE id='$postId'
           ";

    $statement = $dbConn->prepare($sql);
    bindAllValues($statement, $input);

    $statement->execute();
    header("HTTP/1.1 200 OK");
    exit();
}

//En caso de que ninguna de las opciones anteriores se haya ejecutado
header("HTTP/1.1 400 Bad Request");