<?php

// Ruta base de los archivos

$baseDir = '../sistema_archivos';



if (isset($_POST['action'])) {

    $action = $_POST['action'];



    switch ($action) {

        case 'uploadFile':

            if (isset($_FILES['fileToUpload']) && isset($_POST['path'])) {

                $path = $_POST['path'];

                $targetDir = $baseDir . '/Raiz/' . $path . '/';

        

                // Obtener el nombre del archivo y su extensión

                $fileName = basename($_FILES["fileToUpload"]["name"]);

                $targetFilePath = $targetDir . $fileName;

                $fileType = pathinfo($targetFilePath,PATHINFO_EXTENSION);

        

                // Verificar si el archivo ya existe

                if (file_exists($targetFilePath)) {

                    $response = array('success' =>false, 'message' => 'Ya existe un archivo con ese nombre y extensión.');

                } else {

                    // Mover el archivo temporal al directorio de destino

                    if (move_uploaded_file($_FILES["fileToUpload"]["tmp_name"], $targetFilePath)) {

                        $response = array('success' =>true, 'message' => 'Archivo subido correctamente.');

                    } else {

                        $response = array('success' =>false, 'message' => 'Error al subir el archivo.');

                    }

                }

            } else {

                $response = array('success' =>false, 'message' => 'Falta el archivo o la ruta.');

            }

           

            break;



        case 'create_folder':

            if (isset($_POST['parent']) && isset($_POST['name'])) {

                $parent = $_POST['parent'];

                $folderName = $_POST['name'];



                // Ruta completa del nodo padre en el sistema de archivos

                $parentPath = $baseDir . '/Raiz/' . $parent;

                $newFolderPath = $parentPath . '/' . $folderName;



                // Crear la nueva carpeta

                if (!file_exists($newFolderPath)) {

                    if (mkdir($newFolderPath, 0755, true)) {

                        $response = array('success' =>true, 'message' => 'Carpeta creada correctamente.');

                    } else {

                        $response = array('success' =>false, 'message' => 'Error al crear la carpeta.');

                    }

                } else {

                    $response = array('success' =>false, 'message' => 'La carpeta ya existe.');

                }



                

            }

            break;



        case 'rename_node':

            if (isset($_POST['node']) && isset($_POST['name'])) {

                $nodeId = $_POST['node'];

                $newName = $_POST['name'];



                // Ruta completa del nodo a renombrar

                $nodePath = $baseDir . '/Raiz/' . $nodeId;



                // Renombrar el nodo

                if (rename($nodePath, dirname($nodePath) . '/' . $newName)) {

                    $response = array('success' =>true, 'message' => 'Nodo renombrado correctamente.');

                } else {

                    $response = array('success' =>false, 'message' => 'Error al renombrar el nodo.');

                }



               

            }

            break;



        case 'delete_node':

            if (isset($_POST['node'])) {

                $nodeId = $_POST['node'];



                // Ruta completa del nodo a eliminar

                $nodePath = $baseDir . '/Raiz/' . $nodeId;



                // Verificar si es un directorio o un archivo

                if (is_dir($nodePath)) {

                    // Eliminar directorio y su contenido de forma recursiva

                    if (removeDir($nodePath)) {

                        $response = array('success' =>true, 'message' => 'Nodo eliminado correctamente.');

                    } else {

                        $response = array('success' =>false, 'message' => 'Error al eliminar el nodo.');

                    }

                } else {

                    // Eliminar archivo

                    if (unlink($nodePath)) {

                        $response = array('success' =>true, 'message' => 'Nodo eliminado correctamente.');

                    } else {

                        $response = array('success' =>false, 'message' => 'Error al eliminar el nodo.');

                    }

                }



               

            }

            break;



        default:

            // Acción no válida

            $response = array('success' =>false, 'message' => 'Acción no válida.');

            

            break;

    }

    // Devolver la respuesta como JSON

    header('Content-Type: application/json');

    echo json_encode($response);

    exit; // Finalizar la ejecución del script después de enviar la respuesta

}



// Función para eliminar directorios de forma recursiva

function removeDir($dir)

{

    if (is_dir($dir)) {

        $objects = scandir($dir);

        foreach ($objects as $object) {

            if ($object != '.' && $object != '..') {

                if (is_dir($dir . '/' . $object)) {

                    removeDir($dir . '/' . $object);

                } else {

                    unlink($dir . '/' . $object);

                }

            }

        }

        rmdir($dir);

        return true;

    }

    return false;

}

// Función recursiva para obtener la estructura de archivos

function getDirectoryTree($directory)

{

    $tree = [];

    $files = array_diff(scandir($directory), ['.', '..']);



    foreach ($files as $file) {

        $filePath = $directory . '/' . $file;

        if (is_dir($filePath)) {

            // Si es una carpeta, llamar recursivamente a la función para obtener su estructura

            $subtree = getDirectoryTree($filePath); // Obtener la estructura de la subcarpeta

            $tree[] = [

                'text' => $file,

                'children' => $subtree, // Asignar la estructura de la subcarpeta como hijos

                'type' => 'default', // Tipo para carpetas (por defecto),

                'icon' => '/assets/images/folder.svg' // Ícono para archivos

            ];

        } else {

            // Si es un archivo, determinar el tipo basado en la extensión u otra característica

            $fileExtension = pathinfo($filePath, PATHINFO_EXTENSION);

            $fileType = getFileType($fileExtension); // Función para determinar el tipo de archivo



            switch ($fileType) {

                case 'pdf':

                    $tree[] = [

                        'text' => $file,

                        'icon' => '/assets/images/pdf.svg', // Ícono para archivos

                        'type' => $fileType // Asignar el tipo específico del archivo

                    ];

                    break;

                case 'jpg':

                    $tree[] = [

                        'text' => $file,

                        'icon' => '/assets/images/jpg.svg', // Ícono para archivos

                        'type' => $fileType // Asignar el tipo específico del archivo

                    ];

                    break;

                case 'png':

                    $tree[] = [

                        'text' => $file,

                        'icon' => '/assets/images/png.svg', // Ícono para archivos

                        'type' => $fileType // Asignar el tipo específico del archivo

                    ];

                    break;

                default:

                    $tree[] = [

                        'text' => $file,

                        'icon' => '/assets/images/file.svg', // Ícono para archivos

                        'type' => $fileType // Asignar el tipo específico del archivo

                    ];

                    break;

            }

        }

    }



    return $tree;

}



// Función para determinar el tipo de archivo basado en la extensión (puedes personalizar según tus necesidades)

function getFileType($fileExtension)

{

    // Por ejemplo, asignar tipos específicos según la extensión del archivo

    switch ($fileExtension) {

        case 'txt':

            return 'txt'; // Tipo para archivos de texto (.txt)

        case 'pdf':

            return 'pdf'; // Tipo para archivos PDF (.pdf)

        case 'png':

            return 'png'; // Tipo para archivos PDF (.pdf)

        case 'jpg':

            return 'jpg'; // Tipo para archivos PDF (.pdf)

        case 'jpeg':

            return 'jpg'; // Tipo para archivos PDF (.pdf)

        case 'xlsx':

            return 'xlsx'; // Tipo para archivos PDF (.pdf)

        default:

            return 'file'; // Tipo genérico para otros tipos de archivos

    }

}

// Obtener la estructura de archivos desde la ruta base

$directoryTree = getDirectoryTree($baseDir);



// Devolver la estructura como JSON

header('Content-Type: application/json');

echo json_encode($directoryTree);