<?php



include "utils.php";

include "../libraries/image_upload.php";


include "../models/users.model.php";

$dbConn = connect($db);



/*

listar todos los posts o solo uno

*/

function organizarCarpetasEnArbol($carpetas, $idCarpetaPadre)

    {

    $arbol = array();



    foreach ($carpetas as $carpeta)

        {

        if ($carpeta['carpeta_id'] === $idCarpetaPadre)

            {

            if ($carpeta['type'] == "carpeta")

                {



                $carpeta['subcarpetas'] = organizarCarpetasEnArbol($carpetas, $carpeta['id_carpeta']);

                $carpeta['archivos'] = obtenerArchivos($carpeta['id_carpeta']); // Obtener los archivos de la carpeta





                } else

                {



                $carpeta['subcarpetas'] = [];

                $carpeta['archivos'] = []; // Obtener los archivos de la carp

                }

            $arbol[] = $carpeta;

            }

        }



    return $arbol;

    }



function obtenerArchivos($idCarpeta)

    {

    global $dbConn;



    try

        {

        if ($idCarpeta === null)

            {

            $consulta = $dbConn->prepare('SELECT *, "archivo" AS type FROM archivos WHERE carpeta_id IS NULL');

            } else

            {

            $consulta = $dbConn->prepare('SELECT *, "archivo" AS type FROM archivos WHERE carpeta_id = :idCarpeta');

            $consulta->bindParam(':idCarpeta', $idCarpeta);

            }

        $consulta->execute();



        $archivos = $consulta->fetchAll(PDO::FETCH_ASSOC);



        return $archivos;

        } catch (PDOException $e)

        {

        // Manejar errores de base de datos

        echo 'Error al obtener los archivos: ' . $e->getMessage();

        return array();

        }

    }



function obtenerRuta($id, $tipo)

    {

    global $dbConn;



    try

        {

        if ($id != null)

            {

            if ($tipo == "carpeta")

                {

                $consulta = $dbConn->prepare("

                WITH RECURSIVE parents AS (

                    SELECT id_carpeta, nombre, carpeta_id

                    FROM carpetas

                    WHERE id_carpeta = :id

                    UNION ALL

                    SELECT c.id_carpeta, c.nombre, c.carpeta_id

                    FROM carpetas c

                    INNER JOIN parents p ON c.id_carpeta = p.carpeta_id

                )

                SELECT nombre

                FROM parents;

                ");

                } else

                {

                $consulta = $dbConn->prepare("

                WITH RECURSIVE parents AS (

                    SELECT id_archivo, nombre, carpeta_id

                    FROM archivos

                    WHERE id_archivo = :id

                    UNION ALL

                    SELECT c.id_carpeta, c.nombre, c.carpeta_id

                    FROM carpetas c

                    INNER JOIN parents p ON c.id_carpeta = p.carpeta_id

                )

                SELECT nombre

                FROM parents;

                ");





                }

            } else

            {

            return "/";

            }



        $consulta->bindParam(':id', $id);

        $consulta->execute();



        $ruta = $consulta->fetchAll(PDO::FETCH_COLUMN);

        $inverted_names = array_reverse($ruta);

        $concatenacion_nombres = "/" . implode('/', $inverted_names);

        return $concatenacion_nombres;

        } catch (PDOException $e)

        {

        // Manejar errores de base de datos

        echo 'Error al obtener los archivos: ' . $e->getMessage();

        return 0;

        }

    }

function validarNombreCarpeta($nombre, $carpeta_id)

    {

    global $dbConn;



    try

        {

        // Preparar la consulta SQL

        if ($carpeta_id === null)

            {

            // Si el id_carpeta es null, buscar en la raíz

            $consulta = $dbConn->prepare('SELECT COUNT(*) FROM carpetas WHERE nombre = ? AND carpeta_id IS NULL');

            // Ejecutar la consulta con el nombre proporcionado

            $consulta->execute([$nombre]);

            } else

            {

            // Si se proporciona un id_carpeta, buscar en la ubicación específica

            $consulta = $dbConn->prepare('SELECT COUNT(*) FROM carpetas WHERE nombre = ? AND carpeta_id = ?');

            // Ejecutar la consulta con los datos proporcionados

            $consulta->execute([$nombre, $carpeta_id]);

            }



        // Obtener el resultado de la consulta

        $resultado = $consulta->fetchColumn();



        // Si el resultado es mayor a 0, significa que ya existe una carpeta con el mismo nombre en la misma ubicación

        if ($resultado > 0)

            {

            return false; // La carpeta ya existe

            } else

            {

            return true; // La carpeta no existe

            }

        } catch (PDOException $e)

        {

        // Manejar errores de base de datos

        echo 'Error al validar el nombre de la carpeta: ' . $e->getMessage();

        return false; // Error al ejecutar la consulta

        }

    }

function validarNombreArchivo($nombre, $id_carpeta)

    {

    global $dbConn;



    try

        {

        // Preparar la consulta SQL

        if ($id_carpeta === null)

            {

            // Si el id_carpeta es null, buscar en la raíz

            $consulta = $dbConn->prepare('SELECT COUNT(*) FROM archivos WHERE nombre = ? AND carpeta_id IS NULL');

            // Ejecutar la consulta con el nombre proporcionado

            $consulta->execute([$nombre]);

            } else

            {

            // Si se proporciona un id_carpeta, buscar en la ubicación específica

            $consulta = $dbConn->prepare('SELECT COUNT(*) FROM archivos WHERE nombre = ? AND carpeta_id = ?');

            // Ejecutar la consulta con los datos proporcionados

            $consulta->execute([$nombre, $id_carpeta]);

            }



        // Obtener el resultado de la consulta

        $resultado = $consulta->fetchColumn();



        // Si el resultado es mayor a 0, significa que ya existe una carpeta con el mismo nombre en la misma ubicación

        if ($resultado > 0)

            {



            return false; // La carpeta ya existe

            } else

            {

            return true; // La carpeta no existe

            }

        } catch (PDOException $e)

        {

        // Manejar errores de base de datos

        echo 'Error al validar el nombre del archivo: ' . $e->getMessage();

        return false; // Error al ejecutar la consulta

        }

    }



if ($_SERVER['REQUEST_METHOD'] === 'POST')

    {

    // CREAR CARPETA

    if (isset($_POST['nombre']) && isset($_POST['carpeta_id']))

        {

        // Obtener los datos de la carpeta desde la solicitud

        $nombre = $_POST['nombre'];

        $carpeta_id = $_POST['carpeta_id'];



        if ($carpeta_id === '')

            {

            $carpeta_id = null;

            }



        if (validarNombreCarpeta($nombre, $carpeta_id))

            {

            try

                {

                // Preparar la consulta SQL

                $consulta = $dbConn->prepare('INSERT INTO carpetas (nombre, carpeta_id) VALUES (?, ?)');

                // Ejecutar la consulta con los datos proporcionados

                $consulta->execute([$nombre, $carpeta_id]);



                // Obtener el ID de la carpeta recién insertada

                $id_carpeta = $dbConn->lastInsertId();



                // Obtener los datos completos de la carpeta

                $consulta = $dbConn->prepare('SELECT * FROM carpetas WHERE id_carpeta = ?');

                $consulta->execute([$id_carpeta]);

                $carpeta = $consulta->fetch(PDO::FETCH_ASSOC);

                $folder = '../archivos' . obtenerRuta($id_carpeta, "carpeta");



                mkdir($folder, 0777, true);

                // Devolver una respuesta JSON con los datos de la carpeta

                header('Content-Type: application/json');

                echo json_encode($carpeta);

                exit();

                } catch (PDOException $e)

                {

                // Manejar errores de base de datos

                echo 'Error al agregar la carpeta: ' . $e->getMessage();

                }



            } else

            {

            // La carpeta ya existe, devolver un mensaje de error

            echo 0;

            exit();

            }

        }



    //RENOMBRAR 

    if (isset($_POST['id']) && isset($_POST['tipo']) && isset($_POST['nuevo_nombre']))

        {

        $id = $_POST['id'];

        $tipo = $_POST['tipo'];

        $nuevoNombre = $_POST['nuevo_nombre'];

        $carpeta_id = $_POST['carpeta_id'];

        if ($carpeta_id === '')

            {

            $carpeta_id = null;

            }

        try

            {

            // Verificar si el tipo es carpeta o archivo

            if ($tipo === 'carpeta')

                {



                // Validar el nuevo nombre de la carpeta

                if (!validarNombreCarpeta($nuevoNombre, $carpeta_id))

                    {

                    // El nombre no cumple con la condición, devolver un mensaje de error

                    echo 0;

                    exit();

                    }

                $rutaCarpeta = '../archivos' . obtenerRuta($id, "carpeta");

                // Actualizar el nombre de la carpeta en la base de datos

                $consulta = $dbConn->prepare('UPDATE carpetas SET nombre = ? WHERE id_carpeta = ?');

                $consulta->execute([$nuevoNombre, $id]);



                $nuevaRutaCarpeta = dirname($rutaCarpeta) . '/' . $nuevoNombre;

                rename($rutaCarpeta, $nuevaRutaCarpeta);



                // Devolver una respuesta de éxito

                echo 'Carpeta renombrada exitosamente';

                exit();

                } elseif ($tipo === 'archivo')

                {

                // Validar el nuevo nombre del archivo

                if (!validarNombreArchivo($nuevoNombre, $carpeta_id))

                    {

                    // El nombre no cumple con la condición, devolver un mensaje de error

                    echo 0;

                    exit();

                    }

                $consulta = $dbConn->prepare('SELECT * FROM archivos WHERE id_archivo = ?');

                $consulta->execute([$id]);

                $archivo = $consulta->fetch(PDO::FETCH_ASSOC);

                // Actualizar el nombre del archivo en la base de datos

                $consulta = $dbConn->prepare('UPDATE archivos SET nombre = ? WHERE id_archivo = ?');

                $consulta->execute([$nuevoNombre, $id]);







                $rutaArchivo = ".." . $archivo["url"] . "." . $archivo["extension"];



                $nuevaRutaArchivo = dirname($rutaArchivo) . '/' . $nuevoNombre . "." . $archivo["extension"];

                rename($rutaArchivo, $nuevaRutaArchivo);







                // Devolver una respuesta de éxito

                echo 'Archivo renombrado exitosamente';

                exit();

                } else

                {

                // Tipo inválido, devolver un mensaje de error

                echo 'Tipo inválido';

                exit();

                }

            } catch (PDOException $e)

            {

            // Manejar errores de base de datos

            echo 'Error al renombrar ' . $tipo . ': ' . $e->getMessage();

            }

        }

    //MOVER ELEMENTO

    if (isset($_POST['tipo_mover']) && isset($_POST['nombre_mover']) && isset($_POST['carpeta_id']) && isset($_POST['id']))

        {



        $tipo = $_POST['tipo_mover'];

        $nombre = $_POST['nombre_mover'];

        $carpeta_id = $_POST['carpeta_id'];

        $id = $_POST['id'];



        if ($carpeta_id === '')

            {

            $carpeta_id = null;

            }





        try

            {

            // Verificar si el tipo es carpeta o archivo

            if ($tipo === 'carpeta')

                {



                // Validar el nuevo nombre de la carpeta

                if (!validarNombreCarpeta($nombre, $carpeta_id))

                    {

                    // El nombre no cumple con la condición, devolver un mensaje de error

                    echo 0;

                    exit();

                    }

                $rutaCarpeta = '../archivos' . obtenerRuta($id, "carpeta");

                // Actualizar el nombre de la carpeta en la base de datos

                $consulta = $dbConn->prepare('UPDATE carpetas SET carpeta_id = ? WHERE id_carpeta = ?');

                $consulta->execute([$carpeta_id, $id]);



                $nuevaRutaCarpeta = '../archivos' . obtenerRuta($id, "carpeta");



                rename($rutaCarpeta, $nuevaRutaCarpeta);

                // Devolver una respuesta de éxito

                echo 'Carpeta renombrada exitosamente';

                exit();

                } elseif ($tipo === 'archivo')

                {

                // Validar el nuevo nombre del archivo

                if (!validarNombreArchivo($nombre, $carpeta_id))

                    {

                    // El nombre no cumple con la condición, devolver un mensaje de error

                    echo 0;

                    exit();

                    }



                $consulta = $dbConn->prepare('SELECT * FROM archivos WHERE id_archivo = ?');

                $consulta->execute([$id]);

                $archivo = $consulta->fetch(PDO::FETCH_ASSOC);



                $rutaCarpeta = '../archivos' . obtenerRuta($id, "archivo") . "." . $archivo["extension"];

                // Actualizar el nombre del archivo en la base de datos

                $consulta = $dbConn->prepare('UPDATE archivos SET carpeta_id = ? WHERE id_archivo = ?');

                $consulta->execute([$carpeta_id, $id]);



                $nuevaRutaCarpeta = '../archivos' . obtenerRuta($id, "archivo") . "." . $archivo["extension"];

                rename($rutaCarpeta, $nuevaRutaCarpeta); // Devolver una respuesta de éxito



                echo 'Archivo renombrado exitosamente';

                exit();

                } else

                {

                // Tipo inválido, devolver un mensaje de error

                echo 'Tipo inválido';

                exit();

                }

            } catch (PDOException $e)

            {

            // Manejar errores de base de datos

            echo 'Error al renombrar ' . $tipo . ': ' . $e->getMessage();

            }

        } else





        // CREAR ARCHIVO

        if (isset($_POST['nombre']) && isset($_POST['id_carpeta']) && isset($_FILES['archivo']) && isset($_POST['tipo_archivo']))

            {

            // Obtener los datos de la carpeta desde la solicitud

            $nombre = $_POST['nombre'];

            $id_carpeta = $_POST['id_carpeta'];

            $tipo = $_POST['tipo_archivo'];

            $nombreArchivo = $_FILES['archivo']['name'];

            $rutaArchivoTemporal = $_FILES['archivo']['tmp_name'];

            $url = "url";

            $valores = explode('.', $nombreArchivo);

            $extension = $valores[count($valores) - 1];





            if ($id_carpeta === '')

                {

                $id_carpeta = null;

                }



            if (validarNombreArchivo($nombre, $id_carpeta))

                {

                try

                    {

                    // Preparar la consulta SQL

                    $consulta = $dbConn->prepare('INSERT INTO archivos (nombre, carpeta_id, tipo, url, extension) VALUES (?, ?, ?, ?, ?)');

                    // Ejecutar la consulta con los datos proporcionados

                    $consulta->execute([$nombre, $id_carpeta, $tipo, $url, $extension]);



                    // Obtener el ID de la carpeta recién insertada

                    $id_archivo = $dbConn->lastInsertId();



                    $url = '/archivos' . obtenerRuta($id_archivo, "archivo");



                    $consulta = $dbConn->prepare('UPDATE archivos SET url = ? WHERE id_archivo = ?');

                    $consulta->execute([$url, $id_archivo]);





                    // Obtener los datos completos de la carpeta

                    $consulta = $dbConn->prepare('SELECT * FROM archivos WHERE id_archivo = ?');

                    $consulta->execute([$id_archivo]);

                    $archivo = $consulta->fetch(PDO::FETCH_ASSOC);





                    $rutaDestino = ".." . $url . "." . $extension;



                    move_uploaded_file($rutaArchivoTemporal, $rutaDestino);

                    // Devolver una respuesta JSON con los datos de la carpeta

                    header('Content-Type: application/json');

                    echo json_encode($archivo);

                    exit();

                    } catch (PDOException $e)

                    {

                    // Manejar errores de base de datos

                    echo 'Error al agregar el archivo: ' . $e->getMessage();

                    }



                } else

                {

                // La carpeta ya existe, devolver un mensaje de error

                echo 0;

                exit();



                }

            }

    }





if ($_SERVER['REQUEST_METHOD'] === 'GET')

    {

    try

        {

        $consulta = $dbConn->prepare('

            WITH RECURSIVE carpeta_cte AS (

                SELECT id_carpeta, nombre, carpeta_id, "carpeta" AS type

                FROM carpetas

                WHERE carpeta_id IS NULL

                UNION ALL

                SELECT c.id_carpeta, c.nombre, c.carpeta_id, "carpeta" AS type

                FROM carpeta_cte cc

                INNER JOIN carpetas c ON c.carpeta_id = cc.id_carpeta

            )

            SELECT id_carpeta, nombre, carpeta_id, type FROM carpeta_cte

        ');

        $consulta->execute();



        // Obtener todas las carpetas y subcarpetas

        $carpetas = $consulta->fetchAll(PDO::FETCH_ASSOC);

        // Obtener todos los archivos



        $archivosEnRaiz = obtenerArchivos(null);



        // Concatenar los archivos en la raíz al arreglo de carpetas

        $carpetas = array_merge($carpetas, $archivosEnRaiz);



        // Organizar las carpetas y archivos en el árbol

        $arbolCarpetas = organizarCarpetasEnArbol($carpetas, null);

        // Devolver una respuesta JSON con las carpetas y subcarpetas

        header('Content-Type: application/json');

        echo json_encode($arbolCarpetas);

        exit();

        } catch (PDOException $e)

        {

        // Manejar errores de base de datos

        echo 'Error al obtener las carpetas: ' . $e->getMessage();

        }

    }



if ($_SERVER['REQUEST_METHOD'] === 'DELETE')

    {



    if (isset($_GET['id']) && isset($_GET['tipo']))

        {

        $tipo = $_GET['tipo'];

        $id = $_GET['id'];

        if ($tipo == "carpeta")

            {



            $statement = $dbConn->prepare("DELETE FROM carpetas where id_carpeta=:id");

            $ruta = '../archivos' . obtenerRuta($id, "carpeta");

            eliminarDirectorio($ruta);

            } else

            {

            // Obtener los datos completos de la carpeta

            $consulta = $dbConn->prepare('SELECT * FROM archivos WHERE id_archivo = ?');

            $consulta->execute([$id]);

            $archivo = $consulta->fetch(PDO::FETCH_ASSOC);





            $statement = $dbConn->prepare("DELETE FROM archivos where id_archivo=:id");

            $ruta = '../archivos' . obtenerRuta($id, "archivo") . "." . $archivo["extension"];

            unlink($ruta);

            }



        $statement->bindValue(':id', $id);

        $statement->execute();

        header("HTTP/1.1 200 OK");

        exit();

        }



    }





function eliminarDirectorio($directorio)

    {

    if (!is_dir($directorio))

        {

        return;

        }



    $archivos = glob($directorio . '/*');



    foreach ($archivos as $archivo)

        {

        if (is_dir($archivo))

            {

            eliminarDirectorio($archivo);

            } else

            {

            unlink($archivo);

            }

        }



    rmdir($directorio);

    }



//En caso de que ninguna de las opciones anteriores se haya ejecutado

header("HTTP/1.1 400 Bad Request");