<?php














// Establecer encabezados de respuesta



header('Content-Type: application/json');



header('Access-Control-Allow-Origin: *'); // Permitir solicitudes de cualquier origen



header('Access-Control-Allow-Methods: GET, POST, PUT, DELETE'); // Métodos permitidos



header('Access-Control-Allow-Headers: Content-Type, Authorization');







// Conexión a la base de datos



$conexion = new mysqli(DB_SERVER, DB_USERNAME, DB_PASSWORD, DB_NAME);









// Comprobar la conexión



if ($conexion->connect_error) {



    http_response_code(500); // Error en el servidor



    echo json_encode(['status' => 'error', 'message' => 'Error al conectar con la base de datos.']);



    exit();



}



$conexion->set_charset("utf8");



// Obtener el nombre de la tabla de la URL



$table = isset($_GET['table']) ? $_GET['table'] : '';







// Validar el nombre de la tabla (debes tener una lista de tablas válidas)



















// Manejo de solicitudes POST

if ($_SERVER['REQUEST_METHOD'] === 'POST') {

    $nombre = isset($_POST['nombre']) ? trim($_POST['nombre']) : '';



    if (empty($nombre)) {

        http_response_code(400);

        echo json_encode(['status' => 'error', 'message' => 'El nombre no puede estar vacío.']);

        exit();

    }



    // Verificar si el nombre ya existe en la tabla

    $nombre = $conexion->real_escape_string($nombre);

    $query_check = "SELECT id FROM $table WHERE nombre = '$nombre'";

    $result_check = $conexion->query($query_check);



    if ($result_check->num_rows > 0) {

        http_response_code(409); // Conflict

        echo json_encode(['status' => 'error', 'message' => 'El nombre ya existe.']);

        exit();

    }



    // Si no existe, proceder con la inserción

    $query = "INSERT INTO $table (nombre) VALUES ('$nombre')";

    if ($conexion->query($query) === TRUE) {

        $nuevo_id = $conexion->insert_id;

        echo json_encode(['status' => 'success', 'id' => $nuevo_id, 'nombre' => $nombre]);

    } else {

        http_response_code(500);

        echo json_encode(['status' => 'error', 'message' => 'Error al agregar el estado.']);

    }



    $conexion->close();

    exit();

}







// Manejo de solicitudes DELETE



if ($_SERVER['REQUEST_METHOD'] === 'DELETE') {



    // Obtener el ID del estado a eliminar



    parse_str(file_get_contents("php://input"), $_DELETE); // Para obtener datos de la solicitud DELETE



    $id = isset($_DELETE['id']) ? intval($_DELETE['id']) : 0;







    // Validar que el ID sea válido



    if ($id <= 0) {



        http_response_code(400); // Bad Request



        echo json_encode(['status' => 'error', 'message' => 'ID no válido.']);



        exit();



    }







    // Preparar la consulta para evitar inyecciones SQL



    $query = "DELETE FROM $table WHERE id = $id";







    // Ejecutar la consulta



    if ($conexion->query($query) === TRUE) {



        // Respuesta en formato JSON



        echo json_encode(['status' => 'success', 'message' => 'Estado eliminado correctamente.']);



    } else {



        // Error al eliminar



        http_response_code(500); // Error en el servidor



        echo json_encode(['status' => 'error', 'message' => 'Error al eliminar el estado.']);



    }







    // Cerrar la conexión



    $conexion->close();



    exit();



}







// Manejo de solicitudes PUT



// Manejo de solicitudes PUT

if ($_SERVER['REQUEST_METHOD'] === 'PUT') {

    parse_str(file_get_contents("php://input"), $_PUT);



    $id = isset($_PUT['id']) ? intval($_PUT['id']) : 0;

    $nombre = isset($_PUT['nombre']) ? trim($_PUT['nombre']) : '';



    if ($id <= 0) {

        http_response_code(400);

        echo json_encode(['status' => 'error', 'message' => 'ID no válido.']);

        exit();

    }

    if (empty($nombre)) {

        http_response_code(400);

        echo json_encode(['status' => 'error', 'message' => 'El nombre no puede estar vacío.']);

        exit();

    }



    // Verificar si el nombre ya existe en la tabla, excluyendo el registro actual

    $nombre = $conexion->real_escape_string($nombre);

    $query_check = "SELECT id FROM $table WHERE nombre = '$nombre' AND id != $id";

    $result_check = $conexion->query($query_check);



    if ($result_check->num_rows > 0) {

        http_response_code(409); // Conflict

        echo json_encode(['status' => 'error', 'message' => 'El nombre ya existe.']);

        exit();

    }



    // Si no existe, proceder con la actualización

    $query = "UPDATE $table SET nombre = '$nombre' WHERE id = $id";

    if ($conexion->query($query) === TRUE) {

        if ($conexion->affected_rows > 0) {

            echo json_encode(['status' => 'success', 'message' => 'Estado actualizado correctamente.', 'id' => $id, 'nombre' => $nombre]);

        } else {

            http_response_code(404);

            echo json_encode(['status' => 'error', 'message' => 'No se encontró el estado o no hubo cambios.']);

        }

    } else {

        http_response_code(500);

        echo json_encode(['status' => 'error', 'message' => 'Error al actualizar el estado.']);

    }



    $conexion->close();

    exit();

}







// Manejo de solicitudes GET



if ($_SERVER['REQUEST_METHOD'] === 'GET') {



    // Consultar todos los elementos de la tabla especificada



    $query = "SELECT id, nombre FROM $table";



    $resultado = $conexion->query($query);







    // Verificar si se obtuvieron resultados



    if ($resultado->num_rows > 0) {



        $estados = [];







        // Recorrer los resultados y agregarlos al array



        while ($fila = $resultado->fetch_assoc()) {



            $estados[] = $fila;



        }







        // Respuesta en formato JSON



        echo json_encode([



            'status' => 'success',



            'items' => $estados



        ]);



    } else {



        // Si no hay elementos en la tabla



        echo json_encode([



            'status' => 'success',



            'items' => [] // Retorna un array vacío



        ]);



    }







    // Cerrar la conexión



    $conexion->close();



    exit();



}







// Si llegamos aquí, la solicitud no fue válida



http_response_code(400); // Bad Request



echo json_encode(['status' => 'error', 'message' => 'Solicitud no válida.']);