<?php



include "utils.php";

include "../libraries/image_upload.php";


include "../models/users.model.php";

$dbConn = connect($db);



/*

listar todos los posts o solo uno

*/

if ($_SERVER['REQUEST_METHOD'] == 'GET') {

    if (isset($_GET['personalizacion'])) {

        $personalizacion = json_decode(file_get_contents('../personalizacion.json'), true);

        header("HTTP/1.1 200 OK");

        echo json_encode($personalizacion);

        exit();
    }



    if (isset($_GET['id_factura'])) {

        //Mostrar un post

        $sql = $dbConn->prepare("SELECT * FROM facturas where id_factura=:id_factura");

        $sql->bindValue(':id_factura', $_GET['id_factura']);

        $sql->execute();

        header("HTTP/1.1 200 OK");

        echo json_encode($sql->fetch(PDO::FETCH_ASSOC));

        exit();
    }

    if (isset($_GET['fecha_i']) && isset($_GET['fecha_i'])) {

        $fecha_i = $_GET['fecha_i'];

        $fecha_f = $_GET['fecha_f'];

        if ($fecha_i == "No" && $fecha_f == "No") {

            //Mostrar lista de post

            $sql = "SELECT f.*, u.user_full_name 

            FROM files f 

            JOIN users u ON f.file_user = u.user_id 

            WHERE f.file_type = :file_type";

            $stmt = $dbConn->prepare($sql);



            // Obtener clientes potenciales

            $URL = 'URL';

            $stmt->bindParam(':file_type', $URL);

            $stmt->execute();

            $URLS = $stmt->fetchAll(PDO::FETCH_OBJ);

            // Obtener clientes aceptados

            $Imagen = 'Imagen';

            $stmt->bindParam(':file_type', $Imagen);

            $stmt->execute();

            $Imagenes = $stmt->fetchAll(PDO::FETCH_OBJ);

            $Archivo = 'Archivo';

            $stmt->bindParam(':file_type', $Archivo);

            $stmt->execute();

            $Archivos = $stmt->fetchAll(PDO::FETCH_OBJ);

            $recursos["URL"] = $URLS;

            $recursos["imagenes"] = $Imagenes;

            $recursos["archivos"] = $Archivos;



            // Devolver objeto de clientes

            header("HTTP/1.1 200 OK");

            echo json_encode($recursos);

            exit();
        } else {

            $sql = "SELECT f.*, u.user_full_name 

            FROM files f 

            JOIN users u ON f.file_user = u.user_id 

            WHERE f.file_type = :file_type AND f.fecha BETWEEN :fecha_i AND :fecha_f";

            $stmt = $dbConn->prepare($sql);



            // Obtener clientes potenciales

            $URL = 'URL';

            $stmt->bindParam(':file_type', $URL);

            $stmt->bindParam(':fecha_i', $fecha_i);

            $stmt->bindParam(':fecha_f', $fecha_f);

            $stmt->execute();

            $URLS = $stmt->fetchAll(PDO::FETCH_OBJ);

            // Obtener clientes aceptados

            $Imagen = 'Imagen';

            $stmt->bindParam(':file_type', $Imagen);

            $stmt->bindParam(':fecha_i', $fecha_i);

            $stmt->bindParam(':fecha_f', $fecha_f);

            $stmt->execute();

            $Imagenes = $stmt->fetchAll(PDO::FETCH_OBJ);

            $Archivo = 'Archivo';

            $stmt->bindParam(':file_type', $Archivo);

            $stmt->bindParam(':fecha_i', $fecha_i);

            $stmt->bindParam(':fecha_f', $fecha_f);

            $stmt->execute();

            $Archivos = $stmt->fetchAll(PDO::FETCH_OBJ);

            $recursos["URL"] = $URLS;

            $recursos["imagenes"] = $Imagenes;

            $recursos["archivos"] = $Archivos;



            // Devolver objeto de clientes

            header("HTTP/1.1 200 OK");

            echo json_encode($recursos);

            exit();
        }
    }

    if (isset($_GET['dias'])) {



        $dias = json_decode($_GET['dias']);

        $recursos = array();



        foreach ($dias as $fecha_formato) {



            $sql = "SELECT COUNT(*) as cantidad  FROM files WHERE DATE(fecha) = :fecha AND file_type = 'URL'";

            // Preparar la consulta SQL utilizando PDO

            $stmt = $dbConn->prepare($sql);

            $stmt->bindValue(':fecha', $fecha_formato, PDO::PARAM_STR);

            $stmt->execute();

            $row = $stmt->fetch(PDO::FETCH_ASSOC);

            $cantidad_url = $row['cantidad'];

            $sql = "SELECT COUNT(*) as cantidad  FROM files WHERE DATE(fecha) = :fecha AND file_type = 'Imagen'";

            // Preparar la consulta SQL utilizando PDO

            $stmt = $dbConn->prepare($sql);

            $stmt->bindValue(':fecha', $fecha_formato, PDO::PARAM_STR);

            $stmt->execute();

            $row = $stmt->fetch(PDO::FETCH_ASSOC);

            $cantidad_img = $row['cantidad'];

            $sql = "SELECT COUNT(*) as cantidad  FROM files WHERE DATE(fecha) = :fecha AND file_type = 'Archivo'";

            // Preparar la consulta SQL utilizando PDO

            $stmt = $dbConn->prepare($sql);

            $stmt->bindValue(':fecha', $fecha_formato, PDO::PARAM_STR);

            $stmt->execute();

            $row = $stmt->fetch(PDO::FETCH_ASSOC);

            $cantidad_archivo = $row['cantidad'];



            // Crear un objeto con la fecha y la cantidad de facturas y agregarlo al arreglo $facturas_por_dia

            $objeto = array("dia" => $fecha_formato, "cantidad_url" => $cantidad_url, "cantidad_img" => $cantidad_img, "cantidad_archivo" => $cantidad_archivo);

            array_push($recursos, $objeto);
        }

        // Devolver los resultados en formato JSON

        header('Content-Type: application/json');

        echo json_encode($recursos);

        exit();
    } else {

        //Mostrar lista de post

        $sql = $dbConn->prepare("SELECT * FROM files");

        $sql->execute();

        $sql->setFetchMode(PDO::FETCH_ASSOC);

        header("HTTP/1.1 200 OK");



        echo json_encode($sql->fetchAll());

        exit();
    }
}



// Crear un nuevo post

if ($_SERVER['REQUEST_METHOD'] == 'POST') {

    if (isset($_POST["imagen_user_url"])) {

        $URL = $_POST["imagen_user_url"];

        $Users = new _UsersModel($DBLink);

        $User_Data = $Users->_GetUserData();

        $id = $User_Data['user_id'];



        $sql = "UPDATE users SET user_avatar = :URL WHERE user_id = :id";

        $stmt = $dbConn->prepare($sql);



        $stmt->bindParam(':id', $id);



        $stmt->bindParam(':URL', $URL);

        $stmt->execute();



        header("HTTP/1.1 200 OK");

        echo json_encode($URL);

        exit();
    }



    if (isset($_POST["imagen_portada_user_url"])) {

        $URL = $_POST["imagen_portada_user_url"];

        $Users = new _UsersModel($DBLink);

        $User_Data = $Users->_GetUserData();

        $id = $User_Data['user_id'];



        $sql = "UPDATE users SET fondo_portada = :URL WHERE user_id = :id";

        $stmt = $dbConn->prepare($sql);



        $stmt->bindParam(':id', $id);



        $stmt->bindParam(':URL', $URL);

        $stmt->execute();



        header("HTTP/1.1 200 OK");

        echo json_encode($URL);

        exit();
    }
    

    if (isset($_FILES["imagen"])) {

        $imagen = $_FILES["imagen"];

        $Upload = new _ImageUpload($DBLink, '../uploads');

        $URL = $Upload->_SaveImage($imagen);



        header("HTTP/1.1 200 OK");

        echo json_encode($URL);

        exit();
    }

    if (isset($_FILES["informe"])) {

        $informe = $_FILES["informe"];

        $nombreArchivo = $_FILES['informe']['name'];

        $archivoTemporal = $_FILES['informe']['tmp_name'];

        $rutaDestino = '../Informes/' . $nombreArchivo; // Ruta a la carpeta donde deseas guardar el archivo

        $archivos = glob('../Informes/' . $nombreArchivo . '*');

        foreach ($archivos as $archivo) {

            if (is_file($archivo)) {

                unlink($archivo);
            }
        }

        header("HTTP/1.1 200 OK");

        if (move_uploaded_file($archivoTemporal, $rutaDestino)) {

            echo 'Archivo guardado exitosamente.';
        } else {

            echo 'Error al guardar el archivo.';
        }

        exit();
    }

    if (

        isset($_POST["vaciar"])

    ) {



        $archivos = glob('../Informes/*');

        foreach ($archivos as $archivo) {

            if (is_file($archivo)) {

                unlink($archivo);
            }
        }

        header("HTTP/1.1 200 OK");

        echo 'Archivos borrados.';

        exit();
    }

    if (isset($_POST["comprimir"])) {

        $zip = new ZipArchive();

        $zipName = "Informes.zip";

        if ($zip->open("../Informes/" . $zipName, ZipArchive::CREATE) === true) {

            // Obtener la lista de archivos en la carpeta

            $files = new RecursiveIteratorIterator(

                new RecursiveDirectoryIterator("../Informes/"),

                RecursiveIteratorIterator::LEAVES_ONLY

            );



            foreach ($files as $name => $file) {

                if (!$file->isDir()) {

                    // Obtener la ruta relativa del archivo dentro de la carpeta

                    $filePath = $file->getRealPath();

                    $relativePath = substr($filePath, strlen(realpath("../Informes/")) + 1);



                    // Añadir el archivo al ZIP con su ruta relativa

                    $zip->addFile($filePath, $relativePath);
                }
            }



            // Cerrar el archivo ZIP

            $zip->close();



            $response = array(

                'zip_url' => "Informes/" . $zipName

            );

            header("HTTP/1.1 200 OK");

            echo json_encode($response);

            exit();

            // Eliminar el archivo ZIP después de descargarlo

            //unlink($zipName);

        }
    }
}



//Borrar

if ($_SERVER['REQUEST_METHOD'] == 'DELETE') {





    if (

        isset($_GET['id'])

    ) {

        $id = $_GET['id'];

        $Upload = new _ImageUpload($DBLink);

        $Upload->_DeleteImage($id);



        header("HTTP/1.1 200 OK");

        echo json_encode($id);

        exit();
    }
}



//Actualizar

if ($_SERVER['REQUEST_METHOD'] == 'PUT') {

    $input = $_GET;

    $postId = $input['id'];

    $fields = getParams($input);



    $sql = "

          UPDATE posts

          SET $fields

          WHERE id='$postId'

           ";



    $statement = $dbConn->prepare($sql);

    bindAllValues($statement, $input);



    $statement->execute();

    header("HTTP/1.1 200 OK");

    exit();
}



//En caso de que ninguna de las opciones anteriores se haya ejecutado

header("HTTP/1.1 400 Bad Request");