<?php



include "utils.php";



include "../models/users.model.php";



$dbConn = connect($db);





// Crear un nuevo post

if ($_SERVER['REQUEST_METHOD'] == 'POST') {

    $email = $_POST['data']['email'];

    if (!filter_var($email, FILTER_VALIDATE_EMAIL)) {

        $output['msg'] = 'Formato de email no válido';

        echo json_encode($output);

        die();

    }



    $sql = $dbConn->prepare("SELECT * FROM users where user_email=:email");

    $sql->bindValue(':email', $email);

    $sql->execute();

    $check_email_result = $sql->fetch(PDO::FETCH_ASSOC);

    if ($check_email_result == false) {

        $output['msg'] = 'No se ha encontrado ningún usuario con el identificador proporcionado';

        echo json_encode($output);

        die();

    }



    if ($check_email_result['user_role'] == -1) {

        $output['msg'] = 'Tu usuario ha sido baneado';

        echo json_encode($output);

        die();

    }





    //Check for Unverified User

    if ($check_email_result['user_role'] == 0) {

        $output['msg'] = 'Usuario no verificado';

        echo json_encode($output);

        die();

    }



    if ($check_email_result['user_verification_status'] == '0') {

        $output['msg'] = 'Cuenta pendiente de admisión';

        echo json_encode($output);

        die();

    }



    $bytes = random_bytes(100);

    $bin2 = bin2hex($bytes);



    session_start();

    $_SESSION['recover_token'] = $bin2;



    $personalizacion = json_decode(file_get_contents('../personalizacion.json'), true);

    $Newsletter = file_get_contents('../emails/recover.html');

    $Keywords[] = array('%imagen%', htmlentities($personalizacion['imagen_email_usuario'], ENT_QUOTES));

    $Keywords[] = array('%user_name%', htmlentities($check_email_result['user_full_name'], ENT_QUOTES));

    $Keywords[] = array('%url%', WEBSITE_URL . 'recover_login?token=' . $bin2 . '_' . $check_email_result['user_id']);



    $Mailer = new _MailerModel(EMAIL_SERVER, EMAIL_PORT, EMAIL_VALIDATE_USERNAME, EMAIL_VALIDATE_PASSWORD);



    $Mailer->_SetKeywords($Keywords);



    $output['xd'] = $Mailer->_Mail(

        EMAIL_VALIDATE_USERNAME,

        $email,

        'Recupera tu contraseña',

        $Newsletter,

        APP_NAME,

    );



    $output['msg'] = 'Correo de recuperación enviado correctamente a ' . $email;

    $output['status'] = true;

    echo json_encode($output);

    die();

}

//En caso de que ninguna de las opciones anteriores se haya ejecutado

header("HTTP/1.1 400 Bad Request");