<?php



include "utils.php";



$dbConn = connect($db);



/*

listar todos los posts o solo uno

 */

if ($_SERVER['REQUEST_METHOD'] == 'GET') {

  if (isset($_GET['id_gasto_proyecto'])) {

    //Mostrar un post

    $sql = $dbConn->prepare("SELECT * FROM gasto_proyecto where id_gasto_proyecto=:id_gasto_proyecto");

    $sql->bindValue(':id_gasto_proyecto', $_GET['id_gasto_proyecto']);

    $sql->execute();

    $gasto_proyecto = $sql->fetch(PDO::FETCH_ASSOC);

    

    header("HTTP/1.1 200 OK");

    echo json_encode($gasto_proyecto);

    exit();

}

  if (isset($_GET['id_proyecto'])) {

    //Mostrar un post

    $sql = $dbConn->prepare("SELECT * FROM proyectos where id_proyecto=:id_proyecto");

    $sql->bindValue(':id_proyecto', $_GET['id_proyecto']);

    $sql->execute();

    header("HTTP/1.1 200 OK");

    echo json_encode($sql->fetch(PDO::FETCH_ASSOC));

    exit();

  }

  if (isset($_GET['proyectos'])) {

    //Mostrar lista de post

    $sql = $dbConn->prepare("SELECT * FROM proyectos");

    $sql->execute();

    $sql->setFetchMode(PDO::FETCH_ASSOC);

    $clientes = $sql->fetchAll(PDO::FETCH_OBJ);



    header("HTTP/1.1 200 OK");

    // echo var_dump($sql->fetchAll());

    echo json_encode($clientes);



    exit();

  } else {

    //Mostrar lista de post

    $sql = $dbConn->prepare("SELECT *, fecha_i AS 'Fecha de inicio', fecha_f AS 'Fecha de fin',

    HOUR(TIMEDIFF(fecha_f, fecha_i)) AS 'Horas totales'

    FROM proyecto_empleado;");

    $sql->execute();

    $sql->setFetchMode(PDO::FETCH_ASSOC);

    $proyectos_empleado = $sql->fetchAll(PDO::FETCH_OBJ);

    foreach ($proyectos_empleado as $proyecto_empleado) {

      if ($proyecto_empleado->id_proyecto != null) {

        $id = $proyecto_empleado->id_proyecto;

        $sql = "SELECT * FROM proyectos where id_proyecto=:id_proyecto";

        $stmt = $dbConn->prepare($sql);

        $stmt->bindParam(':id_proyecto', $id, PDO::PARAM_INT);

        $stmt->execute();

        // Obtener el resultado como un objeto

        $proyecto = $stmt->fetch(PDO::FETCH_ASSOC);

        $proyecto_empleado->Proyecto = $proyecto;

      } else {

        $proyecto_empleado->Proyecto = null;

      }

      if ($proyecto_empleado->id_empleado != null) {

        $id = $proyecto_empleado->id_empleado;

        $sql = "SELECT * FROM empleados where id_empleado=:id_empleado";

        $stmt = $dbConn->prepare($sql);

        $stmt->bindParam(':id_empleado', $id, PDO::PARAM_INT);

        $stmt->execute();

        // Obtener el resultado como un objeto

        $empleado = $stmt->fetch(PDO::FETCH_ASSOC);

        $proyecto_empleado->Empleado = $empleado;

      } else {

        $proyecto_empleado->Empleado = null;

      }

      if ($proyecto_empleado->id_grupo2 != null) {

        $id = $proyecto_empleado->id_grupo2;

        $sql = "SELECT * FROM grupos2 where id_grupo2=:id_grupo2";

        $stmt = $dbConn->prepare($sql);

        $stmt->bindParam(':id_grupo2', $id, PDO::PARAM_INT);

        $stmt->execute();

        // Obtener el resultado como un objeto

        $grupo = $stmt->fetch(PDO::FETCH_ASSOC);

        //echo var_dump($grupo);

        $sql = "SELECT e.*

            FROM empleados e

            INNER JOIN empleado_grupo2 eg ON e.id_empleado = eg.id_empleado

            WHERE eg.id_grupo2 = :id_grupo2";

        $stmt = $dbConn->prepare($sql);

        $stmt->bindParam(':id_grupo2', $id, PDO::PARAM_INT);

        $stmt->execute();

        $empleados = $stmt->fetchAll(PDO::FETCH_OBJ);



        $empleados_json = $empleados;



        //echo var_dump($empleados_json);

        $proyecto_empleado->Grupo = $grupo;



        $proyecto_empleado->Empleados = $empleados_json;

      } else {

        $proyecto_empleado->Grupo = null;

        $proyecto_empleado->Empleados = null;

      }

      unset($proyecto_empleado->id_grupo2);

      unset($proyecto_empleado->id_empleado);

      unset($proyecto_empleado->id_proyecto);

      unset($proyecto_empleado->id_proyecto_empleado);

      unset($proyecto_empleado->fecha_i);

      unset($proyecto_empleado->fecha_f);

    }







    header("HTTP/1.1 200 OK");

    echo json_encode($proyectos_empleado);



    exit();

  }

}





// Crear un nuevo post

if ($_SERVER['REQUEST_METHOD'] == 'POST') {

  if (

    isset($_POST["nombre"])

    && isset($_POST["color"])

    && isset($_POST["gastos_adicionales"])



    && isset($_POST["observaciones"])

  ) {

    $nombre = $_POST["nombre"];

    $color = $_POST["color"];

    $gastos_adicionales = $_POST["gastos_adicionales"];



    $observaciones = $_POST["observaciones"];





    $sqlVerificar = "SELECT COUNT(*) as count FROM proyectos WHERE nombre = :nombre";

    $statementVerificar = $dbConn->prepare($sqlVerificar);

    $statementVerificar->bindValue(':nombre', $nombre);

    $statementVerificar->execute();

    $resultadoVerificar = $statementVerificar->fetch(PDO::FETCH_ASSOC);



    if ($resultadoVerificar['count'] > 0) {

      // El nombre ya está en uso, mostrar mensaje de error



      echo 0;

      exit();

    }

    $sql = "INSERT INTO proyectos

        (color,nombre,gastos_adicionales,observaciones)

        VALUES

        (:color,:nombre,:gastos_adicionales,:observaciones)";



    $statement = $dbConn->prepare($sql);

    $statement->bindValue(':color', $color);

    $statement->bindValue(':nombre', $nombre);

    $statement->bindValue(':gastos_adicionales', $gastos_adicionales);

    $statement->bindValue(':observaciones', $observaciones);



    $statement->execute();



    $postId = $dbConn->lastInsertId();

    // Obtener la información del proyecto creado

    $sqlSelect = "SELECT * FROM proyectos WHERE id_proyecto = :id";

    $statementSelect = $dbConn->prepare($sqlSelect);

    $statementSelect->bindValue(':id', $postId);

    $statementSelect->execute();

    $proyectoCreado = $statementSelect->fetch(PDO::FETCH_ASSOC);



    header("HTTP/1.1 200 OK");

    echo json_encode($proyectoCreado);

    exit();

  }



  if (

    isset($_POST["concepto"])

    && isset($_POST["id_proyecto"])

    && isset($_POST["importe"])

    && isset($_POST["fecha"])

    && isset($_POST["observaciones"])

  ) {

    foreach ($_POST as $key => $value) {

      $value = ($value == "") ? null : $value;

      $$key = $value;

    }



    if(isset($_POST["id_gasto_proyecto"])){

      $id_gasto_proyecto = $_POST["id_gasto_proyecto"];

      $sql = "UPDATE gasto_proyecto SET

      concepto = :concepto,

      id_proyecto = :id_proyecto,

      importe = :importe,

      fecha = :fecha,

      observaciones = :observaciones

      WHERE

      id_gasto_proyecto = :id_gasto_proyecto";

      $statement = $dbConn->prepare($sql);

      $statement->bindValue(':id_gasto_proyecto', $id_gasto_proyecto);

    

    }else{

      $sql = "INSERT INTO gasto_proyecto

      (concepto,id_proyecto,importe,fecha,observaciones)

      VALUES

      (:concepto,:id_proyecto,:importe,:fecha,:observaciones)";

      $statement = $dbConn->prepare($sql);

    }



    



    

    $statement->bindValue(':concepto', $concepto);

    $statement->bindValue(':id_proyecto', $id_proyecto);

    $statement->bindValue(':importe', $importe);

    $statement->bindValue(':fecha', $fecha);

    $statement->bindValue(':observaciones', $observaciones);

    $statement->execute();

    if(isset($_POST["id_gasto_proyecto"])){

      $postId = $_POST["id_gasto_proyecto"];

    }else{

      $postId = $dbConn->lastInsertId();

    }

    // Obtener la información del proyecto creado

    $sqlSelect = "SELECT * FROM gasto_proyecto WHERE id_gasto_proyecto = :id";

    $statementSelect = $dbConn->prepare($sqlSelect);

    $statementSelect->bindValue(':id', $postId);

    $statementSelect->execute();

    $proyectoCreado = $statementSelect->fetch(PDO::FETCH_ASSOC);



    

    header("HTTP/1.1 200 OK");

    echo json_encode($proyectoCreado);

    exit();

  }

  if (isset($_POST["id_proyecto"]) && isset($_POST["id_proyecto_empleado"])) {

    $id_proyecto = $_POST["id_proyecto"];

    if ($id_proyecto == "") {

      $id_proyecto = null;

    }

    $id_proyecto_empleado = $_POST["id_proyecto_empleado"];



    $sql = "UPDATE proyecto_empleado SET 

          id_proyecto = :id_proyecto

          WHERE

          id_proyecto_empleado = :id_proyecto_empleado";



    $statement = $dbConn->prepare($sql);



    $statement->bindValue(':id_proyecto', $id_proyecto);

    $statement->bindValue(':id_proyecto_empleado', $id_proyecto_empleado);

    $statement->execute();



    $input['id'] = $id_proyecto_empleado;

    $input['id_proyecto'] = $id_proyecto;



    header("HTTP/1.1 200 OK");

    echo json_encode($input);

    exit();

  }

}



if ($_SERVER['REQUEST_METHOD'] == 'DELETE') {

  if (isset($_GET["id_proyecto"])) {

    $id = $_GET['id_proyecto'];

    $statement = $dbConn->prepare("DELETE FROM proyecto_cliente where id_proyecto =:id");

    $statement->bindValue(':id', $id);

    $statement->execute();

    header("HTTP/1.1 200 OK");

    exit();

  }

  if (isset($_GET["id_gasto_proyecto"])) {

    $id = $_GET['id_gasto_proyecto'];

    $statement = $dbConn->prepare("DELETE FROM gasto_proyecto where id_gasto_proyecto =:id");

    $statement->bindValue(':id', $id);

    $statement->execute();

    header("HTTP/1.1 200 OK");

    exit();

  }



  if (isset($_GET["id"])) {

    $id = $_GET['id'];

    $statement = $dbConn->prepare("DELETE FROM proyectos where id_proyecto =:id");

    $statement->bindValue(':id', $id);

    $statement->execute();

    header("HTTP/1.1 200 OK");

    exit();

  }

}



//Actualizar

if ($_SERVER['REQUEST_METHOD'] == 'PUT') {

  $input = $_GET;

  $postId = $input['id'];

  $fields = getParams($input);



  $sql = "

          UPDATE posts

          SET $fields

          WHERE id='$postId'

           ";



  $statement = $dbConn->prepare($sql);

  bindAllValues($statement, $input);



  $statement->execute();

  header("HTTP/1.1 200 OK");

  exit();

}



//En caso de que ninguna de las opciones anteriores se haya ejecutado

header("HTTP/1.1 400 Bad Request");