<?php



include "utils.php";



$dbConn = connect($db);



/*

listar todos los posts o solo uno

 */

if ($_SERVER['REQUEST_METHOD'] == 'GET') {

    if (isset($_GET['id_proveedor'])) {

        //Mostrar un post

        $sql = $dbConn->prepare("SELECT * FROM proveedores where id_proveedor=:id_proveedor");

        $sql->bindValue(':id_proveedor', $_GET['id_proveedor']);

        $sql->execute();

        header("HTTP/1.1 200 OK");

        echo json_encode($sql->fetch(PDO::FETCH_ASSOC));

        exit();

    } else {

        //Mostrar lista de post

        $sql = $dbConn->prepare("SELECT * FROM proveedores");

        $sql->execute();

        $sql->setFetchMode(PDO::FETCH_ASSOC);

        header("HTTP/1.1 200 OK");



        $proveedores = $sql->fetchAll();



        foreach ($proveedores as $key => $value) {

            $sql = "SELECT SUM(importe) as suma FROM factura_proveedor WHERE id_proveedor = :id_proveedor";

            $stmt = $dbConn->prepare($sql);

            $stmt->bindParam(':id_proveedor', $value['id_proveedor'], PDO::PARAM_INT);

            $stmt->execute();

            $suma = $stmt->fetch(PDO::FETCH_ASSOC)['suma'];



            if(is_null($suma)){

                $suma = 0;

            }



            $sql = "SELECT COUNT(id_factura_proveedor) as count FROM factura_proveedor WHERE id_proveedor = :id_proveedor";

            $stmt = $dbConn->prepare($sql);

            $stmt->bindParam(':id_proveedor', $value['id_proveedor'], PDO::PARAM_INT);

            $stmt->execute();

            $cuenta_facturas = $stmt->fetch(PDO::FETCH_ASSOC)['count'];

            $proveedores[$key]['cuenta_facturas'] = $cuenta_facturas . ' <b>('.$suma.'€)</b>';

        }



        echo json_encode($proveedores);

        exit();

    }

}



// Crear un nuevo post

if ($_SERVER['REQUEST_METHOD'] == 'POST') {

    if (

        isset($_POST["nombre"])

        && isset($_POST["cif"]) &&

        isset($_POST["cp"]) &&

        isset($_POST["direccion"]) &&

        isset($_POST["email"]) &&

        isset($_POST["telefono"]) &&

        isset($_POST["tipo"])

    ) {

        foreach ($_POST as $key => $value) {



            $value = ($value == "No") ? false : $value;

            $value = ($value == "") ? null : $value;

            $$key = $value;

        }



        if (isset($_POST['id_proveedor'])) {

            $id_proveedor = $_POST['id_proveedor'];



            $sql = "UPDATE proveedores

                    SET nombre = :nombre,

                        cif = :cif,

                        cp = :cp,

                        direccion = :direccion,

                        email = :email,

                        telefono = :telefono,

                        tipo = :tipo

                    WHERE id_proveedor = :id_proveedor";



            $statement = $dbConn->prepare($sql);



            $statement->bindValue(':nombre', $nombre);

            $statement->bindValue(':cif', $cif);

            $statement->bindValue(':cp', $cp);

            $statement->bindValue(':direccion', $direccion);

            $statement->bindValue(':email', $email);

            $statement->bindValue(':telefono', $telefono);

            $statement->bindValue(':tipo', $tipo);

            $statement->bindValue(':id_proveedor', $id_proveedor); 



            $statement->execute();



            $input['id'] = $id_proveedor;

            $input['nombre'] = $nombre;

            $input['cif'] = $cif;

            $input['cp'] = $cp;

            $input['direccion'] = $direccion;

            $input['email'] = $email;

            $input['telefono'] = $telefono;

            $input['tipo'] = $tipo;

        } else {

            $sql = "INSERT INTO proveedores

                    (nombre, cif, cp, direccion, email, telefono, tipo)

                    VALUES

                    (:nombre, :cif, :cp, :direccion, :email, :telefono, :tipo)";



            $statement = $dbConn->prepare($sql);



            $statement->bindValue(':nombre', $nombre);

            $statement->bindValue(':cif', $cif);

            $statement->bindValue(':cp', $cp);

            $statement->bindValue(':direccion', $direccion);

            $statement->bindValue(':email', $email);

            $statement->bindValue(':telefono', $telefono);

            $statement->bindValue(':tipo', $tipo);

            $statement->execute();



            $postId = $dbConn->lastInsertId();



            $input['id'] = $postId;

            $input['nombre'] = $nombre;

            $input['cif'] = $cif;

            $input['cp'] = $cp;

            $input['direccion'] = $direccion;

            $input['email'] = $email;

            $input['telefono'] = $telefono;

            $input['tipo'] = $tipo;

        }





        header("HTTP/1.1 200 OK");

        echo json_encode($input);

        exit();

    }

}



if ($_SERVER['REQUEST_METHOD'] == 'DELETE') {

    $id = $_GET['id'];

    $statement = $dbConn->prepare("DELETE FROM proveedores where id_proveedor =:id");

    $statement->bindValue(':id', $id);

    $statement->execute();

    header("HTTP/1.1 200 OK");

    exit();

}



//Actualizar

if ($_SERVER['REQUEST_METHOD'] == 'PUT') {

    $input = $_GET;

    $postId = $input['id'];

    $fields = getParams($input);



    $sql = "

          UPDATE posts

          SET $fields

          WHERE id='$postId'

           ";



    $statement = $dbConn->prepare($sql);

    bindAllValues($statement, $input);



    $statement->execute();

    header("HTTP/1.1 200 OK");

    exit();

}



//En caso de que ninguna de las opciones anteriores se haya ejecutado

header("HTTP/1.1 400 Bad Request");