<?php



include "utils.php";



$dbConn = connect($db);



/*

listar todos los posts o solo uno

 */

if ($_SERVER['REQUEST_METHOD'] == 'GET') {



    if (isset($_GET['id_producto'])) {

        //Mostrar un post

        $sql = $dbConn->prepare("SELECT * FROM producto where id_producto=:id_producto");

        $sql->bindValue(':id_producto', $_GET['id_producto']);

        $sql->execute();

        header("HTTP/1.1 200 OK");

        echo json_encode($sql->fetch(PDO::FETCH_ASSOC));

        exit();
    }
    if (isset($_GET['id_servicio'])) {

        //Mostrar un post

        $sql = $dbConn->prepare("SELECT * FROM servicio where id_servicio=:id_servicio");

        $sql->bindValue(':id_servicio', $_GET['id_servicio']);

        $sql->execute();

        header("HTTP/1.1 200 OK");

        echo json_encode($sql->fetch(PDO::FETCH_ASSOC));

        exit();
    } else {

        //Mostrar lista de post

        $sql = $dbConn->prepare("SELECT a.*,CASE 

        WHEN u.id_subcategoria IS NULL THEN 'Ninguna'

        ELSE u.nombre 

      END AS nombre_subcategoria

FROM producto a 

LEFT JOIN subcategorias u ON a.id_subcategoria = u.id_subcategoria

ORDER BY id_producto ");

        $sql->execute();

        $sql->setFetchMode(PDO::FETCH_ASSOC);

        $input["productos"] = $sql->fetchAll();



        $sql = $dbConn->prepare("SELECT a.*,CASE 

        WHEN u.id_subcategoria IS NULL THEN 'Ninguna'

        ELSE u.nombre 

      END AS nombre_subcategoria

FROM servicio a 

LEFT JOIN subcategorias u ON a.id_subcategoria = u.id_subcategoria

ORDER BY id_servicio");

        $sql->execute();

        $sql->setFetchMode(PDO::FETCH_ASSOC);

        $input["servicios"] = $sql->fetchAll();

        header("HTTP/1.1 200 OK");



        echo json_encode($input);

        exit();
    }
}



// Crear un nuevo post

if ($_SERVER['REQUEST_METHOD'] == 'POST') {



    if (

        isset($_POST["nombre"])



        && isset($_POST["precio"])

        && isset($_POST["numero"])

        && isset($_POST["descripcion"])

        && isset($_POST["id_subcategoria"])



    ) {

        foreach ($_POST as $key => $value) {

            $value = ($value == "No") ? null : $value;

            $value = ($value == "") ? null : $value;



            $$key = $value;
        }

        $params = [':numero' => $numero];
        $query = "SELECT COUNT(*) FROM producto WHERE numero = :numero";

        // Si estás actualizando, excluye el actual
        if (isset($id_producto)) {
            $query .= " AND id_producto != :id_producto";
            $params[':id_producto'] = $id_producto;
        }

        $verificar = $dbConn->prepare($query);
        $verificar->execute($params);

        if ($verificar->fetchColumn() > 0) {
            header("HTTP/1.1 200 OK");
            echo json_encode(['success' => false, 'error' => 'Ya existe un producto con ese número.']);
            exit();
        }

        if (isset($_POST["id_producto"])) {

            $id_producto = $_POST["id_producto"];

            $sql = "UPDATE producto SET 

     nombre = :nombre,

          

            precio = :precio,

            numero = :numero,

            descripcion = :descripcion,

            id_subcategoria = :id_subcategoria

           

            WHERE id_producto = :id_producto";

            $statement = $dbConn->prepare($sql);

            $statement->bindValue(':id_producto', $id_producto);
        } else {

            $sql = "INSERT INTO producto

    (nombre, precio,numero, descripcion, id_subcategoria)

    VALUES

    (:nombre, :precio,:numero,:descripcion,:id_subcategoria)";

            $statement = $dbConn->prepare($sql);
        }

        $statement->bindValue(':nombre', $nombre);

  

        $statement->bindValue(':precio', $precio);

        $statement->bindValue(':numero', $numero);

        $statement->bindValue(':descripcion', $descripcion);

        $statement->bindValue(':id_subcategoria', $id_subcategoria);





        $statement->execute();

        $baseUrl = ($_SERVER['HTTPS'] ? 'https://' : 'http://') . $_SERVER['HTTP_HOST'] . '/';

        $rutaArchivoTemporal = isset($_FILES['imagen']) ? $_FILES['imagen']['tmp_name'] : null;

        if (isset($_POST["id_producto"])) {

            if ($_POST["misma"] == "No") {

                $id_producto = $_POST["id_producto"];

                $Archivo = '../imagenes/productos/' . $id_producto . '/perfil.png';

                $carpetaNuevaAlumno = '../imagenes/productos/' . $id_producto;

                if ($rutaArchivoTemporal && !empty($rutaArchivoTemporal)) {

                    if (file_exists($Archivo)) {

                        unlink($Archivo); // Elimina el archivo existente antes de reemplazarlo

                    }

                    move_uploaded_file($rutaArchivoTemporal, $Archivo);
                }
            }
        } else {

            $id_producto = $dbConn->lastInsertId();

            $nombreArchivoUnico = "perfil.png";

            $carpetaNuevaAlumno = '../imagenes/productos/' . $id_producto;



            mkdir($carpetaNuevaAlumno, 0777, true);



            $rutaArchivoDestino = $carpetaNuevaAlumno . "/" . $nombreArchivoUnico;



            if ($rutaArchivoTemporal && !empty($rutaArchivoTemporal)) {

                // Si se proporcionó un archivo subido, moverlo usando move_uploaded_file

                move_uploaded_file($rutaArchivoTemporal, $rutaArchivoDestino);
            } else {

                // Si no se proporcionó un archivo subido, usar file_put_contents para la URL de respaldo

                $urlDefaultImage = $baseUrl . 'assets/images/clientes/user-default.png';

                $imagenDefault = file_get_contents($urlDefaultImage);

                file_put_contents($rutaArchivoDestino, $imagenDefault);
            }
        }

        $input['id'] = $id_producto;



        header("HTTP/1.1 200 OK");


        echo json_encode(['success' => true, 'producto' => $input]);
        exit();
    } elseif (isset($_POST['import_items'])) {

        $jsonData = $_POST['import_items'];
        $items = json_decode($jsonData, true);
        $todoCorrecto = true;

        try {
            if (json_last_error() === JSON_ERROR_NONE && is_array($items)) {
                foreach ($items as $item) {
                    foreach ($item as $key => $value) {
                        $value = ($value === "" || $value === null) ? null : $value;
                        $$key = $value;
                    }

                    // Validar tipo
                    if ($tipo !== 'P' && $tipo !== 'S') {
                        $todoCorrecto = false;
                        break;
                    }

                    // Determinar la tabla según el tipo
                    $tabla = ($tipo === 'P') ? 'producto' : 'servicio';

                    $exists = false;

                    if ($numero !== null) {
                        $checkSql = "SELECT COUNT(*) FROM $tabla WHERE numero = :numero";
                        $checkStmt = $dbConn->prepare($checkSql);
                        $checkStmt->bindValue(':numero', $numero);
                        $checkStmt->execute();
                        $exists = $checkStmt->fetchColumn() > 0;
                    }

                    if ($numero !== null && $exists) {
                        // UPDATE
                        $sql = "UPDATE $tabla SET 
                                    nombre = :nombre,
                                    precio = :precio,
                                    descripcion = :descripcion
                                WHERE numero = :numero";
                        $statement = $dbConn->prepare($sql);
                    } else {
                        // INSERT
                        $sql = "INSERT INTO $tabla (
                                    nombre, numero, precio, descripcion
                                ) VALUES (
                                    :nombre, :numero, :precio, :descripcion
                                )";
                        $statement = $dbConn->prepare($sql);
                    }

                    // Bind de los valores
                    $statement->bindValue(':nombre', $nombre);
                    $statement->bindValue(':numero', $numero);
                    $statement->bindValue(':precio', $precio);
                    $statement->bindValue(':descripcion', $descripcion);

                    if (!$statement->execute()) {
                        $todoCorrecto = false;
                        break;
                    }
                    if ($numero !== null && $exists) {
                    } else {
                        $baseUrl = ($_SERVER['HTTPS'] ? 'https://' : 'http://') . $_SERVER['HTTP_HOST'] . '/';
                        $id_producto = $dbConn->lastInsertId();

                        $nombreArchivoUnico = "perfil.png";

                        $carpetaNuevaAlumno = '../imagenes/' . $tabla . 's/' . $id_producto;



                        mkdir($carpetaNuevaAlumno, 0777, true);



                        $rutaArchivoDestino = $carpetaNuevaAlumno . "/" . $nombreArchivoUnico;

                        $urlDefaultImage = $baseUrl . 'assets/images/clientes/user-default.png';

                        $imagenDefault = file_get_contents($urlDefaultImage);

                        file_put_contents($rutaArchivoDestino, $imagenDefault);
                    }
                }

                if ($todoCorrecto) {
                    header("HTTP/1.1 200 OK");
                    echo json_encode(['status' => 'success', 'message' => 'Todos los elementos se han procesado correctamente']);
                } else {
                    header("HTTP/1.1 200 OK");
                    echo json_encode(['status' => 'error', 'message' => 'Error al procesar uno o más elementos']);
                }
            } else {
                header("HTTP/1.1 400 Bad Request");
                echo json_encode(['status' => 'error', 'message' => 'Datos JSON inválidos o formato incorrecto']);
            }
        } catch (PDOException $e) {
            header("HTTP/1.1 500 Internal Server Error");
            echo json_encode(['status' => 'error', 'message' => 'Error de base de datos: ' . $e->getMessage()]);
        } catch (Exception $e) {
            header("HTTP/1.1 500 Internal Server Error");
            echo json_encode(['status' => 'error', 'message' => 'Error: ' . $e->getMessage()]);
        }

        exit();
    } elseif (

        isset($_POST["nombre_servicio"])



        && isset($_POST["precio_servicio"])

        && isset($_POST["numero_servicio"])

        && isset($_POST["descripcion_servicio"])

        && isset($_POST["id_subcategoria_servicio"])



    ) {

        $nombre = $_POST["nombre_servicio"];

        $precio = $_POST["precio_servicio"];
        $numero = $_POST["numero_servicio"];
        $descripcion = $_POST["descripcion_servicio"];

        $id_subcategoria = ($_POST["id_subcategoria_servicio"] != "No") ? $_POST["id_subcategoria_servicio"] : null;

 $params = [':numero' => $numero];
        $query = "SELECT COUNT(*) FROM servicio WHERE numero = :numero";

        // Si estás actualizando, excluye el actual
        if (isset($_POST["id_servicio"])) {
            $query .= " AND id_servicio != :id_servicio";
            $params[':id_servicio'] = $_POST["id_servicio"];
        }

        $verificar = $dbConn->prepare($query);
        $verificar->execute($params);

        if ($verificar->fetchColumn() > 0) {
            header("HTTP/1.1 200 OK");
            echo json_encode(['success' => false, 'error' => 'Ya existe un servicio con ese número.']);
            exit();
        }




        if (isset($_POST["id_servicio"])) {

            $id_servicio = $_POST["id_servicio"];

            $sql = "UPDATE servicio SET 

     nombre = :nombre,

           

            precio = :precio,
 numero = :numero,
          

            descripcion = :descripcion,

            id_subcategoria = :id_subcategoria

           

            WHERE id_servicio = :id_servicio";

            $statement = $dbConn->prepare($sql);

            $statement->bindValue(':id_servicio', $id_servicio);
        } else {

            $sql = "INSERT INTO servicio

    (nombre,numero, precio, descripcion, id_subcategoria)

    VALUES

    (:nombre,:numero, :precio,:descripcion,:id_subcategoria)";

            $statement = $dbConn->prepare($sql);
        }

        $statement->bindValue(':nombre', $nombre);

        $statement->bindValue(':numero', $numero);

        $statement->bindValue(':precio', $precio);



        $statement->bindValue(':descripcion', $descripcion);

        $statement->bindValue(':id_subcategoria', $id_subcategoria);





        $statement->execute();

        $baseUrl = ($_SERVER['HTTPS'] ? 'https://' : 'http://') . $_SERVER['HTTP_HOST'] . '/';

        $rutaArchivoTemporal = isset($_FILES['imagen_servicio']) ? $_FILES['imagen_servicio']['tmp_name'] : null;

        if (isset($_POST["id_servicio"])) {

            if ($_POST["misma"] == "No") {

                $id_servicio = $_POST["id_servicio"];

                $Archivo = '../imagenes/servicios/' . $id_servicio . '/perfil.png';

                $carpetaNuevaAlumno = '../imagenes/servicios/' . $id_servicio;

                if ($rutaArchivoTemporal && !empty($rutaArchivoTemporal)) {

                    if (file_exists($Archivo)) {

                        unlink($Archivo); // Elimina el archivo existente antes de reemplazarlo

                    }

                    move_uploaded_file($rutaArchivoTemporal, $Archivo);
                }
            }
        } else {

            $id_servicio = $dbConn->lastInsertId();

            $nombreArchivoUnico = "perfil.png";

            $carpetaNuevaAlumno = '../imagenes/servicios/' . $id_servicio;



            mkdir($carpetaNuevaAlumno, 0777, true);



            $rutaArchivoDestino = $carpetaNuevaAlumno . "/" . $nombreArchivoUnico;



            if ($rutaArchivoTemporal && !empty($rutaArchivoTemporal)) {

                // Si se proporcionó un archivo subido, moverlo usando move_uploaded_file

                move_uploaded_file($rutaArchivoTemporal, $rutaArchivoDestino);
            } else {

                // Si no se proporcionó un archivo subido, usar file_put_contents para la URL de respaldo

                $urlDefaultImage = $baseUrl . 'assets/images/clientes/user-default.png';

                $imagenDefault = file_get_contents($urlDefaultImage);

                file_put_contents($rutaArchivoDestino, $imagenDefault);
            }
        }

        $input['id'] = $id_servicio;



        header("HTTP/1.1 200 OK");

        echo json_encode(['success' => true, 'servicio' => $input]);

        exit();
    }
}



//Borrar

if ($_SERVER['REQUEST_METHOD'] == 'DELETE') {

    if (isset($_GET['id_producto'])) {

        $id = $_GET['id_producto'];

        $statement = $dbConn->prepare("DELETE FROM producto where id_producto= :id");

        $statement->bindValue(':id', $id);

        $statement->execute();

        $url = "../imagenes/productos/" . $id;

        eliminarCarpeta($url);

        header("HTTP/1.1 200 OK");



        exit();
    }

    if (isset($_GET['id_servicio'])) {

        $id = $_GET['id_servicio'];

        $statement = $dbConn->prepare("DELETE FROM servicio where id_servicio= :id");

        $statement->bindValue(':id', $id);

        $statement->execute();

        $url = "../imagenes/servicios/" . $id;

        eliminarCarpeta($url);

        header("HTTP/1.1 200 OK");



        exit();
    }
}



//Actualizar

if ($_SERVER['REQUEST_METHOD'] == 'PUT') {

    $input = $_GET;

    $postId = $input['id'];

    $fields = getParams($input);



    $sql = "

          UPDATE posts

          SET $fields

          WHERE id='$postId'

           ";



    $statement = $dbConn->prepare($sql);

    bindAllValues($statement, $input);



    $statement->execute();

    header("HTTP/1.1 200 OK");

    exit();
}

function eliminarCarpeta($rutaCarpeta)

{

    // Obtener una lista de archivos y subcarpetas dentro de la carpeta

    $archivos = glob($rutaCarpeta . '/*');



    // Eliminar cada archivo encontrado

    foreach ($archivos as $archivo) {

        if (is_file($archivo)) {

            unlink($archivo);
        } elseif (is_dir($archivo)) {

            eliminarCarpeta($archivo);
        }
    }



    // Eliminar la carpeta

    if (is_dir($rutaCarpeta)) {

        rmdir($rutaCarpeta);
    }
}



//En caso de que ninguna de las opciones anteriores se haya ejecutado

header("HTTP/1.1 400 Bad Request");