<?php



include "utils.php";



$dbConn = connect($db);

date_default_timezone_set(htmlentities($personalizacion["zona_horaria"], ENT_QUOTES));

/*

listar todos los posts o solo uno

*/

if ($_SERVER['REQUEST_METHOD'] == 'GET') {



    if (isset($_GET['id_presupuesto'])) {

        //Mostrar un post

        $sql = $dbConn->prepare("SELECT * FROM presupuestos where id_presupuesto=:id_presupuesto");

        $sql->bindValue(':id_presupuesto', $_GET['id_presupuesto']);

        $sql->execute();

        header("HTTP/1.1 200 OK");

        echo json_encode($sql->fetch(PDO::FETCH_ASSOC));

        exit();

    }

    if (isset($_GET['dias'])) {



        $dias = json_decode($_GET['dias']);

        $recursos = array();



        foreach ($dias as $fecha_formato) {



            $sql = "SELECT COUNT(*) as cantidad  FROM presupuestos WHERE DATE(fecha) = :fecha AND estado = 'Pendiente'";

            // Preparar la consulta SQL utilizando PDO

            $stmt = $dbConn->prepare($sql);

            $stmt->bindValue(':fecha', $fecha_formato, PDO::PARAM_STR);

            $stmt->execute();

            $row = $stmt->fetch(PDO::FETCH_ASSOC);

            $cantidad_pendientes = $row['cantidad'];

            $sql = "SELECT COUNT(*) as cantidad  FROM presupuestos WHERE DATE(fecha) = :fecha AND estado = 'Aceptado'";

            // Preparar la consulta SQL utilizando PDO

            $stmt = $dbConn->prepare($sql);

            $stmt->bindValue(':fecha', $fecha_formato, PDO::PARAM_STR);

            $stmt->execute();

            $row = $stmt->fetch(PDO::FETCH_ASSOC);

            $cantidad_aceptados = $row['cantidad'];

            $sql = "SELECT COUNT(*) as cantidad  FROM presupuestos WHERE DATE(fecha) = :fecha AND estado = 'Rechazado'";

            // Preparar la consulta SQL utilizando PDO

            $stmt = $dbConn->prepare($sql);

            $stmt->bindValue(':fecha', $fecha_formato, PDO::PARAM_STR);

            $stmt->execute();

            $row = $stmt->fetch(PDO::FETCH_ASSOC);

            $cantidad_rechazados = $row['cantidad'];



            // Crear un objeto con la fecha y la cantidad de facturas y agregarlo al arreglo $facturas_por_dia

            $objeto = array("dia" => $fecha_formato, "cantidad_pendientes" => $cantidad_pendientes, "cantidad_aceptados" => $cantidad_aceptados, "cantidad_rechazados" => $cantidad_rechazados);

            array_push($recursos, $objeto);

        }

        // Devolver los resultados en formato JSON

        header('Content-Type: application/json');

        echo json_encode($recursos);

        exit();

    }

    if (isset($_GET['programados'])) {



        $sql = "SELECT p.*, c.nombre

            FROM presupuestos p 

            JOIN clientes c ON p.id_cliente = c.client_id

            WHERE p.programado IS NOT NULL;";

        $stmt = $dbConn->prepare($sql);



        // Obtener clientes potenciales





        $stmt->execute();

        $presupuestos = $stmt->fetchAll(PDO::FETCH_OBJ);



        // Devolver objeto de clientes

        header("HTTP/1.1 200 OK");

        echo json_encode($presupuestos);

        exit();

    }

    if (isset($_GET['fecha_i']) && isset($_GET['fecha_i'])) {

        $fecha_i = $_GET['fecha_i'];

        $fecha_f = $_GET['fecha_f'];

        $sql = "SELECT p.*, c.nombre

            FROM presupuestos p 

            JOIN clientes c ON p.id_cliente = c.client_id

            WHERE DATE_FORMAT(p.fecha, '%Y-%m-%d') BETWEEN :fecha_i AND :fecha_f";

        $stmt = $dbConn->prepare($sql);



        // Obtener clientes potenciales





        $stmt->bindParam(':fecha_i', $fecha_i);

        $stmt->bindParam(':fecha_f', $fecha_f);

        $stmt->execute();

        $presupuestos = $stmt->fetchAll(PDO::FETCH_OBJ);



        // Devolver objeto de clientes

        header("HTTP/1.1 200 OK");

        echo json_encode($presupuestos);

        exit();

    }

    if (isset($_GET['client_id'])) {

        $sql = $dbConn->prepare("SELECT p.*, u.user_full_name AS responsable, c.nombre, COALESCE(o.nombre, 'Ninguna obra') AS nombre_obra, COALESCE(s.nombre, 'Ningun sector') AS nombre_sector, COALESCE(f.nombre, 'Ninguna fase') AS nombre_fase

            FROM presupuestos p 

     JOIN clientes c ON p.id_cliente = c.client_id

     LEFT JOIN obras o ON o.id_obra = p.id_obra

     LEFT JOIN sectores s ON s.id_sector = p.id_sector

     LEFT JOIN fases f ON f.id_fase = p.id_fase

     LEFT JOIN users u ON u.user_id = p.id_usuario

     WHERE p.id_cliente = :client_id");

        $sql->bindValue(':client_id', $_GET['client_id']);

        $sql->execute();

        $sql->setFetchMode(PDO::FETCH_ASSOC);

        header("HTTP/1.1 200 OK");



        echo json_encode($sql->fetchAll());

        exit();

    } else {

        //Mostrar lista de post

        $sql = $dbConn->prepare("SELECT p.*, u.user_full_name AS responsable, c.nombre, COALESCE(o.nombre, 'Ninguna obra') AS nombre_obra, COALESCE(s.nombre, 'Ningun sector') AS nombre_sector, COALESCE(f.nombre, 'Ninguna fase') AS nombre_fase

       FROM presupuestos p 

JOIN clientes c ON p.id_cliente = c.client_id

LEFT JOIN obras o ON o.id_obra = p.id_obra

LEFT JOIN sectores s ON s.id_sector = p.id_sector

LEFT JOIN fases f ON f.id_fase = p.id_fase

LEFT JOIN users u ON u.user_id = p.id_usuario

");

        $sql->execute();

        $sql->setFetchMode(PDO::FETCH_ASSOC);

        header("HTTP/1.1 200 OK");



        echo json_encode($sql->fetchAll());

        exit();

    }

}



// Crear un nuevo post

if ($_SERVER['REQUEST_METHOD'] == 'POST') {

    if (isset($_POST["programado"]) && isset($_POST["id_presupuesto_editar_envio"])) {



        $programado = ($_POST["programado"] != "No") ? $_POST["programado"] : null;

        $id_presupuesto = $_POST["id_presupuesto_editar_envio"];



        $sql = "UPDATE presupuestos SET programado = :programado WHERE id_presupuesto = :id_presupuesto";

        $statement = $dbConn->prepare($sql);

        $statement->bindValue(':id_presupuesto', $id_presupuesto);

        $statement->bindValue(':programado', $programado);



        $statement->execute();

        $object = [

            'id' => $id_presupuesto,

            'programado' => $programado,



        ];



        header("HTTP/1.1 200 OK");

        echo json_encode($object);

        exit();

    }



    if (isset($_POST["aceptado"]) && isset($_POST["id_presupuesto"])) {



        $aceptado = $_POST["aceptado"];

        $id_presupuesto = $_POST["id_presupuesto"];



        $sql = "UPDATE presupuestos SET estado = :aceptado WHERE id_presupuesto = :id_presupuesto";

        $statement = $dbConn->prepare($sql);

        $statement->bindValue(':id_presupuesto', $id_presupuesto);

        $statement->bindValue(':aceptado', $aceptado);



        $statement->execute();

        $object = [

            'id' => $id_presupuesto,

            'aceptado' => $aceptado,



        ];



        header("HTTP/1.1 200 OK");

        echo "Presupuesto " . $aceptado;

        exit();

    }



    if (

        isset($_POST["estado"])

        && isset($_POST["fecha"])

        && isset($_POST["cif"])

        && isset($_POST["cp"])

        && isset($_POST["domicilio"])

        && isset($_POST["telefono"])

        && isset($_POST["email"])

        && isset($_POST["tipo"])

        && isset($_POST["id_usuario"])

        && isset($_POST["id_obra"])

        && isset($_POST["id_sector"])

        && isset($_POST["id_fase"])

        && isset($_POST["importe_final"])

        && isset($_POST["importe"])

        && isset($_POST["detallado"])

        && isset($_POST["titulo"])

        && isset($_POST["id_cliente"])

        && isset($_POST["condiciones"])

        && isset($_POST["numero"])



        && isset($_POST["irpf"])

        && isset($_POST["nota_interna"])

        && isset($_POST["nota_externa"])

        && isset($_POST["programado"])

        && isset($_POST["imagen"])

        && isset($_POST["lugar"])

        && isset($_POST["fechas"])

    ) {



        try {

            $imagen = $_POST["imagen"];

            $nota_interna = $_POST["nota_interna"];

            $nota_externa = $_POST["nota_externa"];

            $estado = $_POST["estado"];

            $fecha = $_POST["fecha"];

            $cif = $_POST["cif"];

            $cp = $_POST["cp"];

            $domicilio = $_POST["domicilio"];

            $telefono = $_POST["telefono"];

            $email = $_POST["email"];

            $tipo = $_POST["tipo"];

            $id_usuario = $_POST["id_usuario"];

            $id_obra = $_POST["id_obra"];

            $id_sector = $_POST["id_sector"];

            $id_fase = $_POST["id_fase"];

            $importe_final = $_POST["importe_final"];

            $importe = $_POST["importe"];

            $detallado = $_POST["detallado"];

            $titulo = $_POST["titulo"];

            $id_cliente = $_POST["id_cliente"];

            $condiciones = $_POST["condiciones"];

            $numero = $_POST["numero"];



            $irpf = $_POST["irpf"];



            $programado = $_POST["programado"];

            foreach ($_POST as $key => $value) {

                $value = ($value == "null") ? null : $value;

                $value = ($value == "") ? null : $value;

                $value = ($value == "No") ? null : $value;

                $$key = $value;

            }



            if ($id_presupuesto != null) {





                $sql = "UPDATE presupuestos SET 

            estado = :estado

            ,fecha = :fecha

            ,cif = :cif

            ,cp = :cp

            ,domicilio = :domicilio

            ,telefono = :telefono

            ,email = :email

            ,tipo = :tipo

            ,id_usuario = :id_usuario

            ,id_obra = :id_obra

            ,id_sector = :id_sector

            ,id_fase = :id_fase

            ,importe_final = :importe_final

            ,importe = :importe

            ,detallado = :detallado

            ,titulo = :titulo

            ,id_cliente = :id_cliente

            ,condiciones = :condiciones

            ,numero = :numero

           

            ,irpf = :irpf

            

            ,nota_interna = :nota_interna

            ,nota_externa = :nota_externa

            ,imagen = :imagen

             ,programado = :programado

             ,lugar = :lugar

             ,fechas = :fechas

            

             WHERE id_presupuesto = :id_presupuesto";

                $statement = $dbConn->prepare($sql);

                $statement->bindValue(':id_presupuesto', $id_presupuesto);

            } else {



                $sql = "INSERT INTO presupuestos

        (estado

        ,fecha

         ,lugar

         ,fechas

        ,cif

        ,cp

        ,domicilio

        ,telefono

        ,email

        ,tipo

        ,id_usuario

        ,id_obra

        ,id_sector

        ,id_fase

        ,importe_final

        ,importe

        ,detallado

        ,titulo

        ,id_cliente

        ,condiciones

        ,numero

        ,impuesto

        ,irpf

       

        ,nota_interna

        ,nota_externa

        ,imagen

         ,programado

        )

        VALUES

        (:estado

        ,:fecha

        ,:lugar

         ,:fechas

        ,:cif

        ,:cp

        ,:domicilio

        ,:telefono

        ,:email

        ,:tipo

        ,:id_usuario

        ,:id_obra

        ,:id_sector

        ,:id_fase

        ,:importe_final

        ,:importe

        ,:detallado

        ,:titulo

        ,:id_cliente

        ,:condiciones

        ,:numero

        ,:impuesto

        ,:irpf

       

        ,:nota_interna

        ,:nota_externa

        ,:imagen

        ,:programado

        )";

                $statement = $dbConn->prepare($sql);

            }

            $statement->bindValue(':lugar', $lugar);

            $statement->bindValue(':fechas', $fechas);

            $statement->bindValue(':imagen', $imagen);

            $statement->bindValue(':programado', $programado);

            $statement->bindValue(':estado', $estado);

            $statement->bindValue(':fecha', $fecha);

            $statement->bindValue(':cif', $cif);

            $statement->bindValue(':cp', $cp);

            $statement->bindValue(':domicilio', $domicilio);

            $statement->bindValue(':telefono', $telefono);

            $statement->bindValue(':email', $email);

            $statement->bindValue(':tipo', $tipo);

            $statement->bindValue(':id_usuario', $id_usuario);

            $statement->bindValue(':id_obra', $id_obra);

            $statement->bindValue(':id_sector', $id_sector);

            $statement->bindValue(':id_fase', $id_fase);

            $statement->bindValue(':importe_final', $importe_final);

            $statement->bindValue(':importe', $importe);

            $statement->bindValue(':detallado', $detallado);

            $statement->bindValue(':titulo', $titulo);

            $statement->bindValue(':id_cliente', $id_cliente);

            $statement->bindValue(':condiciones', $condiciones);

            $statement->bindValue(':numero', $numero);



            $statement->bindValue(':impuesto', $impuesto);

            $statement->bindValue(':irpf', $irpf);



            $statement->bindValue(':nota_interna', $nota_interna);

            $statement->bindValue(':nota_externa', $nota_externa);

            $statement->execute();

            if ($id_presupuesto == null) {

                $id_presupuesto = $dbConn->lastInsertId();

                $personalizacion = json_decode(file_get_contents('../personalizacion.json'), true);

                $personalizacion["numeracion_presupuestos"] = intval($personalizacion["numeracion_presupuestos"]) + 1;

                $personalizacionEncoded = json_encode($personalizacion, JSON_PRETTY_PRINT);

                file_put_contents('../personalizacion.json', $personalizacionEncoded);

            }



            header("HTTP/1.1 200 OK");

            echo json_encode($id_presupuesto);

            exit();

        } catch (PDOException $e) {

            // Manejar el error

            header("HTTP/1.1 500 Internal Server Error");

            echo "Error al ejecutar la consulta: " . $e->getMessage();

            exit();

        }

    }



}



//Borrar

if ($_SERVER['REQUEST_METHOD'] == 'DELETE') {

    $id = $_GET['id'];

    $statement = $dbConn->prepare("DELETE FROM presupuestos where id_presupuesto =:id");

    $statement->bindValue(':id', $id);

    $statement->execute();

    $statement = $dbConn->prepare("SELECT COUNT(*) AS cantidad_presupuestos

    FROM presupuestos");



    $statement->execute();



    header("HTTP/1.1 200 OK");

    echo json_encode($statement->fetch(PDO::FETCH_ASSOC));

    exit();

}



//Actualizar

if ($_SERVER['REQUEST_METHOD'] == 'PUT') {

    $input = $_GET;

    $postId = $input['id'];

    $fields = getParams($input);



    $sql = "

          UPDATE posts

          SET $fields

          WHERE id='$postId'

           ";



    $statement = $dbConn->prepare($sql);

    bindAllValues($statement, $input);



    $statement->execute();

    header("HTTP/1.1 200 OK");

    exit();

}



//En caso de que ninguna de las opciones anteriores se haya ejecutado

header("HTTP/1.1 400 Bad Request");