<?php



include "utils.php";



$dbConn = connect($db);



/*

listar todos los posts o solo uno

 */

if ($_SERVER['REQUEST_METHOD'] == 'GET') {

    if (isset($_GET['id_periodo_vacaciones'])) {

        //Mostrar un post

        $sql = $dbConn->prepare("SELECT * FROM periodo_vacaciones where id_periodo_vacaciones=:id_periodo_vacaciones");

        $sql->bindValue(':id_periodo_vacaciones', $_GET['id_periodo_vacaciones']);

        $sql->execute();

        header("HTTP/1.1 200 OK");

        echo json_encode($sql->fetch(PDO::FETCH_ASSOC));

        exit();

    } else {

        //Mostrar lista de post

        $sql = $dbConn->prepare("SELECT * FROM periodo_vacaciones");

        $sql->execute();

        $sql->setFetchMode(PDO::FETCH_ASSOC);

        header("HTTP/1.1 200 OK");



        echo json_encode($sql->fetchAll());

        exit();

    }

}



// Crear un nuevo post

if ($_SERVER['REQUEST_METHOD'] == 'POST') {

    if (isset($_POST["id_empleado"])) {

        $output = array();

        $output['status'] = false;

        $id_empleado = $_POST["id_empleado"];

        $data = json_decode($_POST['periodos'], true);



        if (count($data) == 0) {

            $output['msg'] = 'Debe proporcionar al menos un período';

            echo json_encode($output);

            exit;

        }



        if (isset($_POST["id_periodo_vacaciones"])) {

            $id_periodo_vacaciones = $_POST["id_periodo_vacaciones"];

            $sql = "UPDATE periodo_vacaciones

                    SET id_empleado = :id_empleado,

                        data = :data,

                        observaciones = :observaciones_periodo

                    WHERE id_periodo_vacaciones = :id_periodo_vacaciones";

            $statement = $dbConn->prepare($sql);



            $statement->bindValue(':id_empleado', $id_empleado);

            $statement->bindValue(':data', addslashes($_POST['periodos']));

            $statement->bindValue(':observaciones_periodo', $_POST['observaciones_periodo']);

            $statement->bindValue(':id_periodo_vacaciones', $id_periodo_vacaciones);



            if ($statement->execute()) {

                $output['status'] = true;

                $output['msg'] = 'Período de vacaciones actualizado correctamente';

            } else {

                $output['msg'] = 'Error al actualizar el período de vacaciones';

            }

        } else {

            // Hacer un insert

            $sql = "INSERT INTO periodo_vacaciones

                    (id_empleado, data, observaciones)

                    VALUES

                    (:id_empleado, :data, :observaciones_periodo)";

            $statement = $dbConn->prepare($sql);



            $statement->bindValue(':id_empleado', $id_empleado);

            $statement->bindValue(':data', addslashes($_POST['periodos']));

            $statement->bindValue(':observaciones_periodo', $_POST['observaciones_periodo']);



            if ($statement->execute()) {

                $postId = $dbConn->lastInsertId();

                $output['status'] = true;

                $output['msg'] = 'Período de vacaciones añadido correctamente';

            } else {

                $output['msg'] = 'Error al añadir el período de vacaciones';

            }

        }



        echo json_encode($output);

        exit;

    }

}



if ($_SERVER['REQUEST_METHOD'] == 'DELETE') {

    $id = $_GET['id'];

    $statement = $dbConn->prepare("DELETE FROM periodo_vacaciones where id_periodo_vacaciones =:id");

    $statement->bindValue(':id', $id);

    $statement->execute();

    header("HTTP/1.1 200 OK");

    exit();

}



//Actualizar

if ($_SERVER['REQUEST_METHOD'] == 'PUT') {

    $input = $_GET;

    $postId = $input['id'];

    $fields = getParams($input);



    $sql = "

          UPDATE posts

          SET $fields

          WHERE id='$postId'

           ";



    $statement = $dbConn->prepare($sql);

    bindAllValues($statement, $input);



    $statement->execute();

    header("HTTP/1.1 200 OK");

    exit();

}



//En caso de que ninguna de las opciones anteriores se haya ejecutado

header("HTTP/1.1 400 Bad Request");