<?php



include "utils.php";



$dbConn = connect($db);



function response($data, $status = 200)

{

    if ($status == 200) {

        header("HTTP/1.1 200 OK");

    } else if ($status == 400) {

        header("HTTP/1.1 400 Bad Request");

    } else if ($status == 404) {

        header("HTTP/1.1 404 Not Found");

    } else if ($status == 500) {

        header("HTTP/1.1 500 Internal Server Error");

    }



    header('Content-Type: application/json');

    echo json_encode($data);



    exit();

}



function getPedidosTransportistasById($dbConn, $id)

{

    $sql = "SELECT * FROM pedidos_transportistas where id_transportista=:id_transportista";



    $statement = $dbConn->prepare($sql);

    $statement->bindValue(':id_transportista', $id);

    $statement->execute();



    response($statement->fetch(PDO::FETCH_ASSOC));

}



function getPedidosTransportistas($dbConn)

{

    $sql = "SELECT * FROM pedidos_transportistas";



    $statement = $dbConn->prepare($sql);

    $statement->execute();



    response($statement->fetchAll(PDO::FETCH_ASSOC));

}



function createPedidoTransportista($dbConn, $data)

{

    $nombre    = $data['nombre'];

    $domicilio = $data['domicilio'];

    $dni       = $data['dni'];

    $telefono  = $data['telefono'];



    $sql = "INSERT INTO pedidos_transportistas

            (nombre, domicilio, dni, telefono)

            VALUES

            (:nombre, :domicilio, :dni, :telefono)";



    $statement = $dbConn->prepare($sql);

    $statement->bindParam(':nombre', $nombre);

    $statement->bindParam(':domicilio', $domicilio);

    $statement->bindParam(':dni', $dni);

    $statement->bindParam(':telefono', $telefono);



    $statement->execute();



    $pedido_transportista_id = $dbConn->lastInsertId();



    if ($pedido_transportista_id) {

        $response = [

            'id' => $pedido_transportista_id,

            'nombre' => $nombre,

            'domicilio' => $domicilio,

            'dni' => $dni,

            'telefono' => $telefono,

        ];



        response($response);

    }

}



function deletePedidoTransportista($dbConn, $id)

{

    $sql = "DELETE FROM pedidos_transportistas WHERE id = :id";



    $statement = $dbConn->prepare($sql);

    $statement->bindParam(':id', $id);

    $statement->execute();



    response(['message' => 'Pedido transportista eliminado']);

}



/**

 * PROCESAMIENTO DE LA SOLICITUD

 */





/**

 * GET

 */

if ($_SERVER['REQUEST_METHOD'] == 'GET') {

    if (isset($_GET['id_transportista'])) {

        getPedidosTransportistasById($dbConn, $_GET['id_transportista']);

    }



    getPedidosTransportistas($dbConn);

}

/**

 * POST

 */

else if ($_SERVER['REQUEST_METHOD'] == 'POST') {

    if (isset($_POST["nombre"]) && isset($_POST["domicilio"]) && isset($_POST["dni"]) && isset($_POST["telefono"])) {

        createPedidoTransportista(

            $dbConn,

            array(

                'nombre'    => $_POST["nombre"],

                'domicilio' => $_POST["domicilio"],

                'dni'       => $_POST["dni"],

                'telefono'  => $_POST["telefono"],

            )

        );

    }

}

/**

 * DELETE

 */

else if ($_SERVER['REQUEST_METHOD'] == 'DELETE') {

    if (isset($_GET['id'])) {

        deletePedidoTransportista($dbConn, $_GET['id']);

    }

}



response(['message' => 'Error al procesar la solicitud'], 400);

