<?php



include "utils.php";



$dbConn = connect($db);



function response($data, $status = 200)

{

    if ($status == 200) {

        header("HTTP/1.1 200 OK");

    } else if ($status == 400) {

        header("HTTP/1.1 400 Bad Request");

    } else if ($status == 404) {

        header("HTTP/1.1 404 Not Found");

    } else if ($status == 500) {

        header("HTTP/1.1 500 Internal Server Error");

    }



    header('Content-Type: application/json');

    echo json_encode($data);



    exit();

}



function getPedidosObservacionesById($dbConn, $id)

{

    $sql = "SELECT * FROM pedidos_observaciones where id_observacion=:id_observacion";



    $statement = $dbConn->prepare($sql);

    $statement->bindValue(':id_observacion', $id);

    $statement->execute();



    response($statement->fetch(PDO::FETCH_ASSOC));

}



function getPedidosObservaciones($dbConn)

{

    $sql = "SELECT * FROM pedidos_observaciones";



    $statement = $dbConn->prepare($sql);

    $statement->execute();



    response($statement->fetchAll(PDO::FETCH_ASSOC));

}



function createPedidoObservacion($dbConn, $data)

{

    $id_pedido   = $data['id_pedido'];

    $observacion = $data['observacion'];



    $sql = "INSERT INTO pedidos_observaciones

            (id_pedido, observacion)

            VALUES

            (:id_pedido, :observacion)";



    $statement = $dbConn->prepare($sql);

    $statement->bindParam(':id_pedido', $id_pedido);

    $statement->bindParam(':observacion', $observacion);



    $statement->execute();



    $pedido_observacion_id = $dbConn->lastInsertId();



    if ($pedido_observacion_id) {

        $response = [

            'id'          => $pedido_observacion_id,

            'id_pedido'   => $id_pedido,

            'observacion' => $observacion,

        ];



        response($response);

    }

}



function deletePedidoObservacion($dbConn, $id)

{

    $sql = "DELETE FROM pedidos_observaciones WHERE id = :id";



    $statement = $dbConn->prepare($sql);

    $statement->bindParam(':id', $id);

    $statement->execute();



    response(['message' => 'Observación eliminada correctamente']);

}



/**

 * PROCESAMIENTO DE LA SOLICITUD

 */





/**

 * GET

 */

if ($_SERVER['REQUEST_METHOD'] == 'GET') {

    if (isset($_GET['id_observacion'])) {

        getPedidosObservacionesById($dbConn, $_GET['id_observacion']);

    }



    getPedidosObservaciones($dbConn);

}

/**

 * POST

 */

else if ($_SERVER['REQUEST_METHOD'] == 'POST') {

    if (isset($_POST["id_pedido"]) && isset($_POST["observacion"])) {

        createPedidoObservacion(

            $dbConn,

            array(

                'id_pedido'   => $_POST["id_pedido"],

                'observacion' => $_POST["observacion"],

            )

        );

    }

}

/**

 * DELETE

 */

else if ($_SERVER['REQUEST_METHOD'] == 'DELETE') {

    if (isset($_GET['id'])) {

        deletePedidoObservacion($dbConn, $_GET['id']);

    }

}



response(['message' => 'Error al procesar la solicitud'], 400);

