<?php



include "utils.php";



$dbConn = connect($db);



/*

listar todos los posts o solo uno

*/

if ($_SERVER['REQUEST_METHOD'] == 'GET') {

    if (isset($_GET['id_pedido'])) {

        //Mostrar un post

        $sql = $dbConn->prepare("SELECT * FROM `pedidos` where id_pedido=:id_pedido");

        $sql->bindValue(':id_pedido', $_GET['id_pedido']);

        $sql->execute();
        $pedido = $sql->fetch(PDO::FETCH_ASSOC);
        $id_transportista = $pedido["id_transportista"];

        $sql = $dbConn->prepare("SELECT * FROM `transportistas` where id_transportista=:id_transportista");

        $sql->bindValue(':id_transportista', $id_transportista);

        $sql->execute();
        $transportista = $sql->fetch(PDO::FETCH_ASSOC);
        $id_firma = $pedido["id_firma"];

        $sql = $dbConn->prepare("SELECT * FROM `firmas` where id_firma=:id_firma");

        $sql->bindValue(':id_firma', $id_firma);

        $sql->execute();
        $firma = $sql->fetch(PDO::FETCH_ASSOC);
        $input["pedido"] = $pedido;
        $input["transportista"] = $transportista;
        $input["firma"] = $firma;

        header("HTTP/1.1 200 OK");

        echo json_encode($input);

        exit();
    }
    if (isset($_GET['dias'])) {

        $dias = json_decode($_GET['dias']);
        $recursos = array();
        $pendientes_count = 0;
        $en_ruta_count = 0;
        $no_entregados_count = 0;
        $hoy_entregados_count = 0;
        $entregados_count = 0;
        $activos_count = 0;
        $hoy_no_entregados_count = 0;
        $total_count = 0;
        $fecha_i = reset($dias);
        $fecha_f = end($dias);
        $total = 0;
        $sql = "SELECT * FROM pedidos WHERE DATE_FORMAT(fecha_creacion, '%Y-%m-%d') BETWEEN :fecha_i AND :fecha_f";
        // Preparar la consulta SQL utilizando PDO
        $stmt = $dbConn->prepare($sql);
        $stmt->bindParam(':fecha_i', $fecha_i);
        $stmt->bindParam(':fecha_f', $fecha_f);
        $stmt->execute();
        $pedidos = $stmt->fetchAll(PDO::FETCH_ASSOC);
        $currentDateTime = new DateTime();
        $hoy = $currentDateTime->format('Y-m-d');
        foreach ($pedidos as $pedido) {
            $total += 1;
            $estado = $pedido["estado"];
            $fecha_creacion = $pedido["fecha_creacion"];

            $creacion = new DateTime($fecha_creacion);
            $creacion = $creacion->format('Y-m-d');

            if ($estado == "Pendiente") {
                $pendientes_count += 1;
            }
            if ($estado == "En ruta") {
                $en_ruta_count += 1;
            }
            if ($estado == "No entregado") {
                $no_entregados_count += 1;
                if ($hoy == $creacion) {
                    $hoy_no_entregados_count += 1;
                }
            }
            if ($estado == "Entregado") {
                $entregados_count += 1;

                if ($hoy == $creacion) {
                    $hoy_entregados_count += 1;
                }
            }
            if ($estado == "Activo") {
                $activos_count += 1;
            }
        }


        foreach ($dias as $fecha_formato) {
            $sql = "SELECT COUNT(*) as cantidad FROM pedidos WHERE DATE_FORMAT(fecha_creacion, '%Y-%m-%d') = :fecha";
            // Preparar la consulta SQL utilizando PDO
            $stmt = $dbConn->prepare($sql);
            $stmt->bindValue(':fecha', $fecha_formato, PDO::PARAM_STR);
            $stmt->execute();
            $row = $stmt->fetch(PDO::FETCH_ASSOC);
            $cantidad = $row['cantidad'];
            // Crear un objeto con la fecha y la cantidad de facturas y agregarlo al arreglo $facturas_por_dia
            $objeto = array("dia" => $fecha_formato, "cantidad" => $cantidad);
            array_push($recursos, $objeto);
        }

        $datos = array(
            "dias" => $recursos,
            "pendientes_count" => $pendientes_count,
            "activos_count" => $activos_count,
            "en_ruta_count" => $en_ruta_count,
            "no_entregados_count" => $no_entregados_count,
            "entregados_count" => $entregados_count,
            "hoy_no_entregados_count" => $hoy_no_entregados_count,
            "total_count" => $total,
            "hoy_entregados_count" => $hoy_entregados_count,
            "creacion" => $creacion,
            "hoy" => $hoy
        );


        // Devolver los resultados en formato JSON
        header('Content-Type: application/json');
        echo json_encode($datos);
        exit();
    }
    if (isset($_GET['id_pedido_observacion'])) {

        //Mostrar un post
        if ($_GET['id_pedido_observacion'] != "No") {
            $sql = $dbConn->prepare("SELECT * FROM `observaciones` where id_pedido=:id_pedido_observacion");
            $sql->bindValue(':id_pedido_observacion', $_GET['id_pedido_observacion']);
        } else {
            $sql = $dbConn->prepare("SELECT 
                                        observaciones.*, 
                                        pedidos.nombre AS pedido_nombre, 
                                        pedidos.dni AS pedido_dni, 
                                        pedidos.domicilio AS pedido_domicilio, 
                                        pedidos.numero AS pedido_numero, 
                                        pedidos.telefono AS pedido_telefono,
                                        transportistas.nombre AS transportista_nombre
                                    FROM 
                                        observaciones
                                    JOIN 
                                        pedidos ON observaciones.id_pedido = pedidos.id_pedido
                                    JOIN 
                                        transportistas ON pedidos.id_transportista = transportistas.id_transportista;
                                    ");
        }


        $sql->execute();
        $sql->setFetchMode(PDO::FETCH_ASSOC);
        header("HTTP/1.1 200 OK");

        echo json_encode($sql->fetchAll(PDO::FETCH_ASSOC));

        exit();
    } else {
        $sql = $dbConn->prepare("SELECT * FROM pedidos");
        $sql->execute();
        $sql->setFetchMode(PDO::FETCH_ASSOC);
        $clientes = $sql->fetchAll(PDO::FETCH_OBJ);


        header("HTTP/1.1 200 OK");

        echo json_encode($clientes);
        exit();
    }
}



// Crear un nuevo post

if ($_SERVER['REQUEST_METHOD'] == 'POST') {

    if (
        isset($_POST["numero"])
        && isset($_POST["nombre"])
        && isset($_POST["domicilio"])
        && isset($_POST["dni"])
        && isset($_POST["telefono"])
        && isset($_POST["palets"])
        && isset($_POST["bultos"])
        && isset($_POST["tipo_entrega"])
        && isset($_POST["estado"])
        && isset($_POST["id_transportista"])

        && isset($_POST["id_almacen"])
        && isset($_POST["id_balda"])
        && isset($_POST["id_columna"])
        && isset($_POST["fecha_almacen"])
        && isset($_POST["fecha_entrega"])
    ) {
        foreach ($_POST as $key => $value) {
            $value = ($value == "No") ? null : $value;
            $value = ($value == "") ? null : $value;

            $$key = $value;
        }
        if (isset($_POST["id_pedido"])) {
            $id_pedido = $_POST["id_pedido"];
            $sql = "UPDATE pedidos SET 
     id_almacen = :id_almacen,
            id_balda = :id_balda,
            id_columna = :id_columna,
            dni = :dni,
            nombre = :nombre,
            domicilio = :domicilio,
            dni = :dni,
            telefono = :telefono,
            palets = :palets,
            bultos = :bultos,
            tipo_entrega = :tipo_entrega,
            estado = :estado,
            numero = :numero,
            id_transportista = :id_transportista,
           
            fecha_entrega = :fecha_entrega,
            fecha_almacen = :fecha_almacen
           
            WHERE id_pedido = :id_pedido";
            $statement = $dbConn->prepare($sql);
            $statement->bindValue(':id_pedido', $id_pedido);
        } else {
            $sql = "INSERT INTO pedidos
    (id_almacen, id_balda, id_columna,numero, nombre, domicilio, dni, telefono
    ,palets, bultos, tipo_entrega, estado
    ,id_transportista, fecha_entrega
    , fecha_almacen)
    VALUES
    (:id_almacen, :id_balda, :id_columna,:numero,:nombre,:domicilio, :dni, :telefono
    ,:palets, :bultos, :tipo_entrega, :estado
    ,:id_transportista, :fecha_entrega
    ,:fecha_almacen)";
            $statement = $dbConn->prepare($sql);
        }
        $statement->bindValue(':id_almacen', $id_almacen);
        $statement->bindValue(':id_balda', $id_balda);
        $statement->bindValue(':id_columna', $id_columna);
        $statement->bindValue(':numero', $numero);
        $statement->bindValue(':nombre', $nombre);
        $statement->bindValue(':domicilio', $domicilio);
        $statement->bindValue(':dni', $dni);
        $statement->bindValue(':telefono', $telefono);
        $statement->bindValue(':palets', $palets);
        $statement->bindValue(':bultos', $bultos);
        $statement->bindValue(':tipo_entrega', $tipo_entrega);
        $statement->bindValue(':estado', $estado);

        $statement->bindValue(':id_transportista', $id_transportista);

        $statement->bindValue(':fecha_entrega', $fecha_entrega);
        $statement->bindValue(':fecha_almacen', $fecha_almacen);

        $statement->execute();
        $baseUrl = ($_SERVER['HTTPS'] ? 'https://' : 'http://') . $_SERVER['HTTP_HOST'] . '/';
        $rutaArchivoTemporal = isset($_FILES['imagen']) ? $_FILES['imagen']['tmp_name'] : null;
        if (isset($_POST["id_pedido"])) {
            if ($_POST["misma"] == "No") {
                $id_pedido = $_POST["id_pedido"];
                $Archivo = '../imagenes/pedidos/' . $id_pedido . '/perfil.png';
                $carpetaNuevaAlumno = '../imagenes/pedidos/' . $id_pedido;
                if ($rutaArchivoTemporal && !empty($rutaArchivoTemporal)) {
                    if (file_exists($Archivo)) {
                        unlink($Archivo); // Elimina el archivo existente antes de reemplazarlo
                    }
                    move_uploaded_file($rutaArchivoTemporal, $Archivo);
                }
            }
        } else {
            $id_pedido = $dbConn->lastInsertId();
            $nombreArchivoUnico = "perfil.png";
            $carpetaNuevaAlumno = '../imagenes/pedidos/' . $id_pedido;

            mkdir($carpetaNuevaAlumno, 0777, true);

            $rutaArchivoDestino = $carpetaNuevaAlumno . "/" . $nombreArchivoUnico;

            if ($rutaArchivoTemporal && !empty($rutaArchivoTemporal)) {
                // Si se proporcionó un archivo subido, moverlo usando move_uploaded_file
                move_uploaded_file($rutaArchivoTemporal, $rutaArchivoDestino);
            } else {
                // Si no se proporcionó un archivo subido, usar file_put_contents para la URL de respaldo
                $urlDefaultImage = $baseUrl . 'assets/images/clientes/user-default.png';
                $imagenDefault = file_get_contents($urlDefaultImage);
                file_put_contents($rutaArchivoDestino, $imagenDefault);
            }
        }
        $input['nombre'] = $nombre;

        header("HTTP/1.1 200 OK");
        echo json_encode($input);
        exit();
    }

    if (isset($_POST["firma"]) && isset($_POST["id_pedido_firma"]) && isset($_POST["nombre_firma"]) && isset($_POST["dni_firma"])) {
        $id_pedido = $_POST["id_pedido_firma"];
        $firmaBase64 = $_POST["firma"];
        $nombre = $_POST["nombre_firma"];
        $dni = $_POST["dni_firma"];
        if ($nombre === '') {
            $nombre = null;
        }
        if ($dni === '') {
            $dni = null;
        }
        $nombreArchivo = '../firmas/' . $id_pedido . '.png';

        $data = substr($firmaBase64, strpos($firmaBase64, ',') + 1);

        // Decodifica la firma base64 en datos binarios
        $firmaBinaria = base64_decode($data);

        // Guarda la firma en el archivo
        if (file_put_contents($nombreArchivo, $firmaBinaria)) {
            // El archivo se guardó correctamente

            $sql = "INSERT INTO firmas
    (nombre, dni)
    VALUES
    (:nombre, :dni)";
            $statement = $dbConn->prepare($sql);
            $statement->bindValue(':nombre', $nombre);
            $statement->bindValue(':dni', $dni);
            $statement->execute();
            $id_firma = $dbConn->lastInsertId();
            $sql = "UPDATE pedidos SET id_firma = :id_firma WHERE id_pedido = :id_pedido";
            $statement = $dbConn->prepare($sql);
            $statement->bindValue(':id_firma', $id_firma);
            $statement->bindValue(':id_pedido', $id_pedido);
            $statement->execute();

            $input["id_firma"] = $id_firma;
            echo json_encode($input);
        } else {
            // Ocurrió un error al guardar el archivo
            echo json_encode(['success' => false, 'error' => 'Error al guardar la firma']);
        }

        header("HTTP/1.1 200 OK");
        exit();
    }
    if (
        isset($_POST["observacion"])
        && isset($_POST["id_pedido"])
    ) {
        foreach ($_POST as $key => $value) {
            $value = ($value == "No") ? null : $value;
            $value = ($value == "") ? null : $value;
            $value = ($value == "null") ? null : $value;
            $$key = $value;
        }
        $sql = "INSERT INTO observaciones
    (observacion, id_pedido)
    VALUES
    (:observacion, :id_pedido)";
        $statement = $dbConn->prepare($sql);
        $statement->bindValue(':observacion', $observacion);
        $statement->bindValue(':id_pedido', $id_pedido);
        $statement->execute();
        $baseUrl = ($_SERVER['HTTPS'] ? 'https://' : 'http://') . $_SERVER['HTTP_HOST'] . '/';
        $rutaArchivoTemporal = isset($_FILES['imagen']) ? $_FILES['imagen']['tmp_name'] : null;
        $id_observacion = $dbConn->lastInsertId();
        $nombreArchivoUnico = $id_observacion . ".png";
        $carpetaNuevaAlumno = '../observaciones/';

        mkdir($carpetaNuevaAlumno, 0777, true);

        $rutaArchivoDestino = $carpetaNuevaAlumno . "/" . $nombreArchivoUnico;

        if ($rutaArchivoTemporal && !empty($rutaArchivoTemporal)) {
            // Si se proporcionó un archivo subido, moverlo usando move_uploaded_file
            move_uploaded_file($rutaArchivoTemporal, $rutaArchivoDestino);
        } else {
            // Si no se proporcionó un archivo subido, usar file_put_contents para la URL de respaldo
            $urlDefaultImage = $baseUrl . 'assets/images/clientes/user-default.png';
            $imagenDefault = file_get_contents($urlDefaultImage);
            file_put_contents($rutaArchivoDestino, $imagenDefault);
        }
        $input['observacion'] = $observacion;

        header("HTTP/1.1 200 OK");
        echo json_encode($input);
        exit();
    }
    if (
        isset($_POST["id_pedido_atributo"])
        && isset($_POST["valor"])
        && isset($_POST["atributo"])
    ) {
        foreach ($_POST as $key => $value) {
            $value = ($value == "No") ? null : $value;
            $value = ($value == "") ? null : $value;
            $value = ($value == "null") ? null : $value;
            $$key = $value;
        }
        $sql = "UPDATE pedidos SET $atributo = :valor WHERE id_pedido = :id_pedido_atributo";
        $statement = $dbConn->prepare($sql);
        $statement->bindValue(':id_pedido_atributo', $id_pedido_atributo);
        $statement->bindValue(':valor', $valor);

        $statement->execute();

        $input["id"] = $id_pedido_atributo;
        $input["valor"] = $valor;
        $input["atributo"] = $atributo;

        header("HTTP/1.1 200 OK");
        echo json_encode($input);
        exit();
    }
}



//Borrar

if ($_SERVER['REQUEST_METHOD'] == 'DELETE') {

    if (isset($_GET['id'])) {
        $id = $_GET['id'];
        $statement = $dbConn->prepare("DELETE FROM pedidos where id_pedido = :id");
        $statement->bindValue(':id', $id);
        $statement->execute();
        $url = "../imagenes/pedidos/" . $id;
        eliminarCarpeta($url);
        header("HTTP/1.1 200 OK");

        exit();
    }
    if (isset($_GET['id_firma']) && isset($_GET['id_pedido'])) {
        $id_firma = $_GET['id_firma'];
        $id_pedido = $_GET['id_pedido'];
        $url = '../firmas/' . $id_pedido . '.png';
        unlink($url);
        $statement = $dbConn->prepare("DELETE FROM firmas where id_firma = :id_firma");
        $statement->bindValue(':id_firma', $id_firma);
        $statement->execute();
        header("HTTP/1.1 200 OK");

        exit();
    }
    if (isset($_GET['id_observacion_eliminar'])) {
        $id_observacion_eliminar = $_GET['id_observacion_eliminar'];
        $statement = $dbConn->prepare("DELETE FROM observaciones where id_observacion = :id_observacion_eliminar");
        $statement->bindValue(':id_observacion_eliminar', $id_observacion_eliminar);
        $statement->execute();
        $nombreArchivoUnico = $id_observacion_eliminar . ".png";
        $carpetaNuevaAlumno = '../observaciones/';
        $rutaArchivoDestino = $carpetaNuevaAlumno . "/" . $nombreArchivoUnico;
        unlink($rutaArchivoDestino);
        header("HTTP/1.1 200 OK");

        exit();
    }
    if (isset($_GET['url'])) {
        $url = $_GET['url'];
        header("HTTP/1.1 200 OK");
        unlink($url);
        exit();
    }
}



//Actualizar

if ($_SERVER['REQUEST_METHOD'] == 'PUT') {

    $input = $_GET;

    $postId = $input['id'];

    $fields = getParams($input);



    $sql = "

          UPDATE posts

          SET $fields

          WHERE id='$postId'

           ";



    $statement = $dbConn->prepare($sql);

    bindAllValues($statement, $input);



    $statement->execute();

    header("HTTP/1.1 200 OK");

    exit();
}
function eliminarCarpeta($rutaCarpeta)
{
    // Obtener una lista de archivos y subcarpetas dentro de la carpeta
    $archivos = glob($rutaCarpeta . '/*');

    // Eliminar cada archivo encontrado
    foreach ($archivos as $archivo) {
        if (is_file($archivo)) {
            unlink($archivo);
        } elseif (is_dir($archivo)) {
            eliminarCarpeta($archivo);
        }
    }

    // Eliminar la carpeta
    if (is_dir($rutaCarpeta)) {
        rmdir($rutaCarpeta);
    }
}



//En caso de que ninguna de las opciones anteriores se haya ejecutado

header("HTTP/1.1 400 Bad Request");