<?php

include "utils.php";

$dbConn = connect($db);

// GET: obtener uno o todos los materiales
if ($_SERVER['REQUEST_METHOD'] == 'GET') {

    if (isset($_GET['id_pack'])) {
        $id_pack = $_GET['id_pack'];

        // Obtener datos del pack
        $sql = $dbConn->prepare("SELECT * FROM packs WHERE id_pack = :id_pack");
        $sql->bindValue(':id_pack', $id_pack);
        $sql->execute();
        $pack = $sql->fetch(PDO::FETCH_ASSOC);

        if (!$pack) {
            header("HTTP/1.1 404 Not Found");
            echo json_encode(['error' => 'Pack no encontrado']);
            exit();
        }

        // Obtener materiales asociados
        $sql = $dbConn->prepare("
            SELECT m.*, mp.cantidad
            FROM material_pack mp
            JOIN materiales2 m ON m.id_material = mp.id_material
            WHERE mp.id_pack = :id_pack
        ");
        $sql->bindValue(':id_pack', $id_pack);
        $sql->execute();
        $materiales = $sql->fetchAll(PDO::FETCH_ASSOC);

        foreach ($materiales as &$material) {
            $sql_complementos = $dbConn->prepare("SELECT * FROM complementos WHERE id_material = :id_material");
            $sql_complementos->bindValue(':id_material', $material['id_material']);
            $sql_complementos->execute();
            $complementos = $sql_complementos->fetchAll(PDO::FETCH_ASSOC);

            // Agregar los complementos al array del material
            $material['complementos'] = $complementos;
        }
        // Combinar
        $pack['materiales'] = $materiales;

        header("HTTP/1.1 200 OK");
        echo json_encode($pack);
        exit();
    } else {
        $sql = $dbConn->prepare("SELECT * FROM packs");
        $sql->execute();
        $packs = $sql->fetchAll(PDO::FETCH_ASSOC);

        foreach ($packs as &$pack) {
            $sql = $dbConn->prepare("
                SELECT m.*, mp.cantidad
                FROM material_pack mp
                JOIN materiales2 m ON m.id_material = mp.id_material
                WHERE mp.id_pack = :id_pack
            ");
            $sql->bindValue(':id_pack', $pack['id_pack']);
            $sql->execute();
            $pack['materiales'] = $sql->fetchAll(PDO::FETCH_ASSOC);
        }

        header("HTTP/1.1 200 OK");
        echo json_encode($packs);
        exit();
    }
}
// POST: crear o actualizar material
if ($_SERVER['REQUEST_METHOD'] == 'POST') {

    // ✅ Crear nuevo PACK de materiales
    if (isset($_POST["nombre"]) && isset($_POST["extras"]) && empty($_POST["id_pack"])) {

        $nombre = $_POST["nombre"];
        $descripcion = $_POST["descripcion"] ?? "";
        $extras = json_decode($_POST["extras"], true); // array de objetos {id, cantidad}

        // 1. Insertar el pack
        $sql = "INSERT INTO packs (nombre, descripcion) VALUES (:nombre, :descripcion)";
        $stmt = $dbConn->prepare($sql);
        $stmt->bindValue(":nombre", $nombre);
        $stmt->bindValue(":descripcion", $descripcion);
        $stmt->execute();

        $id_pack = $dbConn->lastInsertId();

        // 2. Insertar cada material
        $sql = "INSERT INTO material_pack (id_pack, id_material, cantidad) VALUES (:id_pack, :id_material, :cantidad)";
        $stmt = $dbConn->prepare($sql);

        foreach ($extras as $extra) {
            $stmt->bindValue(":id_pack", $id_pack);
            $stmt->bindValue(":id_material", $extra['id']);
            $stmt->bindValue(":cantidad", $extra['cantidad']);
            $stmt->execute();
        }

        header("HTTP/1.1 200 OK");
        echo json_encode([
            'id_pack' => $id_pack,
            'accion' => 'pack_creado'
        ]);
        exit();
    }

    // ✅ Actualizar PACK existente
    if (isset($_POST["id_pack"]) && isset($_POST["nombre"]) && isset($_POST["extras"])) {

        $id_pack = $_POST["id_pack"];
        $nombre = $_POST["nombre"];
        $descripcion = $_POST["descripcion"] ?? "";
        $extras = json_decode($_POST["extras"], true); // array de objetos {id, cantidad}

        // 1. Actualizar datos del pack
        $sql = "UPDATE packs SET nombre = :nombre, descripcion = :descripcion WHERE id_pack = :id_pack";
        $stmt = $dbConn->prepare($sql);
        $stmt->bindValue(":nombre", $nombre);
        $stmt->bindValue(":descripcion", $descripcion);
        $stmt->bindValue(":id_pack", $id_pack);
        $stmt->execute();

        // 2. Eliminar materiales anteriores
        $sql = "DELETE FROM material_pack WHERE id_pack = :id_pack";
        $stmt = $dbConn->prepare($sql);
        $stmt->bindValue(":id_pack", $id_pack);
        $stmt->execute();

        // 3. Insertar los nuevos materiales
        $sql = "INSERT INTO material_pack (id_pack, id_material, cantidad) VALUES (:id_pack, :id_material, :cantidad)";
        $stmt = $dbConn->prepare($sql);

        foreach ($extras as $extra) {
            $stmt->bindValue(":id_pack", $id_pack);
            $stmt->bindValue(":id_material", $extra['id']);
            $stmt->bindValue(":cantidad", $extra['cantidad']);
            $stmt->execute();
        }

        header("HTTP/1.1 200 OK");
        echo json_encode([
            'id_pack' => $id_pack,
            'accion' => 'pack_actualizado'
        ]);
        exit();
    }

    // ✅ Crear o actualizar MATERIAL ...
}



// DELETE: eliminar material
if ($_SERVER['REQUEST_METHOD'] == 'DELETE') {

    if (isset($_GET['id'])) {
        $id = $_GET['id'];
        $statement = $dbConn->prepare("DELETE FROM packs WHERE id_pack = :id");
        $statement->bindValue(':id', $id);
        $statement->execute();

        header("HTTP/1.1 200 OK");
        exit();
    }
}

// PUT: actualizar parcialmente material
if ($_SERVER['REQUEST_METHOD'] == 'PUT') {

    parse_str(file_get_contents("php://input"), $input);

    if (isset($input['id'])) {
        $id = $input['id'];

        $fields = [];
        if (isset($input['nombre'])) $fields['nombre'] = $input['nombre'];
        if (isset($input['estado'])) $fields['estado'] = $input['estado'];
        if (isset($input['precio_dia'])) $fields['precio_dia'] = $input['precio_dia'];
        if (isset($input['stock'])) $fields['stock'] = $input['stock'];

        $setClause = implode(", ", array_map(fn($k) => "$k = :$k", array_keys($fields)));

        $sql = "UPDATE materiales2 SET $setClause WHERE id_material = :id";

        $statement = $dbConn->prepare($sql);
        $statement->bindValue(':id', $id);
        foreach ($fields as $key => $value) {
            $statement->bindValue(":$key", $value);
        }

        $statement->execute();

        header("HTTP/1.1 200 OK");
        exit();
    }
}

// Si no coincide ninguna petición válida
header("HTTP/1.1 400 Bad Request");