<?php

include "utils.php";

$dbConn = connect($db);

/*
listar todos los posts o solo uno
 */
if ($_SERVER['REQUEST_METHOD'] == 'GET')
    {
    if (isset($_GET['id_curso']))
        {
        //Mostrar un post
        $sql = $dbConn->prepare("SELECT * FROM nivel_estudios where id_nivel_estudios=:id_nivel_estudios");
        $sql->bindValue(':id_nivel_estudios', $_GET['id_nivel_estudios']);
        $sql->execute();
        header("HTTP/1.1 200 OK");
        echo json_encode($sql->fetch(PDO::FETCH_ASSOC));
        exit();
        } else
        {
        //Mostrar lista de post
        $sql = $dbConn->prepare("SELECT * FROM nivel_estudios");
        $sql->execute();
        $sql->setFetchMode(PDO::FETCH_ASSOC);
        header("HTTP/1.1 200 OK");

        echo json_encode($sql->fetchAll());
        exit();
        }
    }

// Crear un nuevo post
if ($_SERVER['REQUEST_METHOD'] == 'POST')
    {
    if (isset($_POST["nombre"]))
        {
        $nombre = $_POST["nombre"];
        $sqlVerificar = "SELECT COUNT(*) as count FROM nivel_estudios WHERE nombre = :nombre";
        $statementVerificar = $dbConn->prepare($sqlVerificar);
        $statementVerificar->bindValue(':nombre', $nombre);
        $statementVerificar->execute();
        $resultadoVerificar = $statementVerificar->fetch(PDO::FETCH_ASSOC);

        if ($resultadoVerificar['count'] > 0)
            {
            // El nombre ya está en uso, mostrar mensaje de error

            echo 0;
            exit();
            }
        $sql = "INSERT INTO nivel_estudios
        (nombre)
        VALUES
        (:nombre)";

        $statement = $dbConn->prepare($sql);

        $statement->bindValue(':nombre', $nombre);

        $statement->execute();

        $postId = $dbConn->lastInsertId();

        $input['id'] = $postId;
        $input['nombre'] = $nombre;

        header("HTTP/1.1 200 OK");
        echo json_encode($input);
        exit();

        }

    }

if ($_SERVER['REQUEST_METHOD'] == 'DELETE')
    {


    if (isset($_GET["id"]))
        {
        $id = $_GET['id'];
        $statement = $dbConn->prepare("DELETE FROM nivel_estudios where id_nivel_estudios =:id");
        $statement->bindValue(':id', $id);
        $statement->execute();
        header("HTTP/1.1 200 OK");
        exit();
        }
    }

//Actualizar
if ($_SERVER['REQUEST_METHOD'] == 'PUT')
    {
    $input = $_GET;
    $postId = $input['id'];
    $fields = getParams($input);

    $sql = "
          UPDATE posts
          SET $fields
          WHERE id='$postId'
           ";

    $statement = $dbConn->prepare($sql);
    bindAllValues($statement, $input);

    $statement->execute();
    header("HTTP/1.1 200 OK");
    exit();
    }

//En caso de que ninguna de las opciones anteriores se haya ejecutado
header("HTTP/1.1 400 Bad Request");