<?php



include "utils.php";



$dbConn = connect($db);



/*

listar todos los posts o solo uno

*/

if ($_SERVER['REQUEST_METHOD'] == 'GET') {



    if (isset($_GET['nombre'])) {

        $nombre = $_GET['nombre'];

        $JSON = json_decode(file_get_contents('../menu.json'), true)["elementos"];

        $submenu = $JSON[$nombre]["elementos"];

        header("HTTP/1.1 200 OK");

        echo json_encode($submenu);

        exit();
    } else {

        //Mostrar lista de post

        $sql = $dbConn->prepare("SELECT * FROM estados");

        $sql->execute();

        $sql->setFetchMode(PDO::FETCH_ASSOC);

        header("HTTP/1.1 200 OK");



        echo json_encode($sql->fetchAll());

        exit();
    }
}



// Crear un nuevo post

if ($_SERVER['REQUEST_METHOD'] == 'POST') {

    if (isset($_POST['menu'])) {

        $JSON = json_decode(file_get_contents('../menu.json'), true);

        $menu = $_POST['menu'];

        foreach ($menu as $m) {

            $JSON["elementos"][$m["nombre"]]["orden"] = $m["orden"];
        }



        $JSONEncoded = json_encode($JSON);

        file_put_contents('../menu.json', $JSONEncoded);

        header("HTTP/1.1 200 OK");

        echo $JSONEncoded;

        exit();
    }


    if (isset($_POST['nombre_link_bloquear'])) {

        $JSON = json_decode(file_get_contents('../menu.json'), true);

        $nombre = $_POST['nombre_link_bloquear'];



        $JSON["elementos"][$nombre]["bloqueado"] = true;





        $JSONEncoded = json_encode($JSON);

        file_put_contents('../menu.json', $JSONEncoded);

        header("HTTP/1.1 200 OK");

        echo $JSONEncoded;

        exit();
    }
    if (isset($_POST['tabla_vaciar'])) {

        $tabla = $_POST['tabla_vaciar'];



        // Vaciar la tabla (sin WHERE)
        try {
            // Validar nombre de tabla para evitar inyecciones


            $sql = "DELETE FROM `$tabla`";
            $statement = $dbConn->prepare($sql);
            $statement->execute();


            // Si la tabla es 'clientes', vaciar también la carpeta
            if ($tabla === 'clientes') {
                $rutaClientes = '../clientes';


                // Eliminar contenido de la carpeta 'clientes'
                eliminarContenidoCarpeta($rutaClientes);
            }

            if ($tabla === 'poveedores' || $tabla === 'factura_poveedor') {
                $rutaClientes = '../archivos/factura_poveedor';


                // Eliminar contenido de la carpeta 'clientes'
                eliminarContenidoCarpeta($rutaClientes);
            }
        } catch (PDOException $e) {
            http_response_code(500);
            echo json_encode(['error' => 'Error al vaciar la tabla']);
            exit();
        }
        // Respuesta de éxito
        header("Content-Type: application/json");
        http_response_code(200);
        echo json_encode(['success' => true, 'tabla_vaciada' => $tabla]);
        exit();
    }


    if (isset($_POST['nombre_sublink_bloquear']) && isset($_POST['padre_sublink_bloquear'])) {

        $JSON = json_decode(file_get_contents('../menu.json'), true);

        $nombre = $_POST['nombre_sublink_bloquear'];

        $padre = $_POST['padre_sublink_bloquear'];

        $JSON["elementos"][$padre]["elementos"][$nombre]["bloqueado"] = true;





        $JSONEncoded = json_encode($JSON);

        file_put_contents('../menu.json', $JSONEncoded);

        header("HTTP/1.1 200 OK");

        echo $JSONEncoded;

        exit();
    }

    if (isset($_POST['submenu']) && isset($_POST['nombre'])) {

        $JSON = json_decode(file_get_contents('../menu.json'), true);

        $submenu = $_POST['submenu'];

        $nombre = $_POST['nombre'];



        foreach ($submenu as $m) {

            $JSON["elementos"][$nombre]["elementos"][$m["nombre"]]["orden"] = $m["orden"];
        }

        $JSONEncoded = json_encode($JSON);

        file_put_contents('../menu.json', $JSONEncoded);

        header("HTTP/1.1 200 OK");

        echo $JSONEncoded;

        exit();
    }

    if (isset($_POST['visible']) && isset($_POST['nombre_menu'])) {

        $JSON = json_decode(file_get_contents('../menu.json'), true);

        $visible = json_decode($_POST['visible']);

        $nombre_menu = $_POST['nombre_menu'];

        if (isset($_POST['nombre_sub_menu'])) {

            $nombre_sub_menu = $_POST['nombre_sub_menu'];

            $JSON["elementos"][$nombre_menu]["elementos"][$nombre_sub_menu]["visible"] = $visible;
        } else {

            $JSON["elementos"][$nombre_menu]["visible"] = $visible;
        }



        $JSONEncoded = json_encode($JSON);

        file_put_contents('../menu.json', $JSONEncoded);

        header("HTTP/1.1 200 OK");

        echo json_encode($visible);

        exit();
    }

    if (isset($_POST['nombre']) && isset($_POST['nombre_visible'])) {

        $JSON = json_decode(file_get_contents('../menu.json'), true);

        $nombre = $_POST['nombre'];

        $nombre_visible = $_POST['nombre_visible'];

        if (isset($_POST['nombre_menu'])) {

            $nombre_menu = $_POST['nombre_menu'];

            $JSON["elementos"][$nombre_menu]["elementos"][$nombre]["nombre_visible"] = $nombre_visible;
        } else {

            $JSON["elementos"][$nombre]["nombre_visible"] = $nombre_visible;
        }



        $JSONEncoded = json_encode($JSON);

        file_put_contents('../menu.json', $JSONEncoded);

        header("HTTP/1.1 200 OK");

        echo json_encode($nombre_visible);

        exit();
    }
}



//Borrar

if ($_SERVER['REQUEST_METHOD'] == 'DELETE') {

    $id = $_GET['id'];

    $statement = $dbConn->prepare("DELETE FROM posts where id=:id");

    $statement->bindValue(':id', $id);

    $statement->execute();

    header("HTTP/1.1 200 OK");

    exit();
}



//Actualizar

if ($_SERVER['REQUEST_METHOD'] == 'PUT') {

    $input = $_GET;

    $postId = $input['id'];

    $fields = getParams($input);



    $sql = "

          UPDATE posts

          SET $fields

          WHERE id='$postId'

           ";



    $statement = $dbConn->prepare($sql);

    bindAllValues($statement, $input);



    $statement->execute();

    header("HTTP/1.1 200 OK");

    exit();
}


function eliminarContenidoCarpeta($ruta)
{
    if (!is_dir($ruta)) return;
    foreach (scandir($ruta) as $item) {
        if ($item === '.' || $item === '..') continue;
        $rutaCompleta = $ruta . '/' . $item;
        if (is_dir($rutaCompleta)) {
            eliminarContenidoCarpeta($rutaCompleta);
            rmdir($rutaCompleta);
        } else {
            unlink($rutaCompleta);
        }
    }
}
//En caso de que ninguna de las opciones anteriores se haya ejecutado

header("HTTP/1.1 400 Bad Request");