<?php

include "utils.php";

$dbConn = connect($db);

// GET: obtener uno o todos los materiales
if ($_SERVER['REQUEST_METHOD'] == 'GET') {

  if (isset($_GET['id_material'])) {
    // Obtener el material
    $sql = $dbConn->prepare("SELECT * FROM materiales2 WHERE id_material = :id_material");
    $sql->bindValue(':id_material', $_GET['id_material']);
    $sql->execute();
    $material = $sql->fetch(PDO::FETCH_ASSOC);

    if ($material) {
        // Obtener los complementos relacionados a ese material
        $sql_complementos = $dbConn->prepare("SELECT * FROM complementos WHERE id_material = :id_material");
        $sql_complementos->bindValue(':id_material', $_GET['id_material']);
        $sql_complementos->execute();
        $complementos = $sql_complementos->fetchAll(PDO::FETCH_ASSOC);

        // Agregar los complementos al array del material
        $material['complementos'] = $complementos;
    }

    header("HTTP/1.1 200 OK");
    echo json_encode($material);
    exit();
}
else {
        // Inicializamos partes del WHERE dinámico
        $where = [];
        $params = [];

        // Filtrar por id_familia si viene y es distinto de 'No'
        if (isset($_GET['id_familia']) && $_GET['id_familia'] !== 'No') {
            $where[] = "m.id_familia = :id_familia";
            $params[':id_familia'] = $_GET['id_familia'];
        }

        // Filtrar por id_subfamilia si viene y es distinto de 'No'
        if (isset($_GET['id_subfamilia']) && $_GET['id_subfamilia'] !== 'No') {
            $where[] = "m.id_subfamilia = :id_subfamilia";
            $params[':id_subfamilia'] = $_GET['id_subfamilia'];
        }

        // Construir la consulta base
        $sqlQuery = "
    SELECT 
        m.*, 
        COALESCE(f.nombre, 'Ninguna') AS nombre_familia,
        COALESCE(s.nombre, 'Ninguna') AS nombre_subfamilia
    FROM materiales2 m
    LEFT JOIN familias f ON m.id_familia = f.id_familia
    LEFT JOIN subfamilias s ON m.id_subfamilia = s.id_subfamilia
";

        // Agregar condiciones si hay filtros
        if (!empty($where)) {
            $sqlQuery .= " WHERE " . implode(" AND ", $where);
        }

        // Preparar y ejecutar
        $sql = $dbConn->prepare($sqlQuery);
        $sql->execute($params);
        $sql->setFetchMode(PDO::FETCH_ASSOC);

        // Retornar respuesta
        header("HTTP/1.1 200 OK");
        echo json_encode($sql->fetchAll());
        exit();
    }
}

// POST: crear o actualizar material
if ($_SERVER['REQUEST_METHOD'] == 'POST') {

    if (isset($_POST["nombre"])) {
        $nombre = $_POST["nombre"];
        $estado = $_POST["estado"] ?? "Disponible";
        $precio_dia = $_POST["precio_dia"] ?? 0;
        $stock = $_POST["stock"] ?? 0;

        // 🔹 Nuevos campos: familia y subfamilia
        $id_familia = !empty($_POST["id_familia"]) ? $_POST["id_familia"] : null;
        $id_subfamilia = !empty($_POST["id_subfamilia"]) ? $_POST["id_subfamilia"] : null;

        if (isset($_POST["id_material"])) {
            // 🔄 UPDATE
            $id = $_POST["id_material"];

            $sql = "UPDATE materiales2 
                    SET nombre = :nombre, estado = :estado, precio_dia = :precio_dia, stock = :stock,
                        id_familia = :id_familia, id_subfamilia = :id_subfamilia
                    WHERE id_material = :id";
            $statement = $dbConn->prepare($sql);

            $statement->bindValue(':nombre', $nombre);
            $statement->bindValue(':estado', $estado);
            $statement->bindValue(':precio_dia', $precio_dia);
            $statement->bindValue(':stock', $stock);
            $statement->bindValue(':id_familia', $id_familia);
            $statement->bindValue(':id_subfamilia', $id_subfamilia);
            $statement->bindValue(':id', $id);

            $statement->execute();

            $response = [
                'id_material' => $id,
                'accion' => 'actualizado'
            ];
        } else {
            // ➕ INSERT
            $sql = "INSERT INTO materiales2 (nombre, estado, precio_dia, stock, id_familia, id_subfamilia) 
                    VALUES (:nombre, :estado, :precio_dia, :stock, :id_familia, :id_subfamilia)";
            $statement = $dbConn->prepare($sql);

            $statement->bindValue(':nombre', $nombre);
            $statement->bindValue(':estado', $estado);
            $statement->bindValue(':precio_dia', $precio_dia);
            $statement->bindValue(':stock', $stock);
            $statement->bindValue(':id_familia', $id_familia);
            $statement->bindValue(':id_subfamilia', $id_subfamilia);

            $statement->execute();

            $id = $dbConn->lastInsertId();

            $response = [
                'id_material' => $id,
                'accion' => 'creado'
            ];
        }

        header("HTTP/1.1 200 OK");
        echo json_encode($response);
        exit();
    }if (
        isset($_POST["id_material_complemento"]) &&
        isset($_POST["nombre_complemento"]) &&
        isset($_POST["cantidad_complemento"])
    ) {
        $id_material = $_POST["id_material_complemento"];
        $nombre = $_POST["nombre_complemento"];
        $cantidad = $_POST["cantidad_complemento"];

        $sql = "INSERT INTO complementos (id_material, nombre, cantidad)
                VALUES (:id_material, :nombre, :cantidad)";
        $stmt = $dbConn->prepare($sql);
        $stmt->bindValue(':id_material', $id_material);
        $stmt->bindValue(':nombre', $nombre);
        $stmt->bindValue(':cantidad', $cantidad);
        $stmt->execute();

        $response = [
            'id_complemento' => $dbConn->lastInsertId(),
            'accion' => 'complemento_creado'
        ];

        header("HTTP/1.1 200 OK");
        echo json_encode($response);
        exit();
    }
}


// DELETE: eliminar material
if ($_SERVER['REQUEST_METHOD'] == 'DELETE') {

    if (isset($_GET['id'])) {
        $id = $_GET['id'];
        $statement = $dbConn->prepare("DELETE FROM materiales2 WHERE id_material = :id");
        $statement->bindValue(':id', $id);
        $statement->execute();

        header("HTTP/1.1 200 OK");
        exit();
    } if (isset($_GET['id_complemento'])) {
        $id = $_GET['id_complemento'];
        $statement = $dbConn->prepare("DELETE FROM complementos WHERE id_complemento = :id");
        $statement->bindValue(':id', $id);
        $statement->execute();

        header("HTTP/1.1 200 OK");
        exit();
    }
}

// PUT: actualizar parcialmente material
if ($_SERVER['REQUEST_METHOD'] == 'PUT') {

    parse_str(file_get_contents("php://input"), $input);

    if (isset($input['id'])) {
        $id = $input['id'];

        $fields = [];
        if (isset($input['nombre'])) $fields['nombre'] = $input['nombre'];
        if (isset($input['estado'])) $fields['estado'] = $input['estado'];
        if (isset($input['precio_dia'])) $fields['precio_dia'] = $input['precio_dia'];
        if (isset($input['stock'])) $fields['stock'] = $input['stock'];

        $setClause = implode(", ", array_map(fn($k) => "$k = :$k", array_keys($fields)));

        $sql = "UPDATE materiales2 SET $setClause WHERE id_material = :id";

        $statement = $dbConn->prepare($sql);
        $statement->bindValue(':id', $id);
        foreach ($fields as $key => $value) {
            $statement->bindValue(":$key", $value);
        }

        $statement->execute();

        header("HTTP/1.1 200 OK");
        exit();
    }
}

// Si no coincide ninguna petición válida
header("HTTP/1.1 400 Bad Request");