<?php



include "utils.php";

include '../libraries/maxmind/autoload.php';



$dbConn = connect($db);



/*

listar todos los posts o solo uno

 */

if ($_SERVER['REQUEST_METHOD'] == 'GET')

    {

    if (isset($_GET['id_metodo']))

        {

        //Mostrar un post

        $sql = $dbConn->prepare("SELECT * FROM metodos_pago where id_metodo=:id_metodo");

        $sql->bindValue(':id_metodo', $_GET['id_metodo']);

        $sql->execute();

        header("HTTP/1.1 200 OK");

        echo json_encode($sql->fetch(PDO::FETCH_ASSOC));

        exit();

        } else

        {

        //Mostrar lista de logins
$sql = $dbConn->prepare("
  SELECT 
    logins.*,
    users.user_full_name AS nombre_usuario,
    FROM_UNIXTIME(logins.login_date, '%Y-%m-%d %H:%i:%s') AS login_date_str
  FROM logins
  LEFT JOIN users ON logins.login_user = users.user_id
");
$sql->execute();
$sql->setFetchMode(PDO::FETCH_ASSOC);

$GeoIP = new MaxMind\Db\Reader('../libraries/maxmind/GeoLite2-City.mmdb');
$logins = $sql->fetchAll();

foreach ($logins as &$login) {
    $Record = $GeoIP->get($login["login_ip"]);
    if (isset($Record['city']['names']['es'])) {
        $City = $Record['city']['names']['es'] . ', ';
    } else if (isset($Record['city']['names']['en'])) {
        $City = $Record['city']['names']['en'] . ', ';
    } else {
        $City = '';
    }

    if (isset($Record['country']['names']['es'])) {
        $Country = $Record['country']['names']['es'];
    } else if (isset($Record['country']['names']['en'])) {
        $Country = $Record['country']['names']['en'];
    } else {
        $Country = '';
    }

    if ($City == '' && $Country == '') {
        $Country = 'Desconocido';
    }
    $login["localizacion"] = htmlentities($City . " " . $Country, ENT_QUOTES);
}

header("HTTP/1.1 200 OK");
echo json_encode($logins);
exit();

        }

    }





// Crear un nuevo post

if ($_SERVER['REQUEST_METHOD'] == 'POST')

    {

    if (isset($_POST["logins"]))

        {



        $logins = $_POST["logins"];

        foreach ($logins as $a)

            {



            $login_user = $a["login_user"];

            $login_ip = $a["login_ip"];

            $login_agent = $a["login_agent"];

            $login_success = $a["login_success"];

            $login_date = $a["login_date"];

            $login_date = new DateTime($login_date);

            $timestamp = $login_date->getTimestamp();

            $sql = "INSERT INTO logins (login_user,login_ip,login_agent,login_success,login_date) VALUES (:login_user,:login_ip,:login_agent,:login_success,:login_date)";

            $statement = $dbConn->prepare($sql);

            $statement->bindValue(':login_user', $login_user);

            $statement->bindValue(':login_ip', $login_ip);

            $statement->bindValue(':login_agent', $login_agent);

            $statement->bindValue(':login_success', $login_success);

            $statement->bindValue(':login_date', $timestamp);

            $statement->execute();

            }

        header("HTTP/1.1 200 OK");

        echo "Llogins agegadas.";

        exit();

        }

    }



//Borrar

if ($_SERVER['REQUEST_METHOD'] == 'DELETE')

    {

    $login_id_eliminar = $_GET['login_id_eliminar'];

    $statement = $dbConn->prepare("DELETE FROM logins where login_id = :login_id_eliminar");

    $statement->bindValue(':login_id_eliminar', $login_id_eliminar);

    $statement->execute();

    header("HTTP/1.1 200 OK");

    exit();

    }



//Actualizar

if ($_SERVER['REQUEST_METHOD'] == 'PUT')

    {

    $input = $_GET;

    $postId = $input['id'];

    $fields = getParams($input);



    $sql = "

          UPDATE posts

          SET $fields

          WHERE id='$postId'

           ";



    $statement = $dbConn->prepare($sql);

    bindAllValues($statement, $input);



    $statement->execute();

    header("HTTP/1.1 200 OK");

    exit();

    }



//En caso de que ninguna de las opciones anteriores se haya ejecutado

header("HTTP/1.1 400 Bad Request");