<?php



include "utils.php";



$dbConn = connect($db);



/*

listar todos los posts o solo uno

 */

if ($_SERVER['REQUEST_METHOD'] == 'GET') {

    if (isset($_GET['id_igic'])) {

        //Mostrar un post

        $sql = $dbConn->prepare("SELECT * FROM igic where id_igic=:id_igic");

        $sql->bindValue(':id_igic', $_GET['id_igic']);

        $sql->execute();

        header("HTTP/1.1 200 OK");

        echo json_encode($sql->fetch(PDO::FETCH_ASSOC));

        exit();

    } else {

        //Mostrar lista de post

        $sql = $dbConn->prepare("SELECT * FROM igic");

        $sql->execute();

        $sql->setFetchMode(PDO::FETCH_ASSOC);

        header("HTTP/1.1 200 OK");



        echo json_encode($sql->fetchAll());

        exit();

    }

}



// Crear un nuevo post

if ($_SERVER['REQUEST_METHOD'] == 'POST') {

    $porcentaje = $_POST["porcentaje"];

    $nombre = $_POST["nombre"];



    try {

        $sql = "INSERT INTO igic (porcentaje, nombre) VALUES (:porcentaje, :nombre)";

        $statement = $dbConn->prepare($sql);

        $statement->bindValue(':porcentaje', $porcentaje);

        $statement->bindValue(':nombre', $nombre);

        $statement->execute();

        $object = [

            'id' => $dbConn->lastInsertId(),

            'porcentaje' => $porcentaje,

            'nombre' => $nombre,

        ];



        header("HTTP/1.1 200 OK");

        echo json_encode($object);

        exit();

    } catch (PDOException $e) {

        if ($e->getCode() == 23000) { // Código de error para violación de restricción UNIQUE en MySQL

            header("HTTP/1.1 409 Conflict");

            echo json_encode(['error' => 'El porcentaje ya existe.']);

        } else {

            header("HTTP/1.1 500 Internal Server Error");

            echo json_encode(['error' => 'Ha ocurrido un error.']);

        }

        exit();

    }

}





//Borrar

if ($_SERVER['REQUEST_METHOD'] == 'DELETE') {

    $id = $_GET['id'];

    $statement = $dbConn->prepare("DELETE FROM igic where id_igic=:id");

    $statement->bindValue(':id', $id);

    $statement->execute();

    header("HTTP/1.1 200 OK");

    exit();

}



//Actualizar

if ($_SERVER['REQUEST_METHOD'] == 'PUT') {

    $input = $_GET;

    $postId = $input['id'];

    $fields = getParams($input);



    $sql = "

          UPDATE posts

          SET $fields

          WHERE id='$postId'

           ";



    $statement = $dbConn->prepare($sql);

    bindAllValues($statement, $input);



    $statement->execute();

    header("HTTP/1.1 200 OK");

    exit();

}



//En caso de que ninguna de las opciones anteriores se haya ejecutado

header("HTTP/1.1 400 Bad Request");