<?php



include "utils.php";



$dbConn = connect($db);



/*

listar todos los posts o solo uno

 */

if ($_SERVER['REQUEST_METHOD'] == 'GET') {

    if (isset($_GET['id_grupo'])) {

        //Mostrar un post

        $sql = $dbConn->prepare("SELECT * FROM grupos where id_grupo=:id_grupo");

        $sql->bindValue(':id_grupo', $_GET['id_grupo']);

        $sql->execute();

        header("HTTP/1.1 200 OK");

        echo json_encode($sql->fetch(PDO::FETCH_ASSOC));

        exit();

    } else {

        //Mostrar lista de post

        $sql = $dbConn->prepare("SELECT * FROM grupos");

        $sql->execute();

        $sql->setFetchMode(PDO::FETCH_ASSOC);

        header("HTTP/1.1 200 OK");



        echo json_encode($sql->fetchAll());

        exit();

    }

}



// Crear un nuevo post

if ($_SERVER['REQUEST_METHOD'] == 'POST') {

    if (isset($_POST["nombre"])) {

        $nombre = $_POST["nombre"];

        $sqlVerificar = "SELECT COUNT(*) as count FROM grupos WHERE nombre = :nombre";

        $statementVerificar = $dbConn->prepare($sqlVerificar);

        $statementVerificar->bindValue(':nombre', $nombre);

        $statementVerificar->execute();

        $resultadoVerificar = $statementVerificar->fetch(PDO::FETCH_ASSOC);



        if ($resultadoVerificar['count'] > 0) {

            // El nombre ya está en uso, mostrar mensaje de error



            echo 0;

            exit();

        }

        $sql = "INSERT INTO grupos

        (nombre)

        VALUES

        (:nombre)";



        $statement = $dbConn->prepare($sql);



        $statement->bindValue(':nombre', $nombre);



        $statement->execute();



        $postId = $dbConn->lastInsertId();



        $input['id'] = $postId;

        $input['nombre'] = $nombre;



        header("HTTP/1.1 200 OK");

        echo json_encode($input);

        exit();



    }

    if (isset($_POST["id_grupo_agregar"]) && isset($_POST["client_ids_agregar"])) {

        $id_grupo = $_POST["id_grupo_agregar"];

        $client_ids = json_decode($_POST['client_ids_agregar'], true);



        foreach ($client_ids as $client_id) {

            $sql = "INSERT INTO grupo_cliente

        (id_grupo,client_id)

        VALUES

        (:id_grupo,:client_id)";



            $statement = $dbConn->prepare($sql);



            $statement->bindValue(':id_grupo', $id_grupo);

            $statement->bindValue(':client_id', $client_id);

            $statement->execute();



        }







        header("HTTP/1.1 200 OK");

        echo json_encode(1);

        exit();



    }

    if (isset($_POST["id_grupo_remover"]) && isset($_POST["client_ids_remover"])) {

        $id_grupo = $_POST["id_grupo_remover"];

        $client_ids = json_decode($_POST['client_ids_remover'], true);



        foreach ($client_ids as $client_id) {

            $sql = "DELETE FROM grupo_cliente where client_id =:client_id AND id_grupo = :id_grupo";



            $statement = $dbConn->prepare($sql);



            $statement->bindValue(':client_id', $client_id);

            $statement->bindValue(':id_grupo', $id_grupo);

            $statement->execute();



        }







        header("HTTP/1.1 200 OK");

        echo json_encode(1);

        exit();



    }

}



if ($_SERVER['REQUEST_METHOD'] == 'DELETE') {

    if (isset($_GET["id_grupo"])) {

        $id = $_GET['id_grupo'];

        $statement = $dbConn->prepare("DELETE FROM grupo_cliente where id_grupo =:id");

        $statement->bindValue(':id', $id);

        $statement->execute();

        header("HTTP/1.1 200 OK");

        exit();

    }



    if (isset($_GET["id"])) {

        $id = $_GET['id'];

        $statement = $dbConn->prepare("DELETE FROM grupos where id_grupo =:id");

        $statement->bindValue(':id', $id);

        $statement->execute();

        header("HTTP/1.1 200 OK");

        exit();

    }

}



//Actualizar

if ($_SERVER['REQUEST_METHOD'] == 'PUT') {

    $input = $_GET;

    $postId = $input['id'];

    $fields = getParams($input);



    $sql = "

          UPDATE posts

          SET $fields

          WHERE id='$postId'

           ";



    $statement = $dbConn->prepare($sql);

    bindAllValues($statement, $input);



    $statement->execute();

    header("HTTP/1.1 200 OK");

    exit();

}



//En caso de que ninguna de las opciones anteriores se haya ejecutado

header("HTTP/1.1 400 Bad Request");