<?php

include "utils.php";

$dbConn = connect($db);

/*
listar todos los posts o solo uno
*/
if ($_SERVER['REQUEST_METHOD'] == 'GET')
    {

    $sql = $dbConn->prepare("SELECT f.*, 
    (SELECT COUNT(*) 
     FROM alumnos a 
     WHERE a.id_formulario = f.id_formulario 
     AND a.estado = 'Potencial') AS inscripciones
FROM formularios f");
    $sql->execute();
    $sql->setFetchMode(PDO::FETCH_ASSOC);
    $clientes = $sql->fetchAll(PDO::FETCH_OBJ);


    header("HTTP/1.1 200 OK");

    echo json_encode($clientes);
    exit();
    }


// Crear un nuevo post
if ($_SERVER['REQUEST_METHOD'] == 'POST')
    {
    if (
        isset($_POST["info_1"])
        && isset($_POST["nombre_formulario"])
        && isset($_POST["nombre"])
        && isset($_POST["apellidos"])
        && isset($_POST["dni"])
        && isset($_POST["telefono"])
        && isset($_POST["email"])
        && isset($_POST["pais"])
        && isset($_POST["ciudad"])
        && isset($_POST["direccion"])
        && isset($_POST["info_2"])
        && isset($_POST["info_3"])
        && isset($_POST["autorizacion"])
        && isset($_POST["info_4"])
        && isset($_POST["texto_modal"])
        && isset($_POST["lottie_modal"])
    )
        {
        if (isset($_POST["portada"]))
            {
            $imagen = null;
            $portada = null;
            } else
            {
            $imagen = $_FILES['portada'];
            $portada = "1";
            }

        foreach ($_POST as $key => $value)
            {
            $value = ($value == "null") ? null : $value;
            $value = ($value == "Si") ? true : $value;
            $value = ($value == "No") ? false : $value;
            $$key = $value;
            }
        if (isset($_POST["id_formulario"]))
            {
            $id_formulario = $_POST["id_formulario"];
            $sql = "UPDATE formularios SET 
             nombre_formulario = :nombre_formulario,
                    portada = :portada,
                    info_1 = :info_1,
                    nombre = :nombre,
                    apellidos = :apellidos,
                    dni = :dni,
                    telefono = :telefono,
                    email = :email,
                    pais = :pais,
                    ciudad = :ciudad,
                    direccion = :direccion,
                    info_2 = :info_2,
                    info_3 = :info_3,
                    autorizacion = :autorizacion,
                    info_4 = :info_4,
                    texto_modal = :texto_modal,
                    lottie_modal = :lottie_modal
                    WHERE id_formulario = :id_formulario";
            $statement = $dbConn->prepare($sql);
            $statement->bindValue(':id_formulario', $id_formulario);
            } else
            {
            $sql = "INSERT INTO formularios
                    (portada, info_1, nombre, apellidos, dni, telefono, email, pais, ciudad, direccion, info_2, info_3, autorizacion, info_4, texto_modal, lottie_modal, nombre_formulario)
                    VALUES
                    (:portada, :info_1, :nombre, :apellidos, :dni, :telefono, :email, :pais, :ciudad, :direccion, :info_2, :info_3, :autorizacion, :info_4, :texto_modal, :lottie_modal, :nombre_formulario)";

            $statement = $dbConn->prepare($sql);
            }

        $statement->bindValue(':portada', $portada);
        $statement->bindValue(':nombre_formulario', $nombre_formulario);
        $statement->bindValue(':info_1', $info_1);
        $statement->bindValue(':nombre', $nombre);
        $statement->bindValue(':apellidos', $apellidos);
        $statement->bindValue(':dni', $dni);
        $statement->bindValue(':telefono', $telefono);
        $statement->bindValue(':email', $email);
        $statement->bindValue(':pais', $pais);
        $statement->bindValue(':ciudad', $ciudad);
        $statement->bindValue(':direccion', $direccion);
        $statement->bindValue(':info_2', $info_2);
        $statement->bindValue(':info_3', $info_3);
        $statement->bindValue(':autorizacion', $autorizacion);
        $statement->bindValue(':info_4', $info_4);
        $statement->bindValue(':texto_modal', $texto_modal);
        $statement->bindValue(':lottie_modal', $lottie_modal);

        $statement->execute();
        $baseUrl = ($_SERVER['HTTPS'] ? 'https://' : 'http://') . $_SERVER['HTTP_HOST'] . '/';
        $rutaArchivoTemporal = ($imagen != null) ? $imagen['tmp_name'] : null;

        if (isset($_POST["id_formulario"]))
            {
            $id_formulario = $_POST["id_formulario"];
            $Archivo = '../formularios/' . $id_formulario . '.png';

            if ($rutaArchivoTemporal && !empty($rutaArchivoTemporal))
                {
                if (file_exists($Archivo))
                    {
                    unlink($Archivo); // Elimina el archivo existente antes de reemplazarlo
                    }
                move_uploaded_file($rutaArchivoTemporal, $Archivo);
                }



            } else
            {
            $id_formulario = $dbConn->lastInsertId();
            $nombreArchivoUnico = $id_formulario . ".png";


            $rutaArchivoDestino = "../formularios/" . $nombreArchivoUnico;

            if ($rutaArchivoTemporal && !empty($rutaArchivoTemporal))
                {
                // Si se proporcionó un archivo subido, moverlo usando move_uploaded_file
                move_uploaded_file($rutaArchivoTemporal, $rutaArchivoDestino);
                }
            }
        $input["id"] = $id_formulario;
        $input["portada"] = $portada;
        $input["info_1"] = $info_1;
        $input["nombre"] = $nombre;
        $input["apellidos"] = $apellidos;
        $input["dni"] = $dni;
        $input["telefono"] = $telefono;
        $input["email"] = $email;
        $input["pais"] = $pais;
        $input["ciudad"] = $ciudad;
        $input["direccion"] = $direccion;
        $input["info_2"] = $info_2;
        $input["info_3"] = $info_3;
        $input["autorizacion"] = $autorizacion;
        $input["info_4"] = $info_4;
        $input["texto_modal"] = $texto_modal;
        $input["lottie_modal"] = $lottie_modal;

        header("HTTP/1.1 200 OK");
        echo json_encode($input);
        exit();


        }





    if (
        isset($_POST["id_formulario_atributo"])
        && isset($_POST["valor"])
        && isset($_POST["atributo"])
    )
        {
        $id_formulario_atributo = $_POST["id_formulario_atributo"];
        $valor = $_POST["valor"];
        $atributo = $_POST["atributo"];
        if ($valor === '')
            {
            $valor = null;
            }
        $sql = "UPDATE formularios SET $atributo = :valor WHERE id_formulario = :id_formulario_atributo";
        $statement = $dbConn->prepare($sql);
        $statement->bindValue(':id_formulario_atributo', $id_formulario_atributo);
        $statement->bindValue(':valor', $valor);

        $statement->execute();

        $input["id"] = $id_alumno_atributo;
        $input["valor"] = $valor;
        $input["atributo"] = $atributo;

        header("HTTP/1.1 200 OK");
        echo json_encode($input);
        exit();
        }

    }

//Borrar
if ($_SERVER['REQUEST_METHOD'] == 'DELETE')
    {
    $id = $_GET['id'];
    $statement = $dbConn->prepare("DELETE FROM formularios where id_formulario = :id");
    $statement->bindValue(':id', $id);
    $statement->execute();
    header("HTTP/1.1 200 OK");
    $archivoEliminar = '../formularios/' . $id . '.png';
    if (is_file($archivoEliminar))
        {
        unlink($archivoEliminar);
        }
    exit();
    }

function eliminarCarpeta($rutaCarpeta)
    {
    // Obtener una lista de archivos y subcarpetas dentro de la carpeta
    $archivos = glob($rutaCarpeta . '/*');

    // Eliminar cada archivo encontrado
    foreach ($archivos as $archivo)
        {
        if (is_file($archivo))
            {
            unlink($archivo);
            } elseif (is_dir($archivo))
            {
            eliminarCarpeta($archivo);
            }
        }

    // Eliminar la carpeta
    if (is_dir($rutaCarpeta))
        {
        rmdir($rutaCarpeta);

        }
    }

//En caso de que ninguna de las opciones anteriores se haya ejecutado
header("HTTP/1.1 400 Bad Request");