<?php

include "utils.php";

$dbConn = connect($db);

/*
listar todos los posts o solo uno
 */
if ($_SERVER['REQUEST_METHOD'] == 'GET') {

    if (isset($_GET['id_estado_archivo'])) {
        //Mostrar un post
        $sql = $dbConn->prepare("SELECT * FROM estado_archivo where id_estado_archivo=:id_estado_archivo");
        $sql->bindValue(':id_estado_archivo', $_GET['id_estado_archivo']);
        $sql->execute();
        header("HTTP/1.1 200 OK");
        echo json_encode($sql->fetch(PDO::FETCH_ASSOC));
        exit();
    } if (isset($_GET['folder_id'])) {
        //Mostrar un post
        $sql = $dbConn->prepare("SELECT * FROM folders where folder_id=:folder_id");
        $sql->bindValue(':folder_id', $_GET['folder_id']);
        $sql->execute();
        header("HTTP/1.1 200 OK");
        echo json_encode($sql->fetch(PDO::FETCH_ASSOC));
        exit();
    }if (isset($_GET['file_id'])) {
        //Mostrar un post
        $sql = $dbConn->prepare("SELECT * FROM files where file_id=:file_id");
        $sql->bindValue(':file_id', $_GET['file_id']);
        $sql->execute();
        header("HTTP/1.1 200 OK");
        echo json_encode($sql->fetch(PDO::FETCH_ASSOC));
        exit();
    } else {
        //Mostrar lista de post
        $sql = $dbConn->prepare("SELECT * FROM folders");
        $sql->execute();
        $sql->setFetchMode(PDO::FETCH_ASSOC);
        $clientes = $sql->fetchAll(PDO::FETCH_OBJ);

        header("HTTP/1.1 200 OK");
        // echo var_dump($sql->fetchAll());
        echo json_encode($clientes);

        exit();
    }
}


// Crear un nuevo post
if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    if (
        isset($_POST["nombre"])
        && isset($_POST["color"])

    ) {
        $nombre = $_POST["nombre"];
        $color = $_POST["color"];



        $sqlVerificar = "SELECT COUNT(*) as count FROM estado_archivo WHERE nombre = :nombre";
        $statementVerificar = $dbConn->prepare($sqlVerificar);
        $statementVerificar->bindValue(':nombre', $nombre);
        $statementVerificar->execute();
        $resultadoVerificar = $statementVerificar->fetch(PDO::FETCH_ASSOC);

        if ($resultadoVerificar['count'] > 0) {
            // El nombre ya está en uso, mostrar mensaje de error

            echo 0;
            exit();
        }
        $sql = "INSERT INTO estado_archivo
        (color,nombre)
        VALUES
        (:color,:nombre)";

        $statement = $dbConn->prepare($sql);
        $statement->bindValue(':color', $color);
        $statement->bindValue(':nombre', $nombre);

        $statement->execute();

        $postId = $dbConn->lastInsertId();
        // Obtener la información del estado_archivo creado
        $sqlSelect = "SELECT * FROM estado_archivo WHERE id_estado_archivo = :id";
        $statementSelect = $dbConn->prepare($sqlSelect);
        $statementSelect->bindValue(':id', $postId);
        $statementSelect->execute();
        $estado_archivoCreado = $statementSelect->fetch(PDO::FETCH_ASSOC);

        header("HTTP/1.1 200 OK");
        echo json_encode($estado_archivoCreado);
        exit();
    }

    if (isset($_POST["id_estado_archivo"]) && isset($_POST["id"]) && isset($_POST["tipo"])) {

        $id_estado_archivo = ($_POST["id_estado_archivo"] != "No") ? $_POST["id_estado_archivo"] : null;
        $tipo = $_POST["tipo"];

        if ($tipo == "folder") {
            $folder_id = $_POST["id"];
            $sql = "UPDATE folders SET id_estado_archivo = :id_estado_archivo WHERE folder_id = :folder_id";
            $statement = $dbConn->prepare($sql);
            $statement->bindValue(':folder_id', $folder_id);
            $statement->bindValue(':id_estado_archivo', $id_estado_archivo);
        }
        if ($tipo == "file") {
            $file_id = $_POST["id"];
            $sql = "UPDATE files SET id_estado_archivo = :id_estado_archivo WHERE file_id = :file_id";
            $statement = $dbConn->prepare($sql);
            $statement->bindValue(':file_id', $file_id);
            $statement->bindValue(':id_estado_archivo', $id_estado_archivo);
        }
        $statement->execute();


        header("HTTP/1.1 200 OK");
        echo $tipo;
        exit();
    }
    if (isset($_POST["nombre"]) && isset($_POST["id"]) && isset($_POST["tipo"])) {

        $nombre = $_POST["nombre"];
        $tipo = $_POST["tipo"];

        if ($tipo == "folder") {
            $folder_id = $_POST["id"];
            $sql = "UPDATE folders SET folder_name = :nombre WHERE folder_id = :folder_id";
            $statement = $dbConn->prepare($sql);
            $statement->bindValue(':folder_id', $folder_id);
            $statement->bindValue(':nombre', $nombre);
        }
        if ($tipo == "file") {
            $file_id = $_POST["id"];
            $sql = "UPDATE files SET file_name = :nombre WHERE file_id = :file_id";
            $statement = $dbConn->prepare($sql);
            $statement->bindValue(':file_id', $file_id);
            $statement->bindValue(':nombre', $nombre);
        }
        $statement->execute();


        header("HTTP/1.1 200 OK");
        echo $tipo;
        exit();
    }
}

if ($_SERVER['REQUEST_METHOD'] == 'DELETE') {


    if (isset($_GET["id"])) {
        $id = $_GET['id'];
        $statement = $dbConn->prepare("DELETE FROM estado_archivo where id_estado_archivo =:id");
        $statement->bindValue(':id', $id);
        $statement->execute();
        header("HTTP/1.1 200 OK");
        exit();
    }
}



//En caso de que ninguna de las opciones anteriores se haya ejecutado
header("HTTP/1.1 400 Bad Request");