<?php



include "utils.php";



require_once __MODELS__ . 'mailer.model.php';

require_once __MODELS__ . 'users.model.php';

require_once(__LIBRARIES__ . 'anti_csrf.class.php');

$dbConn = connect($db);



$personalizacion = json_decode(file_get_contents('../personalizacion.json'), true);

date_default_timezone_set(htmlentities($personalizacion["zona_horaria"], ENT_QUOTES));



$mailer = new _MailerModel(EMAIL_SERVER, EMAIL_PORT, EMAIL_VALIDATE_USERNAME, EMAIL_VALIDATE_PASSWORD);

$Users = new _UsersModel($DBLink);

/*

listar todos los posts o solo uno

*/

if ($_SERVER['REQUEST_METHOD'] == 'GET') {

    if (isset($_GET["id_miembro2"])) {

        //Mostrar un post

        $s = "SELECT * FROM fichajes where id_miembro=:id_miembro";

        $condiciones = [];
        if (isset($_GET["fecha_i"]) && isset($_GET["fecha_f"])) {

            $condiciones[] = "DATE_FORMAT(fecha, '%Y-%m-%d') BETWEEN :fecha_i AND :fecha_f";
        }
        // Agregar WHERE solo si hay condiciones

        if (!empty($condiciones)) {

            $s .= " AND " . implode(" AND ", $condiciones);
        }
        $s .= ";";


        $sql = $dbConn->prepare($s);

        $sql->bindValue(':id_miembro', $_GET['id_miembro2']);
        if (isset($_GET["fecha_i"]) && isset($_GET["fecha_f"])) {

            $sql->bindValue(':fecha_i', $_GET['fecha_i']);

            $sql->bindValue(':fecha_f', $_GET['fecha_f']);
        }

        $sql->execute();

        $fichajes = $sql->fetchAll(PDO::FETCH_OBJ);



        header("HTTP/1.1 200 OK");

        echo json_encode($fichajes);

        exit();
    }

    if (isset($_GET["id_fichaje"])) {

        //Mostrar un post

        $sql = $dbConn->prepare("SELECT f.*, u.user_full_name AS nombre_miembro

            FROM fichajes f

            JOIN miembro_equipo me ON f.id_miembro = me.id_miembro

            JOIN users u ON me.user_id = u.user_id

            WHERE f.id_fichaje = :id_fichaje

            ");

        $sql->bindValue(':id_fichaje', $_GET['id_fichaje']);

        $sql->execute();

        $fichajes = $sql->fetch(PDO::FETCH_ASSOC);



        header("HTTP/1.1 200 OK");

        echo json_encode($fichajes);

        exit();
    }

    if (isset($_GET["id_miembro"])) {

        //Mostrar un post

        $sql = $dbConn->prepare("SELECT * FROM miembro_equipo where id_miembro=:id_miembro");

        $sql->bindValue(':id_miembro', $_GET['id_miembro']);

        $sql->execute();

        $miembro = $sql->fetch(PDO::FETCH_ASSOC);

        $sql = $dbConn->prepare("SELECT * FROM fichajes where id_miembro=:id_miembro 

        AND fecha_salida IS NULL LIMIT 1");

        $sql->bindValue(':id_miembro', $_GET['id_miembro']);

        $sql->execute();

        $miembro["fichaje"] = $sql->fetch(PDO::FETCH_ASSOC);

        $sql = $dbConn->prepare("SELECT * FROM jornada_laboral where id_miembro=:id_miembro LIMIT 1");

        $sql->bindValue(':id_miembro', $_GET['id_miembro']);

        $sql->execute();

        $miembro["jornada"] = $sql->fetch(PDO::FETCH_ASSOC);

        header("HTTP/1.1 200 OK");

        echo json_encode($miembro);

        exit();
    } else {

        //Mostrar lista de post



        $sql = $dbConn->prepare("SELECT a.*,

        COALESCE(n.user_full_name, 'Ninguno') AS nombre , n.user_email AS email_u

        FROM miembro_equipo a

        LEFT JOIN users n ON n.user_id = a.user_id");





        $sql->execute();

        $sql->setFetchMode(PDO::FETCH_ASSOC);

        $miembros = $sql->fetchAll(PDO::FETCH_OBJ);

        foreach ($miembros as $miembro) {

            $clientID = $miembro->id_miembro;

            $sql = "SELECT * FROM fichajes WHERE id_miembro = :clientID";

            $stmt = $dbConn->prepare($sql);

            $stmt->bindParam(':clientID', $clientID, PDO::PARAM_INT);

            $stmt->execute();

            // Obtener el resultado como un objeto

            $fichajes_miembro = $stmt->fetchAll(PDO::FETCH_OBJ);

            $miembro->fichajes = $fichajes_miembro;
        }

        $input["miembros"] = $miembros;

        if (isset($_GET['fecha_i']) && isset($_GET['fecha_f'])) {

            $fecha_i = $_GET['fecha_i'];

            $fecha_f = $_GET['fecha_f'];

            $sql = $dbConn->prepare("SELECT

            fichajes.*,

            users.user_full_name AS nombre

        FROM

            fichajes

        JOIN

            miembro_equipo ON fichajes.id_miembro = miembro_equipo.id_miembro

        JOIN

            users ON miembro_equipo.user_id = users.user_id

            WHERE DATE_FORMAT(fecha, '%Y-%m-%d') BETWEEN :fecha_i AND :fecha_f;");

            $sql->bindValue(':fecha_i', $fecha_i);

            $sql->bindValue(':fecha_f', $fecha_f);
        } else {

            $sql = $dbConn->prepare("SELECT

            fichajes.*,

            users.user_full_name AS nombre

        FROM

            fichajes

        JOIN

            miembro_equipo ON fichajes.id_miembro = miembro_equipo.id_miembro

        JOIN

            users ON miembro_equipo.user_id = users.user_id;");
        }

        $sql->execute();

        $sql->setFetchMode(PDO::FETCH_ASSOC);

        $fichajes = $sql->fetchAll(PDO::FETCH_OBJ);



        $input["miembros"] = $miembros;

        $input["fichajes"] = $fichajes;

        header("HTTP/1.1 200 OK");

        // echo var_dump($sql->fetchAll());

        echo json_encode($input);



        exit();
    }
}





// Crear un nuevo post

if ($_SERVER['REQUEST_METHOD'] == 'POST') {

    if (isset($_POST["id_fichaje"])) {

        $id_fichaje = $_POST["id_fichaje"];



        if (isset($_POST["ultima_salida"])) {

            $ultima_salida = $_POST["ultima_salida"];

            $sql = "UPDATE `fichajes` SET ultima_salida = :ultima_salida WHERE (id_fichaje = :id_fichaje);";

            $statement = $dbConn->prepare($sql);

            $statement->bindValue(':id_fichaje', $id_fichaje);

            $statement->bindValue(':ultima_salida', $ultima_salida);

            $statement->execute();



            $input["id"] = $id_fichaje;

            header("HTTP/1.1 200 OK");

            echo json_encode(getFichajeCompleto($dbConn, $id_fichaje)); // Obtener el fichaje completo

            exit();
        }



        if (isset($_POST["ultima_entrada"])) {

            $sql = $dbConn->prepare("SELECT * FROM fichajes where id_fichaje=:id_fichaje LIMIT 1");

            $sql->bindValue(':id_fichaje', $id_fichaje);

            $sql->execute();

            $fichaje = $sql->fetch(PDO::FETCH_ASSOC);



            $horas_descanso = $fichaje["horas_descanso"];

            $ultima_salida = $fichaje["ultima_salida"];

            $ultima_entrada = $_POST["ultima_entrada"];

            $fecha = date($ultima_entrada);

            $dateTime1 = new DateTime($ultima_salida);

            $dateTime2 = new DateTime($ultima_entrada);



            // Calcula la diferencia en segundos

            $interval = $dateTime1->diff($dateTime2);

            $horas_descanso += $interval->s + $interval->i * 60 + $interval->h * 3600 + $interval->d * 86400;



            $ultima_salida = null;

            $ultima_entrada = null;



            $sql = "UPDATE `fichajes` SET ultima_salida = :ultima_salida, ultima_entrada = :ultima_entrada, horas_descanso = :horas_descanso WHERE (id_fichaje = :id_fichaje);";

            $statement = $dbConn->prepare($sql);

            $statement->bindValue(':id_fichaje', $id_fichaje);

            $statement->bindValue(':ultima_salida', $ultima_salida);

            $statement->bindValue(':ultima_entrada', $ultima_entrada);

            $statement->bindValue(':horas_descanso', $horas_descanso);

            $statement->execute();



            if (isset($_POST["distancia_casa"]) && isset($_POST["distancia_calle"]) && isset($_POST["localizacion"])) {
                $localizacion = $_POST["localizacion"];
                checkAnomalias($dbConn, $fichaje, $_POST["distancia_casa"], $_POST["distancia_calle"], $id_fichaje, $localizacion, "Reanudar");
            }




            $input["id"] = $id_fichaje;

            $input["horas_descanso"] = $horas_descanso;

            header("HTTP/1.1 200 OK");

            echo json_encode(getFichajeCompleto($dbConn, $id_fichaje)); // Obtener el fichaje completo

            exit();
        }



        if (isset($_POST["fecha_salida"])) {

            $sql = $dbConn->prepare("SELECT * FROM fichajes where id_fichaje=:id_fichaje LIMIT 1");

            $sql->bindValue(':id_fichaje', $id_fichaje);

            $sql->execute();

            $fichaje = $sql->fetch(PDO::FETCH_ASSOC);



            $horas_descanso = $fichaje["horas_descanso"];

            $fecha_salida = $_POST["fecha_salida"];
$ip_salida = $_POST["ip_salida"];
$dispositivo_salida = $_POST["dispositivo_salida"];


            if ($fichaje["ultima_entrada"] == null && $fichaje["ultima_salida"] != null) {

                $dateTime2 = new DateTime($fichaje["ultima_salida"]);

                $dateTime1 = new DateTime($fecha_salida);



                // Calcula la diferencia en segundos

                $interval = $dateTime1->diff($dateTime2);

                $horas_descanso += $interval->s + $interval->i * 60 + $interval->h * 3600 + $interval->d * 86400;
            }



            $sql = "UPDATE `fichajes` SET ultima_salida = :ultima_salida, ultima_entrada = :ultima_entrada, fecha_salida = :fecha_salida, horas_descanso = :horas_descanso, ip_salida = :ip_salida, dispositivo_salida = :dispositivo_salida WHERE (id_fichaje = :id_fichaje);";

            $ultima_salida = null;

            $ultima_entrada = null;

            $statement = $dbConn->prepare($sql);

            $statement->bindValue(':fecha_salida', $fecha_salida);

            $statement->bindValue(':id_fichaje', $id_fichaje);

            $statement->bindValue(':ultima_salida', $ultima_salida);

            $statement->bindValue(':ultima_entrada', $ultima_entrada);

            $statement->bindValue(':horas_descanso', $horas_descanso);
  $statement->bindValue(':ip_salida', $ip_salida);
                    $statement->bindValue(':dispositivo_salida', $dispositivo_salida);

            $statement->execute();

            verificarAnomaliaSalida($dbConn, $fecha_salida, $id_fichaje);

            if (isset($_POST["distancia_casa"]) && isset($_POST["distancia_calle"]) && isset($_POST["localizacion"])) {
                $localizacion = $_POST["localizacion"];
                checkAnomalias($dbConn, $fichaje, $_POST["distancia_casa"], $_POST["distancia_calle"], $id_fichaje, $localizacion, "Salida");
            }



            header("HTTP/1.1 200 OK");

            echo json_encode(getFichajeCompleto($dbConn, $id_fichaje)); // Obtener el fichaje completo

            exit();
        }
    } elseif (

        isset($_POST["id_miembro"])

        && isset($_POST["fecha_entrada"])

        && isset($_POST["observaciones"])

        && isset($_POST["fecha_salida"])

        && isset($_POST["horas_descanso"])
        && isset($_POST["ip_entrada"])

        && isset($_POST["dispositivo_entrada"])
        && isset($_POST["ip_salida"])

        && isset($_POST["dispositivo_salida"])

    ) {



        foreach ($_POST as $key => $value) {

            $value = ($value == "") ? null : $value;

            $value = ($value == "null") ? null : $value;

            $$key = $value;
        }

        // Convertir las fechas

        $fecha_entrada = (empty($_POST["fecha_entrada"])) ? null : date("Y-m-d H:i:s", strtotime($_POST["fecha_entrada"]));

        $fecha_salida = (empty($_POST["fecha_salida"])) ? null : date("Y-m-d H:i:s", strtotime($_POST["fecha_salida"]));



        $fecha = date($fecha_entrada);



        $csrf_token = NoCSRF::generate('csrf_token');



        if (isset($_POST["fichaje_id"]) && !empty($_POST["fichaje_id"])) {

            // Obtener el ID del fichaje a actualizar

            $id_fichaje = $_POST["fichaje_id"];



            // Actualizar el fichaje

            $sql = "UPDATE fichajes SET 

                        id_miembro = :id_miembro,

                        observaciones = :observaciones,

                        fecha_entrada = :fecha_entrada,

                        fecha_salida = :fecha_salida,

                        horas_descanso = :horas_descanso,

                        fecha = :fecha,

                           estado = :estado,

                        csrf_token = :csrf_token,

                        ip_entrada=:ip_entrada,
dispositivo_entrada=:dispositivo_entrada,
ip_salida=:ip_salida,
dispositivo_salida=:dispositivo_salida

                    WHERE id_fichaje = :fichaje_id";



            $statement = $dbConn->prepare($sql);

            $statement->bindValue(':id_miembro', $_POST["id_miembro"]);

            $statement->bindValue(':observaciones', $observaciones);

            $statement->bindValue(':fecha_entrada', $fecha_entrada);

            $statement->bindValue(':fecha_salida', $fecha_salida);

            $statement->bindValue(':horas_descanso', $horas_descanso);

            $statement->bindValue(':fecha', $fecha_entrada); // Fecha de la entrada

            $statement->bindValue(':estado', "Pendiente");

            $statement->bindValue(':fichaje_id', $id_fichaje);

            $statement->bindValue(':csrf_token', $csrf_token);
              $statement->bindValue(':ip_entrada', $ip_entrada);
                $statement->bindValue(':dispositivo_entrada', $dispositivo_entrada);
                  $statement->bindValue(':ip_salida', $ip_salida);
                    $statement->bindValue(':dispositivo_salida', $dispositivo_salida);

            $statement->execute();

$accion = 'editado';

            $input["id"] = $id_fichaje;
        } else {





            if ($fecha_entrada != null && $fecha_salida == null) {

                // Obtener el ID del miembro

                $id_miembro = $_POST["id_miembro"];



                // Eliminar los fichajes anteriores con fecha_salida null para el mismo id_miembro

                $deleteSql = "DELETE FROM fichajes WHERE id_miembro = :id_miembro AND fecha_salida IS NULL";

                $deleteStmt = $dbConn->prepare($deleteSql);

                $deleteStmt->bindValue(':id_miembro', $id_miembro);

                $deleteStmt->execute();
            }

            // Si no existe fichaje_id, se crea un nuevo fichaje

            $estado  = ($fecha_salida == null) ? "Aceptado" : "Pendiente";

            // Crear el SQL de inserción para un nuevo fichaje

            $sql = "INSERT INTO fichajes (id_miembro, observaciones, fecha_entrada, fecha_salida, horas_descanso, fecha, csrf_token,estado, ip_entrada, dispositivo_entrada, ip_salida,dispositivo_salida)

        VALUES (:id_miembro, :observaciones, :fecha_entrada, :fecha_salida, :horas_descanso, :fecha, :csrf_token,:estado, :ip_entrada, :dispositivo_entrada, :ip_salida,:dispositivo_salida)";



            $statement = $dbConn->prepare($sql);

            $statement->bindValue(':id_miembro', $_POST["id_miembro"]);

            $statement->bindValue(':observaciones', $observaciones);

            $statement->bindValue(':fecha_entrada', $fecha_entrada);

            $statement->bindValue(':fecha_salida', $fecha_salida);

            $statement->bindValue(':horas_descanso', $horas_descanso);

            $statement->bindValue(':fecha', $fecha_entrada); // Fecha de la entrada

            $statement->bindValue(':estado', $estado);

            $statement->bindValue(':csrf_token', $csrf_token);
              $statement->bindValue(':ip_entrada', $ip_entrada);
                $statement->bindValue(':dispositivo_entrada', $dispositivo_entrada);
                  $statement->bindValue(':ip_salida', $ip_salida);
                    $statement->bindValue(':dispositivo_salida', $dispositivo_salida);

            $statement->execute();



            // Obtener el ID del fichaje insertado

            $id_fichaje = $dbConn->lastInsertId();

            $input["id"] = $id_fichaje;
            $accion = 'creado';
        }

        verificarAnomaliaHorario($dbConn, $id_miembro, $fecha_entrada, $id_fichaje);
        if ($fecha_salida != null) {
            verificarAnomaliaSalida($dbConn, $fecha_salida, $id_fichaje);
        }
        if (isset($_POST["distancia_casa"]) && isset($_POST["distancia_calle"]) && isset($_POST["localizacion"])) {


            $localizacion = $_POST["localizacion"];
            $distancia_casa = intval($_POST["distancia_casa"]);

            $distancia_calle = intval($_POST["distancia_calle"]);

            $fecha = date("Y-m-d H:i:s");

            $sql = $dbConn->prepare("SELECT * FROM miembro_equipo where id_miembro=:id_miembro LIMIT 1");

            $sql->bindValue(':id_miembro', $id_miembro);

            $sql->execute();

            $miembro = $sql->fetch(PDO::FETCH_ASSOC);

            if ($miembro["kilometros_casa"] != null) {

                $kilometros_casa = $miembro["kilometros_casa"] * 1000;

                $input["kilometros_casa"] = $kilometros_casa;

                $input["distancia_casa"] = $distancia_casa;

                if ($kilometros_casa > $distancia_casa) {

                    $input["anomalia1"] = true;

                    $anomalia = "Entrada marcada demasiado cerca de tu casa";

                    $sql = "INSERT INTO anomalia (id_fichaje, anomalia, id_miembro, fecha, localizacion)

                    VALUES (:id_fichaje, :anomalia, :id_miembro,:fecha,:localizacion);";

                    $statement = $dbConn->prepare($sql);

                    $statement->bindValue(':id_fichaje', $id_fichaje);

                    $statement->bindValue(':anomalia', $anomalia);
                    $statement->bindValue(':localizacion', $localizacion);
                    $statement->bindValue(':id_miembro', $id_miembro);

                    $statement->bindValue(':fecha', $fecha);

                    $statement->execute();
                }
            }

            if ($miembro["kilometros_calle"] != null) {

                $kilometros_calle = $miembro["kilometros_calle"] * 1000;

                $input["kilometros_calle"] = $kilometros_calle;

                $input["distancia_calle"] = $distancia_calle;

                if ($kilometros_calle < $distancia_calle) {

                    $input["anomalia2"] = true;

                    $anomalia = "Entrada marcada demasiado lejos de la dirección de trabajo";

                    $sql = "INSERT INTO anomalia (id_fichaje, anomalia, id_miembro, fecha, localizacion)

                    VALUES (:id_fichaje, :anomalia, :id_miembro,:fecha,:localizacion);";

                    $statement = $dbConn->prepare($sql);

                    $statement->bindValue(':id_fichaje', $id_fichaje);
                    $statement->bindValue(':localizacion', $localizacion);
                    $statement->bindValue(':anomalia', $anomalia);

                    $statement->bindValue(':id_miembro', $id_miembro);

                    $statement->bindValue(':fecha', $fecha);

                    $statement->execute();
                }
            }
        }







        $U = $Users->GetUserByMiembro($id_miembro);

       

    

        if ($fecha_salida != null) {

           enviarEmailFichaje($mailer, $U, $id_fichaje, $csrf_token, $personalizacion, $accion);
        }

        header("HTTP/1.1 200 OK");

        echo json_encode(getFichajeCompleto($dbConn, $id_fichaje));

        exit();
    } elseif (

        isset($_POST["id_miembro"])

        && isset($_POST["edit_jornada"])

        && isset($_POST["jornada"])

    ) {

        $jornada = json_decode($_POST["jornada"], true);

        foreach ($jornada as $atributo => $valor) {

            ${$atributo} = ($valor != "") ? $valor : null; // Crea una variable con el nombre del atributo

        }

        $id_miembro = $_POST["id_miembro"];

        $sql = "UPDATE jornada_laboral SET 

                domingo2_e = :domingo2_e,

                domingo2_s = :domingo2_s,

                domingo_e = :domingo_e,

                domingo_s = :domingo_s,

                jueves2_e = :jueves2_e,

                jueves2_s = :jueves2_s,

                jueves_e = :jueves_e,

                jueves_s = :jueves_s,

                lunes2_e = :lunes2_e,

                lunes2_s = :lunes2_s,

                lunes_e = :lunes_e,

                lunes_s = :lunes_s,

                martes2_e = :martes2_e,

                martes2_s = :martes2_s,

                martes_e = :martes_e,

                martes_s = :martes_s,

                miercoles2_e = :miercoles2_e,

                miercoles2_s = :miercoles2_s,

                miercoles_e = :miercoles_e,

                miercoles_s = :miercoles_s,

                sabado2_e = :sabado2_e,

                sabado2_s = :sabado2_s,

                sabado_e = :sabado_e,

                sabado_s = :sabado_s,

                viernes2_e = :viernes2_e,

                viernes2_s = :viernes2_s,

                viernes_e = :viernes_e,

                viernes_s = :viernes_s     

                WHERE id_miembro = :id_miembro";

        $statement = $dbConn->prepare($sql);

        $statement->bindValue(':id_miembro', $id_miembro);

        $statement->bindValue(':domingo2_e', $domingo2_e);

        $statement->bindValue(':domingo2_s', $domingo2_s);

        $statement->bindValue(':domingo_e', $domingo_e);

        $statement->bindValue(':domingo_s', $domingo_s);

        $statement->bindValue(':jueves2_e', $jueves2_e);

        $statement->bindValue(':jueves2_s', $jueves2_s);

        $statement->bindValue(':jueves_e', $jueves_e);

        $statement->bindValue(':jueves_s', $jueves_s);

        $statement->bindValue(':lunes2_e', $lunes2_e);

        $statement->bindValue(':lunes2_s', $lunes2_s);

        $statement->bindValue(':lunes_e', $lunes_e);

        $statement->bindValue(':lunes_s', $lunes_s);

        $statement->bindValue(':martes2_e', $martes2_e);

        $statement->bindValue(':martes2_s', $martes2_s);

        $statement->bindValue(':martes_e', $martes_e);

        $statement->bindValue(':martes_s', $martes_s);

        $statement->bindValue(':miercoles2_e', $miercoles2_e);

        $statement->bindValue(':miercoles2_s', $miercoles2_s);

        $statement->bindValue(':miercoles_e', $miercoles_e);

        $statement->bindValue(':miercoles_s', $miercoles_s);

        $statement->bindValue(':sabado2_e', $sabado2_e);

        $statement->bindValue(':sabado2_s', $sabado2_s);

        $statement->bindValue(':sabado_e', $sabado_e);

        $statement->bindValue(':sabado_s', $sabado_s);

        $statement->bindValue(':viernes2_e', $viernes2_e);

        $statement->bindValue(':viernes2_s', $viernes2_s);

        $statement->bindValue(':viernes_e', $viernes_e);

        $statement->bindValue(':viernes_s', $viernes_s);



        $statement->execute();

        $input["id"] = $id_miembro;

        $input["jornada"] = $jornada;



        header("HTTP/1.1 200 OK");

        echo json_encode($input);

        exit();
    } elseif (

        isset($_POST["user_id"])

        && isset($_POST["dni"])

        && isset($_POST["precio_hora"])

        && isset($_POST["precio_horas_extra"])

        && isset($_POST["direccion"])

        && isset($_POST["kilometros_casa"])

        && isset($_POST["kilometros_calle"])

        && isset($_POST["calle"])

        && isset($_POST["jornada"])

    ) {



        $jornada = json_decode($_POST["jornada"], true);



        foreach ($jornada as $atributo => $valor) {

            ${$atributo} = ($valor != "") ? $valor : null; // Crea una variable con el nombre del atributo

        }



        foreach ($_POST as $key => $value) {

            $value = ($value == "") ? null : $value;

            $value = ($value == "No") ? null : $value;

            $$key = $value;
        }

        if ($user_email != null) {
            $csrf_token = NoCSRF::generate('csrf_token');
            $estado = "Pendiente";
            $sql = $dbConn->prepare("SELECT * FROM users where user_email=:email");

            $sql->bindValue(':email', $user_email);

            $sql->execute();

            $check_email_result = $sql->fetch(PDO::FETCH_ASSOC);

            if ($check_email_result != false) {

                $output['msg'] = 'Email ya en uso';
                header("HTTP/1.1 200 OK");

                echo json_encode(0);

                exit();
            }
        } else {
            $csrf_token = NULL;
            $estado = "Aceptado";
        }

        if (isset($_POST["id_miembro"])) {

            $id_miembro = $_POST["id_miembro"];

            $sql = "UPDATE miembro_equipo SET 

             user_id = :user_id,

                    dni = :dni,
email = :email,
                    precio_hora = :precio_hora,

                    precio_horas_extra = :precio_horas_extra,

                    direccion = :direccion,
 estado = :estado,
                    kilometros_casa = :kilometros_casa,

                    kilometros_calle = :kilometros_calle,

                    calle = :calle,
                    csrf_token = :csrf_token

                    WHERE id_miembro = :id_miembro";

            $statement = $dbConn->prepare($sql);

            $statement->bindValue(':id_miembro', $id_miembro);
        } else {

            $sql = "INSERT INTO miembro_equipo

                    (user_id, dni, precio_hora, precio_horas_extra, direccion, kilometros_casa, kilometros_calle, calle, csrf_token,email,estado)

                    VALUES

                    (:user_id, :dni, :precio_hora, :precio_horas_extra, :direccion, :kilometros_casa, :kilometros_calle,:calle,:csrf_token,:email,:estado)";



            $statement = $dbConn->prepare($sql);
        }



        $statement->bindValue(':csrf_token', $csrf_token);

        $statement->bindValue(':user_id', $user_id);
        $statement->bindValue(':estado', $estado);
        $statement->bindValue(':dni', $dni);
        $statement->bindValue(':email', $user_email);
        $statement->bindValue(':precio_hora', $precio_hora);

        $statement->bindValue(':precio_horas_extra', $precio_horas_extra);

        $statement->bindValue(':direccion', $direccion);

        $statement->bindValue(':kilometros_casa', $kilometros_casa);

        $statement->bindValue(':kilometros_calle', $kilometros_calle);

        $statement->bindValue(':calle', $calle);

        $statement->execute();



        if (isset($_POST["id_miembro"])) {

            $id_miembro = $_POST["id_miembro"];

            $sql = "UPDATE jornada_laboral SET 

                    domingo2_e = :domingo2_e,

                    domingo2_s = :domingo2_s,

                    domingo_e = :domingo_e,

                    domingo_s = :domingo_s,

                    jueves2_e = :jueves2_e,

                    jueves2_s = :jueves2_s,

                    jueves_e = :jueves_e,

                    jueves_s = :jueves_s,

                    lunes2_e = :lunes2_e,

                    lunes2_s = :lunes2_s,

                    lunes_e = :lunes_e,

                    lunes_s = :lunes_s,

                    martes2_e = :martes2_e,

                    martes2_s = :martes2_s,

                    martes_e = :martes_e,

                    martes_s = :martes_s,

                    miercoles2_e = :miercoles2_e,

                    miercoles2_s = :miercoles2_s,

                    miercoles_e = :miercoles_e,

                    miercoles_s = :miercoles_s,

                    sabado2_e = :sabado2_e,

                    sabado2_s = :sabado2_s,

                    sabado_e = :sabado_e,

                    sabado_s = :sabado_s,

                    viernes2_e = :viernes2_e,

                    viernes2_s = :viernes2_s,

                    viernes_e = :viernes_e,

                    viernes_s = :viernes_s     

                    WHERE id_miembro = :id_miembro";
        } else {

            $id_miembro = $dbConn->lastInsertId();

            $sql = "INSERT INTO jornada_laboral

                    (domingo2_e, domingo2_s, domingo_e, domingo_s, jueves2_e, jueves2_s, jueves_e, jueves_s,

                    lunes2_e, lunes2_s, lunes_e, lunes_s, martes2_e, martes2_s, martes_e, martes_s,

                    miercoles2_e, miercoles2_s, miercoles_e, miercoles_s, sabado2_e, sabado2_s, sabado_e, sabado_s,

                    viernes2_e, viernes2_s, viernes_e, viernes_s, id_miembro)

                    VALUES

                    (:domingo2_e, :domingo2_s, :domingo_e, :domingo_s, :jueves2_e, :jueves2_s, :jueves_e,:jueves_s,

                    :lunes2_e, :lunes2_s, :lunes_e, :lunes_s, :martes2_e, :martes2_s, :martes_e,:martes_s,

                    :miercoles2_e, :miercoles2_s, :miercoles_e, :miercoles_s, :sabado2_e, :sabado2_s, :sabado_e,:sabado_s, 

                    :viernes2_e, :viernes2_s, :viernes_e, :viernes_s, :id_miembro)";
        }

        $statement = $dbConn->prepare($sql);

        $statement->bindValue(':id_miembro', $id_miembro);

        $statement->bindValue(':domingo2_e', $domingo2_e);

        $statement->bindValue(':domingo2_s', $domingo2_s);

        $statement->bindValue(':domingo_e', $domingo_e);

        $statement->bindValue(':domingo_s', $domingo_s);

        $statement->bindValue(':jueves2_e', $jueves2_e);

        $statement->bindValue(':jueves2_s', $jueves2_s);

        $statement->bindValue(':jueves_e', $jueves_e);

        $statement->bindValue(':jueves_s', $jueves_s);

        $statement->bindValue(':lunes2_e', $lunes2_e);

        $statement->bindValue(':lunes2_s', $lunes2_s);

        $statement->bindValue(':lunes_e', $lunes_e);

        $statement->bindValue(':lunes_s', $lunes_s);

        $statement->bindValue(':martes2_e', $martes2_e);

        $statement->bindValue(':martes2_s', $martes2_s);

        $statement->bindValue(':martes_e', $martes_e);

        $statement->bindValue(':martes_s', $martes_s);

        $statement->bindValue(':miercoles2_e', $miercoles2_e);

        $statement->bindValue(':miercoles2_s', $miercoles2_s);

        $statement->bindValue(':miercoles_e', $miercoles_e);

        $statement->bindValue(':miercoles_s', $miercoles_s);

        $statement->bindValue(':sabado2_e', $sabado2_e);

        $statement->bindValue(':sabado2_s', $sabado2_s);

        $statement->bindValue(':sabado_e', $sabado_e);

        $statement->bindValue(':sabado_s', $sabado_s);

        $statement->bindValue(':viernes2_e', $viernes2_e);

        $statement->bindValue(':viernes2_s', $viernes2_s);

        $statement->bindValue(':viernes_e', $viernes_e);

        $statement->bindValue(':viernes_s', $viernes_s);







        $statement->execute();

        if ($user_email != null) {
            $confirmarUrl = WEBSITE_URL . "aceptar_miembro?id={$id_miembro}&token={$csrf_token}&email={$user_email}";

            $htmlBody = " <html>

                                <head>

                                    <style>

                                        .button {

                                        background-color: #0cca8e;

                                border-color: #0cca8e;

                                        display: inline-block;

                                font-weight: 400;

                                text-align: center;

                                white-space: nowrap;

                                vertical-align: middle;

                                user-select: none;

                                border: 1px solid rgba(0, 0, 0, 0);

                                padding: .56rem 1.375rem;

                                font-size: 1rem;

                                line-height: 1;

                                border-radius: .1875rem;

                                transition: color .15s ease-in-out, background-color .15s ease-in-out, border-color .15s ease-in-out, box-shadow .15s ease-in-out;

                                outline: 0;

                                outline-offset: 0;

                                color: #fff!important;

                            }

                            .button:hover {

                                color: #fff;

                                background-color: #0aa675;

                                border-color: #099a6c;

                                text-decoration: none;

                            }

                                        .email-container {

                                            font-family: Arial, sans-serif;

                                            line-height: 1.5;

                                            margin: 20px;

                                                max-width: 370px;

                                                margin: 0 auto;

                                                text-align:center;

                                        }

                                        .email-title {

                                            color: #333;

                                            font-size: 20px;

                                            font-weight: bold;

                                            width: 100%;

                                            margin-bottom:.5rem;

                                        }

                                        .email-text {

                                            color: #555;

                                            font-size: 16px;

                                            width: 100%;

                                            margin-bottom:.5rem;

                                        }

                                        .email-b{

                                        width: 100%;

                                        }

                                        .email-image {

                                            width: 100%;

                                            max-width: 300px;

                                            height: auto;

                                            display: block;

                                            margin: 0 auto;

                                            margin-bottom:.5rem;

                                        }

                                    </style>

                                </head>

                                <body>

                                    <div class='email-container'>

                                    

                                        <img src='" . htmlentities($personalizacion["imagen_email"], ENT_QUOTES) . "' alt='Imagen de fichaje' class='email-image' />

                            <div class='email-title'>

                                            Se ha añadido tu email a nuestro sistema de fichajes

                                        </div>

                                    

                                        <div class='email-text'>
                                        Para proceder a la creación de tu cuenta haz click en el siguiente enlace: <br>

                                           
                                        

                                        </div>

                            <div class='email-b'>

                                        <a href='{$confirmarUrl}' class='button'>Crear usuario</a> 

                                        </div>

                                    </div>

                                </body>

                                </html>

                            ";



            // Enviar el correo con el cuerpo HTML y el enlace de confirmación



            $mailer->_Mail(

                EMAIL_VALIDATE_USERNAME,

                $user_email,

                "Se ha solicitado la creación de un usuario con tu cuenta de correo electrónico",

                $htmlBody

            );
        }


        $input["id"] = $id_miembro;

        $input["jornada"] = $jornada;



        header("HTTP/1.1 200 OK");

        echo json_encode($input);

        exit();
    } elseif (

        isset($_POST["id_miembro_atributo"])

        && isset($_POST["valor"])

        && isset($_POST["atributo"])

    ) {

        $id_miembro_atributo = $_POST["id_miembro_atributo"];

        $valor = $_POST["valor"];

        $atributo = $_POST["atributo"];

        if ($valor == '') {

            $valor = null;
        }



        if ($valor == 'false') {

            $valor = null;
        }

        if ($valor == 'null') {

            $valor = null;
        }

        $sql = "UPDATE miembro_equipo SET $atributo = :valor WHERE id_miembro = :id_miembro_atributo";

        $statement = $dbConn->prepare($sql);

        $statement->bindValue(':id_miembro_atributo', $id_miembro_atributo);

        $statement->bindValue(':valor', $valor);



        $statement->execute();



        $input["id"] = $id_miembro_atributo;

        $input["valor"] = $valor;

        $input["atributo"] = $atributo;



        header("HTTP/1.1 200 OK");

        echo json_encode($input);

        exit();
    } elseif (

        isset($_POST["id_fichaje_atributo"])

        && isset($_POST["valor"])

        && isset($_POST["atributo"])

    ) {

        $id_fichaje_atributo = $_POST["id_fichaje_atributo"];

        $valor = $_POST["valor"];

        $atributo = $_POST["atributo"];

        if ($valor == '') {

            $valor = null;
        }



        if ($valor == 'false') {

            $valor = null;
        }

        if ($valor == 'null') {

            $valor = null;
        }

        $sql = "UPDATE fichajes SET $atributo = :valor WHERE id_fichaje = :id_fichaje_atributo";

        $statement = $dbConn->prepare($sql);

        $statement->bindValue(':id_fichaje_atributo', $id_fichaje_atributo);

        $statement->bindValue(':valor', $valor);



        $statement->execute();



        $input["id"] = $id_fichaje_atributo;

        $input["valor"] = $valor;

        $input["atributo"] = $atributo;



        header("HTTP/1.1 200 OK");

        echo json_encode($input);

        exit();
    } elseif (

        isset($_POST["id_formulario_atributo"])

        && isset($_POST["valor"])

        && isset($_POST["atributo"])

    ) {

        $id_formulario_atributo = $_POST["id_formulario_atributo"];

        $valor = $_POST["valor"];

        $atributo = $_POST["atributo"];

        if ($valor === '') {

            $valor = null;
        }

        $sql = "UPDATE formularios SET $atributo = :valor WHERE id_formulario = :id_formulario_atributo";

        $statement = $dbConn->prepare($sql);

        $statement->bindValue(':id_formulario_atributo', $id_formulario_atributo);

        $statement->bindValue(':valor', $valor);



        $statement->execute();



        $input["id"] = $id_alumno_atributo;

        $input["valor"] = $valor;

        $input["atributo"] = $atributo;



        header("HTTP/1.1 200 OK");

        echo json_encode($input);

        exit();
    } elseif (

        isset($_POST["fichaje_id"]) &&

        isset($_POST["estado"]) && (

            $_POST["estado"] == "Aceptado" ||

            $_POST["estado"] == "Cancelado")

    ) {

        // Asignar los valores de los parámetros POST a variables

        $fichaje_id = $_POST["fichaje_id"];

        $estado = $_POST["estado"];



        // Validar si el estado es 'Aceptado', ya que es la única opción permitida para este caso





        // SQL para actualizar el estado del fichaje

        $sql = "UPDATE fichajes SET estado = :estado,csrf_token  = NULL WHERE id_fichaje = :fichaje_id";



        // Preparar la consulta

        $statement = $dbConn->prepare($sql);



        // Vincular los valores a la consulta preparada

        $statement->bindValue(':estado', $estado);

        $statement->bindValue(':fichaje_id', $fichaje_id);



        // Ejecutar la consulta

        if ($statement->execute()) {

            // Si la ejecución es exitosa, devolver una respuesta JSON

            $response = [

                "status" => "success",

                "message" => "Fichaje aceptado correctamente",

                "fichaje_id" => $fichaje_id,

                "estado" => $estado

            ];



            $Users->_Logout();

            // Enviar respuesta exitosa

            header("HTTP/1.1 200 OK");

            echo json_encode($response);

            exit();
        } else {

            // Si ocurre un error en la ejecución de la consulta

            $response = [

                "status" => "error",

                "message" => "No se pudo actualizar el estado del fichaje"

            ];



            // Enviar respuesta de error

            header("HTTP/1.1 500 Internal Server Error");

            echo json_encode($response);

            exit();
        }
    } elseif (isset($_POST["business_name"]) && isset($_POST["id_miembro_aceptar"]) && isset($_POST["email_miembro_aceptar"]) && isset($_POST["password"]) && isset($_POST["confirm_pwd"])) {

        $fields = ['business_name', 'id_miembro_aceptar', 'email_miembro_aceptar', 'password', 'confirm_pwd'];

        foreach ($fields as $key => $value) {

            $field_value = $_POST[$value];

            if (is_null($field_value) || empty($field_value)) {

                $output['msg'] = 'Debe proporcionar todos los campos obligatorios';

                echo json_encode($output);

                die();
            }
        }



        $email = $_POST['email_miembro_aceptar'];

        if (!filter_var($email, FILTER_VALIDATE_EMAIL)) {

            $output['msg'] = 'Formato de email no válido';

            echo json_encode($output);

            die();
        }



        $password = $_POST['password'];

        $password_confirm = $_POST['confirm_pwd'];

        if ($password != $password_confirm) {

            $output['msg'] = 'Las contraseñas no coinciden';

            echo json_encode($output);

            die();
        }



        $sql = $dbConn->prepare("SELECT * FROM users where user_email=:email");

        $sql->bindValue(':email', $email);

        $sql->execute();

        $check_email_result = $sql->fetch(PDO::FETCH_ASSOC);

        if ($check_email_result != false) {

            $output['msg'] = 'Email ya en uso';

            echo json_encode($output);

            die();
        }



        $Role = 7;

        $Origin = 3;

        $FullName = $_POST['business_name'];

        $Avatar = '/assets/images/profile.png';

        $Code = rand(1000000000, 99999999999);

        $Time = time();

        $personalizacion = json_decode(file_get_contents(__ROOT__ . '/personalizacion.json'), true);

        $rol = $personalizacion['rol'];



        $options = [

            'cost' => 12,

        ];



        $password = password_hash($password, PASSWORD_BCRYPT, $options);

        if (!mysqli_query($DBLink, "INSERT INTO `users` (`user_role`, `user_origin`, `user_email`, `user_password`, `user_full_name`, `user_avatar`, `user_code`, `user_last_seen`, `user_first_seen`, `id_rol`, `user_verification_status`) VALUES ('{$Role}', '{$Origin}', '{$email}', '{$password}', '{$FullName}', '{$Avatar}', '{$Code}', '0', '{$Time}','{$rol}', '1');")) {

            //Revert the DataBase Queries

            mysqli_rollback($DBLink);



            //Start the DataBase Auto-Commit

            mysqli_autocommit($DBLink, true);



            $output['msg'] = 'No se ha podido completar el registro, intente de nuevo más tarde.';

            echo json_encode($output);

            die();
        }
        $user_id = mysqli_insert_id($DBLink);
        $sql = "UPDATE miembro_equipo SET user_id = :user_id,csrf_token  = NULL ,estado  = 'Aceptado' WHERE id_miembro = :id_miembro";



        // Preparar la consulta

        $statement = $dbConn->prepare($sql);


        $statement->bindValue(':id_miembro', $_POST['id_miembro_aceptar']);

        $statement->bindValue(':user_id', $user_id);
        $statement->execute();

        $output['status'] = true;

        $output['msg'] = 'Registro completado correctamente';

        echo json_encode($output);

        die();
    }
}



//Borrar

if ($_SERVER['REQUEST_METHOD'] == 'DELETE') {

    if (isset($_GET["id"])) {

        $id = $_GET['id'];

        $statement = $dbConn->prepare("DELETE FROM formularios where id_formulario = :id");

        $statement->bindValue(':id', $id);

        $statement->execute();

        header("HTTP/1.1 200 OK");

        $archivoEliminar = '../formularios/' . $id . '.png';

        if (is_file($archivoEliminar)) {

            unlink($archivoEliminar);
        }

        exit();
    }
 if (isset($_GET["id_fi"])) {

        $id = $_GET['id_fi'];

        $statement = $dbConn->prepare("DELETE FROM fichajes where id_fichaje = :id");

        $statement->bindValue(':id', $id);

        $statement->execute();

        header("HTTP/1.1 200 OK");

       

        exit();
    }
    if (isset($_GET["id_fichaje"])) {

        $id = $_GET['id_fichaje'];
 $csrf_token = NoCSRF::generate('csrf_token');
      $statement = $dbConn->prepare("UPDATE fichajes SET estado = 'Pendiente de eliminación',csrf_token = :csrf_token WHERE id_fichaje = :id");
$statement->bindValue(':id', $id);
$statement->bindValue(':csrf_token', $csrf_token);
$statement->execute();

// Obtener el objeto actualizado
$select = $dbConn->prepare("SELECT * FROM fichajes WHERE id_fichaje = :id");
$select->bindValue(':id', $id);
$select->execute();
$fichaje = $select->fetch(PDO::FETCH_ASSOC);

          $U = $Users->GetUserByMiembro($fichaje["id_miembro"]);
            
enviarEmailFichaje($mailer, $U, $id, $csrf_token, $personalizacion, "eliminado");
        header("HTTP/1.1 200 OK");



        exit();
    }

    if (isset($_GET["id_miembro"])) {

        $id = $_GET['id_miembro'];

        $statement = $dbConn->prepare("DELETE FROM miembro_equipo where id_miembro = :id");

        $statement->bindValue(':id', $id);

        $statement->execute();

        header("HTTP/1.1 200 OK");



        exit();
    }

    if (isset($_GET["id_miembro_rechazar"])) {

        $id = $_GET['id_miembro_rechazar'];

        $statement = $dbConn->prepare("UPDATE miembro_equipo SET estado = 'Rechazado' WHERE id_miembro = :id");

        $statement->bindValue(':id', $id);

        $statement->execute();

        header("HTTP/1.1 200 OK");



        exit();
    }
}

function getFichajeCompleto($dbConn, $id_fichaje)

{

    // Recupera los datos completos del fichaje

    $sql = $dbConn->prepare("SELECT * FROM fichajes WHERE id_fichaje=:id_fichaje LIMIT 1");

    $sql->bindValue(':id_fichaje', $id_fichaje);

    $sql->execute();

    $fichaje = $sql->fetch(PDO::FETCH_ASSOC);



    // Recupera la jornada asignada para el fichaje

    $id_miembro = $fichaje["id_miembro"];

    $sql = $dbConn->prepare("SELECT * FROM jornada_laboral WHERE id_miembro=:id_miembro LIMIT 1");

    $sql->bindValue(':id_miembro', $id_miembro);

    $sql->execute();

    $jornada = $sql->fetch(PDO::FETCH_ASSOC);



    // Agregar la jornada laboral al fichaje

    $fichaje["jornada"] = $jornada;



    return $fichaje;
}



function checkAnomalias($dbConn, $fichaje, $distancia_casa, $distancia_calle, $id_fichaje, $localizacion, $tipo)

{

    $id_miembro = $fichaje["id_miembro"];

    $fecha = date("Y-m-d H:i:s");

    $tipo = ($tipo == "Salida") ? "Salida marcada " : "Fichaje reanudado ";

    $sql = $dbConn->prepare("SELECT * FROM miembro_equipo WHERE id_miembro=:id_miembro LIMIT 1");

    $sql->bindValue(':id_miembro', $id_miembro);

    $sql->execute();

    $miembro = $sql->fetch(PDO::FETCH_ASSOC);



    if ($miembro["kilometros_casa"] != null) {

        $kilometros_casa = $miembro["kilometros_casa"] * 1000;

        if ($kilometros_casa > $distancia_casa) {

            // Anomalia 1

            $anomalia = "{$tipo}demasiado cerca de tu casa";

            logAnomalia($dbConn, $id_fichaje, $anomalia, $id_miembro, $fecha, $localizacion);
        }
    }



    if ($miembro["kilometros_calle"] != null) {

        $kilometros_calle = $miembro["kilometros_calle"] * 1000;

        if ($kilometros_calle < $distancia_calle) {

            // Anomalia 2

            $anomalia = "{$tipo}demasiado lejos de la dirección de trabajo";

            logAnomalia($dbConn, $id_fichaje, $anomalia, $id_miembro, $fecha, $localizacion);
        }
    }
}



function logAnomalia($dbConn, $id_fichaje, $anomalia, $id_miembro, $fecha, $localizacion)

{

    $sql = "INSERT INTO anomalia (id_fichaje, anomalia, id_miembro, fecha, localizacion) VALUES (:id_fichaje, :anomalia, :id_miembro, :fecha, :localizacion);";

    $statement = $dbConn->prepare($sql);
    $statement->bindValue(':localizacion', $localizacion);
    $statement->bindValue(':id_fichaje', $id_fichaje);

    $statement->bindValue(':anomalia', $anomalia);

    $statement->bindValue(':id_miembro', $id_miembro);

    $statement->bindValue(':fecha', $fecha);

    $statement->execute();
}

function eliminarCarpeta($rutaCarpeta)

{

    // Obtener una lista de archivos y subcarpetas dentro de la carpeta

    $archivos = glob($rutaCarpeta . '/*');



    // Eliminar cada archivo encontrado

    foreach ($archivos as $archivo) {

        if (is_file($archivo)) {

            unlink($archivo);
        } elseif (is_dir($archivo)) {

            eliminarCarpeta($archivo);
        }
    }



    // Eliminar la carpeta

    if (is_dir($rutaCarpeta)) {

        rmdir($rutaCarpeta);
    }
}
function verificarAnomaliaSalida($dbConn, $fecha_salida, $id_fichaje)
{
    // Obtener el id_miembro desde el fichaje
    $sql = $dbConn->prepare("SELECT id_miembro FROM fichajes WHERE id_fichaje = :id_fichaje LIMIT 1");
    $sql->bindValue(':id_fichaje', $id_fichaje);
    $sql->execute();
    $resultado = $sql->fetch(PDO::FETCH_ASSOC);

    if (!$resultado || !isset($resultado['id_miembro'])) return;

    $id_miembro = $resultado['id_miembro'];

    // Obtener jornada laboral
    $sql = $dbConn->prepare("SELECT * FROM jornada_laboral WHERE id_miembro = :id_miembro LIMIT 1");
    $sql->bindValue(':id_miembro', $id_miembro);
    $sql->execute();
    $jornada = $sql->fetch(PDO::FETCH_ASSOC);

    if (!$jornada) return;

    // Día de la semana
    $fecha_actual = new DateTime($fecha_salida);
    $numero_dia = $fecha_actual->format('w');
    $dias_semana = ['domingo', 'lunes', 'martes', 'miercoles', 'jueves', 'viernes', 'sabado'];
    $dia = $dias_semana[$numero_dia];

    // Horarios de salida
    $horario2 = $jornada[$dia . "_s"];     // salida 1
    $horario4 = $jornada[$dia . "2_s"];    // salida 2

    // Hora de salida real
    $hora_salida = substr($fecha_salida, 11, 8);
    $timestamp = strtotime($hora_salida);
    $fecha = date("Y-m-d H:i:s");

    // Convertir horarios a timestamp
    $horario2Time = $horario2 ? strtotime($horario2) : null;
    $horario4Time = $horario4 ? strtotime($horario4) : null;

    // CASO 1: Ambos turnos
    if ($horario2Time && $horario4Time) {
        if ($timestamp < $horario2Time) {
            $anomalia = "Salida registrada antes del horario previsto. Hora prevista: $horario2, hora registrada: $hora_salida.";
            logAnomalia($dbConn, $id_fichaje, $anomalia, $id_miembro, $fecha, NULL);
            return;
        }

        if ($timestamp > $horario2Time && $timestamp < $horario4Time) {
            $anomalia = "Salida registrada antes del horario previsto del segundo turno. Hora prevista: $horario4, hora registrada: $hora_salida.";
            logAnomalia($dbConn, $id_fichaje, $anomalia, $id_miembro, $fecha, NULL);
            return;
        }
    }

    // CASO 2: Solo primer turno
    if ($horario2Time && !$horario4Time) {
        if ($timestamp < $horario2Time) {
            $anomalia = "Salida registrada antes del horario previsto. Hora prevista: $horario2, hora registrada: $hora_salida.";
            logAnomalia($dbConn, $id_fichaje, $anomalia, $id_miembro, $fecha, NULL);
            return;
        }
    }

    // CASO 3: Solo segundo turno
    if (!$horario2Time && $horario4Time) {
        if ($timestamp < $horario4Time) {
            $anomalia = "Salida registrada antes del horario previsto. Hora prevista: $horario4, hora registrada: $hora_salida.";
            logAnomalia($dbConn, $id_fichaje, $anomalia, $id_miembro, $fecha, NULL);
            return;
        }
    }

    return;
}


function verificarAnomaliaHorario($dbConn, $id_miembro, $fecha_entrada, $id_fichaje)
{
    // Obtener jornada laboral
    $sql = $dbConn->prepare("SELECT * FROM jornada_laboral WHERE id_miembro = :id_miembro LIMIT 1");
    $sql->bindValue(':id_miembro', $id_miembro);
    $sql->execute();
    $jornada = $sql->fetch(PDO::FETCH_ASSOC);

    if (!$jornada) return;

    // Día de la semana
    $fecha_actual = new DateTime($fecha_entrada);
    $numero_dia = $fecha_actual->format('w');
    $dias_semana = ['domingo', 'lunes', 'martes', 'miercoles', 'jueves', 'viernes', 'sabado'];
    $dia = $dias_semana[$numero_dia];

    // Horarios
    $horario1 = $jornada[$dia . "_e"];
    $horario2 = $jornada[$dia . "_s"];
    $horario3 = $jornada[$dia . "2_e"];
    $horario4 = $jornada[$dia . "2_s"];

    // Hora de entrada real
    $hora_entrada = substr($fecha_entrada, 11, 8);
    $timestamp = strtotime($hora_entrada);
    $fecha = date("Y-m-d H:i:s");

    // Convertir horarios
    $horario1Time = $horario1 ? strtotime($horario1) : null;
    $horario3Time = $horario3 ? strtotime($horario3) : null;

    $horario1Time10 = $horario1Time ? strtotime($horario1 . ' +10 minutes') : null;
    $horario3Time10 = $horario3Time ? strtotime($horario3 . ' +10 minutes') : null;

    // CASO 1: Tiene ambos turnos
    if ($horario1Time && $horario3Time) {
        if ($timestamp > $horario1Time10 && $timestamp < $horario3Time) {
            $anomalia = "Entrada marcada pasados 10 minutos del horario de entrada. Hora prevista: $horario1, hora registrada: $hora_entrada.";
            logAnomalia($dbConn, $id_fichaje, $anomalia, $id_miembro, $fecha, NULL);
            return;
        }

        if ($timestamp >= $horario3Time10) {
            $anomalia = "Entrada marcada pasados 10 minutos del horario de entrada. Hora prevista: $horario3, hora registrada: $hora_entrada.";
            logAnomalia($dbConn, $id_fichaje, $anomalia, $id_miembro, $fecha, NULL);
            return;
        }
    }

    // CASO 2: Solo primer turno
    if ($horario1Time && !$horario3Time) {
        if ($timestamp > $horario1Time10) {
            $anomalia = "Entrada marcada pasados 10 minutos del horario de entrada. Hora prevista: $horario1, hora registrada: $hora_entrada.";
            logAnomalia($dbConn, $id_fichaje, $anomalia, $id_miembro, $fecha, NULL);
            return;
        }
    }

    // CASO 3: Solo segundo turno
    if (!$horario1Time && $horario3Time) {
        if ($timestamp > $horario3Time10) {
            $anomalia = "Entrada marcada pasados 10 minutos del horario de entrada. Hora prevista: $horario3, hora registrada: $hora_entrada.";
            logAnomalia($dbConn, $id_fichaje, $anomalia, $id_miembro, $fecha, NULL);
            return;
        }
    }

    return;
}

function enviarEmailFichaje($mailer, $U, $id_fichaje, $csrf_token, $personalizacion, $accion = 'creado') {
    $confirmarUrl = WEBSITE_URL . "aceptar_fichaje?id={$id_fichaje}&token={$csrf_token}";

    $titulo = "Se ha {$accion} un fichaje a su nombre";

    $htmlBody = "
        <html>
            <head>
                <style>
                    .button {
                        background-color: #0cca8e;
                        border-color: #0cca8e;
                        display: inline-block;
                        font-weight: 400;
                        text-align: center;
                        white-space: nowrap;
                        vertical-align: middle;
                        user-select: none;
                        border: 1px solid rgba(0, 0, 0, 0);
                        padding: .56rem 1.375rem;
                        font-size: 1rem;
                        line-height: 1;
                        border-radius: .1875rem;
                        transition: color .15s ease-in-out, background-color .15s ease-in-out, border-color .15s ease-in-out, box-shadow .15s ease-in-out;
                        outline: 0;
                        outline-offset: 0;
                        color: #fff!important;
                    }
                    .button:hover {
                        color: #fff;
                        background-color: #0aa675;
                        border-color: #099a6c;
                        text-decoration: none;
                    }
                    .email-container {
                        font-family: Arial, sans-serif;
                        line-height: 1.5;
                        margin: 20px auto;
                        max-width: 370px;
                        text-align:center;
                    }
                    .email-title {
                        color: #333;
                        font-size: 20px;
                        font-weight: bold;
                        margin-bottom:.5rem;
                    }
                    .email-text {
                        color: #555;
                        font-size: 16px;
                        margin-bottom:.5rem;
                    }
                    .email-b {
                        width: 100%;
                    }
                    .email-image {
                        width: 100%;
                        max-width: 300px;
                        height: auto;
                        display: block;
                        margin: 0 auto .5rem auto;
                    }
                </style>
            </head>
            <body>
                <div class='email-container'>
                    <img src='" . htmlentities($personalizacion["imagen_email"], ENT_QUOTES) . "' alt='Imagen de fichaje' class='email-image' />
                    <div class='email-title'>{$titulo}</div>
                    <div class='email-text'>
                        ¿Desea aceptar el fichaje?<br>
                        Haga clic en el siguiente botón para confirmar su aceptación:
                    </div>
                    <div class='email-b'>
                        <a href='{$confirmarUrl}' class='button'>Revisar Fichaje</a>
                    </div>
                </div>
            </body>
        </html>";

    $mailer->_Mail(
        EMAIL_VALIDATE_USERNAME,
        $U['user_email'],
        $titulo,
        $htmlBody
    );
}








//En caso de que ninguna de las opciones anteriores se haya ejecutado

header("HTTP/1.1 400 Bad Request");