<?php



include "utils.php";




require_once __MODELS__ . 'pdf.model.php';

require_once __MODELS__ . 'mailer.model.php';

require_once __LIBRARIES__ . 'dompdf/autoload.inc.php';



use Dompdf\Dompdf;

use Dompdf\Options;



$dbConn = connect($db);



/*

listar todos los posts o solo uno

*/



if ($_SERVER['REQUEST_METHOD'] == 'GET') {



    if (isset($_GET['id_factura_manual_apartados'])) {

        // Mostrar un post

        $sql = $dbConn->prepare("SELECT * FROM apartado_factura_manual WHERE id_factura_manual = :id");

        $sql->bindValue(':id', $_GET['id_factura_manual_apartados']);

        $sql->execute();

        header("HTTP/1.1 200 OK");

        echo json_encode($sql->fetchAll(PDO::FETCH_ASSOC));

        exit();

    }

    if (isset($_GET['id_factura_rectificada_descargar'])) {



        try {

            $personalizacion = json_decode(file_get_contents('../personalizacion.json'), true);

            $sql = $dbConn->prepare("SELECT * FROM facturas_rectificadas WHERE id_factura_rectificada = :id;");

            $sql->bindValue(':id', $_GET['id_factura_rectificada_descargar']);

            $sql->execute();

            //$sql->setFetchMode(PDO::FETCH_ASSOC);

            $f = $sql->fetch(PDO::FETCH_OBJ);

            $id_factura_rectificada = $f->id_factura_rectificada;



            $sql = "SELECT a.*, 

            COALESCE(m.cantidad, 'Ninguno') AS cantidad_original,

            COALESCE(m.precio_unitario, 'Ninguno') AS precio_unitario_original,

            m.igic AS igic_original,

            m.codigo,

            ROUND(

                CASE 

                    WHEN TRIM(BOTH FROM REGEXP_REPLACE(a.cantidad, '[^0-9]', '')) <> '' 

                    THEN 

                        CAST(TRIM(BOTH FROM REGEXP_REPLACE(a.cantidad, '[^0-9]', '')) AS DECIMAL) * a.precio_unitario +

                        (CAST(TRIM(BOTH FROM REGEXP_REPLACE(a.cantidad, '[^0-9]', '')) AS DECIMAL) * a.precio_unitario * a.igic / 100)

                    ELSE 0

                END

            , 2) AS total,

            ROUND(

                CASE 

                    WHEN TRIM(BOTH FROM REGEXP_REPLACE(m.cantidad, '[^0-9]', '')) <> '' 

                    THEN 

                        CAST(TRIM(BOTH FROM REGEXP_REPLACE(m.cantidad, '[^0-9]', '')) AS DECIMAL) * m.precio_unitario +

                        (CAST(TRIM(BOTH FROM REGEXP_REPLACE(m.cantidad, '[^0-9]', '')) AS DECIMAL) * m.precio_unitario * m.igic / 100)

                    ELSE 0

                END

            , 2) AS total_original,

            ROUND(

                CASE 

                    WHEN TRIM(BOTH FROM REGEXP_REPLACE(a.cantidad, '[^0-9]', '')) <> '' 

                    THEN 

                        CASE 

                            WHEN TRIM(BOTH FROM REGEXP_REPLACE(m.cantidad, '[^0-9]', '')) <> '' 

                            THEN 

                                CASE 

                                    WHEN 

                                        (CAST(TRIM(BOTH FROM REGEXP_REPLACE(a.cantidad, '[^0-9]', '')) AS DECIMAL) * a.precio_unitario + 

                                         CAST(TRIM(BOTH FROM REGEXP_REPLACE(a.cantidad, '[^0-9]', '')) AS DECIMAL) * a.precio_unitario * a.igic / 100) >

                                        (CAST(TRIM(BOTH FROM REGEXP_REPLACE(m.cantidad, '[^0-9]', '')) AS DECIMAL) * m.precio_unitario + 

                                         CAST(TRIM(BOTH FROM REGEXP_REPLACE(m.cantidad, '[^0-9]', '')) AS DECIMAL) * m.precio_unitario * m.igic / 100)

                                    THEN 

                                        (CAST(TRIM(BOTH FROM REGEXP_REPLACE(a.cantidad, '[^0-9]', '')) AS DECIMAL) * a.precio_unitario + 

                                         CAST(TRIM(BOTH FROM REGEXP_REPLACE(a.cantidad, '[^0-9]', '')) AS DECIMAL) * a.precio_unitario * a.igic / 100) -

                                        (CAST(TRIM(BOTH FROM REGEXP_REPLACE(m.cantidad, '[^0-9]', '')) AS DECIMAL) * m.precio_unitario + 

                                         CAST(TRIM(BOTH FROM REGEXP_REPLACE(m.cantidad, '[^0-9]', '')) AS DECIMAL) * m.precio_unitario * m.igic / 100)

                                    ELSE 

                                        (CAST(TRIM(BOTH FROM REGEXP_REPLACE(m.cantidad, '[^0-9]', '')) AS DECIMAL) * m.precio_unitario + 

                                         CAST(TRIM(BOTH FROM REGEXP_REPLACE(m.cantidad, '[^0-9]', '')) AS DECIMAL) * m.precio_unitario * m.igic / 100) -

                                        (CAST(TRIM(BOTH FROM REGEXP_REPLACE(a.cantidad, '[^0-9]', '')) AS DECIMAL) * a.precio_unitario + 

                                         CAST(TRIM(BOTH FROM REGEXP_REPLACE(a.cantidad, '[^0-9]', '')) AS DECIMAL) * a.precio_unitario * a.igic / 100)

                                END

                            ELSE 

                                0

                        END

                    ELSE 

                        0

                END

            , 2) AS diferencia_total_total_original

     FROM apartado_factura_rectificada a

     LEFT JOIN apartado_factura_manual m ON a.id_apartado_factura_manual = m.id_apartado_factura_manual

     WHERE id_factura_rectificada = :id_factura_rectificada;";

            $stmt = $dbConn->prepare($sql);

            $stmt->bindParam(':id_factura_rectificada', $id_factura_rectificada, PDO::PARAM_INT);

            $stmt->execute();

            // Obtener el resultado como un objeto

            $apartados = $stmt->fetchAll(PDO::FETCH_OBJ);

            $f->apartados = $apartados;

            $id_factura_manual = $f->id_factura_manual;

            $sql = $dbConn->prepare("SELECT 

            f.*, 

            ROUND(COALESCE(SUM(a.cantidad * a.precio_unitario * (a.igic / 100)), 0), 2) AS igic_sumado,

            ROUND(

                COALESCE(SUM(a.cantidad * a.precio_unitario * (a.igic / 100)), 0) + 

                f.importe - 

                COALESCE(f.importe * (f.irpf / 100), 0), 

                2

            ) AS importe_calculado,

            COALESCE(c.codigo_tramitador , 'Ninguno') AS codigo_tramitador,

            COALESCE(c.codigo_gestor , 'Ninguno') AS codigo_gestor,

            COALESCE(c.codigo_contable , 'Ninguno') AS codigo_contable

        FROM 

            factura_manual f

            LEFT JOIN apartado_factura_manual a ON f.id_factura_manual = a.id_factura_manual

            LEFT JOIN clientes c ON f.client_id = c.client_id

        WHERE 

            f.id_factura_manual = :id

        GROUP BY 

            f.id_factura_manual;");

            $sql->bindValue(':id', $id_factura_manual);

            $sql->execute();



            $factura_manual = $sql->fetch(PDO::FETCH_OBJ);

            $f->factura_manual = $factura_manual;



            $Newsletter = file_get_contents(__ROOT__ . '/emails/factura_rectificada.html');

            $Newsletter = str_replace("%color%", htmlentities($personalizacion['color_elementos'], ENT_QUOTES), $Newsletter);

            $Newsletter = str_replace("%cif_comercio%", htmlentities($personalizacion['cif'], ENT_QUOTES), $Newsletter);

            $Newsletter = str_replace("%imagen%", htmlentities($f->factura_manual->imagen, ENT_QUOTES), $Newsletter);

            $Newsletter = str_replace("%direccion_comercio%", htmlentities($personalizacion['direccion'], ENT_QUOTES), $Newsletter);

            $Newsletter = str_replace("%nombre_comercio%", htmlentities($personalizacion['nombre'], ENT_QUOTES), $Newsletter);

            $Newsletter = str_replace("%telefono_comercio%", htmlentities($personalizacion['telefono'], ENT_QUOTES), $Newsletter);

            $Newsletter = str_replace("%email_comercio%", htmlentities($personalizacion['email'], ENT_QUOTES), $Newsletter);

            $Newsletter = str_replace("%fax_comercio%", htmlentities($personalizacion['fax'], ENT_QUOTES), $Newsletter);

            $Newsletter = str_replace("%web_comercio%", htmlentities($personalizacion['web'], ENT_QUOTES), $Newsletter);

            $Newsletter = str_replace("%numero_factura%", htmlentities($f->numero, ENT_QUOTES), $Newsletter);



            $fecha_formateada = date("Y/m/d", strtotime($f->fecha));

            $Newsletter = str_replace("%fecha_factura%", htmlentities($fecha_formateada, ENT_QUOTES), $Newsletter);

            if ($f->factura_manual->fecha_vencimiento != null) {

                $fecha_formateada = date("Y/m/d", strtotime($f->factura_manual->fecha_vencimiento));

                $Newsletter = str_replace("%fecha_vencimiento_factura%", htmlentities($fecha_formateada, ENT_QUOTES), $Newsletter);

                $Newsletter = str_replace("%fecha_factura_display%", "table-cell", $Newsletter);

            } else {

                $Newsletter = str_replace("%fecha_factura_display%", "none", $Newsletter);

            }







            $cifview = (htmlentities($personalizacion['cif'], ENT_QUOTES) != "") ? "block" : "none";

            $direccionview = (htmlentities($personalizacion['direccion'], ENT_QUOTES) != "") ? "block" : "none";

            $nombreview = (htmlentities($personalizacion['nombre'], ENT_QUOTES) != "") ? "block" : "none";

            $telefonoview = (htmlentities($personalizacion['telefono'], ENT_QUOTES) != "") ? "block" : "none";

            $emailview = (htmlentities($personalizacion['email'], ENT_QUOTES) != "") ? "block" : "none";

            $faxview = (htmlentities($personalizacion['fax'], ENT_QUOTES) != "") ? "block" : "none";

            $webview = (htmlentities($personalizacion['web'], ENT_QUOTES) != "") ? "block" : "none";

            $Newsletter = str_replace("%cif_comercio_view%", $cifview, $Newsletter);

            $Newsletter = str_replace("%direccion_comercio_view%", $direccionview, $Newsletter);

            $Newsletter = str_replace("%nombre_comercio_view%", $nombreview, $Newsletter);

            $Newsletter = str_replace("%telefono_comercio_view%", $telefonoview, $Newsletter);

            $Newsletter = str_replace("%email_comercio_view%", $emailview, $Newsletter);

            $Newsletter = str_replace("%fax_comercio_view%", $faxview, $Newsletter);

            $Newsletter = str_replace("%web_comercio_view%", $webview, $Newsletter);







            $detallado = '';

            $Apartados = $f->apartados;

            $concepto = "<p style='font-size:14px;display:block;width:100%;text-align:center;margin-bottom:.1rem;'>Rectifica factura Nº {$f->factura_manual->numero} por: </p>";

            $suma_igic = 0.00;

            foreach ($Apartados as $apartado) {

                $suma_igic += floatval($apartado->precio_unitario) * floatval(explode(" ", trim($apartado->cantidad))[0]) * (floatval($apartado->igic) / 100);



                $detallado .= '<tr>';

                $detallado .= '<td class="table-cell" style="width: 10%; text-align:center;">' . $apartado->codigo . '</td>';

                $detallado .= '<td class="table-cell" style="width: 40%; text-align:center;"><h4 style="margin-bottom:0px;text-align:center;">' . $apartado->titulo . '</h4><p style="margin:0px;">' . $apartado->descripcion . '</p></td>';

                $detallado .= '<td class="table-cell" style="width: 10%; text-align:center;">' . $apartado->cantidad . '</td>';

                $detallado .= '<td class="table-cell" style="width: 10%; text-align:center;">' . formatearNumero($apartado->precio_unitario) . '€</td>';

                $detallado .= '<td class="table-cell" style="width: 10%; text-align:center;">' . formatearNumero($apartado->igic) . '%</td>';

                $detallado .= '<td class="table-cell" style="width: 20%; text-align:center;">' . formatearNumero(sprintf("%.2f", ($apartado->total - $apartado->total_original))) . '€</td>';

                $detallado .= '</tr>';

                $cant = "";

                $nom = $apartado->codigo;

                if (floatval($apartado->total_original) > floatval($apartado->total)) {

                    $valor = floatval($apartado->total_original) - floatval($apartado->total);

                    $cant = "<p style='font-size:14px;display:block;width:100%;text-align:center;margin-bottom:.1rem;'>Reducción del artículo {$nom} en {$valor}€.</p>";

                }

                if (floatval($apartado->total_original) < floatval($apartado->total)) {

                    $valor = floatval($apartado->total) - floatval($apartado->total_original);

                    $cant = "<p style='font-size:14px;display:block;width:100%;text-align:center;margin-bottom:.1rem;'>Aumento del artículo {$nom} en {$valor}€.</p>";

                }
                

                $concepto .= $cant;

            }



           



            $Newsletter = str_replace("%descripcion_factura%", $concepto, $Newsletter);





            $Newsletter = str_replace("%detallado%", $detallado, $Newsletter);

            $Newsletter = str_replace("%nombre_cliente%", htmlentities($f->factura_manual->nombre, ENT_QUOTES), $Newsletter);

            $Newsletter = str_replace("%direccion_cliente%", htmlentities($f->factura_manual->direccion, ENT_QUOTES), $Newsletter);



            $Newsletter = str_replace("%obra_cliente%", "Ninguna", $Newsletter);



            $Newsletter = str_replace("%sector_cliente%", "Ninguno", $Newsletter);



            $Newsletter = str_replace("%fase_cliente%", "Ninguna", $Newsletter);



            if ($Factura->factura_manual->lugar != null) {

                $Newsletter = str_replace("%lugar_factura_view%", "block", $Newsletter);

                $Newsletter = str_replace("%lugar_factura%", htmlentities($Factura->factura_manual->lugar, ENT_QUOTES), $Newsletter);

            } else {

                $Newsletter = str_replace("%lugar_factura_view%", "none", $Newsletter);

                $Newsletter = str_replace("%lugar_factura%", "Ninguna", $Newsletter);

            }

            if ($Factura->factura_manual->fechas != null) {

                $Newsletter = str_replace("%fechas_factura_view%", "block", $Newsletter);

                $Newsletter = str_replace("%fechas_factura%", htmlentities($Factura->factura_manual->fechas, ENT_QUOTES), $Newsletter);

            } else {

                $Newsletter = str_replace("%fechas_factura_view%", "none", $Newsletter);

                $Newsletter = str_replace("%fechas_factura%", "Ninguna", $Newsletter);

            }

            if ($Factura->factura_manual->nombre != null) {

                $Newsletter = str_replace("%titulo_factura_view%", "block", $Newsletter);

                $Newsletter = str_replace("%titulo_factura%", htmlentities($Factura->factura_manual->nombre, ENT_QUOTES), $Newsletter);

            } else {

                $Newsletter = str_replace("%titulo_factura_view%", "none", $Newsletter);

                $Newsletter = str_replace("%titulo_factura%", "Ninguna", $Newsletter);

            }











$con = false;

            if ($f->factura_manual->codigo_contable != null) {

                $Newsletter = str_replace("%contable_factura_view%", "block", $Newsletter);

                $Newsletter = str_replace("%contable_factura%", htmlentities($f->factura_manual->codigo_contable, ENT_QUOTES), $Newsletter);
$con = true;
            } else {

                $Newsletter = str_replace("%contable_factura_view%", "none", $Newsletter);

                $Newsletter = str_replace("%contable_factura%", "Ninguna", $Newsletter);

            }

            if ($f->factura_manual->codigo_gestor != null) {

                $Newsletter = str_replace("%gestor_factura_view%", "block", $Newsletter);

                $Newsletter = str_replace("%gestor_factura%", htmlentities($f->factura_manual->codigo_gestor, ENT_QUOTES), $Newsletter);
$con = true;
            } else {

                $Newsletter = str_replace("%gestor_factura_view%", "none", $Newsletter);

                $Newsletter = str_replace("%gestor_factura%", "Ninguna", $Newsletter);

            }

            if ($f->factura_manual->codigo_tramitador != null) {

                $Newsletter = str_replace("%tramitadora_factura_view%", "block", $Newsletter);

                $Newsletter = str_replace("%tramitadora_factura%", htmlentities($f->factura_manual->codigo_tramitador, ENT_QUOTES), $Newsletter);
$con = true;
            } else {

                $Newsletter = str_replace("%tramitadora_factura_view%", "none", $Newsletter);

                $Newsletter = str_replace("%tramitadora_factura%", "Ninguna", $Newsletter);

            }
            if ($con) {

              //  $Newsletter = str_replace("%contables_factura_view%", "inline-block", $Newsletter);

            } else {

                $Newsletter = str_replace("%contables_factura_view%", "display:none", $Newsletter);

            }
            

            if ($f->factura_manual->direccion != null) {

                $Newsletter = str_replace("%direccion_cliente_view%", "block", $Newsletter);

                $Newsletter = str_replace("%direccion_cliente%", htmlentities($f->factura_manual->direccion, ENT_QUOTES), $Newsletter);

            } else {

                $Newsletter = str_replace("%direccion_cliente_view%", "none", $Newsletter);

                $Newsletter = str_replace("%direccion_cliente%", "Ninguna", $Newsletter);

            }



            if ($f->factura_manual->email != null) {

                $Newsletter = str_replace("%email_cliente_view%", "block", $Newsletter);

                $Newsletter = str_replace("%email_cliente%", htmlentities($f->factura_manual->email, ENT_QUOTES), $Newsletter);

            } else {

                $Newsletter = str_replace("%email_cliente_view%", "none", $Newsletter);

                $Newsletter = str_replace("%email_cliente%", "Ninguna", $Newsletter);

            }







            if ($f->factura_manual->telefono != null) {

                $Newsletter = str_replace("%telefono_cliente_view%", "block", $Newsletter);

                $Newsletter = str_replace("%telefono_cliente%", htmlentities($f->factura_manual->telefono, ENT_QUOTES), $Newsletter);

            } else {

                $Newsletter = str_replace("%telefono_cliente_view%", "none", $Newsletter);

            }



            if ($f->factura_manual->cif != null) {

                $Newsletter = str_replace("%cif_cliente_view%", "block", $Newsletter);

                $Newsletter = str_replace("%cif_cliente%", htmlentities($f->factura_manual->cif, ENT_QUOTES), $Newsletter);

            } else {

                $Newsletter = str_replace("%cif_cliente_view%", "none", $Newsletter);

            }

            if ($f->factura_manual->condiciones != null) {

                $Newsletter = str_replace("%condiciones_view%", "block", $Newsletter);



                $arreglo = explode("\\n", $f->factura_manual->condiciones);

                $condi = "";

                foreach ($arreglo as $a) {



                    $condi .= '<p style="margin-bottom:.1rem">';

                    $condi .= $a;

                    $condi .= '</p>';

                }

                $Newsletter = str_replace("%condiciones_factura%", $condi, $Newsletter);

            } else {

                $Newsletter = str_replace("%condiciones_view%", "none", $Newsletter);

            }

            if ($f->factura_manual->impuesto != null) {

                $Newsletter = str_replace("%impuestos_view%", "block", $Newsletter);

                $arreglo = explode("\\n", $f->factura_manual->impuesto);

                $condi = "";

                foreach ($arreglo as $a) {



                    $condi .= '<p style="margin-bottom:.1rem">';

                    $condi .= $a;

                    $condi .= '</p>';

                }

                $Newsletter = str_replace("%impuestos_factura%", $condi, $Newsletter);

            } else {

                $Newsletter = str_replace("%impuestos_view%", "none", $Newsletter);

            }

            if ($f->factura_manual->cp != null) {

                $Newsletter = str_replace("%cp_cliente_view%", "block", $Newsletter);

                $Newsletter = str_replace("%cp_cliente%", htmlentities($f->factura_manual->cp, ENT_QUOTES), $Newsletter);

            } else {

                $Newsletter = str_replace("%cp_cliente_view%", "none", $Newsletter);

            }







            $total = 0;

            $subtotal = 0;

            // Iterar sobre los apartados de cada factura

            foreach ($f->apartados as $apartado) {

                // Calcular la diferencia entre 'total' y 'total_original'

                $diferencia = floatval($apartado->total - $apartado->total_original);

              

                // Sumar la diferencia a 'sumaDiferencias'

                $total += $diferencia;

                

            }



            // Agregar 'sumaDiferencias' como un nuevo atributo al objeto principal



            $subtotal = $total - floatval($suma_igic);

            // Calcular el total final

            $importe = number_format($subtotal, 2, '.', '');

            // Agregar el total final al objeto principal

           



$valor_igic = floatval($suma_igic) - floatval($f->factura_manual->igic_sumado);



            $Newsletter = str_replace("%subtotal_factura%", $importe, $Newsletter);



            //sprintf("%.2f", (($suma_igic)));

            $resto_irpf = 0;

            if ($f->factura_manual->irpf != null) {

                $irpf = $f->factura_manual->irpf;

                $resto_irpf = sprintf("%.2f", (floatval($subtotal) * ($irpf / 100)));

                $Newsletter = str_replace("%irpf_factura%", htmlentities($f->factura_manual->irpf, ENT_QUOTES), $Newsletter);

                $Newsletter = str_replace("%irpf_total_factura%", $resto_irpf, $Newsletter);

                $Newsletter = str_replace("%irpf_view%", "block", $Newsletter);

            } else {

                $Newsletter = str_replace("%irpf_factura%", "0.00", $Newsletter);

                $Newsletter = str_replace("%irpf_total_factura%", "0,00", $Newsletter);

                $Newsletter = str_replace("%irpf_view%", "none", $Newsletter);

            }



            $Newsletter = str_replace("%impuesto_factura%", htmlentities($igic, ENT_QUOTES), $Newsletter);

            $Newsletter = str_replace("%total_impuesto_factura%", sprintf("%.2f", (($suma_igic))), $Newsletter);

            $total = sprintf("%.2f", ($total - $resto_irpf));

            $Newsletter = str_replace("%total_factura%", htmlentities($total, ENT_QUOTES), $Newsletter);

            $tmp = sys_get_temp_dir();

            $options = new Options();

            $options->set('logOutputFile', '');

            // $options->set('defaultFont', 'Helvetica');

            $options->set('isRemoteEnabled', true);

            $options->set('debugKeepTemp', true);

            $options->set('isHtml5ParserEnabled', true);

            $options->set('fontDir', $tmp);

            $options->set('fontCache', $tmp);

            $options->set('tempDir', $tmp);

            $options->set('chroot', $tmp);



            $options->set('chroot', '');

            $pdf = new Dompdf($options);

            $context = stream_context_create([

                'ssl' => [

                    'verify_peer' => false,

                    'verify_peer_name' => false,

                    'allow_self_signed' => true,

                ],

            ]);

            $pdf->setHttpContext($context);

            // Definimos el tamaño y orientación del papel que queremos.

            $pdf->set_paper("A4", "portrait");

            // Cargamos el contenido HTML.

            $pdf->load_html($Newsletter);

            // Renderizamos el documento PDF.

            $pdf->render();

            // Enviamos el fichero PDF al navegador.

            //$pdf->stream('Factura.pdf',array("Attachment" => true));

            $nombre = "Factura_Rectificada_" . str_replace('/', '_', str_replace(' ', '_', $f->factura_manual->numero)) . ".pdf";

            if (isset($_GET["enviar"])) {

                $fileatt = $pdf->output();

                $Mailer = new _MailerModel(EMAIL_SERVER, EMAIL_PORT, EMAIL_VALIDATE_USERNAME, EMAIL_VALIDATE_PASSWORD);

               if( $Mailer->_Mail(

                    EMAIL_VALIDATE_USERNAME,

                    $f->factura_manual->email,

                    $personalizacion['cabecera_email_factura'],

                    $personalizacion['cuerpo_email_factura'],

                    APP_NAME,

                    "Cliente",

                    $fileatt,

                    true,

                    true,

                    $nombre,

                    ".pdf"

                )){

                    

                    echo json_encode(array('status' => true, 'body' => "Email enviado"));

                }else{

               

                    

                    echo json_encode(array('status' => false, 'body' => "Email no enviado"));

                }



                

                exit();

            }





            $file_to_save = "../facturas/" . $nombre;

            $files = glob('../facturas/*'); // get all file names

            foreach ($files as $file) { // iterate files

                if (is_file($file)) {

                    unlink($file); // delete file

                }

            }

            //save the pdf file on the server

            file_put_contents($file_to_save, $pdf->output());

            //print the pdf file to the screen for saving

            header('Content-type: application/pdf');

            header('Content-Disposition: inline; filename="' . $nombre . '"');

            header('Content-Transfer-Encoding: binary');

            header('Content-Length: ' . filesize($file_to_save));

            header('Accept-Ranges: bytes');

            // $options = new Options();



            $file_to_save = "facturas/" . $nombre;

            echo $file_to_save;

            exit();

        } catch (PDOException $e) {

            // Manejar el error

            header("HTTP/1.1 500 Internal Server Error");

            echo "Error al ejecutar la consulta: " . $e->getMessage();

            exit();

        }

    } else {



        try {

            $sql = $dbConn->prepare("SELECT f.*

        

         FROM facturas_rectificadas f

         LEFT JOIN factura_manual m ON m.id_factura_manual = f.id_factura_manual;");

            $sql->execute();

            $sql->setFetchMode(PDO::FETCH_ASSOC);

            $facturas = $sql->fetchAll(PDO::FETCH_OBJ);



            foreach ($facturas as $f) {



                $id_factura_rectificada = $f->id_factura_rectificada;



                $sql = "SELECT a.*, 

                COALESCE(m.cantidad, 'Ninguno') AS cantidad_original,

                COALESCE(m.precio_unitario, 'Ninguno') AS precio_unitario_original,

                m.igic AS igic_original,

                ROUND(

                    CASE 

                        WHEN TRIM(BOTH FROM REGEXP_REPLACE(a.cantidad, '[^0-9]', '')) <> '' 

                        THEN 

                            CAST(TRIM(BOTH FROM REGEXP_REPLACE(a.cantidad, '[^0-9]', '')) AS DECIMAL) * a.precio_unitario +

                            (CAST(TRIM(BOTH FROM REGEXP_REPLACE(a.cantidad, '[^0-9]', '')) AS DECIMAL) * a.precio_unitario * a.igic / 100)

                        ELSE 0

                    END

                , 2) AS total,

                ROUND(

                    CASE 

                        WHEN TRIM(BOTH FROM REGEXP_REPLACE(m.cantidad, '[^0-9]', '')) <> '' 

                        THEN 

                            CAST(TRIM(BOTH FROM REGEXP_REPLACE(m.cantidad, '[^0-9]', '')) AS DECIMAL) * m.precio_unitario +

                            (CAST(TRIM(BOTH FROM REGEXP_REPLACE(m.cantidad, '[^0-9]', '')) AS DECIMAL) * m.precio_unitario * m.igic / 100)

                        ELSE 0

                    END

                , 2) AS total_original,

                ROUND(

                    CASE 

                        WHEN TRIM(BOTH FROM REGEXP_REPLACE(a.cantidad, '[^0-9]', '')) <> '' 

                        THEN 

                            CASE 

                                WHEN TRIM(BOTH FROM REGEXP_REPLACE(m.cantidad, '[^0-9]', '')) <> '' 

                                THEN 

                                    CASE 

                                        WHEN 

                                            (CAST(TRIM(BOTH FROM REGEXP_REPLACE(a.cantidad, '[^0-9]', '')) AS DECIMAL) * a.precio_unitario + 

                                             CAST(TRIM(BOTH FROM REGEXP_REPLACE(a.cantidad, '[^0-9]', '')) AS DECIMAL) * a.precio_unitario * a.igic / 100) >

                                            (CAST(TRIM(BOTH FROM REGEXP_REPLACE(m.cantidad, '[^0-9]', '')) AS DECIMAL) * m.precio_unitario + 

                                             CAST(TRIM(BOTH FROM REGEXP_REPLACE(m.cantidad, '[^0-9]', '')) AS DECIMAL) * m.precio_unitario * m.igic / 100)

                                        THEN 

                                            (CAST(TRIM(BOTH FROM REGEXP_REPLACE(a.cantidad, '[^0-9]', '')) AS DECIMAL) * a.precio_unitario + 

                                             CAST(TRIM(BOTH FROM REGEXP_REPLACE(a.cantidad, '[^0-9]', '')) AS DECIMAL) * a.precio_unitario * a.igic / 100) -

                                            (CAST(TRIM(BOTH FROM REGEXP_REPLACE(m.cantidad, '[^0-9]', '')) AS DECIMAL) * m.precio_unitario + 

                                             CAST(TRIM(BOTH FROM REGEXP_REPLACE(m.cantidad, '[^0-9]', '')) AS DECIMAL) * m.precio_unitario * m.igic / 100)

                                        ELSE 

                                            (CAST(TRIM(BOTH FROM REGEXP_REPLACE(m.cantidad, '[^0-9]', '')) AS DECIMAL) * m.precio_unitario + 

                                             CAST(TRIM(BOTH FROM REGEXP_REPLACE(m.cantidad, '[^0-9]', '')) AS DECIMAL) * m.precio_unitario * m.igic / 100) -

                                            (CAST(TRIM(BOTH FROM REGEXP_REPLACE(a.cantidad, '[^0-9]', '')) AS DECIMAL) * a.precio_unitario + 

                                             CAST(TRIM(BOTH FROM REGEXP_REPLACE(a.cantidad, '[^0-9]', '')) AS DECIMAL) * a.precio_unitario * a.igic / 100)

                                    END

                                ELSE 

                                    0

                            END

                        ELSE 

                            0

                    END

                , 2) AS diferencia_total_total_original

         FROM apartado_factura_rectificada a

         LEFT JOIN apartado_factura_manual m ON a.id_apartado_factura_manual = m.id_apartado_factura_manual

         WHERE id_factura_rectificada = :id_factura_rectificada;

         ";

                $stmt = $dbConn->prepare($sql);

                $stmt->bindParam(':id_factura_rectificada', $id_factura_rectificada, PDO::PARAM_INT);

                $stmt->execute();

                // Obtener el resultado como un objeto

                $apartados = $stmt->fetchAll(PDO::FETCH_OBJ);

                $f->apartados = $apartados;

                $id_factura_manual = $f->id_factura_manual;

                $sql = $dbConn->prepare("SELECT f.*,

                ROUND(COALESCE(SUM(a.cantidad * a.precio_unitario * (a.igic / 100)), 0), 2) AS igic_sumado,

                ROUND(COALESCE(SUM(a.cantidad * a.precio_unitario * (a.igic / 100)), 0) + f.importe - COALESCE(f.importe * (f.irpf / 100), 0), 2) AS importe_calculado

         FROM factura_manual f

         LEFT JOIN apartado_factura_manual a ON f.id_factura_manual = a.id_factura_manual

         WHERE f.id_factura_manual = :id

         GROUP BY f.id_factura_manual;

         ");

                $sql->bindValue(':id', $id_factura_manual);

                $sql->execute();



                $factura_manual = $sql->fetch(PDO::FETCH_OBJ);

                $f->factura_manual = $factura_manual;

            }







            header("HTTP/1.1 200 OK");



            echo json_encode($facturas);

            exit();

        } catch (PDOException $e) {

            // Manejar el error

            header("HTTP/1.1 500 Internal Server Error");

            echo "Error al ejecutar la consulta: " . $e->getMessage();

            exit();

        }

    }

}



// Crear un nuevo post

if ($_SERVER['REQUEST_METHOD'] == 'POST') {

    if (isset($_POST["programado"]) && isset($_POST["id_factura_editar_envio"])) {



        $programado = ($_POST["programado"] != "No") ? $_POST["programado"] : null;

        $id_factura_manual = $_POST["id_factura_editar_envio"];



        $sql = "UPDATE factura_manual SET programado = :programado WHERE id_factura_manual = :id_factura_manual";

        $statement = $dbConn->prepare($sql);

        $statement->bindValue(':id_factura_manual', $id_factura_manual);

        $statement->bindValue(':programado', $programado);



        $statement->execute();

        $object = [

            'id' => $id_factura,

            'programado' => $programado,



        ];



        header("HTTP/1.1 200 OK");

        echo json_encode($object);

        exit();

    }

    if (

        isset($_POST["nombre"]) &&

        isset($_POST["fecha"]) &&

        isset($_POST["numero"]) &&

        isset($_POST["estado"]) &&

        isset($_POST["cif"]) &&

        isset($_POST["cp"]) &&

        isset($_POST["direccion"]) &&

        isset($_POST["telefono"]) &&

        isset($_POST["email"]) &&

        isset($_POST["importe"]) &&

        isset($_POST["titulo"]) &&

        isset($_POST["client_id"]) &&

        isset($_POST["igic"]) &&

        isset($_POST["irpf"]) &&

        isset($_POST["imagen"]) &&

        isset($_POST["fecha_envio"]) &&

        isset($_POST["id_contable"]) &&

        isset($_POST["id_gestor"]) &&

        isset($_POST["id_tramitadora"]) &&

        isset($_POST["tipo"]) &&

        isset($_POST["id_banco"]) &&

        isset($_POST["id_banco_2"]) &&

        isset($_POST["id_banco_3"]) &&

        isset($_POST["programado"]) &&

        isset($_POST["condiciones"]) &&

        isset($_POST["impuesto"]) &&

        isset($_POST["fechas"]) &&

        isset($_POST["lugar"]) &&

        isset($_POST["descripcion"]) &&

        isset($_POST["fecha_vencimiento"])

    ) {

        try {

            foreach ($_POST as $key => $value) {

                $value = ($value == "") ? null : $value;



                $value = ($value == "No") ? null : $value;

                $$key = $value;

            }





            if (isset($_POST["id_factura_manual_editar"])) {



                $id_factura_manual = $_POST["id_factura_manual_editar"];

                $sql = "UPDATE factura_manual

            SET imagen = :imagen,

            id_banco = :id_banco,

            id_banco_2 = :id_banco_2,

            id_banco_3 = :id_banco_3,

                nombre = :nombre,

                fecha = :fecha,

                numero = :numero,

                estado = :estado,

                cif = :cif,

                cp = :cp,

                direccion = :direccion,

                telefono = :telefono,

                email = :email,

                importe = :importe,

                fecha_envio = :fecha_envio,

                fecha_vencimiento = :fecha_vencimiento,

                titulo = :titulo,

                client_id = :client_id,

                igic = :igic, 

                id_contable = :id_contable,

                 tipo = :tipo,

            id_gestor = :id_gestor,

            id_tramitadora = :id_tramitadora,

            programado = :programado,

            condiciones = :condiciones,

            impuesto = :impuesto,

            fechas = :fechas,

            descripcion = :descripcion,

            lugar = :lugar,

                irpf = :irpf

            WHERE id_factura_manual = :id_factura_manual";

                $statement = $dbConn->prepare($sql);

                $statement->bindValue(':id_factura_manual', $id_factura_manual);

            } else {

                $sql = "INSERT INTO factura_manual (descripcion,fechas,lugar,condiciones,impuesto,programado,id_banco,id_banco_2,id_banco_3,tipo,id_contable,id_gestor,id_tramitadora,imagen,nombre,fecha,numero,estado,cif,cp,direccion,telefono,email,importe,fecha_envio,fecha_vencimiento,titulo,client_id,igic,irpf)

        VALUES

        (:descripcion,:fechas,:lugar,:condiciones,:impuesto,:programado,:id_banco,:id_banco_2,:id_banco_3,:tipo,:id_contable,:id_gestor,:id_tramitadora,:imagen,:nombre,:fecha,:numero,:estado,:cif,:cp,:direccion,:telefono,:email,:importe,:fecha_envio,:fecha_vencimiento,:titulo,:client_id,:igic,:irpf)";

                $statement = $dbConn->prepare($sql);

            }

            $statement->bindValue(':fechas', $fechas);

            $statement->bindValue(':lugar', $lugar);

            $statement->bindValue(':programado', $programado);

            $statement->bindValue(':id_banco', $id_banco);

            $statement->bindValue(':id_banco_2', $id_banco_2);

            $statement->bindValue(':id_banco_3', $id_banco_3);

            $statement->bindValue(':id_contable', $id_contable);

            $statement->bindValue(':tipo', $tipo);

            $statement->bindValue(':id_gestor', $id_gestor);

            $statement->bindValue(':id_tramitadora', $id_tramitadora);

            $statement->bindValue(':imagen', $imagen);

            $statement->bindValue(':nombre', $nombre);

            $statement->bindValue(':fecha', $fecha);

            $statement->bindValue(':numero', $numero);

            $statement->bindValue(':estado', $estado);

            $statement->bindValue(':cif', $cif);

            $statement->bindValue(':cp', $cp);

            $statement->bindValue(':direccion', $direccion);

            $statement->bindValue(':telefono', $telefono);

            $statement->bindValue(':email', $email);

            $statement->bindValue(':importe', $importe);

            $statement->bindValue(':titulo', $titulo);

            $statement->bindValue(':client_id', $client_id);

            $statement->bindValue(':igic', $igic);

            $statement->bindValue(':irpf', $irpf);

            $statement->bindValue(':fecha_envio', $fecha_envio);

            $statement->bindValue(':fecha_vencimiento', $fecha_vencimiento);

            $statement->bindValue(':condiciones', $condiciones);

            $statement->bindValue(':impuesto', $impuesto);

            $statement->bindValue(':descripcion', $descripcion);

            $statement->execute();



            if (isset($_POST["id_factura_manual_editar"])) {

                $postId = $_POST["id_factura_manual_editar"];

            } else {

                $postId = $dbConn->lastInsertId();

                $personalizacion = json_decode(file_get_contents('../personalizacion.json'), true);

                $personalizacion["numeracion_facturas"] = intval($personalizacion["numeracion_facturas"]) + 1;

                $personalizacionEncoded = json_encode($personalizacion, JSON_PRETTY_PRINT);

                file_put_contents('../personalizacion.json', $personalizacionEncoded);

            }





            $input['id'] = $postId;

            $input['nombre'] = $nombre;



            $input['imagen'] = $imagen;

            $input['fecha'] = $fecha;

            $input['numero'] = $numero;

            $input['estado'] = $estado;

            $input['cif'] = $cif;

            $input['cp'] = $cp;

            $input['direccion'] = $direccion;

            $input['telefono'] = $telefono;

            $input['email'] = $email;

            $input['importe'] = $importe;

            $input['titulo'] = $titulo;

            $input['client_id'] = $client_id;

            $input['igic'] = $igic;

            $input['irpf'] = $irpf;

            $input['fecha_envio'] = $fecha_envio;

            header("HTTP/1.1 200 OK");

            echo json_encode($input);

            exit();

        } catch (PDOException $e) {

            // Manejar el error

            header("HTTP/1.1 500 Internal Server Error");

            echo "Error al ejecutar la consulta: " . $e->getMessage();

            exit();

        }

    }

    if (

        isset($_POST["id"]) &&

        isset($_POST["detallado"])

    ) {

        $id_factura_manual = $_POST["id"];

        $detallado = json_decode($_POST["detallado"], true);

        if (isset($_POST["editar"])) {

            $deleteStatement = $dbConn->prepare("DELETE FROM apartado_factura_manual WHERE id_factura_manual = :id_factura_manual");

            $deleteStatement->bindValue(':id_factura_manual', $id_factura_manual);

            $deleteStatement->execute();

        }









        foreach ($detallado as $apartado) {



            $titulo = ($apartado["titulo"] != "") ? $apartado["titulo"] : null;

            $cantidad = $apartado["cantidad"];

            $descripcion = $apartado["descripcion"];

            $precio_unitario = $apartado["precio_unitario"];

            $statement = $dbConn->prepare("INSERT INTO apartado_factura_manual (id_factura_manual, cantidad, descripcion, precio_unitario, titulo ) VALUES (:id_factura_manual, :cantidad, :descripcion, :precio_unitario, :titulo)");

            $statement->bindValue(':id_factura_manual', $id_factura_manual);

            $statement->bindValue(':cantidad', $cantidad);

            $statement->bindValue(':titulo', $titulo);

            $statement->bindValue(':descripcion', $descripcion);

            $statement->bindValue(':precio_unitario', $precio_unitario);

            $statement->execute();

        }

        header("HTTP/1.1 200 OK");

        echo json_encode($detallado);

        exit();

    }

    if (

        isset($_POST["numero_rectificar"]) &&

        isset($_POST["id_factura_manual_rectificar"]) &&

        isset($_POST["detallado_rectificar"])

    ) {

        $numero = $_POST["numero_rectificar"];

        $id_factura_manual = $_POST["id_factura_manual_rectificar"];

        $detallado = json_decode($_POST["detallado_rectificar"], true);

        $fecha = date("Y-m-d");



        $statement = $dbConn->prepare("INSERT INTO facturas_rectificadas (numero, id_factura_manual, fecha) VALUES (:numero, :id_factura_manual, :fecha)");

        $statement->bindValue(':numero', $numero);

        $statement->bindValue(':id_factura_manual', $id_factura_manual);

        $statement->bindValue(':fecha', $fecha);





        $statement->execute();

        $id_factura_rectificada = $dbConn->lastInsertId();





        foreach ($detallado as $apartado) {



            $titulo = ($apartado["titulo"] != "") ? $apartado["titulo"] : null;

            $cantidad = $apartado["cantidad"];

            $descripcion = $apartado["descripcion"];

            $precio_unitario = $apartado["precio_unitario"];

            $statement = $dbConn->prepare("INSERT INTO apartado_factura_rectificada (id_factura_rectificada, cantidad, descripcion, precio_unitario, titulo ) VALUES (:id_factura_rectificada, :cantidad, :descripcion, :precio_unitario, :titulo)");

            $statement->bindValue(':id_factura_rectificada', $id_factura_rectificada);

            $statement->bindValue(':cantidad', $cantidad);

            $statement->bindValue(':titulo', $titulo);

            $statement->bindValue(':descripcion', $descripcion);

            $statement->bindValue(':precio_unitario', $precio_unitario);

            $statement->execute();

        }

        header("HTTP/1.1 200 OK");

        echo json_encode($detallado);

        exit();

    }

    if (isset($_POST["importe"]) && isset($_POST["id_factura_manual"]) && isset($_POST["id_metodo"]) && isset($_POST["id_banco"]) && isset($_POST["fecha"])) {

        foreach ($_POST as $key => $value) {

            $value = ($value == "") ? null : $value;



            $value = ($value == "No") ? null : $value;

            $$key = $value;

        }



        $sql = "INSERT INTO pago_factura

            (importe, id_factura_manual, id_metodo, id_banco, fecha)

            VALUES

            (:importe, :id_factura_manual, :id_metodo, :id_banco, :fecha)";

        $statement = $dbConn->prepare($sql);

        $statement->bindValue(':importe', $importe);

        $statement->bindValue(':id_factura_manual', $id_factura_manual);

        $statement->bindValue(':id_metodo', $id_metodo);

        $statement->bindValue(':id_banco', $id_banco);

        $statement->bindValue(':fecha', $fecha);

        $statement->execute();

        $postId = $dbConn->lastInsertId();



        $input['id'] = $postId;

        $input['importe'] = $importe;

        $input['id_factura_manual'] = $id_factura_manual;

        $input['id_banco'] = $id_banco;

        $input['id_metodo'] = $id_metodo;

        $input['fecha'] = $fecha;

        header("HTTP/1.1 200 OK");

        echo json_encode($input);

        exit();

    }

}



if ($_SERVER['REQUEST_METHOD'] == 'DELETE') {



    if (isset($_GET["id_pago_factura"])) {

        $id_pago_factura = $_GET['id_pago_factura'];

        $statement = $dbConn->prepare("DELETE FROM pago_factura where id_pago_factura=:id_pago_factura");

        $statement->bindValue(':id_pago_factura', $id_pago_factura);

        $statement->execute();

        header("HTTP/1.1 200 OK");

        exit();

    }

    if (isset($_GET["id_factura_rectificada"])) {

        $id_factura_rectificada = $_GET['id_factura_rectificada'];

        $statement = $dbConn->prepare("DELETE FROM facturas_rectificadas where id_factura_rectificada=:id_factura_rectificada");

        $statement->bindValue(':id_factura_rectificada', $id_factura_rectificada);

        $statement->execute();

        header("HTTP/1.1 200 OK");

        exit();

    }

}











function formatearNumero($cadena)

{

    // Reemplazar la coma por el punto para asegurar el formato numérico correcto

    $cadena = str_replace(',', '.', $cadena);



    // Separar la parte entera de la decimal

    $partes = explode('.', $cadena);

    $parteEntera = $partes[0];

    $parteDecimal = isset($partes[1]) ? $partes[1] : '';



    // Formatear la parte entera con separadores de miles

    $parteEntera = number_format($parteEntera, 0, '', '.');



    // Unir la parte entera y decimal con el formato deseado

    $numeroFormateado = $parteEntera . ',' . $parteDecimal;



    return $numeroFormateado;

}





//En caso de que ninguna de las opciones anteriores se haya ejecutado

header("HTTP/1.1 400 Bad Request");