<?php

include "utils.php";

require_once (dirname(dirname(__FILE__)) . '/vendor/autoload.php');
require_once (dirname(dirname(__FILE__)) . '/core/configuration.php');
require_once dirname(dirname(__FILE__)) . '/libraries/Facturae-PHP/src/Common/KeyPairReaderTrait.php';
require_once dirname(dirname(__FILE__)) . '/libraries/Facturae-PHP/src/Common/FacturaeSigner.php';
require_once dirname(dirname(__FILE__)) . '/libraries/Facturae-PHP/src/Common/XmlTools.php';
require_once dirname(dirname(__FILE__)) . '/libraries/Facturae-PHP/src/FacturaeTraits/PropertiesTrait.php';
require_once dirname(dirname(__FILE__)) . '/libraries/Facturae-PHP/src/FacturaeTraits/UtilsTrait.php';
require_once dirname(dirname(__FILE__)) . '/libraries/Facturae-PHP/src/FacturaeTraits/SignableTrait.php';
require_once dirname(dirname(__FILE__)) . '/libraries/Facturae-PHP/src/FacturaeTraits/ExportableTrait.php';
require_once dirname(dirname(__FILE__)) . '/libraries/Facturae-PHP/src/Facturae.php';
require_once dirname(dirname(__FILE__)) . '/libraries/Facturae-PHP/src/FacturaeCentre.php';
require_once dirname(dirname(__FILE__)) . '/libraries/Facturae-PHP/src/FacturaeItem.php';
require_once dirname(dirname(__FILE__)) . '/libraries/Facturae-PHP/src/FacturaeParty.php';
require_once dirname(dirname(__FILE__)) . '/libraries/Facturae-PHP/src/FacturaePayment.php';

use josemmo\Facturae\Facturae;
use josemmo\Facturae\FacturaeCentre;
use josemmo\Facturae\FacturaeParty;
use josemmo\Facturae\FacturaePayment;
use josemmo\Facturae\FacturaeItem;
use josemmo\Facturae\Exception\InvalidFormatException;

$dbConn = connect($db);
/*
  listar todos los posts o solo uno
 */
if ($_SERVER['REQUEST_METHOD'] == 'POST') {
  header('Content-Type: text/plain');
  if (isset($_POST["eliminar_pfx"])) {
    $uploadDir = '../assets/firma/';

    // Verificar si existe un archivo en la carpeta y eliminar todo el contenido
    $files = glob($uploadDir . '*');
    foreach ($files as $file) {
      if (is_file($file)) {
        unlink($file);
      }
    }
    echo "Archivo .pfx eliminado con éxito.";


  }
  if (isset($_FILES["pfx"])) {
    $uploadDir = '../assets/firma/';

    // Verificar si existe un archivo en la carpeta
    $files = glob($uploadDir . '*');
    foreach ($files as $file) {
      if (is_file($file)) {
        unlink($file);
      }
    }

    // Mover el nuevo archivo a la carpeta
    $file = $_FILES["pfx"];
    $uploadPath = $uploadDir . basename($file['name']);

    if (move_uploaded_file($file['tmp_name'], $uploadPath)) {
      echo "Archivo subido con éxito.";
    } else {
      echo "Error al mover el archivo.";
    }
  }
}
if ($_SERVER['REQUEST_METHOD'] == 'GET') {
  $id = $_GET["id"];
  $firmado = $_GET["firmado"];
  $nombre_factura = $_GET["nombre"];
  $personalizacion = json_decode(file_get_contents('../personalizacion.json'), true);
  $sql = $dbConn->prepare("SELECT 
  f.*, 
  IFNULL(c.pais, 'No definido') AS pais,
  IFNULL(c.provincia, 'No definido') AS provincia,
  IFNULL(c.localidad, 'No definida') AS localidad
FROM 
  factura_manual_materiales f
LEFT JOIN 
  clientes c ON f.client_id = c.client_id
WHERE 
  f.id_factura_manual_materiales = :id_factura_manual_materiales;
");
  $sql->bindValue(':id_factura_manual_materiales', $id);
  $sql->execute();
  $factura = $sql->fetch(PDO::FETCH_ASSOC);

  //Cogemos los datos de la factura 
  $num_factura = $factura['numero'];
  $fecha = explode(" ", $factura['fecha'])[0];

  $email = $factura['email'];

  $cp = $factura['cp'];
  $nif = $factura['cif'];
  $pais = $factura['pais'];
 
  $provincia = $factura['provincia'];
  $localidad = $factura['localidad'];
  $direccion = $factura['direccion']; 

 
  // Dividir el string en partes usando la coma como delimitador
 

  $es_para_empresa = $factura['tipo'] === "Empresa" ? "true" : "false";

  //Cogemos los datos del cliente 
  $sql = $dbConn->prepare("SELECT * FROM clientes where client_id=:client_id");
  $sql->bindValue(':client_id', $factura['client_id']);
  $sql->execute();
  $user = $sql->fetch(PDO::FETCH_ASSOC);
  $nombre = explode(" ", $user['nombre'])[0];
  $apellido1 = explode(" ", $user['nombre'])[1];
  $apellido2 = is_null(explode(" ", $user['nombre'])[2]) ? " " : explode(" ", $user['nombre'])[2];
  $codigo_gestor = $user['codigo_gestor'];
  $codigo_tramitador = $user['codigo_tramitador'];
  $codigo_contable = $user['codigo_contable'];

  //Generamos facturae 
  $fac = new Facturae(Facturae::SCHEMA_3_2_1);
  $fac->setNumber('', $num_factura);
  $fac->setIssueDate($fecha);

  $fac->setSeller(new FacturaeParty([
    "taxNumber" => $personalizacion["cif"],
    "name" => $personalizacion["nombre"],
    "address" => $personalizacion["direccion"],
    "postCode" => $personalizacion["cp"],
    "town" => "Las Palmas de Gran Canaria",
    "province" => "Las Palmas"
  ]));
  if (!is_null($codigo_gestor) && !is_null($codigo_tramitador) && !is_null($codigo_contable)) {
    $fac->setBuyer(new FacturaeParty([
      "isLegalEntity" => $es_para_empresa,
      "taxNumber" => $nif,
      "name" => ($es_para_empresa) ? $user['nombre'] : $nombre . " " . $apellido1 . " " . $apellido2,
      "firstSurname" => $apellido1,
      "lastSurname" => $apellido2,
      "address" => $direccion,
      "postCode" => $cp,
      "town" => $localidad,
      "province" => $provincia,
      "centres" => [
        new FacturaeCentre([
          "role" => FacturaeCentre::ROLE_GESTOR,
          "code" => $codigo_gestor,
          "name" => ($es_para_empresa) ? $user['nombre'] : $nombre . " " . $apellido1 . " " . $apellido2,
          "address" => $direccion,
          "postCode" => $cp,
          "town" => $localidad,
          "province" => $provincia,
        ]),


        new FacturaeCentre([
          "role" => FacturaeCentre::ROLE_TRAMITADOR,
          "code" => $codigo_tramitador,
          "name" => ($es_para_empresa) ? $user['nombre'] : $nombre . " " . $apellido1 . " " . $apellido2,
          "address" => $direccion,
          "postCode" => $cp,
          "town" => $localidad,
          "province" => $provincia,
        ]),
        new FacturaeCentre([
          "role" => FacturaeCentre::ROLE_CONTABLE,
          "code" => $codigo_contable,
          "name" => ($es_para_empresa) ? $user['nombre'] : $nombre . " " . $apellido1 . " " . $apellido2,
          "address" => $direccion,
          "postCode" => $cp,
          "town" => $localidad,
          "province" => $provincia,
        ]),
      ]
    ]));
  } else {

    $fac->setBuyer(new FacturaeParty([
      "isLegalEntity" => $es_para_empresa,
      "taxNumber" => $nif,
      "name" => ($es_para_empresa) ? $user['nombre'] : $nombre . " " . $apellido1 . " " . $apellido2,
      "address" => $direccion,
          "postCode" => $cp,
          "town" => $localidad,
          "province" => $provincia,
    ]));
  }
 
  if($factura["id_banco"] != null){
    $sql = $dbConn->prepare("SELECT * FROM bancos where id_banco = :id_banco");
    $sql->bindValue(':id_banco', $factura["id_banco"]);
    $sql->execute();
    $banco = $sql->fetch(PDO::FETCH_ASSOC);
    $fac->addPayment(new FacturaePayment([
      "method" => FacturaePayment::TYPE_TRANSFER,
      "iban" => $banco["iban"]
  
    ]));}
  //$fac->setAdditionalInformation('En un lugar de la Mancha, de cuyo nombre no quiero acordarme, no ha mucho tiempo que vivía un hidalgo de los de lanza en astillero, adarga antigua, rocín flaco y galgo corredor.');

  $sql = $dbConn->prepare("SELECT * FROM apartado_factura_manual_materiales where id_factura_manual_materiales =:id_factura_manual_materiales");
  $sql->bindValue(':id_factura_manual_materiales', $factura['id_factura_manual_materiales']);
  $sql->execute();
  $sql->setFetchMode(PDO::FETCH_ASSOC);

  $detallado = $sql->fetchAll();
 $irpfPorcentaje = isset($factura['irpf']) ? floatval($factura['irpf']) : 0.00;
$descuento_factura = isset($factura['descuento']) ? floatval($factura['descuento']) : 0.00;

// Descuento global (porcentaje)
if ($descuento_factura > 0) {
  $fac->addDiscount('Descuento global de la factura', $descuento_factura); // No se especifica tipo
}

foreach ($detallado as $producto) {
  $precio_unitario = floatval($producto["precio_unitario"]);
  $descuento_apartado = isset($producto['descuento']) ? floatval($producto['descuento']) : 0.00;
$igic = isset($producto['igic']) ? floatval($producto['igic']) : 0.00;

// Si hay impuesto, usar tipo según valor

  if ($igic == 21.0) {
    $tipo_impuesto = Facturae::TAX_IVA;
  } else {
    $tipo_impuesto = Facturae::TAX_IGIC;
  }

  $taxes = [
    $tipo_impuesto => $igic
  ];


// Añadir IRPF si aplica
if ($irpfPorcentaje > 0) {
  $taxes[Facturae::TAX_IRPF] = $irpfPorcentaje;
}


  $item = new FacturaeItem([
    
    "name" => strip_tags($producto["descripcion"]),
    "quantity" => $producto["cantidad"] * $producto["dias"],
    "unitPriceWithoutTax" => round($precio_unitario, 2), 
    "taxes" =>  $taxes,
    "discounts" => $descuento_apartado > 0 ? [
      [
        "reason" => "Descuento individual",
        "rate" => $descuento_apartado 
      ]
    ] : []
  ]);

  $fac->addItem($item);
}



  if ($firmado == "1") {
    try {
      $firmaDir = realpath(__DIR__ . "/../assets/firma/");
      $pfxFiles = glob($firmaDir . "/*.pfx");

      if (count($pfxFiles) > 0) {
        // Usar el primer archivo .pfx encontrado
        $path_to_pfx = $pfxFiles[0];
        $res = $fac->sign($path_to_pfx, null, $personalizacion["pfx_password"]);
        if (!$res) {
          throw new Exception("Contraseña de firma digital incorrecta.");
        }
      } else {
        // Manejar el caso en que no se encuentre ningún archivo .pfx
        throw new Exception("No se encontró ningún archivo .pfx en la carpeta de firma.");
      }
    } catch (Exception $e) {
      // Captura cualquier excepción y maneja el error
      header('Content-Type: application/json');
      echo json_encode(['success' => false, 'error' => $e->getMessage()]);
      exit;
    }
  }

  $filename = dirname(dirname(__FILE__)) . "/assets/" . basename($nombre_factura) . ".xml";
  $fac->export($filename);
$xml = simplexml_load_file($filename);
$jsonData = json_encode($xml); // Convertimos el XML a JSON
  $url = WEBSITE_URL . "assets/" . basename($nombre_factura) . ".xml";
  // Devolver la URL del archivo como respuesta JSON
  header('Content-Type: application/json');
  echo json_encode(['success' => true, 'url' => $url, 'parseado' =>json_decode($jsonData, true)]);
  exit;
}