 <?php



  include "utils.php";



  require_once(dirname(dirname(__FILE__)) . '/vendor/autoload.php');

  require_once(dirname(dirname(__FILE__)) . '/core/configuration.php');

  require_once dirname(dirname(__FILE__)) . '/libraries/Facturae-PHP/src/Common/KeyPairReaderTrait.php';

  require_once dirname(dirname(__FILE__)) . '/libraries/Facturae-PHP/src/Common/FacturaeSigner.php';

  require_once dirname(dirname(__FILE__)) . '/libraries/Facturae-PHP/src/Common/XmlTools.php';

  require_once dirname(dirname(__FILE__)) . '/libraries/Facturae-PHP/src/FacturaeTraits/PropertiesTrait.php';

  require_once dirname(dirname(__FILE__)) . '/libraries/Facturae-PHP/src/FacturaeTraits/UtilsTrait.php';

  require_once dirname(dirname(__FILE__)) . '/libraries/Facturae-PHP/src/FacturaeTraits/SignableTrait.php';

  require_once dirname(dirname(__FILE__)) . '/libraries/Facturae-PHP/src/FacturaeTraits/ExportableTrait.php';

  require_once dirname(dirname(__FILE__)) . '/libraries/Facturae-PHP/src/Facturae.php';

  require_once dirname(dirname(__FILE__)) . '/libraries/Facturae-PHP/src/FacturaeCentre.php';

  require_once dirname(dirname(__FILE__)) . '/libraries/Facturae-PHP/src/FacturaeItem.php';

  require_once dirname(dirname(__FILE__)) . '/libraries/Facturae-PHP/src/FacturaeParty.php';

  require_once dirname(dirname(__FILE__)) . '/libraries/Facturae-PHP/src/FacturaePayment.php';



  use josemmo\Facturae\Facturae;

  use josemmo\Facturae\FacturaeCentre;

  use josemmo\Facturae\FacturaeParty;

  use josemmo\Facturae\FacturaePayment;

  use josemmo\Facturae\FacturaeItem;

  use josemmo\Facturae\Exception\InvalidFormatException;



  $dbConn = connect($db);

  /*

  listar todos los posts o solo uno

 */

  if ($_SERVER['REQUEST_METHOD'] == 'POST') {

    header('Content-Type: text/plain');

    if (isset($_POST["eliminar_pfx"])) {

      $uploadDir = '../assets/firma/';



      // Verificar si existe un archivo en la carpeta y eliminar todo el contenido

      $files = glob($uploadDir . '*');

      foreach ($files as $file) {

        if (is_file($file)) {

          unlink($file);
        }
      }

      echo "Archivo .pfx eliminado con éxito.";
    }

    if (isset($_FILES["pfx"])) {

      $uploadDir = '../assets/firma/';



      // Verificar si existe un archivo en la carpeta

      $files = glob($uploadDir . '*');

      foreach ($files as $file) {

        if (is_file($file)) {

          unlink($file);
        }
      }



      // Mover el nuevo archivo a la carpeta

      $file = $_FILES["pfx"];

      $uploadPath = $uploadDir . basename($file['name']);



      if (move_uploaded_file($file['tmp_name'], $uploadPath)) {

        echo "Archivo subido con éxito.";
      } else {

        echo "Error al mover el archivo.";
      }
    }
  }

  if ($_SERVER['REQUEST_METHOD'] == 'GET') {

    $id = $_GET["id"];

    $firmado = $_GET["firmado"];

    $nombre_factura = $_GET["nombre"];

    $personalizacion = json_decode(file_get_contents('../personalizacion.json'), true);

    $sql = $dbConn->prepare("SELECT * FROM factura_manual where id_factura_manual = :id_factura_manual");

    $sql->bindValue(':id_factura_manual', $id);

    $sql->execute();

    $factura = $sql->fetch(PDO::FETCH_ASSOC);



    //Cogemos los datos de la factura 

    $num_factura = $factura['numero'];

    $fecha = explode(" ", $factura['fecha'])[0];



    $email = $factura['email'];



    $cp = $factura['cp'];

    $nif = $factura['cif'];

    

    // Obtener las partes individuales




    $es_para_empresa = $factura['tipo'] === "Empresa" ? "true" : "false";



    //Cogemos los datos del cliente 

    $sql = $dbConn->prepare("SELECT * FROM clientes where client_id=:client_id");

    $sql->bindValue(':client_id', $factura['client_id']);

    $sql->execute();

    $user = $sql->fetch(PDO::FETCH_ASSOC);

    $nombre = explode(" ", $user['nombre'])[0];

    $apellido1 = explode(" ", $user['nombre'])[1];

    $apellido2 = is_null(explode(" ", $user['nombre'])[2]) ? " " : explode(" ", $user['nombre'])[2];

    $codigo_gestor = $user['codigo_gestor'];

    $codigo_tramitador = $user['codigo_tramitador'];

    $codigo_contable = $user['codigo_contable'];


    $provincia = $user['provincia'];
    $localidad = $user['localidad'];
    $direccion = $user['direccion'];



    //Generamos facturae 

    $fac = new Facturae(Facturae::SCHEMA_3_2_1);

    $fac->setNumber('', $num_factura);

    $fac->setIssueDate($fecha);



    $fac->setSeller(new FacturaeParty([

      "taxNumber" => $personalizacion["cif"],

      "name" => $personalizacion["nombre"],

      "address" => $personalizacion["direccion"],

      "postCode" => $personalizacion["cp"],

      "town" => "Las Palmas de Gran Canaria",

      "province" => "Las Palmas"

    ]));

    if (!is_null($codigo_gestor) && !is_null($codigo_tramitador) && !is_null($codigo_contable)) {

      $fac->setBuyer(new FacturaeParty([

        "isLegalEntity" => $es_para_empresa,

        "taxNumber" => $nif,

        "name" => $nombre . " " . $apellido1 . " " . $apellido2,

        "firstSurname" => $apellido1,

        "lastSurname" => $apellido2,

        "address" => $direccion,

        "postCode" => $cp,

        "town" => $localidad,

        "province" => $provincia,

        "centres" => [

          new FacturaeCentre([

            "role" => FacturaeCentre::ROLE_GESTOR,

            "code" => $codigo_gestor,

            "name" => $nombre . " " . $apellido1 . " " . $apellido2,

            "address" => $direccion,

            "postCode" => $cp,

            "town" => $localidad,

            "province" => $provincia,

          ]),





          new FacturaeCentre([

            "role" => FacturaeCentre::ROLE_TRAMITADOR,

            "code" => $codigo_tramitador,

            "name" => $nombre . " " . $apellido1 . " " . $apellido2,

            "address" => $direccion,

            "postCode" => $cp,

            "town" => $localidad,

            "province" => $provincia,

          ]),

          new FacturaeCentre([

            "role" => FacturaeCentre::ROLE_CONTABLE,

            "code" => $codigo_contable,

            "name" => $nombre . " " . $apellido1 . " " . $apellido2,

            "address" => $direccion,

            "postCode" => $cp,

            "town" => $localidad,

            "province" => $provincia,

          ]),

        ]

      ]));
    } else {



      $fac->setBuyer(new FacturaeParty([

        "isLegalEntity" => $es_para_empresa,

        "taxNumber" => $nif,

        "name" => $nombre . " " . $apellido1 . " " . $apellido2,

        "address" => $direccion,

        "postCode" => $cp,

        "town" => $localidad,

        "province" => $provincia,

      ]));
    }



    if (!is_null($factura['id_banco']) && !empty($factura['id_banco'])) {

      $sql = $dbConn->prepare("SELECT * FROM bancos where id_banco=:id_banco");

      $sql->bindValue(':id_banco', $factura['id_banco']);

      $sql->execute();

      $banco = $sql->fetch(PDO::FETCH_ASSOC);



      $fac->addPayment(new FacturaePayment([

        "method" => FacturaePayment::TYPE_TRANSFER,

        "iban" => $banco["iban"],

        "bic" => $banco["swift"]



      ]));
    } else {

      $fac->addPayment(new FacturaePayment([

        "method" => FacturaePayment::TYPE_TRANSFER,

        "iban" => $personalizacion["iban_empresa"],

        "bic" => $personalizacion["swift_bancaria_empresa"]



      ]));
    }



    //$fac->setAdditionalInformation('En un lugar de la Mancha, de cuyo nombre no quiero acordarme, no ha mucho tiempo que vivía un hidalgo de los de lanza en astillero, adarga antigua, rocín flaco y galgo corredor.');



    $sql = $dbConn->prepare("SELECT * FROM apartado_factura_manual where id_factura_manual =:id_factura_manual");

    $sql->bindValue(':id_factura_manual', $factura['id_factura_manual']);

    $sql->execute();

    $sql->setFetchMode(PDO::FETCH_ASSOC);



    $detallado = $sql->fetchAll();

    $irpfPorcentaje = ($factura['irpf'] != null) ? $factura['irpf'] : 0.00;

    foreach ($detallado as $producto) {

      $precio_con_iva = $producto["precio_unitario"];

      $impuesto = $producto['igic'];

      $impuesto = floatVal($impuesto);



      $percentage = $impuesto / 100;

      $result = $precio_con_iva * $percentage;

      // $result = $precio_con_iva * 0.07;

      $precio = $precio_con_iva + $result;

      $tipo_impuesto = $impuesto == 21 ? Facturae::TAX_IVA : Facturae::TAX_IGIC;

      $titulo = ($producto['titulo'] != null) ? $producto['titulo'] : "";



      //$fac->addItem($producto["descripcion"], $precio, $producto["cantidad"], $tipo_impuesto, $impuesto);



      $fac->addItem(new FacturaeItem([

        "name" => $titulo,

        "description" => $producto["descripcion"],

        "quantity" => $producto["cantidad"], // Esto es opcional, es el valor por defecto si se omite

        "unitPriceWithoutTax" => $precio_con_iva,

        "taxes" => [

          $tipo_impuesto => $impuesto,

          Facturae::TAX_IRPF => $irpfPorcentaje

        ]

      ]));
    }



    if ($firmado == "1") {

      try {

        $firmaDir = realpath(__DIR__ . "/../assets/firma/");

        if (!$firmaDir) {

          throw new Exception("La carpeta de firma no existe o no es accesible.");
        }



        $certExtensions = ['pfx', 'p12', 'crt', 'cer', 'pem'];

        $certFiles = [];



        foreach ($certExtensions as $ext) {

          $certFiles = array_merge($certFiles, glob($firmaDir . "/*.$ext"));
        }



        if (count($certFiles) > 0) {

          $path_to_cert = $certFiles[0];

          $res = $fac->sign($path_to_cert, null, $personalizacion["pfx_password"]);
        } else {

          // Manejar el caso en que no se encuentre ningún archivo de certificado

          throw new Exception("No se encontró ningún archivo de certificado en la carpeta de firma.");
        }
      } catch (Exception $e) {

        // Captura cualquier excepción y maneja el error

        header('Content-Type: application/json');

        echo json_encode(['success' => false, 'error' => $e->getMessage()]);

        exit;
      }





      $filename = dirname(dirname(__FILE__)) . "/assets/" . basename($nombre_factura) . ".xsig";

      $fac->export($filename);

      $url = WEBSITE_URL . "assets/" . basename($nombre_factura) . ".xsig";
    } else {

      $filename = dirname(dirname(__FILE__)) . "/assets/" . basename($nombre_factura) . ".xml";

      $fac->export($filename);

      $url = WEBSITE_URL . "assets/" . basename($nombre_factura) . ".xml";
    }



    // Devolver la URL del archivo como respuesta JSON

    header('Content-Type: application/json');

    echo json_encode(['success' => true, 'url' => $url, 'firmado' => $firmado]);

    exit;
  }