<?php



include "utils.php";



$dbConn = connect($db);



/*

listar todos los posts o solo uno

*/

if ($_SERVER['REQUEST_METHOD'] == 'GET') {

    if (isset($_GET['id'])) {

        //Mostrar un post

        $sql = $dbConn->prepare("SELECT * FROM factura_proveedor where id_factura_proveedor=:id");

        $sql->bindValue(':id', $_GET['id']);

        $sql->execute();

        header("HTTP/1.1 200 OK");

        echo json_encode($sql->fetch(PDO::FETCH_ASSOC));

        exit();

    }

    if (isset($_GET['id_factura_proveedor'])) {



        //Mostrar un post

        $sql = $dbConn->prepare("SELECT SUM(importe) as total_pagado

        FROM pago_proveedor

        WHERE id_factura_proveedor = :id_factura_proveedor");

        $sql->bindValue(':id_factura_proveedor', $_GET['id_factura_proveedor']);

        $sql->execute();

        $result = $sql->fetch(PDO::FETCH_ASSOC);

        $totalPagado = $result['total_pagado'];

        header("HTTP/1.1 200 OK");

        echo json_encode($totalPagado);

        exit();

    }

    if (isset($_GET['id_factura_proveedor_archivos'])) {

        $id_factura_proveedor = $_GET["id_factura_proveedor_archivos"];

        $images = glob('../archivos/factura_proveedor/' . $id_factura_proveedor . '/*.{png,jpg,pdf}', GLOB_BRACE);

        $fileObjects = array();



        foreach ($images as $image) {

            $fileInfo = pathinfo($image);

            $fileObject = new stdClass(); // Crear un objeto vacío para almacenar los datos

            $fileObject->url = $image; // Almacenar la URL del archivo

            $fileObject->extension = $fileInfo['extension']; // Almacenar la extensión del archivo

            $fileObject->nombre = $fileInfo['basename']; // Almacenar la extensión del archivo



            $fileObjects[] = $fileObject; // Agregar el objeto al arreglo

        }

        header("HTTP/1.1 200 OK");

        echo json_encode($fileObjects);

        exit();

    }

    if (isset($_GET['fecha_i']) && isset($_GET['fecha_i'])) {

        $fecha_i = $_GET['fecha_i'];

        $fecha_f = $_GET['fecha_f'];

        if ($fecha_i == "No" && $fecha_f == "No") {



            $sql = "SELECT * FROM `factura_proveedor`";

            $stmt = $dbConn->prepare($sql);



            $stmt->execute();

            $facturasProveedor = $stmt->fetchAll(PDO::FETCH_OBJ);

            $total_pagado = 0;

            $total_pendiente = 0;

            foreach ($facturasProveedor as $factura) {



                $sql = "SELECT SUM(importe) as total_pagado FROM `pago_proveedor` WHERE id_factura_proveedor = :id_factura_proveedor";

                $stmt = $dbConn->prepare($sql);

                $stmt->bindParam(':id_factura_proveedor', $factura->id_factura_proveedor);

                $stmt->execute();

                $importe = $factura->importe;

                $pagado = $stmt->fetchAll(PDO::FETCH_OBJ)[0]->total_pagado;

                $total_pagado += floatval($pagado);

                $total_pendiente += floatval($importe) - floatval($pagado);

            }





            $facturas["total_pagado"] = number_format($total_pagado, 2, '.', '');

            $facturas["total_pendiente"] = number_format($total_pendiente, 2, '.', '');





            // Devolver objeto de clientes

            header("HTTP/1.1 200 OK");

            echo json_encode($facturas);

            exit();

        } else {



            $sql = "SELECT * FROM `factura_proveedor` WHERE DATE_FORMAT(fecha, '%Y-%m-%d') BETWEEN :fecha_i AND :fecha_f";

            $stmt = $dbConn->prepare($sql);

            $stmt->bindParam(':fecha_i', $fecha_i);

            $stmt->bindParam(':fecha_f', $fecha_f);

            $stmt->execute();

            $facturasProveedor = $stmt->fetchAll(PDO::FETCH_OBJ);

            $total_pagado = 0;

            $total_pendiente = 0;

            foreach ($facturasProveedor as $factura) {



                $sql = "SELECT SUM(importe) as total_pagado FROM `pago_proveedor` WHERE id_factura_proveedor = :id_factura_proveedor";

                $stmt = $dbConn->prepare($sql);

                $stmt->bindParam(':id_factura_proveedor', $factura->id_factura_proveedor);

                $stmt->execute();

                $importe = $factura->importe;

                $pagado = $stmt->fetchAll(PDO::FETCH_OBJ)[0]->total_pagado;

                $total_pagado += floatval($pagado);

                $total_pendiente += floatval($importe) - floatval($pagado);

            }





            $facturas["total_pagado"] = number_format($total_pagado, 2, '.', '');

            $facturas["total_pendiente"] = number_format($total_pendiente, 2, '.', '');





            // Devolver objeto de clientes

            header("HTTP/1.1 200 OK");

            echo json_encode($facturas);

            exit();

        }

    } else {



        //Mostrar lista de post

        $sql = $dbConn->prepare("SELECT c.*, e.nombre AS nombre 

     FROM factura_proveedor c

     INNER JOIN proveedores e ON c.id_proveedor = e.id_proveedor");

        $sql->execute();

        $sql->setFetchMode(PDO::FETCH_ASSOC);

        $facturas = $sql->fetchAll(PDO::FETCH_OBJ);



        foreach ($facturas as $f) {



            $id_factura_proveedor = $f->id_factura_proveedor;

            $sql = "SELECT c.*,  COALESCE(m.nombre, 'Ninguno') AS metodo ,  COALESCE(b.nombre, 'Ninguno') AS banco 

         FROM pago_proveedor c

         LEFT JOIN bancos b ON c.id_banco = b.id_banco

         LEFT JOIN metodos_pago m ON c.id_metodo = m.id_metodo

         WHERE id_factura_proveedor = :id_factura_proveedor";

            $stmt = $dbConn->prepare($sql);

            $stmt->bindParam(':id_factura_proveedor', $id_factura_proveedor, PDO::PARAM_INT);

            $stmt->execute();

            // Obtener el resultado como un objeto

            $pagos = $stmt->fetchAll(PDO::FETCH_OBJ);

            $f->pagos = $pagos;

            if (COUNT($pagos) > 0) {

                $sql = "SELECT SUM(importe) as total_pagado FROM pago_proveedor WHERE id_factura_proveedor = :id_factura_proveedor";

                $stmt = $dbConn->prepare($sql);

                $stmt->bindParam(':id_factura_proveedor', $id_factura_proveedor, PDO::PARAM_INT);

                $stmt->execute();

                // Obtener el resultado como un objeto

                $total_pagado = $stmt->fetch(PDO::FETCH_ASSOC);

                $f->total_pagado = $total_pagado["total_pagado"];

            } else {

                $f->total_pagado = "0.00";

            }

        }



        header("HTTP/1.1 200 OK");



        echo json_encode($facturas);

        exit();

    }

}



// Crear un nuevo post

if ($_SERVER['REQUEST_METHOD'] == 'POST') {



    if (isset($_POST["importe"]) && isset($_POST["id_proveedor"]) && isset($_POST["fecha_vencimiento"]) && isset($_POST["numero"]) && isset($_POST["fecha"])) {



        foreach ($_POST as $key => $value) {

            $value = ($value == "") ? null : $value;

            $value = ($value == "No") ? null : $value;

            $$key = $value;

        }



        $sql = "INSERT INTO factura_proveedor

            (importe, id_proveedor, fecha_vencimiento, numero, fecha)

            VALUES

            (:importe, :id_proveedor, :fecha_vencimiento, :numero, :fecha)";



        $statement = $dbConn->prepare($sql);

        $statement->bindValue(':importe', $importe);

        $statement->bindValue(':id_proveedor', $id_proveedor);

        $statement->bindValue(':fecha_vencimiento', $fecha_vencimiento);

        $statement->bindValue(':numero', $numero);

        $statement->bindValue(':fecha', $fecha);

        $statement->execute();

        $id_factura_proveedor = $dbConn->lastInsertId();





        $carpetaNuevaAlumno = '../archivos/factura_proveedor/' . $id_factura_proveedor;



        mkdir($carpetaNuevaAlumno, 0777, true);



        $input['id'] = $id_factura_proveedor;

        $input['importe'] = $importe;

        $input['id_proveedor'] = $id_proveedor;

        $input['fecha_vencimiento'] = $fecha_vencimiento;

        $input['numero'] = $numero;

        $input['fecha'] = $fecha;

        header("HTTP/1.1 200 OK");

        echo json_encode($input);

        exit();

    }

    if (isset($_POST["importe"]) && isset($_POST["id_factura_proveedor"]) && isset($_POST["id_metodo"]) && isset($_POST["id_banco"]) && isset($_POST["fecha"])) {

        foreach ($_POST as $key => $value) {

            $value = ($value == "") ? null : $value;

            $value = ($value == "No") ? null : $value;

            $$key = $value;

        }



        $sql = "INSERT INTO pago_proveedor

        (importe, id_factura_proveedor, id_metodo, id_banco, fecha)

        VALUES

        (:importe, :id_factura_proveedor, :id_metodo, :id_banco, :fecha)";

        $statement = $dbConn->prepare($sql);

        $statement->bindValue(':importe', $importe);

        $statement->bindValue(':id_factura_proveedor', $id_factura_proveedor);

        $statement->bindValue(':id_metodo', $id_metodo);

        $statement->bindValue(':id_banco', $id_banco);

        $statement->bindValue(':fecha', $fecha);

        $statement->execute();

        $postId = $dbConn->lastInsertId();



        $input['id'] = $postId;

        $input['importe'] = $importe;

        $input['id_factura_proveedor'] = $id_factura_proveedor;

        $input['id_banco'] = $id_banco;

        $input['id_metodo'] = $id_metodo;

        $input['fecha'] = $fecha;

        header("HTTP/1.1 200 OK");

        echo json_encode($input);

        exit();

    }

    if (

        isset($_POST["id_factura_proveedor_archivo"]) && isset($_FILES['archivo']) && isset($_POST['extension'])

        && isset($_POST['nombre'])

    ) {

        $nombre = $_POST["nombre"];

        $extension = $_POST["extension"];

        $id_factura_proveedor = $_POST["id_factura_proveedor_archivo"];

        $archivo = $_FILES['archivo'];

        $baseUrl = ($_SERVER['HTTPS'] ? 'https://' : 'http://') . $_SERVER['HTTP_HOST'] . '/';

        $rutaArchivoTemporal = isset($_FILES['archivo']) ? $_FILES['archivo']['tmp_name'] : null;

        $Archivo = '../archivos/factura_proveedor/' . $id_factura_proveedor . '/' . $nombre . '.' . $extension;

        if (file_exists($Archivo)) {



            header("HTTP/1.1 200 OK");

            echo 0;

            exit();

        } else {

            if ($rutaArchivoTemporal && !empty($rutaArchivoTemporal)) {

                move_uploaded_file($rutaArchivoTemporal, $Archivo);

            }

            header("HTTP/1.1 200 OK");

            exit();

        }

    }

}



if ($_SERVER['REQUEST_METHOD'] == 'DELETE') {

    if (isset($_GET["id_pago_proveedor"])) {

        $id_pago_proveedor = $_GET['id_pago_proveedor'];

        $statement = $dbConn->prepare("DELETE FROM pago_proveedor where id_pago_proveedor=:id_pago_proveedor");

        $statement->bindValue(':id_pago_proveedor', $id_pago_proveedor);

        $statement->execute();

        header("HTTP/1.1 200 OK");

        exit();

    }



    if (isset($_GET["id_factura_proveedor"])) {

        $id_factura_proveedor = $_GET['id_factura_proveedor'];

        $statement = $dbConn->prepare("DELETE FROM factura_proveedor where id_factura_proveedor=:id_factura_proveedor");

        $statement->bindValue(':id_factura_proveedor', $id_factura_proveedor);

        $statement->execute();

        $carpetaEliminar = '../archivos/factura_proveedor/' . $id_factura_proveedor;

        eliminarCarpeta($carpetaEliminar);

        header("HTTP/1.1 200 OK");

        exit();

    }

    if (isset($_GET["url"])) {

        $url = $_GET['url'];

        $carpetaEliminar = '.' . $url;



        header("HTTP/1.1 200 OK");

        unlink($carpetaEliminar);

        echo $carpetaEliminar;

        exit();

    }

}



//Actualizar

if ($_SERVER['REQUEST_METHOD'] == 'PUT') {

    $input = $_GET;

    $postId = $input['id'];

    $fields = getParams($input);



    $sql = "

          UPDATE posts

          SET $fields

          WHERE id='$postId'

           ";



    $statement = $dbConn->prepare($sql);

    bindAllValues($statement, $input);



    $statement->execute();

    header("HTTP/1.1 200 OK");

    exit();

}

function eliminarCarpeta($rutaCarpeta)

{

    // Obtener una lista de archivos y subcarpetas dentro de la carpeta

    $archivos = glob($rutaCarpeta . '/*');



    // Eliminar cada archivo encontrado

    foreach ($archivos as $archivo) {

        if (is_file($archivo)) {

            unlink($archivo);

        } elseif (is_dir($archivo)) {

            eliminarCarpeta($archivo);

        }

    }



    // Eliminar la carpeta

    if (is_dir($rutaCarpeta)) {

        rmdir($rutaCarpeta);

    }

}

//En caso de que ninguna de las opciones anteriores se haya ejecutado

header("HTTP/1.1 400 Bad Request");