<?php



include "utils.php";



$dbConn = connect($db);



/*

listar todos los posts o solo uno

*/



if ($_SERVER['REQUEST_METHOD'] == 'GET') {

    if (isset($_GET['anos'])) {

        $sql = $dbConn->prepare("SELECT DISTINCT YEAR(fecha) AS ano

        FROM factura_manual

        ORDER BY ano;");

        // $sql->bindValue(':id_factura_manual', $_GET['id_factura_manual']);

        $sql->execute();

        $result = $sql->fetchAll(PDO::FETCH_ASSOC);

        header("HTTP/1.1 200 OK");

        echo json_encode($result);

        exit();

    }

    if (isset($_GET['total'])) {

        $mes = isset($_GET['mes']) ? $_GET['mes'] : null;

        $ano = isset($_GET['ano']) ? $_GET['ano'] : null;

        $client_id = (isset($_GET['client_id']) && $_GET['client_id'] != "No") ? $_GET['client_id'] : null;

        $trimestre = isset($_GET['trimestre']) ? $_GET['trimestre'] : null;



        // Convertir el nombre del mes en español a un número de mes

        $mesNumero = $mes ? getMonthNumber($mes) : null;



        // Definir las fechas de inicio y fin del trimestre si se proporciona

        if ($trimestre && $ano) {

            switch ($trimestre) {

                case '1t':

                    $fechaInicio = "$ano-01-01";

                    $fechaFin = "$ano-03-31";

                    break;

                case '2t':

                    $fechaInicio = "$ano-04-01";

                    $fechaFin = "$ano-06-30";

                    break;

                case '3t':

                    $fechaInicio = "$ano-07-01";

                    $fechaFin = "$ano-09-30";

                    break;

                case '4t':

                    $fechaInicio = "$ano-10-01";

                    $fechaFin = "$ano-12-31";

                    break;

                default:

                    $fechaInicio = null;

                    $fechaFin = null;

            }

        } else {

            $fechaInicio = null;

            $fechaFin = null;

        }



        // Construir la consulta SQL dinámicamente

        $whereClauses = [];

        if ($mesNumero && $ano) {

            $whereClauses[] = "EXTRACT(MONTH FROM fm.fecha) = :mes AND EXTRACT(YEAR FROM fm.fecha) = :ano";

        } elseif ($ano) {

            $whereClauses[] = "EXTRACT(YEAR FROM fm.fecha) = :ano";

        }

        if ($fechaInicio && $fechaFin) {

            $whereClauses[] = "fm.fecha BETWEEN :fechaInicio AND :fechaFin";

        }

        if ($client_id) {

            $whereClauses[] = "fm.client_id = :client_id";

        }

        $whereSql = !empty($whereClauses) ? "WHERE " . implode(" AND ", $whereClauses) : "";



        $sql = $dbConn->prepare("WITH TotalBase AS (

            SELECT

                SUM(COALESCE(r.precio_unitario, a.precio_unitario) * COALESCE(r.cantidad, a.cantidad)) AS total_base

            FROM

                apartado_factura_manual a

            LEFT JOIN

                factura_manual fm ON a.id_factura_manual = fm.id_factura_manual

            LEFT JOIN

                apartado_factura_rectificada r ON a.id_apartado_factura_manual = r.id_apartado_factura_manual

            LEFT JOIN

                facturas_rectificadas fr ON r.id_factura_rectificada = fr.id_factura_rectificada

            $whereSql

        ), TotalIgic AS (

            SELECT

                SUM(COALESCE(r.precio_unitario, a.precio_unitario) * COALESCE(r.cantidad, a.cantidad) * (COALESCE(r.igic, a.igic) / 100)) AS total_igic_sumado

            FROM

                apartado_factura_manual a

            LEFT JOIN

                factura_manual fm ON a.id_factura_manual = fm.id_factura_manual

            LEFT JOIN

                apartado_factura_rectificada r ON a.id_apartado_factura_manual = r.id_apartado_factura_manual

            LEFT JOIN

                facturas_rectificadas fr ON r.id_factura_rectificada = fr.id_factura_rectificada

            $whereSql

        ), IgicDetails AS (

            SELECT

                COALESCE(r.igic, a.igic) AS igic,

                SUM(COALESCE(r.precio_unitario, a.precio_unitario) * COALESCE(r.cantidad, a.cantidad)) AS total_base_por_igic,

                SUM(COALESCE(r.precio_unitario, a.precio_unitario) * COALESCE(r.cantidad, a.cantidad) * (COALESCE(r.igic, a.igic) / 100)) AS total_igic

            FROM

                apartado_factura_manual a

            LEFT JOIN

                factura_manual fm ON a.id_factura_manual = fm.id_factura_manual

            LEFT JOIN

                apartado_factura_rectificada r ON a.id_apartado_factura_manual = r.id_apartado_factura_manual

            LEFT JOIN

                facturas_rectificadas fr ON r.id_factura_rectificada = fr.id_factura_rectificada

            $whereSql

            GROUP BY

                COALESCE(r.igic, a.igic)

        )

        SELECT

            (SELECT total_base FROM TotalBase) AS total_base_sin_igic,

            (SELECT total_igic_sumado FROM TotalIgic) AS total_igic_sumado,

            JSON_ARRAYAGG(

                JSON_OBJECT(

                    'igic', igic,

                    'total_base_por_igic', total_base_por_igic,

                    'total_igic', total_igic

                )

            ) AS igics

        FROM

            IgicDetails;

        ");



        // Vincular parámetros si es necesario

        if ($mesNumero && $ano) {

            $sql->bindValue(':mes', $mesNumero, PDO::PARAM_INT);

            $sql->bindValue(':ano', $ano, PDO::PARAM_INT);

        } elseif ($ano) {

            $sql->bindValue(':ano', $ano, PDO::PARAM_INT);

        }

        if ($fechaInicio && $fechaFin) {

            $sql->bindValue(':fechaInicio', $fechaInicio, PDO::PARAM_STR);

            $sql->bindValue(':fechaFin', $fechaFin, PDO::PARAM_STR);

        }

        if ($client_id) {

            $sql->bindValue(':client_id', $client_id, PDO::PARAM_INT);

        }



        // Ejecutar la consulta

        $sql->execute();

        $result = $sql->fetch(PDO::FETCH_ASSOC);



        // Decodificar el arreglo JSON de 'igics'

        $i = json_decode($result["igics"], true);

        if ($i) {

            $i[] = [

                'igic' => 'Total',

                'total_base_por_igic' => $result['total_base_sin_igic'],

                'total_igic' => $result['total_igic_sumado']

            ];

        } else {

            $i = [];

        }



        $sql = $dbConn->prepare("SELECT 

            COALESCE(afr.id_apartado_factura_rectificada, afm.id_apartado_factura_manual) AS id,

            COALESCE(afr.titulo, afm.titulo) AS titulo,

            COALESCE(al.numero, 'Ninguno') AS numero_albaran,

            COALESCE(afm.codigo) AS codigo,

            COALESCE(afr.descripcion, afm.descripcion) AS descripcion,

            COALESCE(afr.igic, afm.igic) AS igic,

            COALESCE(afr.precio_unitario, afm.precio_unitario) AS precio_unitario,

            COALESCE(afr.cantidad, afm.cantidad) AS cantidad,

            COALESCE(fr.numero, fm.numero) AS numero,

            COALESCE(fm.fecha) AS fecha,

            fm.client_id,

            cl.nombre 

        FROM 

            apartado_factura_manual afm

        LEFT JOIN 

            apartado_factura_rectificada afr ON afm.id_apartado_factura_manual = afr.id_apartado_factura_manual

             LEFT JOIN 

            albaranes al ON al.id_albaran = afm.id_albaran

        LEFT JOIN 

            facturas_rectificadas fr ON afr.id_factura_rectificada = fr.id_factura_rectificada

        JOIN 

            factura_manual fm ON afm.id_factura_manual = fm.id_factura_manual

              JOIN 

            clientes cl ON cl.client_id = fm.client_id

        $whereSql

        ");



        // Vincular parámetros si es necesario

        if ($mesNumero && $ano) {

            $sql->bindValue(':mes', $mesNumero, PDO::PARAM_INT);

            $sql->bindValue(':ano', $ano, PDO::PARAM_INT);

        } elseif ($ano) {

            $sql->bindValue(':ano', $ano, PDO::PARAM_INT);

        }

        if ($fechaInicio && $fechaFin) {

            $sql->bindValue(':fechaInicio', $fechaInicio, PDO::PARAM_STR);

            $sql->bindValue(':fechaFin', $fechaFin, PDO::PARAM_STR);

        }

        if ($client_id) {

            $sql->bindValue(':client_id', $client_id, PDO::PARAM_INT);

        }



        // Ejecutar la consulta

        $sql->execute();

        $result2 = $sql->fetchAll(PDO::FETCH_ASSOC);



        $input["igics"] = $i;

        $input["apartados"] = $result2;



        // Enviar la respuesta

        header("HTTP/1.1 200 OK");

        echo json_encode($input, JSON_PRETTY_PRINT);

        exit();

    } elseif (isset($_GET['id'])) {

        if ($_GET['id'] == "No") {

            // Si no se encuentra la factura_manual

            header("HTTP/1.1 200 OK");

            $input["apartados"] = [];

            echo json_encode($input);

            exit();

        }

        try {

            // Obtener la factura_manual



            $sql = $dbConn->prepare("SELECT 

                f.*, 

                ROUND(COALESCE(SUM(a.cantidad * a.precio_unitario * (a.igic / 100)), 0), 2) AS igic_sumado,

                ROUND(

                    COALESCE(SUM(a.cantidad * a.precio_unitario * (a.igic / 100)), 0) + 

                    f.importe - 

                    COALESCE(f.importe * (f.irpf / 100), 0), 

                    2

                ) AS importe_calculado,

                c.nombre AS nombre_cliente,

                c.client_id,

                c.codigo AS codigo_cliente

            FROM 

                factura_manual f

            JOIN 

                clientes c ON f.client_id = c.client_id

            LEFT JOIN 

                apartado_factura_manual a ON f.id_factura_manual = a.id_factura_manual

            WHERE f.id_factura_manual = :id

            GROUP BY f.id_factura_manual;");





            $sql->bindValue(':id', $_GET['id']);

            $sql->execute();

            $factura_manual = $sql->fetch(PDO::FETCH_ASSOC);



            if ($factura_manual) {

                // Obtener los elementos de apartado_factura_manual

                $sql = $dbConn->prepare("SELECT *

                FROM apartado_factura_manual

                WHERE id_factura_manual = :id");

                $sql->bindValue(':id', $_GET['id']);

                $sql->execute();

                $apartados = $sql->fetchAll(PDO::FETCH_ASSOC);



                // Añadir los apartados al objeto de factura_manual

                $factura_manual['apartados'] = $apartados;

                $bancos = [];

                $bancoIds = ['id_banco', 'id_banco_2', 'id_banco_3'];



                foreach ($bancoIds as $bancoId) {

                    if (!empty($factura_manual[$bancoId])) {

                        $sql = $dbConn->prepare("SELECT * FROM bancos WHERE id_banco = :id_banco");

                        $sql->bindValue(':id_banco', $factura_manual[$bancoId]);

                        $sql->execute();

                        $banco = $sql->fetch(PDO::FETCH_ASSOC);

                        if ($banco) {

                            array_push($bancos, $banco);

                        }

                    }

                }



                // Añadir los bancos al objeto de factura_manual

                $factura_manual['bancos'] = $bancos;



                $id_factura_manual = $factura_manual["id_factura_manual"];

                $sql = "SELECT * FROM facturas_rectificadas WHERE id_factura_manual = :id_factura_manual;";

                $stmt = $dbConn->prepare($sql);

                $stmt->bindParam(':id_factura_manual', $id_factura_manual, PDO::PARAM_INT);

                $stmt->execute();

                // Obtener el resultado como un objeto

                $factura_rectificada = $stmt->fetch(PDO::FETCH_OBJ);

                $factura_manual["factura_rectificada"] = $factura_rectificada;

                $id_factura_rectificada = $factura_manual["factura_rectificada"]->id_factura_rectificada;



                $sql = "SELECT a.*, 

            COALESCE(m.cantidad, 'Ninguno') AS cantidad_original,

            COALESCE(m.precio_unitario, 'Ninguno') AS precio_unitario_original,

            m.igic AS igic_original,

            m.codigo,

            ROUND(

                CASE 

                    WHEN TRIM(BOTH FROM REGEXP_REPLACE(a.cantidad, '[^0-9]', '')) <> '' 

                    THEN 

                        CAST(TRIM(BOTH FROM REGEXP_REPLACE(a.cantidad, '[^0-9]', '')) AS DECIMAL) * a.precio_unitario +

                        (CAST(TRIM(BOTH FROM REGEXP_REPLACE(a.cantidad, '[^0-9]', '')) AS DECIMAL) * a.precio_unitario * a.igic / 100)

                    ELSE 0

                END

            , 2) AS total,

            ROUND(

                CASE 

                    WHEN TRIM(BOTH FROM REGEXP_REPLACE(m.cantidad, '[^0-9]', '')) <> '' 

                    THEN 

                        CAST(TRIM(BOTH FROM REGEXP_REPLACE(m.cantidad, '[^0-9]', '')) AS DECIMAL) * m.precio_unitario +

                        (CAST(TRIM(BOTH FROM REGEXP_REPLACE(m.cantidad, '[^0-9]', '')) AS DECIMAL) * m.precio_unitario * m.igic / 100)

                    ELSE 0

                END

            , 2) AS total_original,

            ROUND(

                CASE 

                    WHEN TRIM(BOTH FROM REGEXP_REPLACE(a.cantidad, '[^0-9]', '')) <> '' 

                    THEN 

                        CASE 

                            WHEN TRIM(BOTH FROM REGEXP_REPLACE(m.cantidad, '[^0-9]', '')) <> '' 

                            THEN 

                                CASE 

                                    WHEN 

                                        (CAST(TRIM(BOTH FROM REGEXP_REPLACE(a.cantidad, '[^0-9]', '')) AS DECIMAL) * a.precio_unitario + 

                                         CAST(TRIM(BOTH FROM REGEXP_REPLACE(a.cantidad, '[^0-9]', '')) AS DECIMAL) * a.precio_unitario * a.igic / 100) >

                                        (CAST(TRIM(BOTH FROM REGEXP_REPLACE(m.cantidad, '[^0-9]', '')) AS DECIMAL) * m.precio_unitario + 

                                         CAST(TRIM(BOTH FROM REGEXP_REPLACE(m.cantidad, '[^0-9]', '')) AS DECIMAL) * m.precio_unitario * m.igic / 100)

                                    THEN 

                                        (CAST(TRIM(BOTH FROM REGEXP_REPLACE(a.cantidad, '[^0-9]', '')) AS DECIMAL) * a.precio_unitario + 

                                         CAST(TRIM(BOTH FROM REGEXP_REPLACE(a.cantidad, '[^0-9]', '')) AS DECIMAL) * a.precio_unitario * a.igic / 100) -

                                        (CAST(TRIM(BOTH FROM REGEXP_REPLACE(m.cantidad, '[^0-9]', '')) AS DECIMAL) * m.precio_unitario + 

                                         CAST(TRIM(BOTH FROM REGEXP_REPLACE(m.cantidad, '[^0-9]', '')) AS DECIMAL) * m.precio_unitario * m.igic / 100)

                                    ELSE 

                                        (CAST(TRIM(BOTH FROM REGEXP_REPLACE(m.cantidad, '[^0-9]', '')) AS DECIMAL) * m.precio_unitario + 

                                         CAST(TRIM(BOTH FROM REGEXP_REPLACE(m.cantidad, '[^0-9]', '')) AS DECIMAL) * m.precio_unitario * m.igic / 100) -

                                        (CAST(TRIM(BOTH FROM REGEXP_REPLACE(a.cantidad, '[^0-9]', '')) AS DECIMAL) * a.precio_unitario + 

                                         CAST(TRIM(BOTH FROM REGEXP_REPLACE(a.cantidad, '[^0-9]', '')) AS DECIMAL) * a.precio_unitario * a.igic / 100)

                                END

                            ELSE 

                                0

                        END

                    ELSE 

                        0

                END

            , 2) AS diferencia_total_total_original

     FROM apartado_factura_rectificada a

     LEFT JOIN apartado_factura_manual m ON a.id_apartado_factura_manual = m.id_apartado_factura_manual

     WHERE id_factura_rectificada = :id_factura_rectificada;";

                $stmt = $dbConn->prepare($sql);

                $stmt->bindParam(':id_factura_rectificada', $id_factura_rectificada, PDO::PARAM_INT);

                $stmt->execute();

                // Obtener el resultado como un objeto

                $apartados = $stmt->fetchAll(PDO::FETCH_OBJ);

                $factura_rectificada->apartados = $apartados;

                $sumaDiferencias = 0;

                $total_rectificado = null;

                $suma_irpf = ($factura_manual["irpf"] != null) ? ($factura_manual["irpf"] / 100) : 0;



                // Iterar sobre los apartados de cada factura

                foreach ($apartados as $apartado) {

                    // Calcular la diferencia entre 'total' y 'total_original'

                    $diferencia = floatval($apartado->total) - floatval($apartado->total_original);

                    $diferencia_sin_ig = floatval($apartado->precio_unitario * $apartado->cantidad) - floatval($apartado->precio_unitario_original * $apartado->cantidad_original);

                    // Sumar la diferencia a 'sumaDiferencias'

                    $sumaDiferencias += $diferencia;

                    $sumaDiferenciasSinIg += $diferencia_sin_ig;

                }



                $factura_manual["importe_calculado"] = floatval($factura_manual["importe_calculado"]);

                // Agregar 'sumaDiferencias' como un nuevo atributo al objeto principal

                $total_rectificado = $factura_manual["importe_calculado"] + $sumaDiferencias;

                $factura_manual["suma_diferencias"] = $sumaDiferencias;

                $factura_manual["suma_diferencias_sin_ig"] = $sumaDiferenciasSinIg;

                $factura_manual["total_rectificado"] = $total_rectificado;





                // Devolver el resultado como JSON

                header("HTTP/1.1 200 OK");

                echo json_encode($factura_manual);

            } else {

                // Si no se encuentra la factura_manual

                header("HTTP/1.1 404 Not Found");

                echo json_encode(["message" => "Factura no encontrada"]);

            }

        } catch (Exception $e) {

            // Manejo de errores

            header("HTTP/1.1 500 Internal Server Error");

            echo json_encode(["message" => "Error en la consulta", "error" => $e->getMessage()]);

        }

        exit();

    } elseif (isset($_GET['id_factura_manual'])) {



        //Mostrar un post

        $sql = $dbConn->prepare("SELECT SUM(importe) as total_pagado

        FROM pago_factura

        WHERE id_factura_manual = :id_factura_manual");

        $sql->bindValue(':id_factura_manual', $_GET['id_factura_manual']);

        $sql->execute();

        $result = $sql->fetch(PDO::FETCH_ASSOC);

        $totalPagado = $result['total_pagado'];

        header("HTTP/1.1 200 OK");

        echo json_encode($totalPagado);

        exit();

    } elseif (isset($_GET['dias'])) {



        $dias = json_decode($_GET['dias']);

        $facturas = array();



        foreach ($dias as $fecha_formato) {



            $sql = "SELECT COUNT(*) AS cantidad FROM factura_manual WHERE DATE_FORMAT(fecha, '%Y-%m-%d') = :fecha";

            // Preparar la consulta SQL utilizando PDO

            $stmt = $dbConn->prepare($sql);

            $stmt->bindValue(':fecha', $fecha_formato, PDO::PARAM_STR);

            $stmt->execute();

            $row = $stmt->fetch(PDO::FETCH_ASSOC);

            $cantidad = $row['cantidad'];



            // Crear un objeto con la fecha y la cantidad de facturas y agregarlo al arreglo $facturas_por_dia

            $objeto = array("dia" => $fecha_formato, "cantidad" => $cantidad);

            array_push($facturas, $objeto);

        }

        // Devolver los resultados en formato JSON

        header('Content-Type: application/json');

        echo json_encode($facturas);

        exit();

    } elseif (isset($_GET['programados'])) {



        $sql = "SELECT * FROM factura_manual WHERE programado IS NOT NULL;";

        $stmt = $dbConn->prepare($sql);



        // Obtener clientes potenciales





        $stmt->execute();

        $presupuestos = $stmt->fetchAll(PDO::FETCH_OBJ);



        // Devolver objeto de clientes

        header("HTTP/1.1 200 OK");

        echo json_encode($presupuestos);

        exit();

    } else {

        //Mostrar lista de post

        $s = "SELECT 

                f.*, 

                ROUND(COALESCE(SUM(a.cantidad * a.precio_unitario * (a.igic / 100)), 0), 2) AS igic_sumado,

                ROUND(

                    COALESCE(SUM(a.cantidad * a.precio_unitario * (a.igic / 100)), 0) + 

                    f.importe - 

                    COALESCE(f.importe * (f.irpf / 100), 0), 

                    2

                ) AS importe_calculado,

                c.nombre AS nombre_cliente,

                c.client_id,

                c.codigo AS codigo_cliente

            FROM 

                factura_manual f

            JOIN 

                clientes c ON f.client_id = c.client_id

            LEFT JOIN 

                apartado_factura_manual a ON f.id_factura_manual = a.id_factura_manual ";



        $condiciones = [];



        if (isset($_GET["client_id"])) {

            $condiciones[] = "f.client_id = :client_id";

        }

        if (isset($_GET["clase"]) && $_GET["clase"] != "Todos") {

            $condiciones[] = "f.clase = :clase";

        }

        if (isset($_GET["fecha_i"]) && isset($_GET["fecha_f"])) {

            $condiciones[] = "DATE_FORMAT(f.fecha, '%Y-%m-%d') BETWEEN :fecha_i AND :fecha_f";

        }



        // Agregar WHERE solo si hay condiciones

        if (!empty($condiciones)) {

            $s .= " WHERE " . implode(" AND ", $condiciones);

        }



        $s .= " GROUP BY f.id_factura_manual, c.client_id;";



        // Preparar y bindear

        $sql = $dbConn->prepare($s);



        if (isset($_GET["client_id"])) {

            $sql->bindValue(':client_id', $_GET['client_id']);

        }

        if (isset($_GET["clase"]) && $_GET["clase"] != "Todos") {

            $sql->bindValue(':clase', $_GET['clase']);

        }

        if (isset($_GET["fecha_i"]) && isset($_GET["fecha_f"])) {

            $sql->bindValue(':fecha_i', $_GET['fecha_i']);

            $sql->bindValue(':fecha_f', $_GET['fecha_f']);

        }



        $sql->execute();

        $sql->setFetchMode(PDO::FETCH_ASSOC);

        $facturas = $sql->fetchAll(PDO::FETCH_OBJ);



        foreach ($facturas as $f) {

            $id_factura_manual = $f->id_factura_manual;





            $sql = "SELECT * FROM facturas_rectificadas WHERE id_factura_manual = :id_factura_manual;";

            $stmt = $dbConn->prepare($sql);

            $stmt->bindParam(':id_factura_manual', $id_factura_manual, PDO::PARAM_INT);

            $stmt->execute();

            // Obtener el resultado como un objeto

            $factura_rectificada = $stmt->fetch(PDO::FETCH_OBJ);

            $f->factura_rectificada = $factura_rectificada;



            if (!$factura_rectificada) {

                $f->factura_rectificada = null;  // O asigna un arreglo vacío si prefieres

            } else {

                $f->factura_rectificada = $factura_rectificada;

                $id_factura_rectificada = $f->factura_rectificada->id_factura_rectificada;



                $sql = "SELECT a.*, 

                        COALESCE(m.cantidad, 'Ninguno') AS cantidad_original,

                        COALESCE(m.precio_unitario, 'Ninguno') AS precio_unitario_original,

                        m.igic AS igic_original,

                        m.codigo,

                        ROUND(

                            CASE 

                                WHEN TRIM(BOTH FROM REGEXP_REPLACE(a.cantidad, '[^0-9]', '')) <> '' 

                                THEN 

                                    CAST(TRIM(BOTH FROM REGEXP_REPLACE(a.cantidad, '[^0-9]', '')) AS DECIMAL) * a.precio_unitario +

                                    (CAST(TRIM(BOTH FROM REGEXP_REPLACE(a.cantidad, '[^0-9]', '')) AS DECIMAL) * a.precio_unitario * a.igic / 100)

                                ELSE 0

                            END

                        , 2) AS total,

                        ROUND(

                            CASE 

                                WHEN TRIM(BOTH FROM REGEXP_REPLACE(m.cantidad, '[^0-9]', '')) <> '' 

                                THEN 

                                    CAST(TRIM(BOTH FROM REGEXP_REPLACE(m.cantidad, '[^0-9]', '')) AS DECIMAL) * m.precio_unitario +

                                    (CAST(TRIM(BOTH FROM REGEXP_REPLACE(m.cantidad, '[^0-9]', '')) AS DECIMAL) * m.precio_unitario * m.igic / 100)

                                ELSE 0

                            END

                        , 2) AS total_original,

                        ROUND(

                            CASE 

                                WHEN TRIM(BOTH FROM REGEXP_REPLACE(a.cantidad, '[^0-9]', '')) <> '' 

                                THEN 

                                    CASE 

                                        WHEN TRIM(BOTH FROM REGEXP_REPLACE(m.cantidad, '[^0-9]', '')) <> '' 

                                        THEN 

                                            CASE 

                                                WHEN 

                                                    (CAST(TRIM(BOTH FROM REGEXP_REPLACE(a.cantidad, '[^0-9]', '')) AS DECIMAL) * a.precio_unitario + 

                                                     CAST(TRIM(BOTH FROM REGEXP_REPLACE(a.cantidad, '[^0-9]', '')) AS DECIMAL) * a.precio_unitario * a.igic / 100) >

                                                    (CAST(TRIM(BOTH FROM REGEXP_REPLACE(m.cantidad, '[^0-9]', '')) AS DECIMAL) * m.precio_unitario + 

                                                     CAST(TRIM(BOTH FROM REGEXP_REPLACE(m.cantidad, '[^0-9]', '')) AS DECIMAL) * m.precio_unitario * m.igic / 100)

                                                THEN 

                                                    (CAST(TRIM(BOTH FROM REGEXP_REPLACE(a.cantidad, '[^0-9]', '')) AS DECIMAL) * a.precio_unitario + 

                                                     CAST(TRIM(BOTH FROM REGEXP_REPLACE(a.cantidad, '[^0-9]', '')) AS DECIMAL) * a.precio_unitario * a.igic / 100) -

                                                    (CAST(TRIM(BOTH FROM REGEXP_REPLACE(m.cantidad, '[^0-9]', '')) AS DECIMAL) * m.precio_unitario + 

                                                     CAST(TRIM(BOTH FROM REGEXP_REPLACE(m.cantidad, '[^0-9]', '')) AS DECIMAL) * m.precio_unitario * m.igic / 100)

                                                ELSE 

                                                    (CAST(TRIM(BOTH FROM REGEXP_REPLACE(m.cantidad, '[^0-9]', '')) AS DECIMAL) * m.precio_unitario + 

                                                     CAST(TRIM(BOTH FROM REGEXP_REPLACE(m.cantidad, '[^0-9]', '')) AS DECIMAL) * m.precio_unitario * m.igic / 100) -

                                                    (CAST(TRIM(BOTH FROM REGEXP_REPLACE(a.cantidad, '[^0-9]', '')) AS DECIMAL) * a.precio_unitario + 

                                                     CAST(TRIM(BOTH FROM REGEXP_REPLACE(a.cantidad, '[^0-9]', '')) AS DECIMAL) * a.precio_unitario * a.igic / 100)

                                            END

                                        ELSE 

                                            0

                                    END

                                ELSE 

                                    0

                            END

                        , 2) AS diferencia_total_total_original

                    FROM apartado_factura_rectificada a

                    LEFT JOIN apartado_factura_manual m ON a.id_apartado_factura_manual = m.id_apartado_factura_manual

                    WHERE id_factura_rectificada = :id_factura_rectificada;";



                $stmt = $dbConn->prepare($sql);

                $stmt->bindParam(':id_factura_rectificada', $id_factura_rectificada, PDO::PARAM_INT);

                $stmt->execute();

                // Obtener el resultado como un objeto

                $apartados = $stmt->fetchAll(PDO::FETCH_OBJ);

                $factura_rectificada->apartados = $apartados;

            }



            $sumaDiferencias = 0;

            $sumaDiferenciasSinIg = 0;

            $total_rectificado = null;

            $suma_irpf = ($f->irpf != null) ? ($f->irpf / 100) : 0;



            // Iterar sobre los apartados de cada factura

            if ($factura_rectificada) {

                foreach ($apartados as $apartado) {

                    // Calcular la diferencia entre 'total' y 'total_original'

                    $diferencia = floatval($apartado->total) - floatval($apartado->total_original);

                    $diferencia_sin_ig = floatval($apartado->precio_unitario * $apartado->cantidad) - floatval($apartado->precio_unitario_original * $apartado->cantidad_original);

                    // Sumar la diferencia a 'sumaDiferencias'

                    $sumaDiferencias += $diferencia;

                    $sumaDiferenciasSinIg += $diferencia_sin_ig;

                }

            }



            $f->importe_calculado = floatval($f->importe_calculado);

            // Agregar 'sumaDiferencias' como un nuevo atributo al objeto principal

            $total_rectificado = $f->importe_calculado + $sumaDiferencias;

            $f->suma_diferencias = $sumaDiferencias;

            $f->suma_diferencias_sin_ig = $sumaDiferenciasSinIg;

            $f->total_rectificado = $total_rectificado;



            $sql = "SELECT c.*, COALESCE(m.nombre, 'Ninguno') AS metodo , COALESCE(b.nombre, 'Ninguno') AS banco 

                   FROM pago_factura c

                   LEFT JOIN bancos b ON c.id_banco = b.id_banco

                   LEFT JOIN metodos_pago m ON c.id_metodo = m.id_metodo

                   WHERE id_factura_manual = :id_factura_manual";

            $stmt = $dbConn->prepare($sql);

            $stmt->bindParam(':id_factura_manual', $id_factura_manual, PDO::PARAM_INT);

            $stmt->execute();

            // Obtener el resultado como un objeto

            $pagos = $stmt->fetchAll(PDO::FETCH_OBJ);

            $f->pagos = $pagos;

            if (COUNT($pagos) > 0) {

                $sql = "SELECT SUM(importe) as total_pagado FROM pago_factura WHERE id_factura_manual = :id_factura_manual";

                $stmt = $dbConn->prepare($sql);

                $stmt->bindParam(':id_factura_manual', $id_factura_manual, PDO::PARAM_INT);

                $stmt->execute();

                // Obtener el resultado como un objeto

                $total_pagado = $stmt->fetch(PDO::FETCH_ASSOC);

                $f->total_pagado = $total_pagado["total_pagado"];

            } else {

                $f->total_pagado = "0.00";

            }

        }



        header("HTTP/1.1 200 OK");

        echo json_encode($facturas);

        exit();

    }

}



// Crear un nuevo post

if ($_SERVER['REQUEST_METHOD'] == 'POST') {

    if (isset($_POST["programado"]) && isset($_POST["id_factura_editar_envio"])) {



        $programado = ($_POST["programado"] != "No") ? $_POST["programado"] : null;

        $id_factura_manual = $_POST["id_factura_editar_envio"];



        $sql = "UPDATE factura_manual SET programado = :programado WHERE id_factura_manual = :id_factura_manual";

        $statement = $dbConn->prepare($sql);

        $statement->bindValue(':id_factura_manual', $id_factura_manual);

        $statement->bindValue(':programado', $programado);



        $statement->execute();

        $object = [

            'id' => $id_factura,

            'programado' => $programado,



        ];



        header("HTTP/1.1 200 OK");

        echo json_encode($object);

        exit();

    }

    if (



        isset($_POST["numero_rectificar"]) &&

        isset($_POST["id_factura_manual_rectificar"]) &&

        isset($_POST["detallado_rectificar"])

    ) {

        $numero = $_POST["numero_rectificar"];

        $id_factura_manual = $_POST["id_factura_manual_rectificar"];

        $detallado = json_decode($_POST["detallado_rectificar"], true);

        $fecha = date("Y-m-d");



        $statement = $dbConn->prepare("INSERT INTO facturas_rectificadas (numero, id_factura_manual, fecha) VALUES (:numero, :id_factura_manual, :fecha)");

        $statement->bindValue(':numero', $numero);



        $statement->bindValue(':id_factura_manual', $id_factura_manual);

        $statement->bindValue(':fecha', $fecha);





        $statement->execute();

        $id_factura_rectificada = $dbConn->lastInsertId();





        foreach ($detallado as $apartado) {



            $titulo = ($apartado["titulo"] != "") ? $apartado["titulo"] : null;

            $cantidad = $apartado["cantidad"];

            $igic = $apartado["igic"];

            $descripcion = $apartado["descripcion"];

            $precio_unitario = $apartado["precio_unitario"];

            $id_apartado_factura_manual = $apartado["id_apartado_factura_manual"];

            $statement = $dbConn->prepare("INSERT INTO apartado_factura_rectificada (igic,id_apartado_factura_manual,id_factura_rectificada, cantidad, descripcion, precio_unitario, titulo ) 

            VALUES (:igic,:id_apartado_factura_manual,:id_factura_rectificada, :cantidad, :descripcion, :precio_unitario, :titulo)");

            $statement->bindValue(':id_factura_rectificada', $id_factura_rectificada);

            $statement->bindValue(':cantidad', $cantidad);

            $statement->bindValue(':titulo', $titulo);

            $statement->bindValue(':descripcion', $descripcion);

            $statement->bindValue(':precio_unitario', $precio_unitario);

            $statement->bindValue(':id_apartado_factura_manual', $id_apartado_factura_manual);

            $statement->bindValue(':igic', $igic);

            $statement->execute();

        }

        $personalizacion = json_decode(file_get_contents('../personalizacion.json'), true);

        $personalizacion["numeracion_factura_rectificada"] = intval($personalizacion["numeracion_factura_rectificada"]) + 1;

        $personalizacionEncoded = json_encode($personalizacion, JSON_PRETTY_PRINT);

        file_put_contents('../personalizacion.json', $personalizacionEncoded);



        header("HTTP/1.1 200 OK");

        echo json_encode($detallado);

        exit();

    }

    if (

        isset($_POST["nombre"]) &&

        isset($_POST["fecha"]) &&

        isset($_POST["numero"]) &&

        isset($_POST["estado"]) &&

        isset($_POST["cif"]) &&

        isset($_POST["cp"]) &&

        isset($_POST["direccion"]) &&

        isset($_POST["telefono"]) &&

        isset($_POST["email"]) &&

        isset($_POST["importe"]) &&

        isset($_POST["titulo"]) &&

        isset($_POST["client_id"]) &&



        isset($_POST["irpf"]) &&

        isset($_POST["imagen"]) &&

        isset($_POST["fecha_envio"]) &&



        isset($_POST["tipo"]) &&

        isset($_POST["id_banco"]) &&

        isset($_POST["id_banco_2"]) &&

        isset($_POST["id_banco_3"]) &&

        isset($_POST["programado"]) &&

        isset($_POST["condiciones"]) &&

        isset($_POST["impuesto"]) &&

        isset($_POST["fechas"]) &&

        isset($_POST["lugar"]) &&

        isset($_POST["id_proyecto"]) &&

        isset($_POST["fecha_vencimiento"]) &&

        isset($_POST["clase"])

    ) {

        try {

            foreach ($_POST as $key => $value) {

                $value = ($value == "") ? null : $value;



                $value = ($value == "No") ? null : $value;

                $$key = $value;

            }



            if ($id_factura_manual != null) {



                $id_factura_manual = $_POST["id_factura_manual"];

                $sql = "UPDATE factura_manual

            SET imagen = :imagen,

            id_banco = :id_banco,

            id_banco_2 = :id_banco_2,

            id_banco_3 = :id_banco_3,

                nombre = :nombre,

                fecha = :fecha,

                numero = :numero,

                estado = :estado,

                cif = :cif,

                cp = :cp,

                direccion = :direccion,

                telefono = :telefono,

                email = :email,

                importe = :importe,

                fecha_envio = :fecha_envio,

                fecha_vencimiento = :fecha_vencimiento,

                titulo = :titulo,

                client_id = :client_id,

               

              

                 tipo = :tipo,

          

            programado = :programado,

            condiciones = :condiciones,

            impuesto = :impuesto,

            fechas = :fechas,

            lugar = :lugar,

            id_proyecto = :id_proyecto,

                irpf = :irpf,

                clase = :clase

            WHERE id_factura_manual = :id_factura_manual";

                $statement = $dbConn->prepare($sql);

                $statement->bindValue(':id_factura_manual', $id_factura_manual);

            } else {

                $sql = "INSERT INTO factura_manual 

        (clase,id_proyecto,fechas,lugar,condiciones,impuesto,programado,id_banco,id_banco_2,id_banco_3,tipo,imagen,nombre,fecha,numero,estado,cif,cp,direccion,telefono,email,importe,fecha_envio,fecha_vencimiento,titulo,client_id,irpf)

        VALUES

        (:clase,:id_proyecto,:fechas,:lugar,:condiciones,:impuesto,:programado,:id_banco,:id_banco_2,:id_banco_3,:tipo,:imagen,:nombre,:fecha,:numero,:estado,:cif,:cp,:direccion,:telefono,:email,:importe,:fecha_envio,:fecha_vencimiento,:titulo,:client_id,:irpf)";

                $statement = $dbConn->prepare($sql);

            }

            $statement->bindValue(':clase', $clase);

            $statement->bindValue(':fechas', $fechas);

            $statement->bindValue(':id_proyecto', $id_proyecto);

            $statement->bindValue(':lugar', $lugar);

            $statement->bindValue(':programado', $programado);

            $statement->bindValue(':id_banco', $id_banco);

            $statement->bindValue(':id_banco_2', $id_banco_2);

            $statement->bindValue(':id_banco_3', $id_banco_3);



            $statement->bindValue(':tipo', $tipo);



            $statement->bindValue(':imagen', $imagen);

            $statement->bindValue(':nombre', $nombre);

            $statement->bindValue(':fecha', $fecha);

            $statement->bindValue(':numero', $numero);

            $statement->bindValue(':estado', $estado);

            $statement->bindValue(':cif', $cif);

            $statement->bindValue(':cp', $cp);

            $statement->bindValue(':direccion', $direccion);

            $statement->bindValue(':telefono', $telefono);

            $statement->bindValue(':email', $email);

            $statement->bindValue(':importe', $importe);

            $statement->bindValue(':titulo', $titulo);

            $statement->bindValue(':client_id', $client_id);



            $statement->bindValue(':irpf', $irpf);

            $statement->bindValue(':fecha_envio', $fecha_envio);

            $statement->bindValue(':fecha_vencimiento', $fecha_vencimiento);

            $statement->bindValue(':condiciones', $condiciones);

            $statement->bindValue(':impuesto', $impuesto);

            $statement->execute();



            if ($id_factura_manual != null) {

                $postId = $id_factura_manual;

            } else {

                $postId = $dbConn->lastInsertId();

                $personalizacion = json_decode(file_get_contents('../personalizacion.json'), true);

                $personalizacion["numeracion_facturas"] = intval($personalizacion["numeracion_facturas"]) + 1;

                $personalizacionEncoded = json_encode($personalizacion, JSON_PRETTY_PRINT);

                file_put_contents('../personalizacion.json', $personalizacionEncoded);

            }





            $input['id'] = $postId;



            header("HTTP/1.1 200 OK");

            echo json_encode($input);

            exit();

        } catch (PDOException $e) {

            // Manejar el error

            header("HTTP/1.1 500 Internal Server Error");

            echo "Error al ejecutar la consulta: " . $e->getMessage();

            exit();

        }

    }

    if (

        isset($_POST["id"]) &&

        isset($_POST["detallado"])

    ) {

        $id_factura_manual = $_POST["id"];

        $detallado = json_decode($_POST["detallado"], true);



        if ($_POST["editar"] == "Si") {

            $deleteStatement = $dbConn->prepare("DELETE FROM apartado_factura_manual WHERE id_factura_manual = :id_factura_manual");

            $deleteStatement->bindValue(':id_factura_manual', $id_factura_manual);

            $deleteStatement->execute();

            $deleteStatement = $dbConn->prepare("DELETE FROM facturas_rectificadas WHERE id_factura_manual = :id_factura_manual");

            $deleteStatement->bindValue(':id_factura_manual', $id_factura_manual);

            $deleteStatement->execute();

        }









        foreach ($detallado as $apartado) {



            $titulo = ($apartado["titulo"] != "") ? $apartado["titulo"] : null;

            $cantidad = $apartado["cantidad"];

            $codigo = $apartado["codigo"];

            $descripcion = $apartado["descripcion"];

            $igic = $apartado["igic"];

            $precio_unitario = $apartado["precio_unitario"];

            $id_albaran = ($apartado["id_albaran"] != "No") ? $apartado["id_albaran"] : null;

            $statement = $dbConn->prepare("INSERT INTO apartado_factura_manual 

            (id_factura_manual, cantidad, descripcion, precio_unitario, titulo, codigo, igic, id_albaran ) VALUES

             (:id_factura_manual, :cantidad, :descripcion, :precio_unitario, :titulo, :codigo, :igic, :id_albaran)");

            $statement->bindValue(':id_factura_manual', $id_factura_manual);

            $statement->bindValue(':cantidad', $cantidad);

            $statement->bindValue(':titulo', $titulo);

            $statement->bindValue(':descripcion', $descripcion);

            $statement->bindValue(':precio_unitario', $precio_unitario);

            $statement->bindValue(':codigo', $codigo);

            $statement->bindValue(':igic', $igic);

            $statement->bindValue(':id_albaran', $id_albaran);

            $statement->execute();

        }

        header("HTTP/1.1 200 OK");

        echo json_encode($detallado);

        exit();

    }

    if (isset($_POST["importe"]) && isset($_POST["id_factura_manual"]) && isset($_POST["id_metodo"]) && isset($_POST["id_banco"]) && isset($_POST["fecha"])) {

        foreach ($_POST as $key => $value) {

            $value = ($value == "") ? null : $value;



            $value = ($value == "No") ? null : $value;

            $$key = $value;

        }



        $sql = "INSERT INTO pago_factura

            (importe, id_factura_manual, id_metodo, id_banco, fecha)

            VALUES

            (:importe, :id_factura_manual, :id_metodo, :id_banco, :fecha)";

        $statement = $dbConn->prepare($sql);

        $statement->bindValue(':importe', $importe);

        $statement->bindValue(':id_factura_manual', $id_factura_manual);

        $statement->bindValue(':id_metodo', $id_metodo);

        $statement->bindValue(':id_banco', $id_banco);

        $statement->bindValue(':fecha', $fecha);

        $statement->execute();

        $postId = $dbConn->lastInsertId();



        $input['id'] = $postId;

        $input['importe'] = $importe;

        $input['id_factura_manual'] = $id_factura_manual;

        $input['id_banco'] = $id_banco;

        $input['id_metodo'] = $id_metodo;

        $input['fecha'] = $fecha;

        header("HTTP/1.1 200 OK");

        echo json_encode($input);

        exit();

    }

}



if ($_SERVER['REQUEST_METHOD'] == 'DELETE') {



    if (isset($_GET["id_pago_factura"])) {

        $id_pago_factura = $_GET['id_pago_factura'];

        $statement = $dbConn->prepare("DELETE FROM pago_factura where id_pago_factura=:id_pago_factura");

        $statement->bindValue(':id_pago_factura', $id_pago_factura);

        $statement->execute();

        header("HTTP/1.1 200 OK");

        exit();

    }

    if (isset($_GET["id_factura_manual"])) {

        $id_factura_manual = $_GET['id_factura_manual'];

        $statement = $dbConn->prepare("DELETE FROM factura_manual where id_factura_manual=:id_factura_manual");

        $statement->bindValue(':id_factura_manual', $id_factura_manual);

        $statement->execute();

        header("HTTP/1.1 200 OK");

        exit();

    }

}



//Actualizar

if ($_SERVER['REQUEST_METHOD'] == 'PUT') {

    $input = $_GET;

    $postId = $input['id'];

    $fields = getParams($input);



    $sql = "

          UPDATE posts

          SET $fields

          WHERE id='$postId'

           ";



    $statement = $dbConn->prepare($sql);

    bindAllValues($statement, $input);



    $statement->execute();

    header("HTTP/1.1 200 OK");

    exit();

}



function getMonthNumber($monthName)

{

    $months = [

        'enero' => 1,

        'febrero' => 2,

        'marzo' => 3,

        'abril' => 4,

        'mayo' => 5,

        'junio' => 6,

        'julio' => 7,

        'agosto' => 8,

        'septiembre' => 9,

        'octubre' => 10,

        'noviembre' => 11,

        'diciembre' => 12

    ];



    return isset($months[strtolower($monthName)]) ? $months[strtolower($monthName)] : null;

}



//En caso de que ninguna de las opciones anteriores se haya ejecutado

header("HTTP/1.1 400 Bad Request");