<?php





include "utils.php";


require_once __MODELS__ . 'mailer.model.php';

require_once __MODELS__ . 'users.model.php';

require_once(__LIBRARIES__ . 'anti_csrf.class.php');



$personalizacion = json_decode(file_get_contents('../personalizacion.json'), true);

date_default_timezone_set(htmlentities($personalizacion["zona_horaria"], ENT_QUOTES));





$mailer = new _MailerModel(EMAIL_SERVER, EMAIL_PORT, EMAIL_VALIDATE_USERNAME, EMAIL_VALIDATE_PASSWORD);

$Users = new _UsersModel($DBLink);

$dbConn = connect($db);



/*

listar todos los posts o solo uno

 */

if ($_SERVER['REQUEST_METHOD'] == 'GET') {

    if (isset($_GET['id'])) {

        //Mostrar un post

        $sql = $dbConn->prepare("SELECT * FROM factura_empleado where id_factura_empleado=:id");

        $sql->bindValue(':id', $_GET['id']);

        $sql->execute();

        header("HTTP/1.1 200 OK");

        echo json_encode($sql->fetch(PDO::FETCH_ASSOC));

        exit();
    }

    if (isset($_GET['id_factura_empleado'])) {



        //Mostrar un post

        $sql = $dbConn->prepare("SELECT SUM(importe) as total_pagado

        FROM pago_empleado

        WHERE id_factura_empleado = :id_factura_empleado");

        $sql->bindValue(':id_factura_empleado', $_GET['id_factura_empleado']);

        $sql->execute();

        $result = $sql->fetch(PDO::FETCH_ASSOC);

        $totalPagado = $result['total_pagado'];

        header("HTTP/1.1 200 OK");

        echo json_encode($totalPagado);

        exit();
    } else {

        if (isset($_GET['fecha_i']) && isset($_GET['fecha_i'])) {

            $fecha_i = $_GET['fecha_i'];

            $fecha_f = $_GET['fecha_f'];

            $sql = $dbConn->prepare("SELECT c.*, e.nombre AS nombre 

            FROM factura_empleado c

            INNER JOIN empleados e ON c.id_empleado = e.id_empleado

            WHERE DATE_FORMAT(c.fecha, '%Y-%m-%d') BETWEEN :fecha_i AND :fecha_f");

            $sql->bindValue(':fecha_i', $fecha_i);

            $sql->bindValue(':fecha_f', $fecha_f);
        } else {

            $sql = $dbConn->prepare("SELECT c.*, e.nombre AS nombre 

            FROM factura_empleado c

            INNER JOIN empleados e ON c.id_empleado = e.id_empleado");
        }

        //Mostrar lista de post



        $sql->execute();

        $sql->setFetchMode(PDO::FETCH_ASSOC);

        $facturas = $sql->fetchAll(PDO::FETCH_OBJ);



        foreach ($facturas as $f) {



            $id_factura_empleado = $f->id_factura_empleado;

            $sql = "SELECT c.*, COALESCE(m.nombre, 'Ninguno') AS metodo ,  COALESCE(b.nombre, 'Ninguno') AS banco 

            FROM pago_empleado c

            LEFT JOIN bancos b ON c.id_banco = b.id_banco

            LEFT JOIN metodos_pago m ON c.id_metodo = m.id_metodo

            WHERE id_factura_empleado = :id_factura_empleado";

            $stmt = $dbConn->prepare($sql);

            $stmt->bindParam(':id_factura_empleado', $id_factura_empleado, PDO::PARAM_INT);

            $stmt->execute();

            // Obtener el resultado como un objeto

            $pagos = $stmt->fetchAll(PDO::FETCH_OBJ);

            $f->pagos = $pagos;

            if (COUNT($pagos) > 0) {

                $sql = "SELECT SUM(importe) as total_pagado FROM pago_empleado WHERE id_factura_empleado = :id_factura_empleado";

                $stmt = $dbConn->prepare($sql);

                $stmt->bindParam(':id_factura_empleado', $id_factura_empleado, PDO::PARAM_INT);

                $stmt->execute();

                // Obtener el resultado como un objeto

                $total_pagado = $stmt->fetch(PDO::FETCH_ASSOC);

                $f->total_pagado = $total_pagado["total_pagado"];
            } else {

                $f->total_pagado = "0.00";
            }
        }



        header("HTTP/1.1 200 OK");



        echo json_encode($facturas);

        exit();
    }
}



// Crear un nuevo post

if ($_SERVER['REQUEST_METHOD'] == 'POST') {



    if (

        isset($_POST["id_empleado"])

        && isset($_POST["importe"])

        && isset($_POST["fecha_i"])

        && isset($_POST["fecha_f"])

        && isset($_POST["precio_hora"])

        && isset($_POST["horas"])

        && isset($_POST["precio_horas_extra"])

        && isset($_POST["horas_extra"])

    ) {

        foreach ($_POST as $key => $value) {

            $value = ($value == "") ? null : $value;



            $value = ($value == "No") ? null : $value;

            $$key = $value;
        }



        // Asegurarse de que el archivo haya sido enviado

        $firma = false;  // Valor predeterminado si no se recibe archivo

        if (isset($_FILES['archivo']) && $_FILES['archivo']['error'] == 0) {

            $firma = true;  // Si el archivo se sube correctamente, asignamos firma como true



        }

        $csrf_token = NoCSRF::generate('csrf_token');

        // Iniciar una transacción

        $dbConn->beginTransaction();

        try {

            // Insertar datos en la base de datos (sin el archivo por ahora)

            $sql = "INSERT INTO factura_empleado

        (id_empleado, fecha_i, fecha_f, importe, precio_hora, horas, precio_horas_extra, horas_extra, firma, csrf_token)

        VALUES

        (:id_empleado, :fecha_i, :fecha_f, :importe, :precio_hora, :horas, :precio_horas_extra, :horas_extra, :firma, :csrf_token)";



            $statement = $dbConn->prepare($sql);



            // Vincular los parámetros a la consulta

            $statement->bindValue(':importe', $importe);

            $statement->bindValue(':id_empleado', $id_empleado);

            $statement->bindValue(':precio_hora', $precio_hora);

            $statement->bindValue(':horas', $horas);

            $statement->bindValue(':precio_horas_extra', $precio_horas_extra);

            $statement->bindValue(':horas_extra', $horas_extra);

            $statement->bindValue(':fecha_i', $fecha_i);

            $statement->bindValue(':fecha_f', $fecha_f);

            $statement->bindValue(':firma', $firma);  // Pasamos el valor de la firma (true/false)

            $statement->bindValue(':csrf_token', $csrf_token);

            $statement->execute();



            // Obtener el ID del registro recién insertado

            $postId = $dbConn->lastInsertId();

            $carpetaNuevaAlumno = '../imagenes/factura_empleado/' . $postId;



            mkdir($carpetaNuevaAlumno, 0777, true);



            // Si se ha subido un archivo, guardarlo en la carpeta correspondiente

            if ($firma) {

                $fileName = basename($_FILES['archivo']['name']);  // Obtener el nombre del archivo

                $baseUrl = ($_SERVER['HTTPS'] ? 'https://' : 'http://') . $_SERVER['HTTP_HOST'] . '/';

                $rutaArchivoTemporal = $_FILES['archivo']['tmp_name'];

                $Archivo = '../imagenes/factura_empleado/' . $postId . '/nomina.pdf';



                // Verificar si el archivo se sube correctamente

                if ($rutaArchivoTemporal && !empty($rutaArchivoTemporal)) {

                    // Intentar mover el archivo a la carpeta destino

                    if (!move_uploaded_file($rutaArchivoTemporal, $Archivo)) {

                        // Si no se puede mover el archivo, deshacer la transacción

                        throw new Exception("No se pudo subir el archivo.");
                    }
                } else {

                    // En caso de que no se reciba el archivo o sea inválido

                    throw new Exception("El archivo no es válido o hubo un problema al cargarlo.");
                }
            }



            // Si todo ha ido bien, confirmar los cambios

            $dbConn->commit();

            $input['id'] = $postId;



            $input['id_empleado'] = $id_empleado;



            $input['importe'] = $importe;



            $input['fecha_f'] = $fecha;





            $U =    $Users->GetEmpleado($id_empleado);

            $confirmarUrl = WEBSITE_URL . "firmar_pago?id={$postId}&token={$csrf_token}";

            $htmlBody = " <html>

                                <head>

                                    <style>

                                        .button {

                                        background-color: #0cca8e;

                                border-color: #0cca8e;

                                        display: inline-block;

                                font-weight: 400;

                                text-align: center;

                                white-space: nowrap;

                                vertical-align: middle;

                                user-select: none;

                                border: 1px solid rgba(0, 0, 0, 0);

                                padding: .56rem 1.375rem;

                                font-size: 1rem;

                                line-height: 1;

                                border-radius: .1875rem;

                                transition: color .15s ease-in-out, background-color .15s ease-in-out, border-color .15s ease-in-out, box-shadow .15s ease-in-out;

                                outline: 0;

                                outline-offset: 0;

                                color: #fff!important;

                            }

                            .button:hover {

                                color: #fff;

                                background-color: #0aa675;

                                border-color: #099a6c;

                                text-decoration: none;

                            }

                                        .email-container {

                                            font-family: Arial, sans-serif;

                                            line-height: 1.5;

                                            margin: 20px;

                                                max-width: 370px;

                                                margin: 0 auto;

                                                text-align:center;

                                        }

                                        .email-title {

                                            color: #333;

                                            font-size: 20px;

                                            font-weight: bold;

                                            width: 100%;

                                            margin-bottom:.5rem;

                                        }

                                        .email-text {

                                            color: #555;

                                            font-size: 16px;

                                            width: 100%;

                                            margin-bottom:.5rem;

                                        }

                                        .email-b{

                                        width: 100%;

                                        }

                                        .email-image {

                                            width: 100%;

                                            max-width: 300px;

                                            height: auto;

                                            display: block;

                                            margin: 0 auto;

                                            margin-bottom:.5rem;

                                        }

                                    </style>

                                </head>

                                <body>

                                    <div class='email-container'>

                                    

                                        <img src='" . htmlentities($personalizacion["imagen_email"], ENT_QUOTES) . "' alt='Imagen de fichaje' class='email-image' />

                            <div class='email-title'>

                                            Se ha creado un pago a su nombre

                                        </div>

                                    

                                        <div class='email-text'>

                                            ¿Desea firmar el pago? <br>

                                            Haga clic en el siguiente botón para redirigirte al link de firma digital:

                                        </div>

                            <div class='email-b'>

                                        <a href='{$confirmarUrl}' class='button'>Firmar</a> 

                                        </div>

                                    </div>

                                </body>

                                </html>

                            ";



            // Enviar el correo con el cuerpo HTML y el enlace de confirmación

            if ($firma != null) {

                $mailer->_Mail(

                    EMAIL_VALIDATE_USERNAME,

                    $U['email'],

                    "Firma obligatoria de nómina.",

                    $htmlBody

                );
            }





            header("HTTP/1.1 200 OK");

            echo json_encode($input);

            exit();
        } catch (Exception $e) {

            // Si ocurre un error en cualquier parte, revertir la transacción

            $dbConn->rollBack();



            // Responder con el error

            $response = [

                "status" => "error",

                "message" => $e->getMessage()

            ];

            header("HTTP/1.1 500 Internal Server Error");

            echo json_encode($response);

            exit();
        }
    } elseif (isset($_POST['firma2'])) {

        // Obtener la firma (base64)

        $firmaBase64 = $_POST['firma2'];

        $id_factura_empleado = $_POST['id_factura_empleado_firma'];

        // Verificar que la firma no está vacía

        if (!empty($firmaBase64)) {

            // Eliminar la parte "data:image/png;base64," de la cadena base64

            $firmaBase64 = str_replace('data:image/png;base64,', '', $firmaBase64);

            $firmaBase64 = str_replace(' ', '+', $firmaBase64);



            // Decodificar la cadena base64

            $firmaImagen = base64_decode($firmaBase64);



            // Crear una carpeta única para la factura

            $carpetaFactura = '../imagenes/factura_empleado/' . $id_factura_empleado;

            if (!file_exists($carpetaFactura)) {

                mkdir($carpetaFactura, 0777, true);  // Crear la carpeta si no existe

            }



            // Definir el nombre del archivo

            $nombreArchivo = $carpetaFactura . '/firma.png';



            // Guardar el archivo de la firma en la carpeta

            file_put_contents($nombreArchivo, $firmaImagen);



            header("HTTP/1.1 200 OK");

            echo json_encode("ok");

            exit();
        } else {

            // Si la firma no se recibió correctamente, lanzar un error

            throw new Exception("Firma no válida o vacía.");
        }
    } elseif (isset($_POST["importe"]) && isset($_POST["id_factura_empleado"]) && isset($_POST["id_metodo"]) && isset($_POST["id_banco"]) && isset($_POST["fecha"])) {

        foreach ($_POST as $key => $value) {

            $value = ($value == "") ? null : $value;



            $value = ($value == "No") ? null : $value;

            $$key = $value;
        }



        $sql = "INSERT INTO pago_empleado

        (importe, id_factura_empleado, id_metodo, id_banco, fecha)

        VALUES

        (:importe, :id_factura_empleado, :id_metodo, :id_banco, :fecha)";

        $statement = $dbConn->prepare($sql);

        $statement->bindValue(':importe', $importe);

        $statement->bindValue(':id_factura_empleado', $id_factura_empleado);

        $statement->bindValue(':id_metodo', $id_metodo);

        $statement->bindValue(':id_banco', $id_banco);

        $statement->bindValue(':fecha', $fecha);

        $statement->execute();

        $postId = $dbConn->lastInsertId();



        $input['id'] = $postId;

        $input['importe'] = $importe;

        $input['id_factura_empleado'] = $id_factura_empleado;

        $input['id_banco'] = $id_banco;

        $input['id_metodo'] = $id_metodo;

        $input['fecha'] = $fecha;

        header("HTTP/1.1 200 OK");

        echo json_encode($input);

        exit();
    } elseif (isset($_POST['import_pagos'])) {

        $jsonData = $_POST['import_pagos'];

        $pagos = json_decode($jsonData, true);

        $todoCorrecto = true;



        try {

            // Verificar cada pago recibido

            foreach ($pagos as $pago) {

                if (isset($pago['numero'], $pago['fecha_i'], $pago['fecha_f'], $pago['importe'])) {

                    $numeroEmpleado = $pago['numero'];

                    $fechaInicio = $pago['fecha_i'];

                    $fechaFin = $pago['fecha_f'];

                    $importe = $pago['importe'];

                    $base = $pago["base"];

                    $bonus = $pago["bonus"];

                    $hora_extra = $pago["hora_extra"];

                    $otros_ingresos = $pago["otros_ingresos"];

                    $irpf = $pago["irpf"];

                    $total_ingresos = $pago["total_ingresos"];

                    $total_deducciones = $pago["total_deducciones"];









                    $fechaInicioObj = date("Y-m-d", strtotime($fechaInicio));

                    $fechaFinObj = date("Y-m-d", strtotime($fechaFin));



                    // Verificar que las fechas se hayan convertido correctamente

                    if ($fechaInicioObj && $fechaFinObj) {

                        // Formatear las fechas en formato 'YYYY-MM-DD'

                        $fechaInicio = $fechaInicioObj;

                        $fechaFin = $fechaFinObj;
                    } else {

                        // Si las fechas no son válidas, marcar el error y salir

                        $todoCorrecto = false;

                        echo json_encode(['status' => 'error', 'message' => "Fecha inválida para el empleado $numeroEmpleado"]);

                        exit(); // Salir inmediatamente si hay un error de fecha

                    }



                    // Verificar si el empleado existe en la base de datos y obtener su ID

                    $stmt = $dbConn->prepare("SELECT id_empleado FROM empleados WHERE numero = :numero");

                    $stmt->bindParam(':numero', $numeroEmpleado);

                    $stmt->execute();

                    $empleado = $stmt->fetch(PDO::FETCH_ASSOC);



                    if ($empleado) {

                        // Obtener el ID del empleado

                        $idEmpleado = $empleado['id_empleado'];



                        // Insertar el pago en la base de datos utilizando el ID del empleado

                        $stmtInsert = $dbConn->prepare("INSERT INTO factura_empleado (id_empleado, fecha_i , fecha_f , importe,base,

bonus,

hora_extra,

otros_ingresos,

irpf,

total_ingresos,

total_deducciones) 

                        VALUES (:id_empleado, :fecha_i, :fecha_f, :importe,:base

,:bonus

,:hora_extra

,:otros_ingresos

,:irpf

,:total_ingresos

,:total_deducciones)");

                        $stmtInsert->bindParam(':id_empleado', $idEmpleado);

                        $stmtInsert->bindParam(':fecha_i', $fechaInicio);

                        $stmtInsert->bindParam(':fecha_f', $fechaFin);

                        $stmtInsert->bindParam(':importe', $importe);

                        $stmtInsert->bindParam(':base', $base);

                        $stmtInsert->bindParam(':bonus', $bonus);

                        $stmtInsert->bindParam(':hora_extra', $hora_extra);

                        $stmtInsert->bindParam(':otros_ingresos', $otros_ingresos);

                        $stmtInsert->bindParam(':irpf', $irpf);

                        $stmtInsert->bindParam(':total_ingresos', $total_ingresos);

                        $stmtInsert->bindParam(':total_deducciones', $total_deducciones);

                        if (!$stmtInsert->execute()) {

                            $todoCorrecto = false;

                            break; // Si la inserción falla, detener el proceso.

                        }
                    } else {

                        // Si el empleado no existe, marcar error

                        $todoCorrecto = false;

                        echo json_encode(['status' => 'error', 'message' => "Empleado con número $numeroEmpleado no encontrado"]);

                        exit(); // Salir inmediatamente si el empleado no se encuentra

                    }
                } else {

                    // Si falta algún dato del pago

                    $todoCorrecto = false;

                    echo json_encode(['status' => 'error', 'message' => 'Datos incompletos para el pago']);

                    exit(); // Salir si los datos están incompletos

                }
            }



            // Si todo está correcto, responder con éxito

            if ($todoCorrecto) {

                header("HTTP/1.1 200 OK");

                echo json_encode(['status' => 'success', 'message' => 'Pagos agregados correctamente']);
            } else {

                header("HTTP/1.1 500 Internal Server Error");

                echo json_encode(['status' => 'error', 'message' => 'Error al agregar uno o más pagos']);
            }
        } catch (PDOException $e) {

            header("HTTP/1.1 500 Internal Server Error");

            echo json_encode(['status' => 'error', 'message' => 'Error de base de datos: ' . $e->getMessage()]);
        } catch (Exception $e) {

            header("HTTP/1.1 500 Internal Server Error");

            echo json_encode(['status' => 'error', 'message' => 'Error: ' . $e->getMessage()]);
        }



        exit(); // Asegurar que no se ejecute nada después de la respuesta

    }





    exit();
}



if ($_SERVER['REQUEST_METHOD'] == 'DELETE') {

    if (isset($_GET["id_pago_empleado"])) {

        $id_pago_empleado = $_GET['id_pago_empleado'];

        $statement = $dbConn->prepare("DELETE FROM pago_empleado where id_pago_empleado=:id_pago_empleado");

        $statement->bindValue(':id_pago_empleado', $id_pago_empleado);

        $statement->execute();

        header("HTTP/1.1 200 OK");

        exit();
    }



    if (isset($_GET["id_factura_empleado"])) {

        $id_factura_empleado = $_GET['id_factura_empleado'];

        $statement = $dbConn->prepare("DELETE FROM factura_empleado where id_factura_empleado=:id_factura_empleado");

        $statement->bindValue(':id_factura_empleado', $id_factura_empleado);

        $statement->execute();

        header("HTTP/1.1 200 OK");

        $archivoEliminar = '../imagenes/factura_empleado/' . $id_factura_empleado;

        eliminarCarpeta($archivoEliminar);

        exit();
    }
}





//Actualizar

if ($_SERVER['REQUEST_METHOD'] == 'PUT') {

    $input = $_GET;

    $postId = $input['id'];

    $fields = getParams($input);



    $sql = "

          UPDATE posts

          SET $fields

          WHERE id='$postId'

           ";



    $statement = $dbConn->prepare($sql);

    bindAllValues($statement, $input);



    $statement->execute();

    header("HTTP/1.1 200 OK");

    exit();
}

function eliminarCarpeta($rutaCarpeta)

{

    // Obtener una lista de archivos y subcarpetas dentro de la carpeta

    $archivos = glob($rutaCarpeta . '/*');



    // Eliminar cada archivo encontrado

    foreach ($archivos as $archivo) {

        if (is_file($archivo)) {

            unlink($archivo);
        } elseif (is_dir($archivo)) {

            eliminarCarpeta($archivo);
        }
    }



    // Eliminar la carpeta

    if (is_dir($rutaCarpeta)) {

        rmdir($rutaCarpeta);
    }
}



//En caso de que ninguna de las opciones anteriores se haya ejecutado

header("HTTP/1.1 400 Bad Request");