<?php

require_once './excepciones.php';

class MyPDOException extends PDOException

{

    function __construct($message = null, $code = 0, Exception $previous = null)

    {

        switch ($code) {

            case 23000:

                $message = 'Violación de restricciones de integridad';

                break;

            default:

                break;

        }



        parent::__construct($message, $code, $previous);

    }

}



class MyPDO extends PDO

{

    public function __construct(string $dsn, string $username = null, string $password = null, array $options = array())

    {

        try {

            parent::__construct($dsn, $username, $password, $options);

        } catch (PDOException $e) {

            throw new MyPDOException($e->getMessage(), $e->getCode(), $e);

        }

    }



    public function exec(string $statement)

    {

        try {

            return parent::exec($statement);

        } catch (PDOException $e) {

            throw new MyPDOException($e->getMessage(), $e->getCode(), $e);

        }

    }



    // Otros métodos que desees sobrescribir

}

?>