<?php

include "utils.php";
$dbConn = connect($db);

// GET: obtener eventos
if ($_SERVER['REQUEST_METHOD'] == 'GET') {
    if (isset($_GET['id_evento_material'])) {
        // Obtener un solo camión
        $sql = $dbConn->prepare("SELECT * FROM evento_material WHERE id_evento_material = :id_evento_material");
        $sql->bindValue(':id_evento_material', $_GET['id_evento_material']);
        $sql->execute();

        header("HTTP/1.1 200 OK");
        echo json_encode($sql->fetch(PDO::FETCH_ASSOC));
        exit();
    } else if (isset($_GET['miembroscalendario'])) {
        $intervalos = [];

        // Si no hay filtro o es "No", devolver todos
        $sql = $dbConn->prepare("SELECT * FROM eventos2");
        $sql->execute();
        $sql->setFetchMode(PDO::FETCH_ASSOC);
        $eventos = $sql->fetchAll();

        foreach ($eventos as $evento2) {
            $matricula = "Ninguno";

            if (!empty($evento2['id_camion'])) {
                $sqlCamion = $dbConn->prepare("SELECT * FROM camiones WHERE id_camion = :id_camion");
                $sqlCamion->bindParam(':id_camion', $evento2['id_camion']);
                $sqlCamion->execute();
                $camion = $sqlCamion->fetch(PDO::FETCH_ASSOC);

                if ($camion && isset($camion['matricula'])) {
                    $matricula = $camion['matricula'];
                }
            }

            // Parsear días
            $dias = json_decode($evento2['dias'], true);
            if (!$dias || count($dias) === 0) continue;

            sort($dias);

            $grupo = [];
            for ($i = 0; $i < count($dias); $i++) {
                $grupo[] = $dias[$i];

                $actual = strtotime($dias[$i]);
                $siguiente = isset($dias[$i + 1]) ? strtotime($dias[$i + 1]) : null;

                if (!$siguiente || $siguiente !== strtotime('+1 day', $actual)) {
                    $fecha_inicio = $grupo[0];
                    $fecha_fin = date('Y-m-d', strtotime(end($grupo) . ' +1 day'));

                    // Obtener miembros de este evento
                    $sqlMiembros = $dbConn->prepare("SELECT 
                            m.*, 
                            me.*, 
                            u.user_full_name
                           
                        FROM 
                            miembro_evento me
                        JOIN 
                            miembro_equipo m ON me.id_miembro = m.id_miembro
                             JOIN 
                            users u ON u.user_id = m.user_id
                        WHERE 
                            me.id_evento = :id_evento
                        ");
                    $sqlMiembros->bindParam(':id_evento', $evento2['id_evento']);
                    $sqlMiembros->execute();
                    $miembros = $sqlMiembros->fetchAll(PDO::FETCH_ASSOC);

                    foreach ($miembros as $miembro) {
                        $intervalos[] = [
                            'id' => 'evento_' . $evento2['id_evento'] . '_miembro_' . $miembro['id_miembro'],
                            'title' => $evento2['nombre'],
                            'start' => $fecha_inicio,
                            'end' => $fecha_fin,
                            'color' => '#4e73df',
                            'extendedProps' => [
                                'tipo' => 'miembro_evento',
                                'id_miembro_evento' => $miembro['id_miembro_evento'],
                                'descripcion' =>  $miembro['user_full_name'] ?? 'Miembro'
                            ]
                        ];
                    }

                    // También agregar el evento del camión (si querés seguir mostrándolo)


                    $grupo = [];
                }
            }
        }

        header("HTTP/1.1 200 OK");
        echo json_encode($intervalos);
        exit();
    }

    if (isset($_GET['id_miembro'])) {
        $id_miembro = $_GET['id_miembro'];

        $sql = $dbConn->prepare("
        SELECT me.*, u.user_full_name
        FROM miembro_equipo me
        LEFT JOIN users u ON me.user_id = u.user_id
        WHERE me.id_miembro = :id_miembro
    ");
        $sql->bindValue(":id_miembro", $id_miembro);
        $sql->execute();
        $miembro = $sql->fetch(PDO::FETCH_ASSOC);

        if ($miembro) {
            header("HTTP/1.1 200 OK");
            echo json_encode($miembro);
        } else {
            header("HTTP/1.1 404 Not Found");
            echo json_encode(["error" => "Miembro no encontrado"]);
        }
        exit();
    }
    if (isset($_GET['id_evento_miembros_no'])) {
        $id_evento = $_GET['id_evento_miembros_no'];

        // Obtener todos los id_miembro que ya están asignados al evento
        $sql = $dbConn->prepare("SELECT id_miembro FROM miembro_evento WHERE id_evento = :id_evento");
        $sql->bindValue(":id_evento", $id_evento);
        $sql->execute();
        $asignados = $sql->fetchAll(PDO::FETCH_COLUMN); // array con solo id_miembro

        if (count($asignados) > 0) {
            // Si hay miembros asignados, usar NOT IN con placeholders
            $placeholders = implode(',', array_fill(0, count($asignados), '?'));
            $query = "
            SELECT me.*, u.user_full_name
            FROM miembro_equipo me
            LEFT JOIN users u ON me.user_id = u.user_id
            WHERE me.estado = 'Aceptado' AND me.id_miembro NOT IN ($placeholders)
        ";
            $sql = $dbConn->prepare($query);
            $sql->execute($asignados);
        } else {
            // Si no hay asignados, traer todos los de estado Aceptado con su nombre de usuario
            $sql = $dbConn->prepare("
            SELECT me.*, u.user_full_name
            FROM miembro_equipo me
            LEFT JOIN users u ON me.user_id = u.user_id
            WHERE me.estado = 'Aceptado'
        ");
            $sql->execute();
        }
        $miembros_disponibles = $sql->fetchAll(PDO::FETCH_ASSOC);

        header("HTTP/1.1 200 OK");
        echo json_encode($miembros_disponibles);
        exit();
    }

    if (isset($_GET['id_evento_miembros'])) {
        $id_evento = $_GET['id_evento_miembros'];

        // 1. Obtener los días del evento actual
        $sql_dias = $dbConn->prepare("SELECT dias FROM eventos2 WHERE id_evento = :id_evento");
        $sql_dias->bindValue(":id_evento", $id_evento);
        $sql_dias->execute();
        $evento_actual = $sql_dias->fetch(PDO::FETCH_ASSOC);
        $dias_evento_actual = json_decode($evento_actual['dias'], true) ?? [];

        // 2. Obtener todos los registros de miembro_evento para ese evento
        $sql = $dbConn->prepare("SELECT * FROM miembro_evento WHERE id_evento = :id_evento");
        $sql->bindValue(":id_evento", $id_evento);
        $sql->execute();
        $miembros_evento = $sql->fetchAll(PDO::FETCH_ASSOC);

        $resultado = [];

        foreach ($miembros_evento as $miembro_evento) {
            $id_miembro = $miembro_evento['id_miembro'];

            // Obtener información del miembro_equipo y su usuario
            $sql_miembro = $dbConn->prepare("
            SELECT me.*, u.user_full_name
            FROM miembro_equipo me
            LEFT JOIN users u ON me.user_id = u.user_id
            WHERE me.id_miembro = :id_miembro
        ");
            $sql_miembro->bindValue(":id_miembro", $id_miembro);
            $sql_miembro->execute();
            $miembro_info = $sql_miembro->fetch(PDO::FETCH_ASSOC);

            // 3. Verificar si este miembro está asignado a otros eventos en los mismos días
            $sql_conflictos = $dbConn->prepare("
            SELECT e.dias
            FROM miembro_evento me
            INNER JOIN eventos2 e ON e.id_evento = me.id_evento
            WHERE me.id_miembro = :id_miembro
            AND me.id_evento != :id_evento
        ");
            $sql_conflictos->bindValue(":id_miembro", $id_miembro);
            $sql_conflictos->bindValue(":id_evento", $id_evento);
            $sql_conflictos->execute();
            $otros_eventos = $sql_conflictos->fetchAll(PDO::FETCH_ASSOC);

            $hay_conflicto = false;

            foreach ($otros_eventos as $otro_evento) {
                $dias_otro = json_decode($otro_evento['dias'], true) ?? [];
                if (count(array_intersect($dias_evento_actual, $dias_otro)) > 0) {
                    $hay_conflicto = true;
                    break;
                }
            }

            if ($hay_conflicto) {
                $miembro_evento['estado_miembro'] = "Solicitado en más de un evento con las mismas fechas";
                $miembro_evento['estado_m'] = false;
            } else {
                $miembro_evento['estado_miembro'] = "Solicitado solo en este evento en las fechas seleccionadas";
                $miembro_evento['estado_m'] = true;
            }

            $miembro_evento['miembro'] = $miembro_info;
            $resultado[] = $miembro_evento;
        }

        header("HTTP/1.1 200 OK");
        echo json_encode($resultado);
        exit();
    }

    if (isset($_GET['id_evento_archivos'])) {

        $id_factura_proveedor = $_GET["id_evento_archivos"];

        $images = glob('../archivos/eventos/' . $id_factura_proveedor . '/*.{png,jpg,pdf}', GLOB_BRACE);

        $fileObjects = array();

        foreach ($images as $image) {

            $fileInfo = pathinfo($image);

            $fileObject = new stdClass(); // Crear un objeto vacío para almacenar los datos

            $fileObject->url = $image; // Almacenar la URL del archivo

            $fileObject->extension = $fileInfo['extension']; // Almacenar la extensión del archivo

            $fileObject->nombre = $fileInfo['basename']; // Almacenar la extensión del archivo

            $fileObjects[] = $fileObject; // Agregar el objeto al arreglo

        }

        header("HTTP/1.1 200 OK");

        echo json_encode($fileObjects);

        exit();
    }
    if (isset($_GET['seguimientos'])) {
        $client_id_filter = (isset($_GET['client_id']) && $_GET['client_id'] != "No") ? $_GET['client_id'] : null;

        if ($client_id_filter) {
            // Obtener registros de evento_material solo para eventos con ese client_id
            $sql = $dbConn->prepare("
            SELECT em.*
            FROM evento_material em
            INNER JOIN eventos2 e ON em.id_evento = e.id_evento
            WHERE e.client_id = :client_id
        ");
            $sql->bindValue(":client_id", $client_id_filter);
            $sql->execute();
            $registros = $sql->fetchAll(PDO::FETCH_ASSOC);
        } else {
            // Sin filtro client_id: obtener todos los registros
            $sql = $dbConn->prepare("SELECT * FROM evento_material");
            $sql->execute();
            $registros = $sql->fetchAll(PDO::FETCH_ASSOC);
        }

        $seguimientos = [];

        foreach ($registros as $registro) {
            $id_evento = $registro['id_evento'];
            $id_material = $registro['id_material'];

            // Obtener evento completo
            $sql_evento = $dbConn->prepare("SELECT * FROM eventos2 WHERE id_evento = :id_evento");
            $sql_evento->bindValue(":id_evento", $id_evento);
            $sql_evento->execute();
            $evento = $sql_evento->fetch(PDO::FETCH_ASSOC);

            $dias_actuales = [];
            if ($evento && isset($evento['dias'])) {
                $evento['dias'] = json_decode($evento['dias'], true);
                $dias_actuales = $evento['dias'];
            }

            // Obtener material completo
            $sql_material = $dbConn->prepare("SELECT * FROM materiales2 WHERE id_material = :id_material");
            $sql_material->bindValue(":id_material", $id_material);
            $sql_material->execute();
            $material = $sql_material->fetch(PDO::FETCH_ASSOC);

            // Obtener cliente asociado al evento
            $cliente = null;
            if ($evento && isset($evento['client_id'])) {
                $sql_cliente = $dbConn->prepare("SELECT * FROM clientes WHERE client_id = :client_id");
                $sql_cliente->bindValue(":client_id", $evento['client_id']);
                $sql_cliente->execute();
                $cliente = $sql_cliente->fetch(PDO::FETCH_ASSOC);
            }

            // Validación de conflictos de stock en mismas fechas
            $sql_conflicto = $dbConn->prepare("
            SELECT em.dias, em.cantidad
            FROM evento_material em
            WHERE em.id_material = :id_material
            AND em.id_evento != :id_evento
        ");
            $sql_conflicto->bindValue(":id_material", $id_material);
            $sql_conflicto->bindValue(":id_evento", $id_evento);
            $sql_conflicto->execute();
            $otros_eventos = $sql_conflicto->fetchAll(PDO::FETCH_ASSOC);

            $cantidad_usada = 0;
            $otros_conflictivos = [];

            foreach ($otros_eventos as $otro) {
                $dias_otro = json_decode($otro['dias'], true) ?? [];

                if (!is_array($dias_otro)) continue;

                if (count(array_intersect($dias_actuales, $dias_otro)) > 0) {
                    $cantidad_usada += (int)$otro['cantidad'];
                    $otros_conflictivos[] = $otro;
                }
            }

            $cantidad_actual = (int)$registro['cantidad'];
            $stock = (int)($material['stock'] ?? 0);
            $cantidad_total = $cantidad_usada + $cantidad_actual;

            if ($cantidad_total > $stock) {
                $estado_material = "Solicitado en otros eventos en la misma fecha. Cantidad total requerida: $cantidad_total > Stock: $stock";
                $estado_m = false;
            } else {
                $estado_material = "Disponible. Cantidad total requerida en la misma fecha: $cantidad_total ≤ Stock: $stock";
                $estado_m = true;
            }

            $item = $registro;
            $item['evento'] = $evento;
            $item['material'] = $material;
            $item['cliente'] = $cliente;
            $item['otros_eventos_conflictivos'] = $otros_conflictivos;
            $item['estado_material'] = $estado_material;
            $item['estado_m'] = $estado_m;

            $seguimientos[] = $item;
        }

        header("HTTP/1.1 200 OK");
        echo json_encode($seguimientos);
        exit();
    }




    if (isset($_GET['id_evento'])) {
        $id = $_GET['id_evento'];

        // 1. Obtener evento y matrícula del camión
        $sql = $dbConn->prepare("
        SELECT e.*, COALESCE(c.matricula, 'Ninguno') AS matricula
        FROM eventos2 e
        LEFT JOIN camiones c ON e.id_camion = c.id_camion
        WHERE e.id_evento = :id
    ");
        $sql->bindValue(":id", $id);
        $sql->execute();
        $evento = $sql->fetch(PDO::FETCH_ASSOC);

        if (!$evento) {
            header("HTTP/1.1 404 Not Found");
            echo json_encode(['error' => 'Evento no encontrado']);
            exit();
        }

        // 2. Obtener materiales asociados al evento (incluyendo los días desde evento_material)
        $sql_mat = $dbConn->prepare("
        SELECT m.*, em.cantidad, em.dias,em.id_evento_material
        FROM materiales2 m
        INNER JOIN evento_material em ON em.id_material = m.id_material
        WHERE em.id_evento = :id
    ");
        $sql_mat->bindValue(":id", $id);
        $sql_mat->execute();
        $materiales = $sql_mat->fetchAll(PDO::FETCH_ASSOC);

        // 3. Recorrer materiales y verificar conflictos por días y stock
        foreach ($materiales as &$material) {
            $id_evento_material = $material['id_evento_material'];

            // Obtener complementos para este evento_material
            $sql_complementos = $dbConn->prepare("
        SELECT c.*
        FROM complemento_material cm
        INNER JOIN complementos c ON cm.id_complemento = c.id_complemento
        WHERE cm.id_evento_material = :id_evento_material
    ");
            $sql_complementos->bindValue(":id_evento_material", $id_evento_material);
            $sql_complementos->execute();
            $complementos = $sql_complementos->fetchAll(PDO::FETCH_ASSOC);

            $material['complementos'] = $complementos;

            $id_material = $material['id_material'];
            $stock = $material['stock'];

            // Obtener los días del evento actual para ese material
            $dias_actuales = json_decode($material['dias'], true) ?? [];

            $sql_conflicto = $dbConn->prepare("
            SELECT em.dias, em.cantidad
            FROM evento_material em
            WHERE em.id_material = :id_material
            AND em.id_evento != :id_evento
        ");
            $sql_conflicto->bindValue(":id_material", $id_material);
            $sql_conflicto->bindValue(":id_evento", $id);
            $sql_conflicto->execute();
            $otros_eventos = $sql_conflicto->fetchAll(PDO::FETCH_ASSOC);

            $cantidad_usada = 0;
            $otros_conflictivos = [];

            foreach ($otros_eventos as $otro) {
                $dias_otro = json_decode($otro['dias'], true) ?? [];

                if (!is_array($dias_otro)) continue;

                // Verificar intersección de días
                if (count(array_intersect($dias_actuales, $dias_otro)) > 0) {
                    $cantidad_usada += (int)$otro['cantidad'];
                    $otros_conflictivos[] = $otro;
                }
            }

            $material['otros'] = $otros_conflictivos;
            $cantidad_total = $cantidad_usada + (int)$material['cantidad'];

            if ($cantidad_total > $stock) {
                $material['estado_material'] = "Solicitado en otros eventos en la misma fecha. Cantidad total requerida: $cantidad_total > Stock: $stock";
                $material['estado_m'] = false;
            } else {
                $material['estado_material'] = "Disponible. Cantidad total requerida en la misma fecha: $cantidad_total ≤ Stock: $stock";
                $material['estado_m'] = true;
            }
        }

        $evento['materiales'] = $materiales;

        header("HTTP/1.1 200 OK");
        echo json_encode($evento);
        exit();
    } else {
 $where = [];
        $params = [];

        if (isset($_GET['id_comercial']) && $_GET['id_comercial'] !== 'No') {
            $where[] = "e.id_comercial = :id_comercial";
            $params[':id_comercial'] = $_GET['id_comercial'];
        }
        $sql = ("
        SELECT e.*, COALESCE(c.matricula, 'Ninguno') AS matricula, COALESCE(cl.nombre, 'Ninguno') AS nombre_cliente
        FROM eventos2 e
        LEFT JOIN camiones c ON e.id_camion = c.id_camion
        LEFT JOIN clientes cl ON e.client_id = cl.client_id
    ");
     // Agregar condiciones si hay filtros
        if (!empty($where)) {
            $sql .= " WHERE " . implode(" AND ", $where);
        }

    $ddd = $dbConn->prepare($sql);
        $ddd->execute($params);
        $eventos = $ddd->fetchAll(PDO::FETCH_ASSOC);

        foreach ($eventos as &$evento) {
    $evento['dias'] = json_decode($evento['dias'], true);
    $id_evento = $evento['id_evento'];
    $dias_actuales = $evento['dias'];

    // Obtener materiales asociados
    $sql_mat = $dbConn->prepare("
        SELECT m.*, em.cantidad
        FROM materiales2 m
        INNER JOIN evento_material em ON em.id_material = m.id_material
        WHERE em.id_evento = :id
    ");
    $sql_mat->bindValue(":id", $id_evento);
    $sql_mat->execute();
    $materiales = $sql_mat->fetchAll(PDO::FETCH_ASSOC);

    // Revisar conflictos para cada material
    foreach ($materiales as &$material) {
        $id_material = $material['id_material'];
        $stock = $material['stock'];

        $sql_conflicto = $dbConn->prepare("
            SELECT e.dias, em.cantidad
            FROM evento_material em
            INNER JOIN eventos2 e ON e.id_evento = em.id_evento
            WHERE em.id_material = :id_material
            AND em.id_evento != :id_evento
        ");
        $sql_conflicto->bindValue(":id_material", $id_material);
        $sql_conflicto->bindValue(":id_evento", $id_evento);
        $sql_conflicto->execute();
        $otros_eventos = $sql_conflicto->fetchAll(PDO::FETCH_ASSOC);

        $cantidad_usada = 0;
        $otros_conflictivos = [];

        foreach ($otros_eventos as $otro) {
            $dias_otro = json_decode($otro['dias'], true);
            if (!is_array($dias_otro)) continue;

            if (count(array_intersect($dias_actuales, $dias_otro)) > 0) {
                $cantidad_usada += (int)$otro['cantidad'];
                $otros_conflictivos[] = $otro;
            }
        }

        $material['otros'] = $otros_conflictivos;
        $cantidad_total = $cantidad_usada + (int)$material['cantidad'];

        if ($cantidad_total > $stock) {
            $material['estado_material'] = "Solicitado en otros eventos en la misma fecha. Cantidad total requerida : $cantidad_total > Stock: $stock";
            $material['estado_m'] = false;
        } else {
            $material['estado_material'] = "Disponible. Cantidad total requerida en la misma fecha: $cantidad_total ≤ Stock: $stock";
            $material['estado_m'] = true;
        }
    }

    $evento['materiales'] = $materiales;

    // 💡 Verificar si existe un presupuesto para este evento
    $sql_pres = $dbConn->prepare("SELECT * FROM presupuestos_material WHERE id_evento = :id_evento LIMIT 1");
    $sql_pres->bindValue(':id_evento', $id_evento);
    $sql_pres->execute();
    $presupuesto = $sql_pres->fetch(PDO::FETCH_ASSOC);

    // Asignar presupuesto o null
    $evento['presupuesto'] = $presupuesto ?: null;

      $sql_pres = $dbConn->prepare("SELECT * FROM factura_manual_materiales WHERE id_evento = :id_evento LIMIT 1");
    $sql_pres->bindValue(':id_evento', $id_evento);
    $sql_pres->execute();
    $factura = $sql_pres->fetch(PDO::FETCH_ASSOC);

    // Asignar presupuesto o null
    $evento['factura'] = $factura ?: null;
}


        header("HTTP/1.1 200 OK");
        echo json_encode($eventos);
        exit();
    }
}

// POST: crear o editar evento
if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    if (
        isset($_POST['id_evento_agregar_miembro']) &&
        isset($_POST['id_miembro_agregar_miembro'])
    ) {
        $id_evento = $_POST['id_evento_agregar_miembro'];
        $id_miembro = $_POST['id_miembro_agregar_miembro'];

        // Verificar si ya existe la relación para evitar duplicados
        $check = $dbConn->prepare("
        SELECT COUNT(*) FROM miembro_evento 
        WHERE id_evento = :id_evento AND id_miembro = :id_miembro
    ");
        $check->bindValue(":id_evento", $id_evento);
        $check->bindValue(":id_miembro", $id_miembro);
        $check->execute();
        $exists = $check->fetchColumn();

        if ($exists > 0) {
            header("HTTP/1.1 409 Conflict");
            echo json_encode(["error" => "El miembro ya está asignado a este evento."]);
            exit();
        }

        // Insertar nuevo registro en miembro_evento
        $insert = $dbConn->prepare("
        INSERT INTO miembro_evento (id_evento, id_miembro) 
        VALUES (:id_evento, :id_miembro)
    ");
        $insert->bindValue(":id_evento", $id_evento);
        $insert->bindValue(":id_miembro", $id_miembro);
        $insert->execute();

        header("HTTP/1.1 201 Created");
        echo json_encode(["success" => true, "message" => "Miembro agregado al evento"]);
        exit();
    }

    if (isset($_POST['id_evento_material_devolver']) && isset($_POST['devueltos'])) {
        $id_evento_material = $_POST['id_evento_material_devolver'];
        $devueltos = $_POST['devueltos'];

        $update_stmt = $dbConn->prepare("UPDATE evento_material SET devueltos = :devueltos WHERE id_evento_material = :id_evento_material");
        $update_stmt->bindValue(":devueltos", $devueltos);
        $update_stmt->bindValue(":id_evento_material", $id_evento_material);
        $update_stmt->execute();

        header("HTTP/1.1 200 OK");
        echo json_encode([
            'accion' => 'material_actualizado',
            'id_evento_material' => $id_evento_material,
            'devueltos' => $devueltos
        ]);
        exit();
    }

    if (

        isset($_POST["id_evento_archivos"]) && isset($_FILES['archivo']) && isset($_POST['extension'])

        && isset($_POST['nombre'])

    ) {

        $nombre = $_POST["nombre"];

        $extension = $_POST["extension"];

        $id_factura_proveedor = $_POST["id_evento_archivos"];

        $archivo = $_FILES['archivo'];

        $baseUrl = ($_SERVER['HTTPS'] ? 'https://' : 'http://') . $_SERVER['HTTP_HOST'] . '/';

        $rutaArchivoTemporal = isset($_FILES['archivo']) ? $_FILES['archivo']['tmp_name'] : null;

        $Archivo = '../archivos/eventos/' . $id_factura_proveedor . '/' . $nombre . '.' . $extension;

        if (file_exists($Archivo)) {

            header("HTTP/1.1 200 OK");

            echo 0;

            exit();
        } else {

            if ($rutaArchivoTemporal && !empty($rutaArchivoTemporal)) {

                move_uploaded_file($rutaArchivoTemporal, $Archivo);
            }

            header("HTTP/1.1 200 OK");

            exit();
        }
    }
     if (isset($_POST['materiales'])) {
    $materiales = json_decode($_POST['materiales'], true);
    $id_evento_final = $_POST["id_evento"] ?? null;

    // 1. Eliminar asociaciones anteriores
    $del_stmt = $dbConn->prepare("DELETE FROM evento_material WHERE id_evento = :id_evento");
    $del_stmt->bindValue(":id_evento", $id_evento_final);
    $del_stmt->execute();

    // 2. Insertar nuevas asociaciones
    $ins_stmt = $dbConn->prepare("INSERT INTO evento_material (id_evento, id_material, cantidad, dias) VALUES (:id_evento, :id_material, :cantidad, :dias)");

    foreach ($materiales as $extra) {
        $ins_stmt->bindValue(":id_evento", $id_evento_final);
        $ins_stmt->bindValue(":id_material", $extra['id']);
        $ins_stmt->bindValue(":cantidad", $extra['cantidad']);
        $ins_stmt->bindValue(":dias", json_encode($extra['dias']));
      $success = $ins_stmt->execute();

if (!$success) {
    error_log("Error al insertar en evento_material: " . implode(" | ", $ins_stmt->errorInfo()));
    continue; // no intentar insertar complementos si falló
}


    $id_evento_material = $dbConn->lastInsertId();
if (!$id_evento_material) {
    error_log("No se obtuvo id_evento_material después del insert");
    continue;
}else{
 error_log( "ID del evento material insertado: " . $id_evento_material);
    
} 


        foreach ($extra['complementos'] as $complemento) {
            $ins_stmt2 = $dbConn->prepare("INSERT INTO complemento_material (id_evento_material, id_complemento) VALUES (:id_evento_material, :id_complemento)");
            $ins_stmt2->bindValue(":id_evento_material", $id_evento_material);
            $ins_stmt2->bindValue(":id_complemento", $complemento);
            $ins_stmt2->execute();
        }
    }

    header("HTTP/1.1 200 OK");
    echo json_encode(['id_evento' => $id_evento_final]);
    exit();
}
if (
    isset($_POST['dias_material_evento']) &&
    isset($_POST['complementos_material_evento']) &&
    isset($_POST['id_evento_agregar_material']) &&
    isset($_POST['cantidad_material_evento']) &&
    isset($_POST['id_material_agregar_evento']) // también necesitamos el id_material
) {
    $id_evento = $_POST['id_evento_agregar_material'];
    $id_material = $_POST['id_material_agregar_evento'];
    $cantidad = $_POST['cantidad_material_evento'];

    // Aseguramos que días sea array
    $dias = is_array($_POST['dias_material_evento']) ? $_POST['dias_material_evento'] : json_decode($_POST['dias_material_evento'], true);
    $complementos = is_array($_POST['complementos_material_evento']) ? $_POST['complementos_material_evento'] : json_decode($_POST['complementos_material_evento'], true);

    try {
        // 1. Insertar evento_material
        $stmt = $dbConn->prepare("INSERT INTO evento_material (id_evento, id_material, cantidad, dias) VALUES (:id_evento, :id_material, :cantidad, :dias)");
        $stmt->bindValue(':id_evento', $id_evento);
        $stmt->bindValue(':id_material', $id_material);
        $stmt->bindValue(':cantidad', $cantidad);
        $stmt->bindValue(':dias', json_encode($dias));
        $success = $stmt->execute();

        if (!$success) {
            error_log("Error al insertar en evento_material: " . implode(" | ", $stmt->errorInfo()));
            http_response_code(500);
            echo json_encode(['error' => 'Error al insertar evento_material']);
            exit();
        }

        $id_evento_material = $dbConn->lastInsertId();
        if (!$id_evento_material) {
            error_log("No se obtuvo id_evento_material después del insert");
            http_response_code(500);
            echo json_encode(['error' => 'No se obtuvo ID insertado']);
            exit();
        }

        error_log("Evento material insertado con ID: " . $id_evento_material);

        // 2. Insertar complementos asociados
        foreach ($complementos as $id_complemento) {
            $stmt2 = $dbConn->prepare("INSERT INTO complemento_material (id_evento_material, id_complemento) VALUES (:id_evento_material, :id_complemento)");
            $stmt2->bindValue(':id_evento_material', $id_evento_material);
            $stmt2->bindValue(':id_complemento', $id_complemento);
            $stmt2->execute();
        }

        http_response_code(200);
        echo json_encode(['id_evento_material' => $id_evento_material]);
        exit();

    } catch (PDOException $e) {
        error_log("Error PDO: " . $e->getMessage());
        http_response_code(500);
        echo json_encode(['error' => 'Error interno']);
        exit();
    }
}

    if (
        isset($_POST['id_evento_dias']) &&
        isset($_POST['fecha_i']) && isset($_POST['fecha_f']) &&
        isset($_POST['fecha_i_o']) && isset($_POST['fecha_f_o'])
    ) {

        try {

            $id_evento = $_POST['id_evento_dias'];
            $fecha_i = $_POST['fecha_i'];
            $fecha_f = $_POST['fecha_f'];
            $fecha_i_o = $_POST['fecha_i_o'];
            $fecha_f_o = $_POST['fecha_f_o'];

            // 1. Obtener días actuales
            $query = $dbConn->prepare("SELECT dias FROM eventos2 WHERE id_evento = :id_evento");
            $query->bindValue(":id_evento", $id_evento);
            $query->execute();
            $result = $query->fetch(PDO::FETCH_ASSOC);

            $dias_actuales = json_decode($result['dias'], true) ?? [];

            // 2. Generar rango de fechas a eliminar (previas)
            $dias_a_eliminar = [];
            $fechaInicioOld = new DateTime($fecha_i_o);
            $fechaFinOld = new DateTime($fecha_f_o);
            while ($fechaInicioOld <= $fechaFinOld) {
                $dias_a_eliminar[] = $fechaInicioOld->format('Y-m-d');
                $fechaInicioOld->modify('+1 day');
            }

            // 3. Filtrar los días actuales para eliminar los viejos
            $dias_filtrados = array_values(array_diff($dias_actuales, $dias_a_eliminar));

            // 4. Generar nuevos días a agregar
            $nuevos_dias = [];
            $fechaInicioNew = new DateTime($fecha_i);
            $fechaFinNew = new DateTime($fecha_f);
            while ($fechaInicioNew <= $fechaFinNew) {
                $nuevos_dias[] = $fechaInicioNew->format('Y-m-d');
                $fechaInicioNew->modify('+1 day');
            }

            // 5. Fusionar y ordenar los días
            $dias_finales = array_unique(array_merge($dias_filtrados, $nuevos_dias));
            sort($dias_finales);

            // 6. Actualizar en base de datos
            $update = $dbConn->prepare("UPDATE eventos2 SET dias = :dias WHERE id_evento = :id_evento");
            $update->bindValue(":dias", json_encode($dias_finales));
            $update->bindValue(":id_evento", $id_evento);
            $update->execute();
            $response = array(
                'success' => true,
                'title' => isset($id_vacacion) ? 'Evento actualizado.' : 'Evento registrado.',
                'message' => isset($id_vacacion)
                    ? 'El evento se ha actualizado correctamente.'
                    : 'El evento se ha registrado correctamente.'
            );
            header("HTTP/1.1 200 OK");
            echo json_encode($response);
            exit();
        } catch (PDOException $e) {
            $response = array(
                'success' => false,
                'title' => "Error en la operación.",
                'message' => "Hubo un problema al guardar los datos: " . $e->getMessage()
            );

            header("HTTP/1.1 200 OK");
            echo json_encode($response);
            exit();
        }
    } else {
        $id_evento = $_POST["id_evento"] ?? null;
        $id_cliente = $_POST["id_cliente"] ?? null;
        $nombre = $_POST["nombre"] ?? '';
        $id_camion = (!empty($_POST["id_camion"])) ? $_POST["id_camion"] : null;
        $localizacion = $_POST["localizacion"] ?? '';
        $dias = isset($_POST["dias"]) ? json_encode(json_decode($_POST["dias"], true)) : '[]';
$id_comercial = !empty($_POST["id_comercial"]) ? $_POST["id_comercial"] : null;

        if ($id_evento === null) {
            // Crear nuevo
           $stmt = $dbConn->prepare("INSERT INTO eventos2 (nombre, id_camion, localizacion, dias, client_id, id_comercial) VALUES (:nombre, :id_camion, :localizacion, :dias, :client_id, :id_comercial)");

        } else {
            // Eliminar registros anteriores de evento_material
            $delete = $dbConn->prepare("DELETE FROM evento_material WHERE id_evento = :id_evento");
            $delete->bindValue(":id_evento", $id_evento);
            $delete->execute();

            // Actualizar existente
$stmt = $dbConn->prepare("UPDATE eventos2 SET nombre = :nombre, id_camion = :id_camion, client_id = :client_id, localizacion = :localizacion, dias = :dias, id_comercial = :id_comercial WHERE id_evento = :id_evento");

            $stmt->bindValue(":id_evento", $id_evento);
        }
$stmt->bindValue(":id_comercial", $id_comercial);

        $stmt->bindValue(":nombre", $nombre);
        $stmt->bindValue(":id_camion", $id_camion);
        $stmt->bindValue(":client_id", $id_cliente);
        $stmt->bindValue(":localizacion", $localizacion);
        $stmt->bindValue(":dias", $dias);
        $stmt->execute();

        if ($id_evento === null) {
            $carpetaNuevaAlumno = '../archivos/eventos/' . $dbConn->lastInsertId();
            mkdir($carpetaNuevaAlumno, 0777, true);
        }

        header("HTTP/1.1 200 OK");
        echo json_encode([
            'accion' => $id_evento ? 'evento_actualizado' : 'evento_creado',
            'id_evento' => $id_evento ?? $dbConn->lastInsertId()
        ]);
        exit();
    }
}

// DELETE: eliminar evento
if ($_SERVER['REQUEST_METHOD'] == 'DELETE') {
    if (isset($_GET['id'])) {
        $id = $_GET['id'];
        $stmt = $dbConn->prepare("DELETE FROM eventos2 WHERE id_evento = :id");
        $stmt->bindValue(":id", $id);
        $stmt->execute();

        $carpetaEliminar = '../archivos/eventos/' . $id;

        eliminarCarpeta($carpetaEliminar);
        header("HTTP/1.1 200 OK");
        echo json_encode(['accion' => 'evento_eliminado']);
        exit();
    }
    if (isset($_GET['id_evento_material'])) {
        $id = $_GET['id_evento_material'];
        $stmt = $dbConn->prepare("DELETE FROM evento_material WHERE id_evento_material = :id");
        $stmt->bindValue(":id", $id);
        $stmt->execute();

        header("HTTP/1.1 200 OK");
        echo json_encode(['accion' => 'evento_eliminado']);
        exit();
    }
    if (isset($_GET['id_evento_miembro'])) {
        $id = $_GET['id_evento_miembro'];
        $stmt = $dbConn->prepare("DELETE FROM miembro_evento WHERE id_miembro_evento = :id");
        $stmt->bindValue(":id", $id);
        $stmt->execute();

        header("HTTP/1.1 200 OK");
        echo json_encode(['accion' => 'evento_eliminado']);
        exit();
    }
    if (isset($_GET["url"])) {

        $url = $_GET['url'];

        $carpetaEliminar = '.' . $url;

        header("HTTP/1.1 200 OK");

        unlink($carpetaEliminar);

        echo $carpetaEliminar;

        exit();
    }
}
function eliminarCarpeta($rutaCarpeta)

{

    // Obtener una lista de archivos y subcarpetas dentro de la carpeta

    $archivos = glob($rutaCarpeta . '/*');

    // Eliminar cada archivo encontrado

    foreach ($archivos as $archivo) {

        if (is_file($archivo)) {

            unlink($archivo);
        } elseif (is_dir($archivo)) {

            eliminarCarpeta($archivo);
        }
    }

    // Eliminar la carpeta

    if (is_dir($rutaCarpeta)) {

        rmdir($rutaCarpeta);
    }
}
// Petición no válida
header("HTTP/1.1 400 Bad Request");
echo json_encode(['error' => 'Petición inválida']);
exit();