<?php



include "utils.php";





include "../models/users.model.php";



require_once(__ROOT__ . '/vendor/autoload.php');





use Convertio\Convertio;



$dbConn = connect($db);



/*

listar todos los posts o solo uno

 */

if ($_SERVER['REQUEST_METHOD'] == 'GET') {

    if (isset($_GET['id_evento'])) {

        //Mostrar un post

        $sql = $dbConn->prepare("SELECT e.*, COALESCE(c.nombre, 'Ninguna') AS nombre_categoria

        FROM eventos e

        LEFT JOIN categoria c ON e.id_categoria = c.id_categoria

        WHERE id_evento = :id_evento");

        $sql->bindValue(':id_evento', $_GET['id_evento']);

        $sql->execute();

        header("HTTP/1.1 200 OK");

        echo json_encode($sql->fetch(PDO::FETCH_ASSOC));

        exit();

    }

    if (isset($_GET['id_evento_archivos'])) {

        $id_evento = $_GET["id_evento_archivos"];

        $images = glob('../eventos/' . $id_evento . '/archivos/*.{png,jpg,pdf,docx}', GLOB_BRACE);

        $fileObjects = array();



        foreach ($images as $image) {

            $fileInfo = pathinfo($image);

            $fileObject = new stdClass(); // Crear un objeto vacío para almacenar los datos

            $fileObject->url = $image; // Almacenar la URL del archivo

            $fileObject->extension = $fileInfo['extension']; // Almacenar la extensión del archivo

            $fileObject->nombre = $fileInfo['basename']; // Almacenar la extensión del archivo



            $fileObjects[] = $fileObject; // Agregar el objeto al arreglo

        }

        header("HTTP/1.1 200 OK");

        echo json_encode($fileObjects);

        exit();

    } else {

        //Mostrar lista de post

        $sql = $dbConn->prepare("SELECT a.*,

      

     COALESCE(n.nombre, 'Ninguna') AS nombre_categoria

        FROM eventos a   

         LEFT JOIN categoria n ON n.id_categoria = a.id_categoria");

        $sql->execute();

        $sql->setFetchMode(PDO::FETCH_ASSOC);

        $clientes = $sql->fetchAll(PDO::FETCH_OBJ);

        foreach ($clientes as $cliente) {

            $clientID = $cliente->id_evento;

            $sql = "SELECT g.user_id, g.user_full_name, gc.id_user_evento

            FROM users g

            INNER JOIN user_evento gc ON g.user_id = gc.user_id

            WHERE gc.id_evento = :clientID";

            $stmt = $dbConn->prepare($sql);

            $stmt->bindParam(':clientID', $clientID, PDO::PARAM_INT);

            $stmt->execute();

            // Obtener el resultado como un objeto

            $cursos = $stmt->fetchAll(PDO::FETCH_OBJ);

            foreach ($cursos as $curso) {

                $contrato = (file_exists('../contratos/' . $clientID . "/" . $curso->user_id . "/contrato_lleno.pdf")) ? './contratos/' . $clientID . "/" . $curso->user_id . "/contrato_lleno.pdf" : null;

                $horario = (file_exists('../horarios/' . $clientID . "/" . $curso->user_id . "/horario_lleno.pdf")) ? './horarios/' . $clientID . "/" . $curso->user_id . "/horario_lleno.pdf" : null;

                $curso->contrato_lleno = $contrato;

                $curso->horario_lleno = $horario;

            }

            $cliente->miembros = $cursos;



            $fechaActual = date('Y-m-d H:i:s');

            // Fechas proporcionadas

            $fechaInicio = $cliente->fecha_inicio;

            $fechaFin = $cliente->fecha_final;

            // Comparar las fechas

            if ($cliente->cancelado == "1") {

                $estado = 'Cancelado';

            } else {

                if ($fechaActual < $fechaInicio) {

                    $estado = 'Pendiente';

                } elseif ($fechaActual >= $fechaInicio && $fechaActual <= $fechaFin) {

                    $estado = 'Activo';

                } else {

                    $estado = 'Finalizado';

                }

            }

            $cliente->estado = $estado;

        }



        header("HTTP/1.1 200 OK");

        // echo var_dump($sql->fetchAll());

        echo json_encode($clientes);



        exit();

    }

}



// Crear un nuevo post

if ($_SERVER['REQUEST_METHOD'] == 'POST') {

    if (

        isset($_POST["id_evento_archivo"]) && isset($_FILES['archivo']) && isset($_POST['extension'])

        && isset($_POST['nombre'])

    ) {

        $nombre = $_POST["nombre"];

        $extension = $_POST["extension"];

        $id_evento = $_POST["id_evento_archivo"];

        $archivo = $_FILES['archivo'];

        $baseUrl = ($_SERVER['HTTPS'] ? 'https://' : 'http://') . $_SERVER['HTTP_HOST'] . '/';

        $rutaArchivoTemporal = isset($_FILES['archivo']) ? $_FILES['archivo']['tmp_name'] : null;

        $Archivo = '../eventos/' . $id_evento . '/archivos/' . $nombre . '.' . $extension;

        if ($extension == "docx") {

            $Docx = '../eventos/' . $id_evento . '/archivos/' . $nombre . '.' . "pdf";

            $Docx2 = '../eventos/' . $id_evento . '/archivos/' . $nombre . '.' . "png";

            $Docx3 = '../eventos/' . $id_evento . '/archivos/' . $nombre . '.' . "jpg";

            if (file_exists($Docx) || file_exists($Docx2) || file_exists($Docx3)) {

                header("HTTP/1.1 200 OK");

                echo 0;

                exit();

            }

        }





        if (file_exists($Archivo)) {



            header("HTTP/1.1 200 OK");

            echo 0;

            exit();

        } else {

            if ($extension == "docx") {



                // Ruta de destino completa del archivo

                $rutaArchivoDestino = '../eventos/' . $id_evento . '/archivos/' . $nombre . '.' . $extension;





                $rutaArchivoDestinoPDF = '../eventos/' . $id_evento . '/archivos/' . $nombre . '.' . "pdf";

                move_uploaded_file($rutaArchivoTemporal, $rutaArchivoDestino);

                $API = new Convertio("e6a728f6d5fa08d8be8837f42f7b5b09");

                $API->start($rutaArchivoDestino, 'pdf')->wait();

                $API->download($rutaArchivoDestinoPDF);

                unlink($rutaArchivoDestino);

            } else {

                if ($rutaArchivoTemporal && !empty($rutaArchivoTemporal)) {

                    move_uploaded_file($rutaArchivoTemporal, $Archivo);

                }

            }

        }

        header("HTTP/1.1 200 OK");

        exit();

    }





    if (isset($_POST["id_evento_cancelar"])) {

        $id_evento_cancelar = $_POST["id_evento_cancelar"];

        $sql = "UPDATE eventos SET 

            cancelado = NOT cancelado WHERE id_evento = :id_evento_cancelar";

        $statement = $dbConn->prepare($sql);

        $statement->bindValue(':id_evento_cancelar', $id_evento_cancelar);

        $statement->execute();

        $sql = "SELECT cancelado, fecha_inicio, fecha_final FROM eventos WHERE id_evento = :id_evento_cancelar";

        $statement = $dbConn->prepare($sql);

        $statement->bindValue(':id_evento_cancelar', $id_evento_cancelar);

        $statement->execute();



        $resultado = $statement->fetch(PDO::FETCH_ASSOC);

        $input["cancelado"] = $resultado['cancelado'];

        $input["inicio"] = $resultado['fecha_inicio'];

        $input["fin"] = $resultado['fecha_final'];



        $fechaInicio = strtotime($resultado['fecha_inicio']);

        $fechaFin = strtotime($resultado['fecha_final']);

        $fechaActual = time();

        if ($fechaActual < $fechaInicio) {

            $input["estado"] = "Pendiente";

        } else {

            if ($fechaActual > $fechaInicio && $fechaActual < $fechaFin) {

                $input["estado"] = "Activo";

            } else {

                $input["estado"] = "Finalizado";

            }

        }



        header("HTTP/1.1 200 OK");

        echo json_encode($input);

        exit();

    }

    if (



        isset($_POST["nombre"]) &&

        isset($_POST["fecha_inicio"]) &&

        isset($_POST["fecha_final"]) &&

        isset($_POST["id_categoria"]) &&



        isset($_POST["descripcion"])

    ) {



        $nombre = $_POST["nombre"];



        $id_categoria = $_POST["id_categoria"];

        $fecha_inicio = $_POST["fecha_inicio"];

        $fecha_final = $_POST["fecha_final"];

        $descripcion = $_POST["descripcion"];



        if ($id_categoria === '') {

            $id_categoria = null;

        }





        $sqlCheck = "SELECT COUNT(*) FROM eventos WHERE nombre = :nombre";

        $statementCheck = $dbConn->prepare($sqlCheck);

        $statementCheck->bindValue(':nombre', $nombre);



        $statementCheck->execute();

        $count = $statementCheck->fetchColumn();



        if ($count > 0) {

            if (isset($_POST["nombre_viejo"]) && $_POST["nombre_viejo"] == $nombre) {

                $id_evento = $_POST["id_evento"];

                $sql = "UPDATE eventos SET 

                    

                        nombre = :nombre,

                        fecha_inicio = :fecha_inicio,

                        fecha_final = :fecha_final,

                        descripcion = :descripcion,

                        id_categoria = :id_categoria

                    WHERE id_evento = :id_evento";

                $statement = $dbConn->prepare($sql);

                $statement->bindValue(':id_evento', $id_evento);



                $statement->bindValue(':id_categoria', $id_categoria);

                $statement->bindValue(':nombre', $nombre);

                $statement->bindValue(':fecha_inicio', $fecha_inicio);

                $statement->bindValue(':fecha_final', $fecha_final);

                $statement->bindValue(':descripcion', $descripcion);

                $statement->execute();



                $postId = $_POST["id_evento"];



                if ($id_categoria != null) {

                    $sql = "SELECT * FROM categoria where id_categoria=:id_categoria";

                    $statement = $dbConn->prepare($sql);

                    $statement->bindValue(':id_categoria', $id_categoria);

                    $statement->execute();

                    $categoria = $statement->fetch(PDO::FETCH_ASSOC);

                } else {

                    $categoria["nombre"] = "Ninguna";

                }

                $input['id'] = $postId;



                $input['id_categoria'] = $id_categoria;

                $input['nombre'] = $nombre;

                $input['fecha_inicio'] = $fecha_inicio;

                $input['fecha_final'] = $fecha_final;

                $input['descripcion'] = $descripcion;

                $input['categoria'] = $categoria["nombre"];



                header("HTTP/1.1 200 OK");

                echo json_encode($input);

                exit();

            } else {

                header("HTTP/1.1 200 OK");

                echo "0";

                exit();

            }

        } else {

            if (isset($_POST["id_evento"])) {



                $id_evento = $_POST["id_evento"];

                $sql = "UPDATE eventos SET 

                   

                    nombre = :nombre,

                   fecha_inicio = :fecha_inicio,

                        fecha_final = :fecha_final,

                    descripcion = :descripcion,

                    id_categoria = :id_categoria

                WHERE id_evento = :id_evento";

                $statement = $dbConn->prepare($sql);

                $statement->bindValue(':id_evento', $id_evento);

            } else {

                $sql = "INSERT INTO eventos

                (nombre,fecha_inicio,fecha_final,descripcion,id_categoria)

                VALUES

                (:nombre,:fecha_inicio,:fecha_final,:descripcion,:id_categoria)";

                $statement = $dbConn->prepare($sql);

            }

        }







        $statement->bindValue(':id_categoria', $id_categoria);

        $statement->bindValue(':nombre', $nombre);

        $statement->bindValue(':fecha_inicio', $fecha_inicio);

        $statement->bindValue(':fecha_final', $fecha_final);

        $statement->bindValue(':descripcion', $descripcion);





        $statement->execute();



        if (isset($_POST["id_evento"])) {



            $id_evento = $_POST["id_evento"];

        } else {

            $postId = $dbConn->lastInsertId();

            $nuevoNombre = '../contratos/' . $postId;

            $carpetaHorarios = '../horarios/' . $postId;

            mkdir($nuevoNombre, 0777, true);

            mkdir($carpetaHorarios, 0777, true);





            $carpetaNuevaAlumno = '../eventos/' . $postId;

            $carpetaArchivosAlumno = '../eventos/' . $postId . '/archivos';

            mkdir($carpetaNuevaAlumno, 0777, true);

            mkdir($carpetaArchivosAlumno, 0777, true);

        }

        if ($id_categoria != null) {

            $sql = "SELECT * FROM categoria where id_categoria=:id_categoria";

            $statement = $dbConn->prepare($sql);

            $statement->bindValue(':id_categoria', $id_categoria);

            $statement->execute();

            $categoria = $statement->fetch(PDO::FETCH_ASSOC);

        } else {

            $categoria["nombre"] = "Ninguna";

        }





        $input['id'] = $postId;



        $input['id_categoria'] = $id_categoria;

        $input['nombre'] = $nombre;

        $input['fecha_inicio'] = $fecha_inicio;

        $input['fecha_final'] = $fecha_final;

        $input['descripcion'] = $descripcion;





        header("HTTP/1.1 200 OK");

        echo json_encode($input);

        exit();

    }

}



if ($_SERVER['REQUEST_METHOD'] == 'DELETE') {

    if (isset($_GET['id'])) {

        $id = $_GET['id'];



        $statement = $dbConn->prepare("DELETE FROM eventos where id_evento =:id");

        $statement->bindValue(':id', $id);



        $statement->execute();



        header("HTTP/1.1 200 OK");

        $carpetaEliminar = '../contratos/' . $id;

        eliminarCarpeta($carpetaEliminar);

        $carpetaEliminar = '../horarios/' . $id;

        eliminarCarpeta($carpetaEliminar);

        $carpetaEliminar = '../eventos/' . $id;

        eliminarCarpeta($carpetaEliminar);

        exit();

    }

    if (isset($_GET['url'])) {

        $url = "." . $_GET['url'];

        unlink($url);

        header("HTTP/1.1 200 OK");



        exit();

    }

}



function eliminarCarpeta($rutaCarpeta)

{

    // Obtener una lista de archivos y subcarpetas dentro de la carpeta

    $archivos = glob($rutaCarpeta . '/*');



    // Eliminar cada archivo encontrado

    foreach ($archivos as $archivo) {

        if (is_file($archivo)) {

            unlink($archivo);

        } elseif (is_dir($archivo)) {

            eliminarCarpeta($archivo);

        }

    }



    // Eliminar la carpeta

    if (is_dir($rutaCarpeta)) {

        rmdir($rutaCarpeta);

        echo "La carpeta se ha eliminado correctamente.";

    }

}



//En caso de que ninguna de las opciones anteriores se haya ejecutado

header("HTTP/1.1 400 Bad Request");