<?php

include "utils.php";

require_once __MODELS__ . 'pdf.model.php';

require_once __MODELS__ . 'mailer.model.php';

require_once __LIBRARIES__ . 'dompdf/autoload.inc.php';
require '../vendor/autoload.php';

use Smalot\PdfParser\Parser;
use Smalot\PdfParser\Config;
use Dompdf\Dompdf;

use Dompdf\Options;

$dbConn = connect($db);
$personalizacion = json_decode(file_get_contents('../personalizacion.json'), true);
/*

listar todos los posts o solo uno

 */

if ($_SERVER['REQUEST_METHOD'] == 'GET') {

    if (isset($_GET['id_miembro'], $_GET['fecha_i'], $_GET['fecha_f'], $_GET['id_miembro2'])) {
        $id_miembro = $_GET['id_miembro'];
        $fecha_i = $_GET['fecha_i'];
        $fecha_f = $_GET['fecha_f'];
        $id_miembro2 = $_GET['id_miembro2'];

        $datos1 = obtenerDatosMiembro($dbConn, $id_miembro, $fecha_i, $fecha_f);
        $datos2 = ($id_miembro2 !== "No") ? obtenerDatosMiembro($dbConn, $id_miembro2, $fecha_i, $fecha_f) : null;

        $respuesta = [
            'miembro_1' => $datos1,
            'miembro_2' => $datos2
        ];

        header("HTTP/1.1 200 OK");
        echo json_encode($respuesta);
        exit();
    }
    if (isset($_GET['pdf'])) {
        $re = pdf_parse();
        header("HTTP/1.1 200 OK");
        echo json_encode($re);
        exit();
    }
}

// Crear un nuevo post

if ($_SERVER['REQUEST_METHOD'] == 'POST') {

    if (isset($_POST['id_miembro_d'], $_POST['fecha_i_d'], $_POST['fecha_f_d'])) {
        $id_miembro = $_POST['id_miembro_d'];
        $fecha_i = $_POST['fecha_i_d'];
        $fecha_f = $_POST['fecha_f_d'];
        $imagen1 = $_POST['imagen1'] ?? null;
        $imagen2 = $_POST['imagen2'] ?? null;
        $datos = obtenerDatosMiembro($dbConn, $id_miembro, $fecha_i, $fecha_f);
        $Newsletter = file_get_contents(__ROOT__ . '/emails/estadisticas.html');

        $tiempo_en_descanso = floatval($datos["tiempo_en_descanso"]);

        $horas = floor($tiempo_en_descanso); // Parte entera: 7
        $minutos_decimales = $tiempo_en_descanso - $horas; // Parte decimal: 0.13
        $minutos = round($minutos_decimales * 60); // Convertir a minutos: 0.13 * 60 = 7.8 → 8

        $resultado1 = "{$horas}hs {$minutos}min";

        $tiempo_en_trabajo = floatval($datos["horas_trabajadas"]);

        $horas = floor($tiempo_en_trabajo); // Parte entera: 7
        $minutos_decimales = $tiempo_en_trabajo - $horas; // Parte decimal: 0.13
        $minutos = round($minutos_decimales * 60); // Convertir a minutos: 0.13 * 60 = 7.8 → 8

        $resultado2 = "{$horas}hs {$minutos}min";

        $Newsletter = str_replace("%dni%", htmlentities($datos["usuario"]["dni"], ENT_QUOTES), $Newsletter);
        $Newsletter = str_replace("%nombre_miembro%", htmlentities($datos["nombre"], ENT_QUOTES), $Newsletter);
        $Newsletter = str_replace("%email_miembro%", htmlentities($datos["email"], ENT_QUOTES), $Newsletter);
        $Newsletter = str_replace("%provincia%", htmlentities($datos["provincia"], ENT_QUOTES), $Newsletter);
        $Newsletter = str_replace("%localidad%", htmlentities($datos["localidad"], ENT_QUOTES), $Newsletter);
        $Newsletter = str_replace("%fecha_i%", htmlentities($fecha_i, ENT_QUOTES), $Newsletter);
        $Newsletter = str_replace("%fecha_f%", htmlentities($fecha_f, ENT_QUOTES), $Newsletter);


        $Newsletter = str_replace("%total_dias%", htmlentities($datos["total_dias"], ENT_QUOTES), $Newsletter);
        $Newsletter = str_replace("%dias_con_fichaje%", htmlentities($datos["dias_con_fichaje"], ENT_QUOTES), $Newsletter);
        $Newsletter = str_replace("%horas_trabajadas%", htmlentities($resultado2, ENT_QUOTES), $Newsletter);
        $Newsletter = str_replace("%tiempo_en_descanso%", htmlentities($resultado1, ENT_QUOTES), $Newsletter);
        $Newsletter = str_replace("%porcentaje_trabajado%", htmlentities($datos["porcentaje_trabajado"], ENT_QUOTES), $Newsletter);
        $Newsletter = str_replace("%cantidad_anomalias%", htmlentities($datos["cantidad_anomalias"], ENT_QUOTES), $Newsletter);
        $Newsletter = str_replace("%dias_totales%", htmlentities($datos["dias_totales"], ENT_QUOTES), $Newsletter);
        $Newsletter = str_replace("%dias_disfrutados%", htmlentities($datos["dias_disfrutados"], ENT_QUOTES), $Newsletter);
        $Newsletter = str_replace("%dias_pendientes%", htmlentities($datos["dias_pendientes"], ENT_QUOTES), $Newsletter);
        $Newsletter = str_replace("%dias_sin_asignar%", htmlentities($datos["dias_sin_asignar"], ENT_QUOTES), $Newsletter);
        foreach ($datos["resumen_dias"] as $nombre_dia => $dia) {

            // Verificar si el día es feriado
            $descripcionFeriado = '';
            foreach ($datos["feriados"] as $feriado) {
                if ($feriado["fecha_i"] === $nombre_dia) {
                    $descripcionFeriado = ' - ' . $feriado["descripcion"];
                    break;
                }
            }
            $ob = "";
            foreach ($dia["fichajes"] as $fe) {
                if ($fe["observaciones"] != null) {
                    $ob .= '<p style="margin-bottom: 0rem; font-size: 13px;">' .  $fe["observaciones"] . ' </p>';
                }
                if (count($fe["anomalias"]) > 0) {
                    foreach ($fe["anomalias"] as $ano) {
                        $an .= '<p style="margin-bottom: 0rem; font-size: 13px;">' .  $ano["anomalia"] . ' </p>';
                    }
                }
            }
            setlocale(LC_TIME, 'es_ES.UTF-8'); // Para sistemas Linux/Mac
            // setlocale(LC_TIME, 'spanish'); // Para Windows

            $date = new DateTime($nombre_dia);
            $palabras = explode(' ', strftime('%A %e de %B de %Y', $date->getTimestamp()));
            $palabras[0] = ucfirst(strtolower($palabras[0]));
            $resultado = implode(' ', $palabras);
            // Título con posible feriado
            $detallado .= '<div
                        style="width: 100%; text-align: center; font-size: 15px;background: #80808030;
                        padding: 7px; border-left: 1px;border-right: 1px solid #7c7a7a4b;border-bottom: 0px solid #7c7a7a4b;border-top: 1px solid #7c7a7a4b;">
                        ' . $resultado . " " . $descripcionFeriado . '
                    </div>';
            if (count($dia["fichajes"]) > 0) {
                // Tiempo trabajado
                $detallado .= '<table class="table"
                        style="width: 100%; text-align: center; font-size: 13px;border:0px
                        ">
                         <thead class="table-head" style="background: #80808030;border:0px">
                    <tr>
                      
                        <th class="table-cell" style="border-left: 1px solid #7c7a7a4b;border-right: 1px solid #7c7a7a4b;border-bottom: 1px solid #7c7a7a4b;">Tiempo trabajado</th>
                         <th class="table-cell" style="border-left: 0px;border-right: 0px solid #7c7a7a4b;border-bottom: 1px solid #7c7a7a4b;">Observaciones</th>
                          
                        <th class="table-cell" style="border-left: 1px solid #7c7a7a4b;border-right: 1px solid #7c7a7a4b;border-bottom: 1px solid #7c7a7a4b;">Tiempo descansado</th>
                       
                    </tr>
                </thead>
                       <tbody> 
                        <tr>
                         
                        <td class="table-cell" style="text-align:center; padding: 7px;border-top:0px;border-left: 1px solid #7c7a7a4b;border-right: 1px solid #7c7a7a4b;border-bottom: 0px solid #7c7a7a4b;"> ' .  $dia["trabajo"] . '</td>
                         <td class="table-cell"style=" text-align:center; padding: 7px;border-top:0px;border-left: 0px;border-right: 0px solid #7c7a7a4b;border-bottom: 0px solid #7c7a7a4b;">' .  $ob . '</td>
                        
                        <td class="table-cell" style="text-align:center; padding: 7px;border-top:0px;border-left: 1px solid #7c7a7a4b;border-right: 1px solid #7c7a7a4b;border-bottom: 0px solid #7c7a7a4b;">  ' .  $dia["descanso"] . '</td>
                </tr>  </tbody></table>';




                // Tabla de fichajes
                $detallado .= '<table class="table-detallado mb-1">
                <thead class="table-head" style="background: #80808030;">
                    <tr>
                        <th class="table-cell" style="width: 20%;">Hora</th>
                        <th class="table-cell" style="width: 20%;">Evento</th>
                        <th class="table-cell" style="width: 20%;">IP</th>
                        <th class="table-cell" style="width: 20%;">Dispositivo</th>
                        <th class="table-cell" style="width: 20%;">Email</th>
                    </tr>
                </thead>
                <tbody>';

                foreach ($dia["fichajes"] as $f) {
                    $detallado .= '<tr>';
                    $detallado .= '<td class="table-cell" style="width: 20%; text-align:center;">' . $f["fecha_entrada"] . '</td>';
                    $detallado .= '<td class="table-cell" style="width: 20%; text-align:center;">Entrada</td>';
                    $detallado .= '<td class="table-cell" style="width: 20%; text-align:center;">' . $f["ip_entrada"] . '</td>';
                    $detallado .= '<td class="table-cell" style="width: 20%; text-align:center;">' . $f["dispositivo_entrada"] . '</td>';
                    $detallado .= '<td class="table-cell" style="width: 20%; text-align:center;">' . $datos["email"] . '</td>';
                    $detallado .= '</tr>';

                    $detallado .= '<tr>';
                    $detallado .= '<td class="table-cell" style="width: 20%; text-align:center;">' . $f["fecha_salida"] . '</td>';
                    $detallado .= '<td class="table-cell" style="width: 20%; text-align:center;">Salida</td>';
                    $detallado .= '<td class="table-cell" style="width: 20%; text-align:center;">' . $f["ip_salida"] . '</td>';
                    $detallado .= '<td class="table-cell" style="width: 20%; text-align:center;">' . $f["dispositivo_salida"] . '</td>';
                    $detallado .= '<td class="table-cell" style="width: 20%; text-align:center;">' . $datos["email"] . '</td>';
                    $detallado .= '</tr>';
                }

                $detallado .= '</tbody></table>';
            } else {
                $detallado .= '<div
                        style="width: 100%; text-align: center; font-size: 13px;
                        padding: 7px; border-left: 1px;border-right: 1px solid #7c7a7a4b;border-bottom: 0px solid #7c7a7a4b;border-top: 1px solid #7c7a7a4b;">
                        No trabajado
                    </div>';
            }
        }




        $Newsletter = str_replace("%tablas%", $detallado, $Newsletter);
        if ($imagen1) {
            $imgTag1 = '<img src="' . $imagen1 . '" style="width: 100%; max-width: 600px;" />';
            $Newsletter = str_replace("%grafico1%", $imgTag1, $Newsletter);
        } else {
            $Newsletter = str_replace("%grafico1%", '', $Newsletter);
        }

        if ($imagen2) {
            $imgTag2 = '<img src="' . $imagen2 . '" style="width: 100%; max-width: 600px;" />';
            $Newsletter = str_replace("%grafico2%", $imgTag2, $Newsletter);
        } else {
            $Newsletter = str_replace("%grafico2%", '', $Newsletter);
        }


        $tmp = sys_get_temp_dir();

        $options = new Options();

        $options->set('logOutputFile', '');

        // $options->set('defaultFont', 'Helvetica');

        $options->set('isRemoteEnabled', true);

        $options->set('debugKeepTemp', true);

        $options->set('isHtml5ParserEnabled', true);

        $options->set('fontDir', $tmp);

        $options->set('fontCache', $tmp);

        $options->set('tempDir', $tmp);

        $options->set('chroot', $tmp);

        $options->set('chroot', '');

        $pdf = new Dompdf($options);

        $context = stream_context_create([

            'ssl' => [

                'verify_peer' => false,

                'verify_peer_name' => false,

                'allow_self_signed' => true,

            ],

        ]);

        $pdf->setHttpContext($context);

        $pdf->set_paper("A4", "portrait");

        $pdf->load_html($Newsletter);

        $pdf->render();

        $nombre = "Estadisticas.pdf";
        $file_to_save = "../facturas/" . $nombre;

        $files = glob('../facturas/*'); // get all file names

        foreach ($files as $file) { // iterate files

            if (is_file($file)) {

                unlink($file); // delete file

            }
        }

        //save the pdf file on the server

        file_put_contents($file_to_save, $pdf->output());

        //print the pdf file to the screen for saving

        header('Content-type: application/pdf');

        header('Content-Disposition: inline; filename="' . $nombre . '"');

        header('Content-Transfer-Encoding: binary');

        header('Content-Length: ' . filesize($file_to_save));

        header('Accept-Ranges: bytes');

        // $options = new Options();



        $file_to_save = "facturas/" . $nombre;

        echo $file_to_save;

        exit();
    }
}

//Borrar

if ($_SERVER['REQUEST_METHOD'] == 'DELETE') {

    $id = $_GET['id'];

    $statement = $dbConn->prepare("DELETE FROM sectores where id_sector =:id");

    $statement->bindValue(':id', $id);

    $statement->execute();

    header("HTTP/1.1 200 OK");

    exit();
}

//Actualizar

if ($_SERVER['REQUEST_METHOD'] == 'PUT') {

    $input = $_GET;

    $postId = $input['id'];

    $fields = getParams($input);

    $sql = "

          UPDATE posts

          SET $fields

          WHERE id='$postId'

           ";

    $statement = $dbConn->prepare($sql);

    bindAllValues($statement, $input);

    $statement->execute();

    header("HTTP/1.1 200 OK");

    exit();
}

function obtenerDatosMiembro($dbConn, $id_miembro, $fecha_i, $fecha_f)
{
    $inicio = new DateTime($fecha_i);
    $fin = new DateTime($fecha_f);
    $intervalo = $inicio->diff($fin)->days + 1;

    // Obtener user_id y nombre completo
    $sql = $dbConn->prepare("
      SELECT me.*,
    u.user_id, 
     u.user_avatar, 
    u.user_full_name,
    u.user_email,
    u.id_provincia,
    IFNULL(p.nombre, 'Ninguna') AS provincia,
    u.id_localidad,
    IFNULL(l.nombre, 'Ninguna') AS localidad
FROM miembro_equipo me
JOIN users u ON me.user_id = u.user_id
LEFT JOIN provincias p ON u.id_provincia = p.id_provincia
LEFT JOIN localidades l ON u.id_localidad = l.id_localidad
WHERE me.id_miembro = ?

    ");
    $sql->execute([$id_miembro]);
    $usuario = $sql->fetch(PDO::FETCH_ASSOC);

    $user_id = $usuario['user_id'] ?? null;
    $nombre = $usuario['user_full_name'] ?? null;
    $email = $usuario['user_email'] ?? null;
    $provincia = $usuario['provincia'] ?? null;
    $localidad = $usuario['localidad'] ?? null;
    $personalizacion = json_decode(file_get_contents('../personalizacion.json'), true);





    $dias_totales = intval($personalizacion["dias_totales_vacaciones"]);
    $dias_disfrutados = 0;
    $dias_pendientes = 0;

    if ($user_id) {
        $hoy = new DateTime();
        $sql = $dbConn->prepare("SELECT fecha_i, fecha_f FROM vacaciones WHERE user_id = ?");
        $sql->execute([$user_id]);
        $vacaciones = $sql->fetchAll(PDO::FETCH_ASSOC);

        foreach ($vacaciones as $v) {
            $fi = new DateTime($v['fecha_i']);
            $ff = new DateTime($v['fecha_f']);
            if ($ff < $fi) continue;

            if ($fi <= $hoy) {
                $end = min($ff, $hoy);
                $dias_disfrutados += $fi->diff($end)->days + 1;
            }

            if ($ff > $hoy) {
                $start = max($fi, (clone $hoy)->modify('+1 day'));
                $dias_pendientes += $start <= $ff ? $start->diff($ff)->days + 1 : 0;
            }
        }
        $id_provincia2 = $usuario['id_provincia'];
        $id_localidad2 = $usuario['id_localidad'];
        $fecha_inicio = $fecha_i; // <-- ajustá esto con tu valor real
        $fecha_fin = $fecha_f;
        $feriados2 = [];
        $feriadosData2 = [];

        $queryFeriados2 = "
    SELECT DISTINCT f.*
    FROM feriados f
    INNER JOIN ubicacion_feriado uf ON f.id_feriado = uf.id_feriado
    WHERE 
       
        
            (uf.id_provincia IS NULL AND uf.id_localidad IS NULL)
    ";

        // Si id_provincia tiene valor y localidad no
        if ($id_provincia2 !== null && $id_localidad2 === null) {
            $queryFeriados2 .= "
        OR (uf.id_provincia = :id_provincia AND uf.id_localidad IS NULL)
    ";
        }

        // Si ambos tienen valor
        elseif ($id_provincia2 !== null && $id_localidad2 !== null) {
            $queryFeriados2 .= "
        OR (uf.id_provincia = :id_provincia AND uf.id_localidad IS NULL)
        OR (uf.id_provincia = :id_provincia AND uf.id_localidad = :id_localidad)
    ";
        }

        // Cerrar el paréntesis de la subcondición
        $queryFeriados2 .= "
        
    ";

        $sqlFeriados2 = $dbConn->prepare($queryFeriados2);

        // Asignar valores a los parámetros


        if ($id_provincia2 !== null) {
            $sqlFeriados2->bindValue(':id_provincia', $id_provincia2, PDO::PARAM_INT);
        }
        if ($id_localidad2 !== null) {
            $sqlFeriados2->bindValue(':id_localidad', $id_localidad2, PDO::PARAM_INT);
        }

        $sqlFeriados2->execute();
        $feriadosData2 = $sqlFeriados2->fetchAll(PDO::FETCH_ASSOC);

        // Recorremos los feriados y comparamos con las vacaciones
        foreach ($feriadosData2 as $feriado) {
            $fechaFeriado = new DateTime($feriado['fecha_i']);
            foreach ($vacaciones as $vac) {
                $fechaInicioVac = new DateTime($vac['fecha_i']);
                $fechaFinVac = new DateTime($vac['fecha_f']);

                // Si el feriado cae dentro de la vacación
                if ($fechaFeriado >= $fechaInicioVac && $fechaFeriado <= $fechaFinVac) {
                    $hoy = new DateTime();
                    if ($fechaFeriado > $hoy) {

                        if ($dias_pendientes > 0) $dias_pendientes--;
                    } else {

                        if ($dias_disfrutados > 0) $dias_disfrutados--;
                    }
                    break; // una vez que lo ajustamos, no hace falta seguir comparando ese feriado
                }
            }
        }
    }

    $dias_sin_asignar = $dias_totales - ($dias_disfrutados + $dias_pendientes);

    // ----------------------------
    // 1) Obtenemos cuántos días con fichaje
    // ----------------------------
    $sql = $dbConn->prepare("
        SELECT DISTINCT DATE(fecha_entrada) as dia
        FROM fichajes
        WHERE id_miembro = :id_miembro
          AND fecha_entrada BETWEEN :fecha_i AND :fecha_f
    ");
    $sql->execute([
        ':id_miembro' => $id_miembro,
        ':fecha_i' => $fecha_i . ' 00:00:00',
        ':fecha_f' => $fecha_f . ' 23:59:59'
    ]);
    $diasConFichaje = $sql->rowCount();

    // ----------------------------
    // 2) Obtenemos todos los fichajes en el rango
    // ----------------------------
    $sql = $dbConn->prepare("
    SELECT *
    FROM fichajes
    WHERE id_miembro = :id_miembro
      AND (
          (fecha_entrada <= :fecha_f AND fecha_salida >= :fecha_i)
      )
");

    $sql->execute([
        ':id_miembro' => $id_miembro,
        ':fecha_i' => $fecha_i . ' 00:00:00',
        ':fecha_f' => $fecha_f . ' 23:59:59'
    ]);
    $fichajes = $sql->fetchAll(PDO::FETCH_ASSOC);

    // Inicializamos acumuladores
    $totalSegundosTrabajo = 0;
    $totalSegundosDescanso = 0;
    $idsFichaje = [];
    $resumenDias = [];

    // --------------------------------------------------------------
    // 3) Para cada fichaje, lo “cortamos” por cada día calendario que toque
    // --------------------------------------------------------------
    foreach ($fichajes as $f) {





        $entrada = new DateTime($f['fecha_entrada']);
        $salida  = new DateTime($f['fecha_salida']);
        $duracionTotal = $salida->getTimestamp() - $entrada->getTimestamp();
        if ($duracionTotal <= 0) continue; // descartamos fechas mal formadas

        // Horas de descanso ya vienen en segundos
        $descansoSegundos = intval($f['horas_descanso']);
        $trabajoSegundos  = max($duracionTotal - $descansoSegundos, 0);

        // Proporciones para repartir trabajo/descanso en cada trozo
        $ratioTrabajo  = $trabajoSegundos  / $duracionTotal;
        $ratioDescanso = $descansoSegundos / $duracionTotal;

        // Recorremos día a día: del instante $entrada hasta $salida
        $tsInicioFichaje = $entrada->getTimestamp();
        $tsFinFichaje    = $salida->getTimestamp();

        $cursor = clone $entrada;
        while ($cursor->getTimestamp() < $tsFinFichaje) {
            // Calculamos fin de este día (23:59:59)
            $finDelDia = (clone $cursor)->setTime(23, 59, 59);
            $tsFinDelDia = $finDelDia->getTimestamp();
            // El “trozo” termina o en la salida real ($tsFinFichaje) o en fin de día, lo que ocurra antes
            $tsTrozoFin = min($tsFinFichaje, $tsFinDelDia);
            $tsTrozoInicio = $cursor->getTimestamp();

            // Duración de este trozo en segundos
            $segundosTrozo = $tsTrozoFin - $tsTrozoInicio + 1;
            if ($segundosTrozo < 0) break;

            // Calculamos cuántos de esos segundos fueron “trabajo” y cuántos “descanso”
            $trabajoEnEsteTrozo  = round($segundosTrozo * $ratioTrabajo);
            $descansoEnEsteTrozo = round($segundosTrozo * $ratioDescanso);

            // Fecha (yyyy-mm-dd) del trozo
            $fechaDia = date('Y-m-d', $tsTrozoInicio);
            if (!isset($resumenDias[$fechaDia])) {
                $resumenDias[$fechaDia] = ['trabajo' => 0, 'descanso' => 0];
            }

            $resumenDias[$fechaDia]['trabajo']  += $trabajoEnEsteTrozo;
            $resumenDias[$fechaDia]['descanso'] += $descansoEnEsteTrozo;

            $cursor->setTimestamp($tsTrozoFin + 1);
        }

        $idsFichaje[] = $f['id_fichaje'];
        $totalSegundosTrabajo  += $trabajoSegundos;
        $totalSegundosDescanso += $descansoSegundos;
    }

    // ---------------------------------------------------
    // 4) Asegurarnos de que existan entradas para cada día
    // ---------------------------------------------------
    $periodo = new DatePeriod($inicio, new DateInterval('P1D'), (clone $fin)->modify('+1 day'));
    foreach ($periodo as $unDia) {
        $key = $unDia->format('Y-m-d');

        if (!isset($resumenDias[$key])) {
            $resumenDias[$key] = ['trabajo' => 0, 'descanso' => 0];
        }
    }


    // Ordenamos por fecha
    ksort($resumenDias);

    // Convertimos de segundos a “X hs Y min”
    foreach ($resumenDias as $fecha => $tiempos) {
        $horasTrabajo = floor($tiempos['trabajo'] / 3600);
        $minutosTrabajo = round(($tiempos['trabajo'] % 3600) / 60);
        $horasDescanso = floor($tiempos['descanso'] / 3600);
        $minutosDescanso = round(($tiempos['descanso'] % 3600) / 60);

        $resumenDias[$fecha] = [
            'trabajo' => "{$horasTrabajo} hs {$minutosTrabajo} min",
            'descanso' => "{$horasDescanso} hs {$minutosDescanso} min"
        ];
        $resumenDias[$fecha]['fichajes'] = [];

        foreach ($fichajes as $fichaje) {
            $fechaEntrada = new DateTime($fichaje['fecha_entrada']);
            $fechaSalida = new DateTime($fichaje['fecha_salida']);
            $fechaActual = new DateTime($fecha); // $fecha del bucle principal
            $sql = $dbConn->prepare("
            SELECT *
            FROM anomalia
            WHERE id_fichaje = :id_fichaje
            
        ");

            $sql->execute([
                ':id_fichaje' => $f["id_fichaje"]

            ]);
            $an = $sql->fetchAll(PDO::FETCH_ASSOC);
            $fichaje["anomalias"] = [];
            foreach ($an as $a) {

                $fichaje["anomalias"][] = $a;
            }

            // Verifica si la fecha coincide o está entre fecha_entrada y fecha_salida
            if (
                $fechaActual->format('Y-m-d') === $fechaEntrada->format('Y-m-d') ||
                $fechaActual->format('Y-m-d') === $fechaSalida->format('Y-m-d') ||
                ($fechaActual >= $fechaEntrada && $fechaActual <= $fechaSalida)
            ) {
                $resumenDias[$fecha]['fichajes'][] = $fichaje;
            }
        }
    }

    // Totales (en horas, con decimales)
    $horasTrabajadas = round($totalSegundosTrabajo   / 3600, 2);
    $tiempoEnDescanso = round($totalSegundosDescanso / 3600, 2);
    $totalTiempo = $totalSegundosTrabajo + $totalSegundosDescanso;
    $porcentajeTrabajado = $totalTiempo > 0
        ? round(($totalSegundosTrabajo * 100) / $totalTiempo, 2)
        : 0;

    // -----------------------
    // 5) Contar anomalías
    // -----------------------
    $cantidadAnomalias = 0;
    if (!empty($idsFichaje)) {
        $inQuery = implode(',', array_fill(0, count($idsFichaje), '?'));
        $sql = $dbConn->prepare("SELECT COUNT(*) FROM anomalia WHERE id_fichaje IN ($inQuery)");
        $sql->execute($idsFichaje);
        $cantidadAnomalias = $sql->fetchColumn();
    }

    return [
        'nombre' => $nombre,
        'email' => $email,
        'provincia' => $provincia,
        'localidad' => $localidad,
        'total_dias' => $intervalo,
        'dias_con_fichaje' => $diasConFichaje,
        'horas_trabajadas' => $horasTrabajadas,
        'tiempo_en_descanso' => $tiempoEnDescanso,
        'porcentaje_trabajado' => $porcentajeTrabajado,
        'cantidad_anomalias' => intval($cantidadAnomalias),
        'resumen_dias' => $resumenDias,
        'fecha_inicio' => $fecha_i,
        'fecha_fin' => $fecha_f,
        'dias_totales' => $dias_totales,
        'dias_disfrutados' => $dias_disfrutados,
        'dias_pendientes' => $dias_pendientes,
        'dias_sin_asignar' => $dias_sin_asignar,
        'usuario' => $usuario,

        'feriados' =>  $feriadosData2
    ];
}
function limpiarTexto($texto)
{
    // Decodifica si viene con \u00e1, \n, etc.
    $texto = str_replace(["\\n", "\\t"], ["\n", "\t"], $texto);
    $texto = html_entity_decode($texto);
    $texto = preg_replace('/[ ]{2,}/', ' ', $texto);  // reemplaza espacios duplicados
    $texto = preg_replace('/\t+/', ' ', $texto);      // reemplaza tabs por espacio
    $texto = preg_replace('/\s{2,}/', ' ', $texto);   // combina espacios y tabs excesivos
    $texto = preg_replace('/\n{2,}/', "\n", $texto);  // múltiples saltos de línea → uno solo
    $texto = preg_replace('/([a-z])\s+([a-z])/iu', '$1 $2', $texto); // conservar separación en minúsculas

    // corregir palabras partidas por OCR (solo si es seguro)
    $texto = preg_replace('/extr\s+a/', 'extra', $texto);
    $texto = preg_replace('/formac\s+ion/', 'formacion', $texto);
    $texto = preg_replace('/desemp\s+leo/', 'desempleo', $texto);

    // Normalizar espacios finales
    return trim($texto);
}

function limpiarTextoNomina($texto) {
    // 1. Decodifica caracteres unicode (\n → salto real)
    $texto = str_replace(["\\n", "\\t"], ["\n", "\t"], $texto);

    // 2. Repara palabras partidas (esto se adapta según tu documento)
    $patronesCorregibles = [
        '/PA LMAS/' => 'PALMAS',
        '/FORMACIO N/' => 'FORMACION',
        '/DESEMPLE O/' => 'DESEMPLEO',
        '/CONT\.COM U/' => 'CONT.COMU',
        '/P\.P\. Bolsa Vacacion es/' => 'P.P. Bolsa Vacaciones',
        '/TRIBUTACION I\.R\.P\.F\s*\./' => 'TRIBUTACION I.R.P.F.',
        '/COTIZACION CONT\.COM U/' => 'COTIZACION CONT.COMU',
        '/A DEDUCIRREM\. TOTAL/' => 'A DEDUCIR REM. TOTAL',
        '/BASEI\.R\.P\.F\.T\./' => 'BASE I.R.P.F. T.',
        '/DEVENGADOBASE A\.T\. Y DES\./' => 'DEVENGADO BASE A.T. Y DES.',
        '/1\.4 22,00/' => '1.422,00',
        '/3\.3 81,12/' => '3.381,12',
        '/1\.3 81,33/' => '1.381,33',
    ];

    foreach ($patronesCorregibles as $buscar => $reemplazo) {
        $texto = preg_replace($buscar, $reemplazo, $texto);
    }

    // 3. Normaliza espacios duplicados y líneas vacías
    $texto = preg_replace('/[ ]{2,}/', ' ', $texto);
    $texto = preg_replace('/\n{2,}/', "\n", $texto);
    $texto = trim($texto);

    // 4. Marca empleados para facilitar la división (puedes ajustar si cambia el formato)
    $texto = preg_replace('/([A-ZÁÉÍÓÚÑ]{2,}\s+[A-ZÁÉÍÓÚÑ]{2,})\s*,\s*([A-ZÁÉÍÓÚÑ\s]+)/', "===EMPLEADO=== $1, $2", $texto);

    return $texto;
}


function pdf_parse()
{
$config = new Config();
$config->setFontSpaceLimit(-60);
$config->setHorizontalOffset("\t");
$config->setIgnoreEncryption(true);
//$config->setPdfWhitespaces("\n\t "); 
$parser = new Parser([], $config);

    $pdf = $parser->parseFile('../r.pdf');
    $textoBruto  = $pdf->getText();

    $texto  = limpiarTexto($textoBruto);
$texto  = limpiarTextoNomina($texto);
$bloques = preg_split('/(?=[A-ZÁÉÍÓÚÑ]+\s+[A-ZÁÉÍÓÚÑ]+\s*,\s+[A-ZÁÉÍÓÚÑ\s]+)/u', $texto, -1, PREG_SPLIT_NO_EMPTY);

    $trabajadores = [];

    foreach ($bloques as $bloque) {
        preg_match('/([A-ZÁÉÍÓÚÑ\s]+,\s+[A-ZÁÉÍÓÚÑ\s]+)\s+(\d{5})/', $bloque, $matches);
        $nombre = trim($matches[1] ?? '');

        preg_match('/CATEGORIA\s+([A-Z\s]+)\s+[A-Z]\s+\d+\s+[A-Z]{3}\s+\d+\s+([0-9A-Z]+)/', $bloque, $matches);
        $categoria = trim($matches[1] ?? '');
        $dni = trim($matches[2] ?? '');

        preg_match('/Nº AFILIACION\. S\.S\.\s+(\d{2}\/\d{8}-\d{2})/', $bloque, $matches);
        $nss = $matches[1] ?? '';

        preg_match('/(\d{2} MAY \d{2}) a (\d{2} MAY \d{2})/', $bloque, $matches);
        $periodo = trim(($matches[1] ?? '') . ' a ' . ($matches[2] ?? ''));

        preg_match('/LIQUIDO A PERCIBIR\s+([\d.,]+)/', $bloque, $matches);
        $liquido = $matches[1] ?? '';

        // Devengos y deducciones simples (sumas si quisieras luego)
        preg_match_all('/\*(Salario Base|Prorrata pagas extra|Compl Absorbible|Bolsa Vacaciones)\s+([\d.,]+)/', $bloque, $devengos, PREG_SET_ORDER);
        $devengo_total = array_reduce($devengos, fn($sum, $d) => $sum + floatval(str_replace(',', '.', $d[2])), 0);

        preg_match_all('/COTIZACION .*?\s+[\d.,]+\s+([\d.,]+)/', $bloque, $deducciones, PREG_SET_ORDER);
        $deduccion_total = array_reduce($deducciones, fn($sum, $d) => $sum + floatval(str_replace(',', '.', $d[1])), 0);

        $trabajadores[] = [
            'nombre' => $nombre,
            'matches' => $matches,
            'bloques' => $bloques,
            'categoria' => $categoria,
            'dni' => $dni,
            'textoBruto' => $texto,
            'nss' => $nss,
            'periodo' => $periodo,
            'liquido' => $liquido,
            'total_devengos' => round($devengo_total, 2),
            'total_deducciones' => round($deduccion_total, 2),
        ];
    }


    return $trabajadores;
}
//En caso de que ninguna de las opciones anteriores se haya ejecutado

header("HTTP/1.1 400 Bad Request");