<?php



include "utils.php";



$dbConn = connect($db);



/*

listar todos los posts o solo uno

 */

if ($_SERVER['REQUEST_METHOD'] == 'GET') {

    if (isset($_GET['id_empleado'])) {

        //Mostrar un post

        $sql = $dbConn->prepare("SELECT * FROM empleados where id_empleado=:id_empleado");

        $sql->bindValue(':id_empleado', $_GET['id_empleado']);

        $sql->execute();

        header("HTTP/1.1 200 OK");

        echo json_encode($sql->fetch(PDO::FETCH_ASSOC));

        exit();

    } else {

        //Mostrar lista de post

        $sql = $dbConn->prepare("SELECT * FROM empleados");

        $sql->execute();

        $sql->setFetchMode(PDO::FETCH_ASSOC);

        $clientes = $sql->fetchAll(PDO::FETCH_OBJ);

        foreach ($clientes as $cliente) {

            $id_empleado = $cliente->id_empleado;

            $sql = "SELECT g.id_grupo2, g.nombre

                  FROM grupos2 g

                  INNER JOIN empleado_grupo2 gc ON g.id_grupo2 = gc.id_grupo2

                  WHERE gc.id_empleado = :id_empleado";

            $stmt = $dbConn->prepare($sql);

            $stmt->bindParam(':id_empleado', $id_empleado, PDO::PARAM_INT);

            $stmt->execute();

            // Obtener el resultado como un objeto

            $grupos = $stmt->fetchAll(PDO::FETCH_OBJ);

            $cliente->grupos = $grupos;

        }



        header("HTTP/1.1 200 OK");

        // echo var_dump($sql->fetchAll());

        echo json_encode($clientes);



        exit();

    }

}

// Crear un nuevo post

if ($_SERVER['REQUEST_METHOD'] == 'POST') {

    if (isset($_POST["id_usuario"]) &&

        isset($_POST["direccion"]) &&

        isset($_POST["nombre"]) &&

        isset($_POST["dni"]) &&

        isset($_POST["telefono"]) &&

        isset($_POST["precio_hora"]) &&

        isset($_POST["numero"]) &&

        isset($_POST["email"]) &&

        isset($_POST["nif"]) &&

        isset($_POST["precio_hora_extra"])

    ) {

        // Iteramos sobre los campos POST y asignamos a variables con valores nulos si están vacíos

        foreach ($_POST as $key => $value) {

            $$key = ($value == "") ? null : $value; // Asigna el valor o null si está vacío

        }



        // Si tenemos un ID de empleado, hacemos una actualización

        if (isset($_POST["id_empleado"])) {

            $id_empleado = $_POST["id_empleado"];

            $sql = "UPDATE empleados SET

                    direccion = :direccion,

                    nombre = :nombre,

                    dni = :dni,

                    telefono = :telefono,

                    precio_hora = :precio_hora,

                    numero = :numero,

                    email = :email,

                    nif = :nif,

                    precio_hora_extra = :precio_hora_extra,

                    id_usuario = :id_usuario

                    WHERE id_empleado = :id_empleado";



            $statement = $dbConn->prepare($sql);

            $statement->bindValue(':id_empleado', $id_empleado);

        } else {

            // Si no tenemos un ID de empleado, hacemos una inserción

            $sql = "INSERT INTO empleados

                    (direccion, nombre, dni, telefono, precio_hora, numero, email, nif, precio_hora_extra, id_usuario)

                    VALUES

                    (:direccion, :nombre, :dni, :telefono, :precio_hora, :numero, :email, :nif, :precio_hora_extra, :id_usuario)";



            $statement = $dbConn->prepare($sql);

        }



        // Asignamos los valores de los parámetros a la consulta

        $statement->bindValue(':direccion', $direccion);

        $statement->bindValue(':nombre', $nombre);

        $statement->bindValue(':dni', $dni);

        $statement->bindValue(':telefono', $telefono);

        $statement->bindValue(':precio_hora', $precio_hora);

        $statement->bindValue(':numero', $numero);

        $statement->bindValue(':email', $email);

        $statement->bindValue(':nif', $nif);

        $statement->bindValue(':precio_hora_extra', $precio_hora_extra);

        $statement->bindValue(':id_usuario', $id_usuario);



        // Ejecutamos la consulta

        $statement->execute();



        // Si estamos insertando, obtenemos el último ID insertado

        if (!isset($_POST["id_empleado"])) {

            $id_empleado = $dbConn->lastInsertId();

        }



        // Preparamos los datos de respuesta

        $input['id'] = $id_empleado;

        $input['direccion'] = $direccion;

        $input['nombre'] = $nombre;

        $input['dni'] = $dni;

        $input['telefono'] = $telefono;

        $input['precio_hora'] = $precio_hora;

        $input['numero'] = $numero;

        $input['email'] = $email;

        $input['nif'] = $nif;

        $input['precio_hora_extra'] = $precio_hora_extra;

        $input['id_usuario'] = $id_usuario;



        // Enviamos la respuesta

        header("HTTP/1.1 200 OK");

        echo json_encode($input);

        exit();

    } 

}



if ($_SERVER['REQUEST_METHOD'] == 'DELETE') {

    $id = $_GET['id'];

    $statement = $dbConn->prepare("DELETE FROM empleados where id_empleado =:id");

    $statement->bindValue(':id', $id);

    $statement->execute();

    header("HTTP/1.1 200 OK");

    exit();

}



//Actualizar

if ($_SERVER['REQUEST_METHOD'] == 'PUT') {

    $input = $_GET;

    $postId = $input['id'];

    $fields = getParams($input);



    $sql = "

          UPDATE posts

          SET $fields

          WHERE id='$postId'

           ";



    $statement = $dbConn->prepare($sql);

    bindAllValues($statement, $input);



    $statement->execute();

    header("HTTP/1.1 200 OK");

    exit();

}



//En caso de que ninguna de las opciones anteriores se haya ejecutado

header("HTTP/1.1 400 Bad Request");