<?php



include "utils.php";



$dbConn = connect($db);



/*

listar todos los empleados o solo uno

 */

if ($_SERVER['REQUEST_METHOD'] == 'GET') {

    if (isset($_GET['id_empleado'])) {

        // Mostrar un empleado

        $sql = $dbConn->prepare("SELECT * FROM empleado WHERE id_empleado = :id_empleado");

        $sql->bindValue(':id_empleado', $_GET['id_empleado']);

        $sql->execute();

        header("HTTP/1.1 200 OK");

        echo json_encode($sql->fetch(PDO::FETCH_ASSOC));

        exit();

    } else {

        // Mostrar lista de empleados

        $sql = $dbConn->prepare("SELECT * FROM empleado");

        $sql->execute();

        $sql->setFetchMode(PDO::FETCH_ASSOC);

        $empleados = $sql->fetchAll(PDO::FETCH_OBJ);

        foreach ($empleados as $empleado) {

            $id_empleado = $empleado->id_empleado;

            $sql = "SELECT g.id_grupo2, g.nombre

                  FROM grupos2 g

                  INNER JOIN empleado_grupo2 gc ON g.id_grupo2 = gc.id_grupo2

                  WHERE gc.id_empleado = :id_empleado";

            $stmt = $dbConn->prepare($sql);

            $stmt->bindParam(':id_empleado', $id_empleado, PDO::PARAM_INT);

            $stmt->execute();

            // Obtener el resultado como un objeto

            $grupos = $stmt->fetchAll(PDO::FETCH_OBJ);

            $empleado->grupos = $grupos;

        }



        header("HTTP/1.1 200 OK");

        echo json_encode($empleados);

        exit();

    }

}



// Crear o actualizar un empleado

if ($_SERVER['REQUEST_METHOD'] == 'POST') {

    if (

        isset($_POST["numero_seguridad_social"]) &&

        isset($_POST["direccion"]) &&

        isset($_POST["nombre"]) &&

        isset($_POST["nif"]) &&

        isset($_POST["telefono"]) &&

        isset($_POST["fecha_contratacion"]) &&

        isset($_POST["fecha_nacimiento"]) &&

        isset($_POST["estado"])

    ) {

        foreach ($_POST as $key => $value) {

            $value = ($value == "") ? null : $value;

            $$key = $value;

        }



        if (isset($_POST["id_empleado"])) {

            $id_empleado = $_POST["id_empleado"];

            $sql = "UPDATE empleado SET

                numero_seguridad_social = :numero_seguridad_social,

                direccion = :direccion,

                nombre = :nombre,

                nif = :nif,

                telefono = :telefono,

                fecha_contratacion = :fecha_contratacion,

                fecha_nacimiento = :fecha_nacimiento,

                estado = :estado

                WHERE id_empleado = :id_empleado";

            $statement = $dbConn->prepare($sql);

            $statement->bindValue(':id_empleado', $id_empleado);

        } else {

            $sql = "INSERT INTO empleado

                (numero_seguridad_social,direccion, nombre, nif, telefono, fecha_contratacion, fecha_nacimiento, estado)

                VALUES

                (:numero_seguridad_social,:direccion, :nombre, :nif, :telefono, :fecha_contratacion, :fecha_nacimiento, :estado)";

            $statement = $dbConn->prepare($sql);

        }



        $statement->bindValue(':numero_seguridad_social', $numero_seguridad_social);

        $statement->bindValue(':direccion', $direccion);

        $statement->bindValue(':nombre', $nombre);

        $statement->bindValue(':nif', $nif);

        $statement->bindValue(':telefono', $telefono);

        $statement->bindValue(':fecha_contratacion', $fecha_contratacion);

        $statement->bindValue(':fecha_nacimiento', $fecha_nacimiento);

        $statement->bindValue(':estado', $estado);



        $statement->execute();



        if (!isset($_POST["id_empleado"])) {

            $id_empleado = $dbConn->lastInsertId();

        }



        $input['id_empleado'] = $id_empleado;

        $input['numero_seguridad_social'] = $numero_seguridad_social;

        $input['direccion'] = $direccion;

        $input['nombre'] = $nombre;

        $input['nif'] = $nif;

        $input['telefono'] = $telefono;

        $input['fecha_contratacion'] = $fecha_contratacion;

        $input['fecha_nacimiento'] = $fecha_nacimiento;

        $input['estado'] = $estado;



        header("HTTP/1.1 200 OK");

        echo json_encode($input);

        exit();

    }

}



if ($_SERVER['REQUEST_METHOD'] == 'DELETE') {

    $id_empleado = $_GET['id'];

    $statement = $dbConn->prepare("DELETE FROM empleado WHERE id_empleado = :id_empleado");

    $statement->bindValue(':id_empleado', $id_empleado);

    $statement->execute();

    header("HTTP/1.1 200 OK");

    exit();

}



// En caso de que ninguna de las opciones anteriores se haya ejecutado

header("HTTP/1.1 400 Bad Request");