<?php

include "utils.php";

$dbConn = connect($db);

/*
listar todos los posts o solo uno
 */
if ($_SERVER['REQUEST_METHOD'] == 'GET') {
    if (isset($_GET['id_email_custom'])) {
        //Mostrar un post
        $sql = $dbConn->prepare("SELECT * FROM email_custom where id_email_custom=:id_email_custom");
        $sql->bindValue(':id_email_custom', $_GET['id_email_custom']);
        $sql->execute();
        header("HTTP/1.1 200 OK");
        echo json_encode($sql->fetch(PDO::FETCH_ASSOC));
        exit();
    } else {
        //Mostrar lista de post
        $sql = $dbConn->prepare("SELECT 
            *
        FROM 
            email_custom
    ");

        $sql->execute();
        $sql->setFetchMode(PDO::FETCH_ASSOC);
        header("HTTP/1.1 200 OK");

        echo json_encode($sql->fetchAll());
        exit();
    }
}







// Crear un nuevo post
if ($_SERVER['REQUEST_METHOD'] == 'POST') {

    if (
        isset($_POST["nombre"])
        && isset($_POST["asunto"])
        && isset($_POST["cuerpo"])
      
    ) {
        foreach ($_POST as $key => $value) {
            $value = ($value == "") ? null : $value;
            $value = ($value == "No") ? null : $value;

            $$key = $value;
        }
        try {
            if (isset($_POST["id_email_custom"])) {
                $id_email_custom = $_POST["id_email_custom"];
                $sql = "UPDATE email_custom SET 
                    nombre = :nombre,
                    asunto = :asunto,
                    cuerpo = :cuerpo
                    WHERE id_email_custom = :id_email_custom";
                $statement = $dbConn->prepare($sql);
                $statement->bindValue(':id_email_custom', $id_email_custom);
            } else {
                $sql = "INSERT INTO email_custom
                (nombre,
                asunto,
                cuerpo)
                VALUES
                (:nombre,
                :asunto,
                :cuerpo)";
                $statement = $dbConn->prepare($sql);
            }
            $statement->bindValue(':nombre', $nombre);
            $statement->bindValue(':asunto', $asunto);
            $statement->bindValue(':cuerpo', $cuerpo);
           

            $statement->execute();

            $postId = $dbConn->lastInsertId();


            $response = array('success' => true, 'title' => 'Email agregado.', 'message' => 'Se ha agregado el email correctamente.');

            header("HTTP/1.1 200 OK");
            echo json_encode($response);
            exit();
        } catch (PDOException $e) {



            $response = array('success' => false, 'title' => "Error.", 'message' => $e);


            header("HTTP/1.1 200 OK");
            echo json_encode($response);
            exit();
        }
    } 
}


if ($_SERVER['REQUEST_METHOD'] == 'DELETE') {
    $id = $_GET['id'];
    $statement = $dbConn->prepare("DELETE FROM email_custom where id_email_custom =:id");
    $statement->bindValue(':id', $id);
    $statement->execute();
    header("HTTP/1.1 200 OK");
    exit();
}

//Actualizar
if ($_SERVER['REQUEST_METHOD'] == 'PUT') {
    $input = $_GET;
    $postId = $input['id'];
    $fields = getParams($input);

    $sql = "
          UPDATE posts
          SET $fields
          WHERE id='$postId'
           ";

    $statement = $dbConn->prepare($sql);
    bindAllValues($statement, $input);

    $statement->execute();
    header("HTTP/1.1 200 OK");
    exit();
}

//En caso de que ninguna de las opciones anteriores se haya ejecutado
header("HTTP/1.1 400 Bad Request");