<?php



include "utils.php";



$dbConn = connect($db);



/*

listar todos los posts o solo uno

 */

if ($_SERVER['REQUEST_METHOD'] == 'GET') {

    if (isset($_GET['id_curso'])) {

        //Mostrar un post

        $sql = $dbConn->prepare("SELECT a.*,

COALESCE(v.denominacion, 'Ninguno') AS denominacion_curso

 FROM cursos a

           LEFT JOIN acciones v ON v.numero_aaff = a.numero_aaff");

        $sql->bindValue(':id_curso', $_GET['id_curso']);

        $sql->execute();

        header("HTTP/1.1 200 OK");

        echo json_encode($sql->fetch(PDO::FETCH_ASSOC));

        exit();

    }

    if (isset($_GET['id_curso_archivos'])) {

        $id_curso = $_GET["id_curso_archivos"];

        $images = glob('../cursos/' . $id_curso . '/*.{png,jpg,pdf}', GLOB_BRACE);

        $fileObjects = array();



        foreach ($images as $image) {

            $fileInfo = pathinfo($image);

            $fileObject = new stdClass(); // Crear un objeto vacío para almacenar los datos

            $fileObject->url = $image; // Almacenar la URL del archivo

            $fileObject->extension = $fileInfo['extension']; // Almacenar la extensión del archivo

            $fileObject->nombre = $fileInfo['basename']; // Almacenar la extensión del archivo



            $fileObjects[] = $fileObject; // Agregar el objeto al arreglo

        }

        header("HTTP/1.1 200 OK");

        echo json_encode($fileObjects);

        exit();

    } else {

        //Mostrar lista de post

       try {

        $sql = $dbConn->prepare("SELECT a.*,

      

        COALESCE(d.nombre, 'Ninguno') AS nombre_docente, COALESCE(p.nombre, 'Ninguno') AS nombre_plan,

        JSON_OBJECT(

           'denominacion', v.denominacion,

           'horas_totales', v.horas_totales) AS accion

           FROM cursos a

           LEFT JOIN acciones v ON v.numero_aaff = a.numero_aaff

           LEFT JOIN planes p ON p.id_plan = a.id_plan

           LEFT JOIN docentes d ON d.id_docente = a.id_docente");

        $sql->execute();

        $sql->setFetchMode(PDO::FETCH_ASSOC);

        $clientes = $sql->fetchAll(PDO::FETCH_OBJ);

        foreach ($clientes as $cliente) {

            $clientID = $cliente->id_curso;

            $sql = "SELECT g.*

               FROM alumnos g

               INNER JOIN alumno_curso gc ON g.id_alumno = gc.id_alumno

               WHERE gc.id_curso = :clientID";

            $stmt = $dbConn->prepare($sql);

            $stmt->bindParam(':clientID', $clientID, PDO::PARAM_INT);

            $stmt->execute();

            // Obtener el resultado como un objeto

            $cursos = $stmt->fetchAll(PDO::FETCH_OBJ);

            $cliente->alumnos = $cursos;

            $cliente->accion = json_decode($cliente->accion);

        }



        header("HTTP/1.1 200 OK");

        // echo var_dump($sql->fetchAll());

        echo json_encode($clientes);



        exit();

    }catch (PDOException $e) {

        // Manejar el error

        header("HTTP/1.1 200 OK");

        echo "Error al ejecutar la consulta: " . $e->getMessage();

        exit();

    }

    }

}



// Crear un nuevo post

if ($_SERVER['REQUEST_METHOD'] == 'POST') {

    if (

     

        isset($_POST["numero_plaza"])

        && isset($_POST["numero_grupo"])

        && isset($_POST["numero_aaff"])

      

        && isset($_POST["estado"])

        && isset($_POST["horario"])

        && isset($_POST["fecha_f"])

        && isset($_POST["fecha_i"])

        && isset($_POST["id_docente"])

        && isset($_POST["modalidad"])

        && isset($_POST["sede"])

        && isset($_POST["instalacion"])

        && isset($_POST["nivel_estudios"])

        && isset($_POST["id_plan"])

        && isset($_POST["certificado"])

    ) {

         try {

        foreach ($_POST as $key => $value) {

            $value = ($value == "Si") ? 1 : $value;

            $value = ($value == "No") ? 0 : $value;



            $value = ($value === "") ? null : $value;



            $$key = $value;

        }











        if (isset($_POST["id_curso"])) {

            $id_curso = $_POST["id_curso"];

            $sql = "UPDATE cursos SET

              

                 id_plan = :id_plan ,

numero_plaza =:numero_plaza,

numero_grupo =:numero_grupo,

numero_aaff =:numero_aaff,

estado = :estado,

horario = :horario,

fecha_f = :fecha_f,

fecha_i = :fecha_i,

id_docente = :id_docente,

modalidad = :modalidad,

sede = :sede,

instalacion = :instalacion,

nivel_estudios = :nivel_estudios,

certificado = :certificado

                WHERE id_curso = :id_curso";

            $statement = $dbConn->prepare($sql);

            $statement->bindValue(':id_curso', $id_curso);

        } else {

            $sql = "INSERT INTO cursos

                (id_plan,numero_plaza ,numero_grupo ,numero_aaff ,

                estado,horario ,fecha_f ,fecha_i ,id_docente,

                modalidad,sede ,instalacion ,nivel_estudios ,certificado)

                VALUES

                (:id_plan,:numero_plaza ,:numero_grupo ,:numero_aaff ,

                :estado,:horario ,:fecha_f ,:fecha_i ,:id_docente,

                :modalidad,:sede ,:instalacion ,:nivel_estudios ,:certificado)";

            $statement = $dbConn->prepare($sql);

        }





    

        $statement->bindValue(':id_plan', $id_plan);

        $statement->bindValue(':numero_plaza', $numero_plaza);

        $statement->bindValue(':numero_grupo', $numero_grupo);

        $statement->bindValue(':numero_aaff', $numero_aaff);

      



        $statement->bindValue(':estado', $estado);

        $statement->bindValue(':horario', $horario);

        $statement->bindValue(':fecha_f', $fecha_f);

        $statement->bindValue(':fecha_i', $fecha_i);

        $statement->bindValue(':id_docente', $id_docente);

        $statement->bindValue(':modalidad', $modalidad);

        $statement->bindValue(':sede', $sede);

        $statement->bindValue(':instalacion', $instalacion);

        $statement->bindValue(':nivel_estudios', $nivel_estudios);

        $statement->bindValue(':certificado', $certificado);







        $statement->execute();

        if (isset($_POST["id_curso"])) {

            $id_curso = $_POST["id_curso"];

        } else {

            $id_curso = $dbConn->lastInsertId();





            $carpetaNuevaAlumno = '../cursos/' . $id_curso;



            mkdir($carpetaNuevaAlumno, 0777, true);

        }



       









        

   



        header("HTTP/1.1 200 OK");

        echo json_encode($id_curso);

        exit();

    }catch (PDOException $e) {

        // Manejar el error

        header("HTTP/1.1 200 OK");

        echo "Error al ejecutar la consulta: " . $e->getMessage();

        exit();

    }

    }

    if (isset($_POST["id_curso_agregar"]) && isset($_POST["id_alumno_agregar"])) {

        $id_curso = $_POST["id_curso_agregar"];

        $id_alumno = $_POST["id_alumno_agregar"];



        $sqlVerificar = "SELECT COUNT(*) as count FROM alumno_curso WHERE id_alumno = :id_alumno AND id_curso = :id_curso";

        $statementVerificar = $dbConn->prepare($sqlVerificar);

        $statementVerificar->bindValue(':id_alumno', $id_alumno);

        $statementVerificar->bindValue(':id_curso', $id_curso);

        $statementVerificar->execute();

        $resultadoVerificar = $statementVerificar->fetch(PDO::FETCH_ASSOC);



        if ($resultadoVerificar['count'] > 0) {

            // El nombre ya está en uso, mostrar mensaje de error



            echo 0;

            exit();

        }

        $sql = "INSERT INTO alumno_curso

        (id_alumno,id_curso)

        VALUES

        (:id_alumno,:id_curso)";



        $statement = $dbConn->prepare($sql);



        $statement->bindValue(':id_alumno', $id_alumno);

        $statement->bindValue(':id_curso', $id_curso);

        $statement->execute();



        $postId = $dbConn->lastInsertId();



        $input['id'] = $postId;

        $input['id_curso'] = $id_curso;

        $input['id_alumno'] = $id_alumno;

        header("HTTP/1.1 200 OK");

        echo json_encode($input);

        exit();

    }

    if (isset($_POST["id_curso_foto"]) && isset($_FILES['foto'])) {

        $id_curso = $_POST["id_curso_foto"];

        $foto = $_FILES['foto'];

        $baseUrl = ($_SERVER['HTTPS'] ? 'https://' : 'http://') . $_SERVER['HTTP_HOST'] . '/';

        $rutaArchivoTemporal = isset($_FILES['foto']) ? $_FILES['foto']['tmp_name'] : null;

        $caracteres = 'abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789';

        $longitud = 10;

        $cadenaAleatoria = substr(str_shuffle($caracteres), 0, $longitud);



        $Archivo = '../cursos/' . $id_curso . '/' . $cadenaAleatoria . '.png';



        if ($rutaArchivoTemporal && !empty($rutaArchivoTemporal)) {



            move_uploaded_file($rutaArchivoTemporal, $Archivo);

        }

        header("HTTP/1.1 200 OK");

        exit();

    }

    if (

        isset($_POST["id_curso_archivo"]) && isset($_FILES['archivo']) && isset($_POST['extension'])

        && isset($_POST['nombre'])

    ) {

        $nombre = $_POST["nombre"];

        $extension = $_POST["extension"];

        $id_curso = $_POST["id_curso_archivo"];

        $archivo = $_FILES['archivo'];

        $baseUrl = ($_SERVER['HTTPS'] ? 'https://' : 'http://') . $_SERVER['HTTP_HOST'] . '/';

        $rutaArchivoTemporal = isset($_FILES['archivo']) ? $_FILES['archivo']['tmp_name'] : null;

        $Archivo = '../cursos/' . $id_curso . '/' . $nombre . '.' . $extension;

        if (file_exists($Archivo)) {



            header("HTTP/1.1 200 OK");

            echo 0;

            exit();

        } else {

            if ($rutaArchivoTemporal && !empty($rutaArchivoTemporal)) {

                move_uploaded_file($rutaArchivoTemporal, $Archivo);

            }

            header("HTTP/1.1 200 OK");

            exit();

        }

    }

}



if ($_SERVER['REQUEST_METHOD'] == 'DELETE') {

    if (isset($_GET["id_curso"])) {

        $id = $_GET['id_curso'];

        $statement = $dbConn->prepare("DELETE FROM alumno_curso where id_curso =:id");

        $statement->bindValue(':id', $id);

        $statement->execute();

        header("HTTP/1.1 200 OK");

        exit();

    }

    if (isset($_GET["id_curso_eliminar"])) {

        $id = $_GET['id_curso_eliminar'];

        $statement = $dbConn->prepare("DELETE FROM alumno_curso where id_curso =:id");

        $statement->bindValue(':id', $id);

        $statement->execute();

        header("HTTP/1.1 200 OK");

        exit();

    }

    if (isset($_GET["url"])) {

        $url = $_GET['url'];

        $carpetaEliminar = '.' . $url;



        header("HTTP/1.1 200 OK");

        unlink($carpetaEliminar);

        echo $carpetaEliminar;

        exit();

    }

    if (isset($_GET["id"])) {

        $id = $_GET['id'];

        $statement = $dbConn->prepare("DELETE FROM cursos where id_curso =:id");

        $statement->bindValue(':id', $id);

        $statement->execute();

        header("HTTP/1.1 200 OK");

        $carpetaEliminar = '../cursos/' . $id;

        eliminarCarpeta($carpetaEliminar);

        exit();

    }

}





function eliminarCarpeta($rutaCarpeta)

{

    // Obtener una lista de archivos y subcarpetas dentro de la carpeta

    $archivos = glob($rutaCarpeta . '/*');



    // Eliminar cada archivo encontrado

    foreach ($archivos as $archivo) {

        if (is_file($archivo)) {

            unlink($archivo);

        } elseif (is_dir($archivo)) {

            eliminarCarpeta($archivo);

        }

    }



    // Eliminar la carpeta

    if (is_dir($rutaCarpeta)) {

        rmdir($rutaCarpeta);

    }

}



//En caso de que ninguna de las opciones anteriores se haya ejecutado

header("HTTP/1.1 400 Bad Request");