<?php



include "utils.php";

require '../vendor/autoload.php';





require_once '../models/users.model.php';

require_once '../models/clientes.model.php';

require_once '../models/presupuestos.model.php';







use PhpOffice\PhpSpreadsheet\Spreadsheet;

use PhpOffice\PhpSpreadsheet\Writer\Xlsx;

use PhpOffice\PhpSpreadsheet\IOFactory;



$dbConn = connect($db);



/*

listar todos los posts o solo uno

*/



if ($_SERVER['REQUEST_METHOD'] == 'GET')

    {

    if (isset($_GET['id']))

        {

        //Mostrar un post

        $sql = $dbConn->prepare("SELECT * FROM factura_manual where id_factura_manual=:id");

        $sql->bindValue(':id', $_GET['id']);

        $sql->execute();

        header("HTTP/1.1 200 OK");

        echo json_encode($sql->fetch(PDO::FETCH_ASSOC));

        exit();

        }

    if (isset($_GET['id_factura_manual']))

        {



        //Mostrar un post

        $sql = $dbConn->prepare("SELECT SUM(importe) as total_pagado

        FROM pago_empleado

        WHERE id_factura_manual = :id_factura_manual");

        $sql->bindValue(':id_factura_manual', $_GET['id_factura_manual']);

        $sql->execute();

        $result = $sql->fetch(PDO::FETCH_ASSOC);

        $totalPagado = $result['total_pagado'];

        header("HTTP/1.1 200 OK");

        echo json_encode($totalPagado);

        exit();

        }

    if (isset($_GET['descargar']))

        {



        GetFacturasXSLX($dbConn);

        header("HTTP/1.1 200 OK");

        echo "1";

        exit();

        } else

        {

        //Mostrar lista de post

        $sql = $dbConn->prepare("SELECT

        cs.*,

        JSON_ARRAYAGG(JSON_OBJECT('id_user_copia', uc.id_user_copia, 'email', uc.email)) AS user_copia_array

      FROM

        copia_seguridad cs

      LEFT JOIN

        user_copia uc ON cs.id_copia_seguridad = uc.id_copia_seguridad

      GROUP BY

        cs.id_copia_seguridad");

        $sql->execute();

        $resultado = $sql->fetchAll(PDO::FETCH_ASSOC);



        foreach ($resultado as &$fila)

            {

            $fila['user_copia_array'] = json_decode($fila['user_copia_array'], true);

            }



        header("HTTP/1.1 200 OK");



        echo json_encode($resultado);

        exit();

        }

    }



// Crear un nuevo post

if ($_SERVER['REQUEST_METHOD'] == 'POST')

    {





    if (



        isset($_POST["activo_copia"])

    )

        {



        $activo_copia = json_decode($_POST["activo_copia"], true);

        $personalizacion = json_decode(file_get_contents('../personalizacion.json'), true);

        $personalizacion["activo_copia"] = $activo_copia;

        $personalizacionEncoded = json_encode($personalizacion, JSON_PRETTY_PRINT);

        file_put_contents('../personalizacion.json', $personalizacionEncoded);

        header("HTTP/1.1 200 OK");

        echo json_encode($activo_copia);

        exit();



        }

    if (



        isset($_POST["dias_copia"])

    )

        {



        $dias_copia = json_decode($_POST["dias_copia"], true);

        $personalizacion = json_decode(file_get_contents('../personalizacion.json'), true);

        $personalizacion["dias_copia"] = $dias_copia;

        $personalizacionEncoded = json_encode($personalizacion, JSON_PRETTY_PRINT);

        file_put_contents('../personalizacion.json', $personalizacionEncoded);

        header("HTTP/1.1 200 OK");

        echo json_encode($dias_copia);

        exit();



        }

    if (



        isset($_POST["fecha_inicio_copia"])

    )

        {



        $fecha_inicio_copia = $_POST["fecha_inicio_copia"];

        $personalizacion = json_decode(file_get_contents('../personalizacion.json'), true);

        $personalizacion["fecha_inicio_copia"] = $fecha_inicio_copia;

        $personalizacionEncoded = json_encode($personalizacion, JSON_PRETTY_PRINT);

        file_put_contents('../personalizacion.json', $personalizacionEncoded);

        header("HTTP/1.1 200 OK");

        echo json_encode($fecha_inicio_copia);

        exit();



        }



    if ($_POST["emails_copia"] != null)

        {



        $emails_copia = json_decode($_POST["emails_copia"]);





        $personalizacion = json_decode(file_get_contents('../personalizacion.json'), true);

        $personalizacion["emails_copia"] = $emails_copia;

        $personalizacionEncoded = json_encode($personalizacion, JSON_PRETTY_PRINT);

        file_put_contents('../personalizacion.json', $personalizacionEncoded);

        header("HTTP/1.1 200 OK");



        echo $emails_copia;

        exit();



        }



    }



if ($_SERVER['REQUEST_METHOD'] == 'DELETE')

    {

    if (isset($_GET["id"]))

        {

        $id_copia_seguridad = $_GET['id'];

        $statement = $dbConn->prepare("DELETE FROM copia_seguridad where id_copia_seguridad = :id_copia_seguridad");

        $statement->bindValue(':id_copia_seguridad', $id_copia_seguridad);

        $statement->execute();

        header("HTTP/1.1 200 OK");

        exit();

        }





    }



//Actualizar

if ($_SERVER['REQUEST_METHOD'] == 'PUT')

    {

    $input = $_GET;

    $postId = $input['id'];

    $fields = getParams($input);



    $sql = "

          UPDATE posts

          SET $fields

          WHERE id='$postId'

           ";



    $statement = $dbConn->prepare($sql);

    bindAllValues($statement, $input);



    $statement->execute();

    header("HTTP/1.1 200 OK");

    exit();

    }

    function GetFacturasXSLX($dbConn)

    {

        $spreadsheet = new Spreadsheet();

        $sheet = $spreadsheet->getActiveSheet();

        $tabla = "facturas";

      

       

    

        $columnaActual = 'A';

    $filaActual = 1;

    // Agregar una fila extra para el título "Facturas manuales"

    $sheet->setCellValue('A' . $filaActual, 'Facturas');

    $sheet->mergeCells('A' . $filaActual . ':' . $columnaActual . $filaActual);

    

    $sql_factura_manual = "SELECT * FROM factura_manual";

    $statement_factura_manual = $dbConn->prepare($sql_factura_manual);

    $statement_factura_manual->execute();

    $facturas_manuales = $statement_factura_manual->fetchAll(PDO::FETCH_OBJ);

 

    $claves_manual = array_keys(get_object_vars($facturas_manuales[0]));

    $columnas_manual = $claves_manual;

    

    foreach ($columnas_manual as $columna)

    {

    if (($columna != "programado") && ($columna != "id_contable") && ($columna != "id_tramitadora") && ($columna !=

    "id_gestor") && ($columna != "client_id") && ($columna != "fecha_envio") && ($columna != "titulo") && ($columna !=

    "telefono") && ($columna != "cp") && ($columna != "tipo"))

    {

    if ($columna == "nombre")

    {

    $columna = "Cliente";

    }

    if ($columna == "id_factura_manual")

    {

    $columna = "ID";

    }

    if ($columna == "numero")

    {

    $columna = "Número";

    }

    if ($columna == "estado")

    {

    $columna = "Estado";

    }

    if ($columna == "fecha")

    {

    $columna = "Fecha";

    }

    if ($columna == "fecha_vencimiento")

    {

    $columna = "Fecha de vencimiento";

    }

    if ($columna == "email")

    {

    $columna = "Email";

    }

    if ($columna == "direccion")

    {

    $columna = "Domicilio";

    }

    if ($columna == "importe")

    {

    $columna = "Importe";

    }

    if ($columna == "imagen")

    {

    $columna = "Importe final";

    }

    if ($columna == "cif")

    {

    $columna = "CIF";

    }

    if ($columna == "igic")

    {

    $columna = "IGIC";

    }

    if ($columna == "irpf")

    {

    $columna = "IRPF";

    }

    $sheet->setCellValue($columnaActual . $filaActual, $columna);

    $columnaActual++;

    }

    

    }

    $filaActual++;

    foreach ($facturas_manuales as $fila)

    {

    $columnaActual = 'A';

    foreach ($fila as $clave => $valor)

    {

    if (($clave != "id_tramitadora") && ($clave != "id_gestor") && ($clave != "id_contable") && ($clave != "tipo") && ($clave != "client_id") && ($clave != "fecha_envio") && ($clave != "titulo") && ($clave != "telefono") && ($clave !=

    "cp"))

    {

    if ($clave == "igic")

    {

    $valor = $valor . "%";

    }

    if ($clave == "irpf")

    {

    $valor = ($valor != null) ? $valor . "%" : "0.00%";

    }

    if ($clave == "importe")

    {

    $valor = $valor . "€";

    }

    if ($clave == "imagen")

    {

    $importe = str_replace("€", "", $fila->importe);

    $igic_porcentaje = str_replace("%", "", $fila->igic);

    $irpf_porcentaje = ($fila->irpf != null) ? str_replace("%", "", $fila->irpf) : 0.00;

    

    // Calcular el valor para "imagen"

    $importe_num = (float) str_replace("€", "", $importe);

    $igic_num = (float) str_replace("%", "", $igic_porcentaje);

    $irpf_num = (float) str_replace("%", "", $irpf_porcentaje);

    

    $valor_imagen = $importe_num + ($importe_num * $igic_num / 100) - ($importe_num * $irpf_num / 100);

    $valor = number_format($valor_imagen, 2) . "€";

    }

    $sheet->setCellValue($columnaActual . $filaActual, $valor);

    $columnaActual++;

    }

    }

    $filaActual++;

    }

    

    

    // Configurar el encabezado del archivo XLSX

    // Guardar el archivo XLSX en la salida (output)

    $writer = IOFactory::createWriter($spreadsheet, 'Xls');

    

    $rutaCarpetaGuardar = __ROOT__ . '/copias/';

    $nombreArchivoXLSX = 'copia.xlsx';

    if (file_exists($rutaCarpetaGuardar . $nombreArchivoXLSX))

    {

    unlink($rutaCarpetaGuardar . $nombreArchivoXLSX);

    }

    $writer->save($rutaCarpetaGuardar . $nombreArchivoXLSX);

    $contenidoXLSX = file_get_contents($rutaCarpetaGuardar . $nombreArchivoXLSX);

    

    

    

    // Leer el archivo y enviarlo al navegador

    return $contenidoXLSX;

    }

//En caso de que ninguna de las opciones anteriores se haya ejecutado

header("HTTP/1.1 400 Bad Request");