<?php

include "utils.php";

$dbConn = connect($db);

/*
listar todos los posts o solo uno
 */
if ($_SERVER['REQUEST_METHOD'] == 'GET')
    {
    if (isset($_GET['id_banco']))
        {
        //Mostrar un post
        $sql = $dbConn->prepare("SELECT * FROM bancos where id_banco=:id_banco");
        $sql->bindValue(':id_banco', $_GET['id_banco']);
        $sql->execute();
        header("HTTP/1.1 200 OK");
        echo json_encode($sql->fetch(PDO::FETCH_ASSOC));
        exit();
        } else
        {
        //Mostrar lista de post
        $sql = $dbConn->prepare("SELECT * FROM bancos");
        $sql->execute();
        $sql->setFetchMode(PDO::FETCH_ASSOC);
        header("HTTP/1.1 200 OK");

        echo json_encode($sql->fetchAll());
        exit();
        }
    }

// Crear un nuevo post
if ($_SERVER['REQUEST_METHOD'] == 'POST')
    {
    if (isset($_POST["id_proyecto_asignar"]) && isset($_POST["id_proyecto_trabajador_asignar"]))
        {
        $id_proyecto_asignar = $_POST["id_proyecto_asignar"];
        $id_proyecto_trabajador_asignar = $_POST["id_proyecto_trabajador_asignar"];


        $sql = "UPDATE proyecto_trabajador
        SET id_proyecto = :id_proyecto
        WHERE id_proyecto_trabajador = :id_proyecto_trabajador;";

        $statement = $dbConn->prepare($sql);

        $statement->bindValue(':id_proyecto', $id_proyecto_asignar);
        $statement->bindValue(':id_proyecto_trabajador', $id_proyecto_trabajador_asignar);

        $statement->execute();


        $sql_color = "SELECT color FROM proyectos WHERE id_proyecto = :id_proyecto;";
        $statement_color = $dbConn->prepare($sql_color);
        $statement_color->bindValue(':id_proyecto', $id_proyecto_asignar);
        $statement_color->execute();
        $color = $statement_color->fetchColumn();
        $input['color'] = $color;
        header("HTTP/1.1 200 OK");
        echo json_encode($input);
        exit();

        }
    if (
        isset($_POST["id_trabajador_crear"]) &&
        isset($_POST["fecha_i_crear"]) &&
        isset($_POST["fecha_f_crear"])
    )
        {
        $id_trabajador_crear = $_POST["id_trabajador_crear"];
        $fecha_i_crear = $_POST["fecha_i_crear"];
        $fecha_f_crear = $_POST["fecha_f_crear"];

        $sql = "INSERT INTO proyecto_trabajador (id_trabajador, fecha_i, fecha_f) VALUES (:id_trabajador, :fecha_i, :fecha_f);";

        $statement = $dbConn->prepare($sql);

        $statement->bindValue(':id_trabajador', $id_trabajador_crear);
        $statement->bindValue(':fecha_i', $fecha_i_crear);
        $statement->bindValue(':fecha_f', $fecha_f_crear);

        $statement->execute();
        $id_proyecto_trabajador = $dbConn->lastInsertId();
        $input['id_proyecto_trabajador'] = $id_proyecto_trabajador;
        header("HTTP/1.1 200 OK");
        echo json_encode($input);
        exit();

        }
    }

if ($_SERVER['REQUEST_METHOD'] == 'DELETE')
    {
    $id = $_GET['id'];
    $statement = $dbConn->prepare("DELETE FROM bancos where id_banco =:id");
    $statement->bindValue(':id', $id);
    $statement->execute();
    header("HTTP/1.1 200 OK");
    exit();
    }

//Actualizar
if ($_SERVER['REQUEST_METHOD'] == 'PUT')
    {
    $input = $_GET;
    $postId = $input['id'];
    $fields = getParams($input);

    $sql = "
          UPDATE posts
          SET $fields
          WHERE id='$postId'
           ";

    $statement = $dbConn->prepare($sql);
    bindAllValues($statement, $input);

    $statement->execute();
    header("HTTP/1.1 200 OK");
    exit();
    }

//En caso de que ninguna de las opciones anteriores se haya ejecutado
header("HTTP/1.1 400 Bad Request");