<?php

include "utils.php";

$dbConn = connect($db);

/*
listar todos los contratos o solo uno
 */
if ($_SERVER['REQUEST_METHOD'] == 'GET') {
    if (isset($_GET['id_contrato'])) {
        // Mostrar un contrato
        $sql = $dbConn->prepare("SELECT * FROM contratos WHERE id_contrato = :id_contrato");
        $sql->bindValue(':id_contrato', $_GET['id_contrato']);
        $sql->execute();
        header("HTTP/1.1 200 OK");
        echo json_encode($sql->fetch(PDO::FETCH_ASSOC));
        exit();
    } else {
        // Mostrar lista de contratos
        $sql = $dbConn->prepare("SELECT * FROM contratos");
        $sql->execute();
        $sql->setFetchMode(PDO::FETCH_ASSOC);
        $contratos = $sql->fetchAll(PDO::FETCH_OBJ);
        header("HTTP/1.1 200 OK");
        echo json_encode($contratos);
        exit();
    }
}

// Crear o actualizar un contrato
if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    if (
        isset($_POST["id_empleado"]) &&
        isset($_POST["tipo_contrato"]) &&
        isset($_POST["fecha_inicio"]) &&
        isset($_POST["salario_base"]) &&
        isset($_POST["horas_semanales"]) &&
        isset($_POST["dias_laborales"]) &&
        isset($_POST["horario_entrada"]) &&
        isset($_POST["horario_salida"]) &&
        isset($_POST["estado"])
    ) {
        foreach ($_POST as $key => $value) {
            $value = ($value == "") ? null : $value;
            $$key = $value;
        }

        if (isset($_POST["id_contrato"])) {
            $id_contrato = $_POST["id_contrato"];
            $sql = "UPDATE contratos SET
                id_empleado = :id_empleado,
                tipo_contrato = :tipo_contrato,
                fecha_inicio = :fecha_inicio,
                fecha_fin = :fecha_fin,
                salario_base = :salario_base,
                horas_semanales = :horas_semanales,
                dias_laborales = :dias_laborales,
                horario_entrada = :horario_entrada,
                horario_salida = :horario_salida,
                estado = :estado
                WHERE id_contrato = :id_contrato";
            $statement = $dbConn->prepare($sql);
            $statement->bindValue(':id_contrato', $id_contrato);
        } else {
            $sql = "INSERT INTO contratos
                (id_empleado, tipo_contrato, fecha_inicio, fecha_fin, salario_base, horas_semanales, dias_laborales, horario_entrada, horario_salida, estado)
                VALUES
                (:id_empleado, :tipo_contrato, :fecha_inicio, :fecha_fin, :salario_base, :horas_semanales, :dias_laborales, :horario_entrada, :horario_salida, :estado)";
            $statement = $dbConn->prepare($sql);
        }

        $statement->bindValue(':id_empleado', $id_empleado);
        $statement->bindValue(':tipo_contrato', $tipo_contrato);
        $statement->bindValue(':fecha_inicio', $fecha_inicio);
        $statement->bindValue(':fecha_fin', $fecha_fin);
        $statement->bindValue(':salario_base', $salario_base);
        $statement->bindValue(':horas_semanales', $horas_semanales);
        $statement->bindValue(':dias_laborales', $dias_laborales);
        $statement->bindValue(':horario_entrada', $horario_entrada);
        $statement->bindValue(':horario_salida', $horario_salida);
        $statement->bindValue(':estado', $estado);

        $statement->execute();

        if (!isset($_POST["id_contrato"])) {
            $id_contrato = $dbConn->lastInsertId();
        }

        $input['id_contrato'] = $id_contrato;
        $input['id_empleado'] = $id_empleado;
        $input['tipo_contrato'] = $tipo_contrato;
        $input['fecha_inicio'] = $fecha_inicio;
        $input['fecha_fin'] = $fecha_fin;
        $input['salario_base'] = $salario_base;
        $input['horas_semanales'] = $horas_semanales;
        $input['dias_laborales'] = $dias_laborales;
        $input['horario_entrada'] = $horario_entrada;
        $input['horario_salida'] = $horario_salida;
        $input['estado'] = $estado;

        header("HTTP/1.1 200 OK");
        echo json_encode($input);
        exit();
    }
}

if ($_SERVER['REQUEST_METHOD'] == 'DELETE') {
    $id_contrato = $_GET['id'];
    $statement = $dbConn->prepare("DELETE FROM contratos WHERE id_contrato = :id_contrato");
    $statement->bindValue(':id_contrato', $id_contrato);
    $statement->execute();
    header("HTTP/1.1 200 OK");
    exit();
}

// En caso de que ninguna de las opciones anteriores se haya ejecutado
header("HTTP/1.1 400 Bad Request");