<?php

include "utils.php";

$dbConn = connect($db);

/*
listar todos los posts o solo uno
 */
if ($_SERVER['REQUEST_METHOD'] == 'GET') {

    if (isset($_GET['id_condicion'])) {
        //Mostrar un post
        $sql = $dbConn->prepare("SELECT * FROM condiciones where id_condicion=:id_condicion");
        $sql->bindValue(':id_condicion', $_GET['id_condicion']);
        $sql->execute();
        header("HTTP/1.1 200 OK");
        echo json_encode($sql->fetch(PDO::FETCH_ASSOC));
        exit();
    } else {
        //Mostrar lista de post
        $sql = $dbConn->prepare("SELECT * FROM condiciones");
        $sql->execute();
        $sql->setFetchMode(PDO::FETCH_ASSOC);
        header("HTTP/1.1 200 OK");

        echo json_encode($sql->fetchAll());
        exit();
    }
}

if ($_SERVER['REQUEST_METHOD'] == 'POST') {

    $titulo = $_POST["titulo"];
    $condicion = $_POST["condicion"];

    if(isset($_POST["id_condicion"])){
        $id_condicion = $_POST["id_condicion"];
        $sql = "UPDATE condiciones SET 
        condicion = :condicion,
        titulo = :titulo
        WHERE id_condicion = :id_condicion";
        $statement = $dbConn->prepare($sql);
        $statement->bindValue(':id_condicion', $id_condicion);
    }else{
        $sql = "INSERT INTO condiciones (condicion,titulo) VALUES (:condicion,:titulo)";
        $statement = $dbConn->prepare($sql);
    }

    $statement->bindValue(':titulo', $titulo);
    $statement->bindValue(':condicion', $condicion);

    $statement->execute();
    $object = [
        'id' => $dbConn->lastInsertId(),
        'titulo' => $titulo,
        'condicion' => $condicion,
    ];

    header("HTTP/1.1 200 OK");
    echo json_encode($object);
    exit();

}

//Borrar
if ($_SERVER['REQUEST_METHOD'] == 'DELETE') {
    $id = $_GET['id'];
    $statement = $dbConn->prepare("DELETE FROM condiciones where id_condicion = :id");
    $statement->bindValue(':id', $id);
    $statement->execute();
    header("HTTP/1.1 200 OK");
    exit();
}

//Actualizar
if ($_SERVER['REQUEST_METHOD'] == 'PUT') {
    $input = $_GET;
    $postId = $input['id'];
    $fields = getParams($input);

    $sql = "
          UPDATE posts
          SET $fields
          WHERE id='$postId'
           ";

    $statement = $dbConn->prepare($sql);
    bindAllValues($statement, $input);

    $statement->execute();
    header("HTTP/1.1 200 OK");
    exit();
}

//En caso de que ninguna de las opciones anteriores se haya ejecutado
header("HTTP/1.1 400 Bad Request");