<?php



include "utils.php";







$dbConn =  connect($db);



/*

  listar todos los posts o solo uno

 */
$personalizacion = json_decode(file_get_contents('../personalizacion.json'), true);
if ($_SERVER['REQUEST_METHOD'] == 'GET') {

    if (isset($_GET['crear_factura'])) {

        $sql = $dbConn->prepare("SELECT 

                c.*, 

                x.cif, 

                x.email,

                z.numero AS numero_f,

                CASE 

                    WHEN c.user_id IS NULL THEN 'Ningún responsable seleccionado'

                    ELSE u.user_full_name 

                END AS nombre_responsable,

                CASE 

                    WHEN c.client_id IS NULL THEN 'Ningún cliente seleccionado'

                    ELSE x.nombre 

                END AS nombre_cliente

                FROM compras c 

                LEFT JOIN users u ON c.user_id = u.user_id

                LEFT JOIN clientes x ON c.client_id = x.client_id

                LEFT JOIN factura_manual z ON c.invoice_id = z.id_factura_manual

                WHERE c.invoice_id IS NULL");

        $sql->execute();

        header("HTTP/1.1 200 OK");

        echo json_encode($sql->fetchAll(PDO::FETCH_ASSOC));

        exit();
    }



    if (isset($_GET['id_compra'])) {

        //Mostrar un post

        $sql = $dbConn->prepare("SELECT * FROM compras where id_compra=:id_compra");

        $sql->bindValue(':id_compra', $_GET['id_compra']);

        $sql->execute();

        header("HTTP/1.1 200 OK");



        foreach ($input as $key => $value) {

            if (is_null($value['numero']) || empty($value['numero'])) {

                $input[$key]['numero'] = 'Sin factura asociada';
            }
        }



        echo json_encode($sql->fetch(PDO::FETCH_ASSOC));

        exit();
    } else {

        try {
            $s = "SELECT 
                        c.*, 
                        x.cif, 
                        x.email,
                         z.numero AS numero_f,
                        CASE 
                            WHEN c.user_id IS NULL THEN 'Ningún responsable seleccionado'
                            ELSE u.user_full_name 
                        END AS nombre_responsable,
                        CASE 
                            WHEN c.client_id IS NULL THEN 'Ningún cliente seleccionado'
                            ELSE x.nombre 
                        END AS nombre_cliente
                    FROM compras c 
                    LEFT JOIN users u ON c.user_id = u.user_id
                    LEFT JOIN clientes x ON c.client_id = x.client_id
                    LEFT JOIN factura_manual z ON c.invoice_id = z.id_factura_manual
                    ";
            $condiciones = [];
            if (isset($_GET["fecha_i"]) && isset($_GET["fecha_f"])) {

                $condiciones[] = "DATE_FORMAT(c.fecha, '%Y-%m-%d') BETWEEN :fecha_i AND :fecha_f";
            }

            // Agregar WHERE solo si hay condiciones

            if (!empty($condiciones)) {

                $s .= " WHERE " . implode(" AND ", $condiciones);
            }
            // 1. Obtener las compras con joins y datos adicionales
            $sql = $dbConn->prepare($s);

            if (isset($_GET["fecha_i"]) && isset($_GET["fecha_f"])) {

                $sql->bindValue(':fecha_i', $_GET['fecha_i']);

                $sql->bindValue(':fecha_f', $_GET['fecha_f']);
            }



            $sql->execute();
            $sql->setFetchMode(PDO::FETCH_ASSOC);
            $compras = $sql->fetchAll();

            // Asegurar que el campo 'numero' no venga vacío o nulo
            foreach ($compras as $key => $value) {
                if (is_null($value['numero']) || empty($value['numero'])) {
                    $compras[$key]['numero'] = 'Sin factura asociada';
                }
            }

            // 2. Obtener el total de ingresos
            $sqlIngresos = $dbConn->prepare("SELECT SUM(importe_final) AS total_ingresos FROM compras");
            $sqlIngresos->execute();
            $ingresos = $sqlIngresos->fetch(PDO::FETCH_ASSOC)['total_ingresos'] ?? 0;

            // 3. Contar compras con factura (invoice_id no es NULL)
            $sqlConFactura = $dbConn->prepare("SELECT COUNT(*) AS total_con_factura FROM compras WHERE invoice_id IS NOT NULL");
            $sqlConFactura->execute();
            $con_factura = $sqlConFactura->fetch(PDO::FETCH_ASSOC)['total_con_factura'] ?? 0;

            // 4. Contar compras sin factura (invoice_id IS NULL)
            $sqlSinFactura = $dbConn->prepare("SELECT COUNT(*) AS total_sin_factura FROM compras WHERE invoice_id IS NULL");
            $sqlSinFactura->execute();
            $sin_factura = $sqlSinFactura->fetch(PDO::FETCH_ASSOC)['total_sin_factura'] ?? 0;

            // 5. Armar la respuesta
            $response = [
                "compras" => $compras,
                "ingresos" => (float)$ingresos,
                "con_factura" => (int)$con_factura,
                "sin_factura" => (int)$sin_factura
            ];

            header("HTTP/1.1 200 OK");
            echo json_encode($response);
            exit();
        } catch (PDOException $e) {

            // Manejo del error

            header("HTTP/1.1 500 Internal Server Error");

            echo json_encode(array("error" => $e->getMessage()));

            exit();
        }
    }
}



// Crear un nuevo post

if ($_SERVER['REQUEST_METHOD'] == 'POST') {

    if (isset($_GET['crear_factura'])) {

        $output = array();

        $output['status'] = false;

        $razon_social = $_POST['data']['razon_social'];

        if (is_null($razon_social) || empty($razon_social)) {

            $output['msg'] = 'Debe proporcionar una razón social válida';

            echo json_encode($output);

            exit;
        }



        $cif = $_POST['data']['cif'];

        if (is_null($cif) || empty($cif)) {

            $output['msg'] = 'Debe proporcionar un CIF/NIF válido';

            echo json_encode($output);

            exit;
        }



        $email = $_POST['data']['email'];

        if (is_null($email) || empty($email)) {

            $output['msg'] = 'Debe proporcionar un email válido';

            echo json_encode($output);

            exit;
        }



        if (!filter_var($email, FILTER_VALIDATE_EMAIL)) {

            $output['msg'] = 'Formato de email no válido';

            echo json_encode($output);

            exit;
        }



        $email = $_POST['data']['email'];

        if (is_null($email) || empty($email)) {

            $output['msg'] = 'Debe proporcionar un email válido';

            echo json_encode($output);

            exit;
        }



        $numero = $_POST['data']['numero'];

        if (is_null($numero) || empty($numero)) {

            $output['msg'] = 'Debe proporcionar un número de factura válida';

            echo json_encode($output);

            exit;
        }



        $direccion = $_POST['data']['direccion'];

        if (is_null($direccion) || empty($direccion)) {

            $output['msg'] = 'Debe proporcionar una dirección válida';

            echo json_encode($output);

            exit;
        }



        $titulo = $_POST['data']['titulo'];

        if (is_null($titulo) || empty($titulo)) {

            $output['msg'] = 'Debe proporcionar una dirección válida';

            echo json_encode($output);

            exit;
        }

        $client_id = $_POST['data']['client_id'];
        if (is_null($client_id) || empty($client_id) || $client_id == "No") {

            $output['msg'] = 'Debe seleccionar un cliente';

            echo json_encode($output);

            exit;
        }

        $telefono = $_POST['data']['telefono'];

        if (is_null($telefono) || empty($telefono)) {

            $output['msg'] = 'Debe proporcionar un teléfono válido';

            echo json_encode($output);

            exit;
        }



        $cp = $_POST['data']['cp'];

        if (is_null($cp) || empty($cp)) {

            $output['msg'] = 'Debe proporcionar un código postal válido';

            echo json_encode($output);

            exit;
        }



        if (count($_POST['data']['tickets']) == 0) {

            $output['msg'] = 'Debe seleccionar al menos un ticket';

            echo json_encode($output);

            exit;
        }



        $tickets_ids_txt = '';

        foreach ($_POST['data']['tickets'] as $key => $value) {

            $tickets_ids_txt .= $value . ',';
        }



        $tickets_ids_txt = substr($tickets_ids_txt, 0, -1);



        $sql = $dbConn->prepare("SELECT * FROM compras WHERE id_compra IN(" . $tickets_ids_txt . ")");

        $sql->execute();

        $tickets_row = $sql->fetchAll(PDO::FETCH_ASSOC);



        $subtotal = 0.00;

        $impuestos = 0.00;

        $total = 0.00;

        $id_cliente = '';

        $igic_per = 0;

        foreach ($tickets_row as $key => $value) {

            $igic_per = $value['igic'] * 100;

            $subtotal += $value['importe'];

            $impuestos += $value['igic'];

            $total += $value['importe_final'];
        }






        $sql = "INSERT INTO factura_manual 

        (numero, fecha, direccion, importe, estado, email, imagen, nombre, cif, cp, telefono, client_id, titulo, tipo, impuesto)

        VALUES

        (:numero, :fecha, :direccion, :importe, :estado, :email, :imagen, :nombre, :cif, :cp, :telefono, :client_id, :titulo, :tipo, :impuesto)";



        $statement = $dbConn->prepare($sql);

        $statement->bindValue(':numero', $numero);

        $statement->bindValue(':fecha', date('Y-m-d'));

        $statement->bindValue(':direccion', $direccion);

        $statement->bindValue(':importe', $subtotal);

        $statement->bindValue(':estado', 'Pendiente');

        $statement->bindValue(':email', $email);

        $statement->bindValue(':imagen', htmlentities($personalizacion['url_logo_superior'], ENT_QUOTES));

        $statement->bindValue(':nombre', $razon_social);

        $statement->bindValue(':cif', $cif);

        $statement->bindValue(':cp', $cp);

        $statement->bindValue(':telefono', $telefono);

        $statement->bindValue(':client_id', $client_id);

        $statement->bindValue(':titulo', $titulo);

        $statement->bindValue(':tipo', 'Particular');

        $statement->bindValue(':impuesto', NULL);

        $statement->execute();



        $postId = $dbConn->lastInsertId();



        $personalizacion["numeracion_facturas"] = intval($personalizacion["numeracion_facturas"]) + 1;

        $personalizacionEncoded = json_encode($personalizacion, JSON_PRETTY_PRINT);

        file_put_contents('../personalizacion.json', $personalizacionEncoded);



        $sql = "UPDATE compras SET invoice_id = :invoice_id WHERE id_compra IN(" . $tickets_ids_txt . ")";

        $statement = $dbConn->prepare($sql);

        $statement->bindValue(':invoice_id', $postId);



        $statement->execute();



        foreach ($tickets_row as $key => $value) {

            /**

             * Insertar lineas de la factura

             */

            $sql = "INSERT INTO apartado_factura_manual 

            (cantidad, titulo, descripcion, precio_unitario,id_factura_manual, codigo, igic)

            VALUES

            (:cantidad, :titulo, :descripcion, :precio_unitario, :id_factura_manual, :codigo, :igic)";



            $statement = $dbConn->prepare($sql);

            $statement->bindValue(':cantidad', '1');

            $statement->bindValue(':titulo', 'Ticket de compra');

            $statement->bindValue(':descripcion', '');

            $statement->bindValue(':precio_unitario', $value['importe']);

            $statement->bindValue(':id_factura_manual', $postId);

            $statement->bindValue(':codigo', $value['id_compra']);

            $statement->bindValue(':igic', $value['igic'] * 100);

            $statement->execute();
        }



        $output['msg'] = 'Factura creada correctamente';

        $output['status'] = true;

        echo json_encode($output);

        exit;
    } else {

        if (

            isset($_POST["client_id"])

            && isset($_POST["detallado"])

            && isset($_POST["igic"])

            && isset($_POST["importe"])

            && isset($_POST["tipo"])

            && isset($_POST["importe_final"])

            && isset($_POST["fecha"])
            && isset($_POST["numero"])

            && isset($_POST["user_id"])

        ) {

            foreach ($_POST as $key => $value) {

                $value = ($value == "No") ? null : $value;

                $value = ($value == "") ? null : $value;



                $$key = $value;
            }

            try {

                if (isset($_POST["id_compra"])) {

                    $id_compra = $_POST["id_compra"];

                    $sql = "UPDATE compras SET 

                client_id = :client_id,

                detallado = :detallado,

                igic = :igic,

                importe = :importe,

                tipo = :tipo,

                importe_final = :importe_final,

                fecha = :fecha,
                  numero = :numero,

                user_id = :user_id

                WHERE id_compra = :id_compra";

                    $statement = $dbConn->prepare($sql);

                    $statement->bindValue(':id_compra', $id_compra);
                } else {

                    $sql = "INSERT INTO compras

                (client_id, detallado, igic, importe, tipo, importe_final, fecha
                , numero, user_id)

                VALUES

                (:client_id, :detallado, :igic, :importe, :tipo, :importe_final, :fecha
                , :numero, :user_id)";

                    $statement = $dbConn->prepare($sql);
                }

                $statement->bindValue(':client_id', $client_id);

                $statement->bindValue(':detallado', $detallado);

                $statement->bindValue(':igic', $igic);

                $statement->bindValue(':importe', $importe);

                $statement->bindValue(':tipo', $tipo);

                $statement->bindValue(':importe_final', $importe_final);

                $statement->bindValue(':fecha', $fecha);
                $statement->bindValue(':numero', $numero);

                $statement->bindValue(':user_id', $user_id);



                $statement->execute();
                if (isset($_POST["id_compra"])) {

                    $id_compra = $_POST["id_compra"];
                } else {

                    $id_compra = $dbConn->lastInsertId();

                    $personalizacion = json_decode(file_get_contents('../personalizacion.json'), true);

                    $personalizacion["numeracion_tickets"] = intval($personalizacion["numeracion_tickets"]) + 1;

                    $personalizacionEncoded = json_encode($personalizacion, JSON_PRETTY_PRINT);

                    file_put_contents('../personalizacion.json', $personalizacionEncoded);
                }


                $input['id'] = $id_compra;



                header("HTTP/1.1 200 OK");

                echo json_encode($input);

                exit();
            } catch (PDOException $e) {

                header("HTTP/1.1 200 OK");

                echo json_encode(array("error" => $e->getMessage()));

                exit();
            }
        }
    }
}



//Borrar

if ($_SERVER['REQUEST_METHOD'] == 'DELETE') {

    $id = $_GET['id'];

    $statement = $dbConn->prepare("DELETE FROM posts where id=:id");

    $statement->bindValue(':id', $id);

    $statement->execute();

    header("HTTP/1.1 200 OK");

    exit();
}



//Actualizar

if ($_SERVER['REQUEST_METHOD'] == 'PUT') {

    $input = $_GET;

    $postId = $input['id'];

    $fields = getParams($input);



    $sql = "

          UPDATE posts

          SET $fields

          WHERE id='$postId'

           ";



    $statement = $dbConn->prepare($sql);

    bindAllValues($statement, $input);



    $statement->execute();

    header("HTTP/1.1 200 OK");

    exit();
}





//En caso de que ninguna de las opciones anteriores se haya ejecutado

header("HTTP/1.1 400 Bad Request");
