<?php



include "utils.php";







require_once __LIBRARIES__ . 'image_upload.php';

$dbConn = connect($db);







/*

listar todos los posts o solo uno

*/

if ($_SERVER['REQUEST_METHOD'] == 'GET') {

    if (isset($_GET['id_grupo'])) {

        $sql = $dbConn->prepare("SELECT * FROM grupos where id_grupo=:id_grupo");

        $sql->bindValue(':id_grupo', $_GET['id_grupo']);

        $sql->execute();

        $grupo = $sql->fetch(PDO::FETCH_ASSOC);





        //Mostrar un post

        $sql = $dbConn->prepare("SELECT c.*, g.nombre AS nombre_grupo

        FROM clientes c

        INNER JOIN grupo_cliente gc ON c.client_id = gc.client_id

        INNER JOIN grupos g ON gc.id_grupo = g.id_grupo

        WHERE gc.id_grupo = :id_grupo");

        $sql->bindValue(':id_grupo', $_GET['id_grupo']);

        $sql->execute();

        $sql->setFetchMode(PDO::FETCH_ASSOC);



        $clientes = $sql->fetchAll(PDO::FETCH_OBJ);

        foreach ($clientes as $cliente) {

            $clientID = $cliente->client_id;

            $sql = "SELECT g.id_grupo, g.nombre

                FROM grupos g

                INNER JOIN grupo_cliente gc ON g.id_grupo = gc.id_grupo

                WHERE gc.client_id = :clientID";

            $stmt = $dbConn->prepare($sql);

            $stmt->bindParam(':clientID', $clientID, PDO::PARAM_INT);

            $stmt->execute();

            // Obtener el resultado como un objeto

            $grupos = $stmt->fetchAll(PDO::FETCH_OBJ);

            $cliente->grupos = $grupos;
        }





        header("HTTP/1.1 200 OK");

        echo json_encode($clientes);

        exit();
    }





    if (isset($_GET['fecha_i']) && isset($_GET['fecha_f'])) {

        $fecha_i = $_GET['fecha_i'];

        $fecha_f = $_GET['fecha_f'];

        if ($fecha_i == "No" && $fecha_f == "No") {



            $sql = "SELECT client_id, estado FROM clientes";

            $stmt = $dbConn->prepare($sql);





            $stmt->execute();

            $result = $stmt->fetchAll(PDO::FETCH_OBJ);

            $clientesPotenciales = array();

            $clientesAceptados = array();

            foreach ($result as $row) {

                $e = $row->estado;



                $sql = "SELECT COUNT(*) AS cantidad_presupuestos

                FROM presupuestos

                WHERE id_cliente = :clientID

                AND estado = 'Aceptado'";

                $stmt = $dbConn->prepare($sql);

                $stmt->bindParam(':clientID', $row->client_id, PDO::PARAM_INT);

                $stmt->execute();

                $cant_presupuestos = $stmt->fetch(PDO::FETCH_OBJ)->cantidad_presupuestos;



                $clientID = $row->client_id;



                $estado = (intval($cant_presupuestos) > 0 || $row->estado == "Aceptado") ? 'Aceptado' : 'Potencial';





                $sql = "SELECT *

                FROM clientes 

                WHERE client_id = :clientID";

                $stmt = $dbConn->prepare($sql);

                $stmt->bindParam(':clientID', $clientID, PDO::PARAM_INT);

                $stmt->execute();

                // Obtener el resultado como un objeto

                $cliente = $stmt->fetch(PDO::FETCH_OBJ);



                $sql = "SELECT g.id_grupo, g.nombre

                FROM grupos g

                INNER JOIN grupo_cliente gc ON g.id_grupo = gc.id_grupo

                WHERE gc.client_id = :clientID";

                $stmt = $dbConn->prepare($sql);

                $stmt->bindParam(':clientID', $clientID, PDO::PARAM_INT);

                $stmt->execute();

                // Obtener el resultado como un objeto

                $grupos = $stmt->fetchAll(PDO::FETCH_OBJ);

                $cliente->grupos = $grupos;



                if ($estado == "Aceptado") {

                    array_push($clientesAceptados, $cliente);
                } else {

                    array_push($clientesPotenciales, $cliente);
                }
            }





            $clientes["potenciales"] = $clientesPotenciales;

            $clientes["aceptados"] = $clientesAceptados;





            // Devolver objeto de clientes

            header("HTTP/1.1 200 OK");

            echo json_encode($clientes);

            exit();
        } else {

            $sql = "SELECT client_id, estado FROM clientes WHERE DATE_FORMAT(fecha, '%Y-%m-%d') BETWEEN :fecha_i AND :fecha_f";

            $stmt = $dbConn->prepare($sql);

            $stmt->bindParam(':fecha_i', $fecha_i);

            $stmt->bindParam(':fecha_f', $fecha_f);



            $stmt->execute();

            $result = $stmt->fetchAll(PDO::FETCH_OBJ);

            $clientesPotenciales = array();

            $clientesAceptados = array();

            foreach ($result as $row) {

                $e = $row->estado;

                $sql = "SELECT COUNT(*) AS cantidad_presupuestos

                    FROM presupuestos

                    WHERE id_cliente = :clientID

                    AND estado = 'Aceptado'";

                $stmt = $dbConn->prepare($sql);

                $stmt->bindParam(':clientID', $row->client_id, PDO::PARAM_INT);

                $stmt->execute();

                $cant_presupuestos = $stmt->fetch(PDO::FETCH_OBJ)->cantidad_presupuestos;



                $clientID = $row->client_id;

                $estado = (intval($cant_presupuestos) > 0 || $row->estado == "Aceptado") ? 'Aceptado' : 'Potencial';





                $sql = "SELECT c.*, u.user_full_name 

                FROM clientes c 

                JOIN users u ON c.user_id = u.user_id 

                WHERE c.client_id = :clientID";

                $stmt = $dbConn->prepare($sql);

                $stmt->bindParam(':clientID', $clientID, PDO::PARAM_INT);

                $stmt->execute();

                // Obtener el resultado como un objeto

                $cliente = $stmt->fetch(PDO::FETCH_OBJ);

                if ($estado == "Aceptado") {

                    array_push($clientesAceptados, $cliente);
                } else {

                    array_push($clientesPotenciales, $cliente);
                }
            }





            $clientes["potenciales"] = $clientesPotenciales;

            $clientes["aceptados"] = $clientesAceptados;



            // Devolver objeto de clientes

            header("HTTP/1.1 200 OK");

            echo json_encode($clientes);

            exit();
        }
    }

    if (isset($_GET['client_id'])) {

        //Mostrar un post

        $sql = $dbConn->prepare("SELECT * FROM clientes where client_id=:client_id");

        $sql->bindValue(':client_id', $_GET['client_id']);

        $sql->execute();



        $images = glob('../clientes/' . $_GET['client_id'] . '/contratos/*.{pdf}', GLOB_BRACE);

        $fileObjects = array();



        foreach ($images as $image) {

            $fileInfo = pathinfo($image);

            $fileObject = new stdClass(); // Crear un objeto vacío para almacenar los datos

            $fileObject->url = $image; // Almacenar la URL del archivo

            $fileObject->extension = $fileInfo['extension']; // Almacenar la extensión del archivo

            $fileObject->nombre = $fileInfo['basename']; // Almacenar la extensión del archivo



            $fileObjects[] = $fileObject; // Agregar el objeto al arreglo

        }

        $cliente = $sql->fetch(PDO::FETCH_ASSOC);

        $cliente["contratos"] = $fileObjects;

        header("HTTP/1.1 200 OK");

        echo json_encode($cliente);

        exit();
    } else {

        //Mostrar lista de post

        $sql = $dbConn->prepare("SELECT * FROM clientes");

        $sql->execute();

        $sql->setFetchMode(PDO::FETCH_ASSOC);

        header("HTTP/1.1 200 OK");

        // echo var_dump($sql->fetchAll());

        echo json_encode($sql->fetchAll(), JSON_UNESCAPED_UNICODE);



        exit();
    }
}



// Crear un nuevo post

if ($_SERVER['REQUEST_METHOD'] == 'POST') {





    if (isset($_FILES["imagen_cliente"]) && isset($_POST["client_id_imagen"])) {





        $Upload = new _ImageUpload($DBLink, '../uploads');



        $Avatar = $Upload->_SaveImage($_FILES["imagen_cliente"]);



        $res = mysqli_real_escape_string($DBLink, './image.php?id=' . $Avatar->url);



        $sql = "UPDATE clientes SET imagen = :imagen WHERE client_id = :client_id_imagen";

        $statement = $dbConn->prepare($sql);

        $statement->bindValue(':client_id_imagen', $_POST["client_id_imagen"]);

        $statement->bindValue(':imagen', htmlentities($res, ENT_QUOTES));



        $statement->execute();

        header("HTTP/1.1 200 OK");



        echo htmlentities($res, ENT_QUOTES);

        exit();
    } elseif (isset($_FILES["contrato"]) && isset($_POST["client_id"])) {

        $contrato = $_FILES['contrato'];

        $id_cliente = $_POST["client_id"];



        $nombreArchivo = $contrato['name'];

        $tipoArchivo = $contrato['type'];

        $archivoTemporal = $contrato['tmp_name'];

        $tamañoArchivo = $contrato['size'];



        $directorioCliente = '../clientes/' . $id_cliente . '/contratos/';





        $rutaArchivo = $directorioCliente . $nombreArchivo;



        if (move_uploaded_file($archivoTemporal, $rutaArchivo)) {

            echo json_encode(['status' => 1]); // Archivo movido exitosamente

        } else {

            echo json_encode(['status' => 0]); // Error al mover el archivo

        }
    } elseif (isset($_POST['import_items'])) {

        $jsonData = $_POST['import_items'];
        $items = json_decode($jsonData, true);
        $todoCorrecto = true;

        try {
            if (json_last_error() === JSON_ERROR_NONE && is_array($items)) {
                foreach ($items as $item) {
                    foreach ($item as $key => $value) {
                        $value = ($value === "" || $value === null) ? null : $value;
                        $$key = $value;
                    }

                    $id_poblacion = null;
                    $emails = null;

                    $user_id = null;

                    $tipo = "Particular";
                    $codigo_contable = null;
                    $codigo_gestor = null;
                    $codigo_tramitador = null;
                    $id_sector = null;
                    $terminos = 1;

                    $forma_juridica = null;
                    $nombre_juridico = null;
                    $cif_juridico = null;
                    $domicilio_fiscal = null;


                    $fecha = date('Y-m-d');

                    $estado = 'Potencial';

                    $peluqueria = "No";
                    $exists = false;

                    if ($codigo !== null) {
                        $checkSql = "SELECT COUNT(*) FROM clientes WHERE codigo = :codigo";
                        $checkStmt = $dbConn->prepare($checkSql);
                        $checkStmt->bindValue(':codigo', $codigo);
                        $checkStmt->execute();
                        $exists = $checkStmt->fetchColumn() > 0;
                    }

                    if ($codigo !== null && $exists) {
                        // UPDATE
                        $sql = "UPDATE clientes SET 
                        nombre = :nombre,

                        id_poblacion = :id_poblacion,
        
                        tipo = :tipo,
        
                        web = :web,
        
                        sexo = :sexo,
        
                        emails = :emails,
        
                        direccion = :direccion,
        
                        telefono = :telefono,
        
                        cp = :cp,
        
                        cif = :cif,
        
                        email = :email,
        
                        fecha = :fecha,
        
                        codigo_contable = :codigo_contable,
        
                        codigo_gestor = :codigo_gestor,
        
                        codigo_tramitador = :codigo_tramitador,
        
                        user_id = :user_id,
        
                        id_sector = :id_sector,
        
                        linkedin = :linkedin,
        
                        instagram = :instagram,
        
                        tiktok = :tiktok,
        
                        x = :x,
        
                        facebook = :facebook,
        
                        forma_juridica = :forma_juridica,
        
                        nombre_juridico = :nombre_juridico,
        
                        cif_juridico = :cif_juridico,
        
                        domicilio_fiscal = :domicilio_fiscal,
        
                        estado = :estado,
        
                        fecha_nacimiento = :fecha_nacimiento,
        
                        codigo = :codigo,
        
                        peluqueria = :peluqueria,
        
                        movil = :movil,
        
                        terminos = :terminos
                                WHERE codigo = :codigo";
                        $statement = $dbConn->prepare($sql);
                    } else {
                        // INSERT
                        $sql = "INSERT INTO clientes  (codigo_contable,

                        codigo_gestor,
        
                        codigo_tramitador,
        
                        nombre,
        
                        id_poblacion,
        
                        direccion,
        
                        tipo,
        
                        telefono,
        
                        web,
        
                        sexo,
        
                        cp,
        
                        cif,
        
                        email,
        
                        fecha,
        
                        user_id,
        
                        id_sector,
        
                        linkedin,
        
                        instagram,
        
                        tiktok,
        
                        x,
        
                        facebook,
        
                        forma_juridica,
        
                        nombre_juridico,
        
                        cif_juridico,
        
                        domicilio_fiscal,
        
                        estado,
        
                        emails,
        
                        fecha_nacimiento,
        
                        codigo,
        
                        peluqueria,
        
                        movil,
        
                        terminos)
        
                        VALUES
        
                        (:codigo_contable,
        
                        :codigo_gestor,
        
                        :codigo_tramitador,
        
                        :nombre,
        
                        :id_poblacion,
        
                        :direccion,
        
                        :tipo,
        
                        :telefono,
        
                        :web,
        
                        :sexo,
        
                        :cp,
        
                        :cif,
        
                        :email,
        
                        :fecha,
        
                        :user_id,
        
                        :id_sector,
        
                        :linkedin,
        
                        :instagram,
        
                        :tiktok,
        
                        :x,
        
                        :facebook,
        
                        :forma_juridica,
        
                        :nombre_juridico,
        
                        :cif_juridico,
        
                        :domicilio_fiscal,
        
                        :estado,
        
                        :emails,
        
                        :fecha_nacimiento,
        
                        :codigo,
        
                        :peluqueria,
        
                        :movil,
        
                        :terminos)";
                        $statement = $dbConn->prepare($sql);
                    }

                    // Bind de los valores
                    $statement->bindValue(':codigo', $codigo);

                    $statement->bindValue(':tipo', $tipo);

                    $statement->bindValue(':nombre', $nombre);

                    $statement->bindValue(':id_poblacion', $id_poblacion);

                    $statement->bindValue(':emails', $emails);

                    $statement->bindValue(':sexo', $sexo);

                    $statement->bindValue(':web', $web);

                    $statement->bindValue(':direccion', $direccion);

                    $statement->bindValue(':telefono', $telefono);

                    $statement->bindValue(':cp', $cp);

                    $statement->bindValue(':cif', $cif);

                    $statement->bindValue(':email', $email);

                    $statement->bindValue(':fecha', $fecha);

                    $statement->bindValue(':user_id', $user_id);

                    $statement->bindValue(':estado', $estado);

                    $statement->bindValue(':fecha_nacimiento', $fecha_nacimiento);

                    $statement->bindValue(':peluqueria', $peluqueria);

                    $statement->bindValue(':codigo_contable', $codigo_contable);

                    $statement->bindValue(':codigo_gestor', $codigo_gestor);

                    $statement->bindValue(':codigo_tramitador', $codigo_tramitador);

                    $statement->bindValue(':id_sector', $id_sector);

                    $statement->bindValue(':linkedin', $linkedin);

                    $statement->bindValue(':instagram', $instagram);

                    $statement->bindValue(':tiktok', $tiktok);

                    $statement->bindValue(':x', $x);

                    $statement->bindValue(':facebook', $facebook);

                    $statement->bindValue(':forma_juridica', $forma_juridica);

                    $statement->bindValue(':nombre_juridico', $nombre_juridico);

                    $statement->bindValue(':cif_juridico', $cif_juridico);

                    $statement->bindValue(':domicilio_fiscal', $domicilio_fiscal);

                    $statement->bindValue(':movil', $movil); // Nuevo campo

                    $statement->bindValue(':terminos', $terminos);

                    if (!$statement->execute()) {
                        $todoCorrecto = false;
                        break;
                    }
                    if ($codigo !== null && $exists) {
                    } else {
                        $baseUrl = ($_SERVER['HTTPS'] ? 'https://' : 'http://') . $_SERVER['HTTP_HOST'] . '/';
                        $id_cliente = $dbConn->lastInsertId();

                        $carpetaNuevaAlumno = '../clientes/' . $id_cliente;

                        $carpetaArchivosAlumno = '../clientes/' . $id_cliente . '/contratos';

                        mkdir($carpetaNuevaAlumno, 0777, true);

                        mkdir($carpetaArchivosAlumno, 0777, true);
                    }
                }

                if ($todoCorrecto) {
                    header("HTTP/1.1 200 OK");
                    echo json_encode(['status' => 'success', 'message' => 'Todos los elementos se han procesado correctamente']);
                } else {
                    header("HTTP/1.1 200 OK");
                    echo json_encode(['status' => 'error', 'message' => 'Error al procesar uno o más elementos']);
                }
            } else {
                header("HTTP/1.1 400 Bad Request");
                echo json_encode(['status' => 'error', 'message' => 'Datos JSON inválidos o formato incorrecto']);
            }
        } catch (PDOException $e) {
            header("HTTP/1.1 500 Internal Server Error");
            echo json_encode(['status' => 'error', 'message' => 'Error de base de datos: ' . $e->getMessage()]);
        } catch (Exception $e) {
            header("HTTP/1.1 500 Internal Server Error");
            echo json_encode(['status' => 'error', 'message' => 'Error: ' . $e->getMessage()]);
        }

        exit();
    } elseif (isset($_POST['import_clientes'])) {

        $jsonData = $_POST['import_clientes'];

        $clientes = json_decode($jsonData, true);

        $todoCorrecto = true;



        try {

            if (json_last_error() === JSON_ERROR_NONE && is_array($clientes)) {

                foreach ($clientes as $cliente) {

                    if (is_array($cliente) && isset($cliente['nombre'], $cliente['email'], $cliente['direccion'], $cliente['cp'], $cliente['telefono'], $cliente['user_id'])) {

                        $nombre = $cliente['nombre'];

                        $email = $cliente['email'];

                        $direccion = $cliente['direccion'];

                        $cp = $cliente['cp'];

                        $telefono = $cliente['telefono'];

                        $user_id = $cliente['user_id'];

                        $dni = $cliente['dni'];

                        $codigo = ($cliente['codigo'] != "") ? $cliente['codigo'] : null;

                        $fecha_nacimiento = ($cliente['fecha_nacimiento'] != "") ? $cliente['fecha_nacimiento'] : null;

                        $sexo = ($cliente['sexo'] != "") ? $cliente['sexo'] : null;

                        $tiktok = ($cliente['tiktok'] != "") ? $cliente['tiktok'] : null;

                        $facebook = ($cliente['facebook'] != "") ? $cliente['facebook'] : null;

                        $instagram = ($cliente['instagram'] != "") ? $cliente['instagram'] : null;

                        $x = ($cliente['x'] != "") ? $cliente['x'] : null;

                        $website = ($cliente['website'] != "") ? $cliente['website'] : null;

                        $linkedin = ($cliente['linkedin'] != "") ? $cliente['linkedin'] : null;

                        $movil = ($cliente['movil'] != "") ? $cliente['movil'] : null;



                        if (!filter_var($email, FILTER_VALIDATE_EMAIL)) {

                            throw new Exception('Email inválido: ' . $email);
                        }



                        $stmt = $dbConn->prepare("INSERT INTO clientes (codigo, cif,user_id, nombre, email, direccion, cp, telefono, movil, fecha_nacimiento, sexo, linkedin, instagram,x,facebook,web, tiktok) 

                        VALUES (:codigo, :cif, :user_id, :nombre, :email, :direccion, :cp, :telefono, :movil, :fecha_nacimiento, :sexo, :linkedin, :instagram, :x, :facebook, :web, :tiktok)");

                        $stmt->bindParam(':nombre', $nombre);

                        $stmt->bindParam(':cif', $dni);

                        $stmt->bindParam(':email', $email);

                        $stmt->bindParam(':direccion', $direccion);

                        $stmt->bindParam(':cp', $cp);

                        $stmt->bindParam(':telefono', $telefono);

                        $stmt->bindParam(':movil', $telefono);

                        $stmt->bindParam(':user_id', $user_id);

                        $stmt->bindParam(':codigo', $codigo);

                        $stmt->bindParam(':fecha_nacimiento', $fecha_nacimiento);

                        $stmt->bindParam(':sexo', $sexo);

                        $stmt->bindParam(':linkedin', $linkedin);

                        $stmt->bindParam(':instagram', $instagram);

                        $stmt->bindParam(':x', $x);

                        $stmt->bindParam(':facebook', $facebook);

                        $stmt->bindParam(':web', $website);

                        $stmt->bindParam(':tiktok', $tiktok);



                        if (!$stmt->execute()) {

                            $todoCorrecto = false;

                            break;
                        }



                        $id_cliente = $dbConn->lastInsertId();

                        $carpetaNuevaAlumno = '../clientes/' . $id_cliente;

                        $carpetaArchivosAlumno = '../clientes/' . $id_cliente . '/contratos';



                        if (!file_exists($carpetaNuevaAlumno)) {

                            mkdir($carpetaNuevaAlumno, 0777, true);
                        }



                        if (!file_exists($carpetaArchivosAlumno)) {

                            mkdir($carpetaArchivosAlumno, 0777, true);
                        }
                    } else {

                        $todoCorrecto = false;

                        break;
                    }
                }



                if ($todoCorrecto) {

                    header("HTTP/1.1 200 OK");

                    echo json_encode(['status' => 'success', 'message' => 'Todos los clientes se han agregado correctamente']);
                } else {

                    header("HTTP/1.1 200 OK");

                    echo json_encode(['status' => 'error', 'message' => 'Error al agregar uno o más clientes']);
                }
            } else {

                header("HTTP/1.1 400 Bad Request");

                echo json_encode(['status' => 'error', 'message' => 'Datos JSON inválidos o formato incorrecto']);
            }
        } catch (PDOException $e) {

            header("HTTP/1.1 500 Internal Server Error");

            echo json_encode(['status' => 'error', 'message' => 'Error de base de datos: ' . $e->getMessage()]);
        } catch (Exception $e) {

            header("HTTP/1.1 500 Internal Server Error");

            echo json_encode(['status' => 'error', 'message' => 'Error: ' . $e->getMessage()]);
        }

        exit();
    } elseif (

        isset($_POST["id_cliente_atributo"])

        && isset($_POST["valor"])

        && isset($_POST["atributo"])

    ) {

        $id_cliente_atributo = $_POST["id_cliente_atributo"];

        $valor = $_POST["valor"];

        $atributo = $_POST["atributo"];

        if ($valor === '') {

            $valor = null;
        }

        $sql = "UPDATE clientes SET $atributo = :valor WHERE client_id = :id_cliente_atributo";

        $statement = $dbConn->prepare($sql);

        $statement->bindValue(':id_cliente_atributo', $id_cliente_atributo);

        $statement->bindValue(':valor', $valor);



        $statement->execute();



        $input["id"] = $id_cliente_atributo;

        $input["valor"] = $valor;

        $input["atributo"] = $atributo;



        header("HTTP/1.1 200 OK");

        echo json_encode($input);

        exit();
    } elseif (

        isset($_POST["nombre"])

        && isset($_POST["sexo"])

        && isset($_POST["web"])

        && isset($_POST["tipo"])

        && isset($_POST["direccion"])

        && isset($_POST["telefono"])

        && isset($_POST["cp"])

        && isset($_POST["cif"])

        && isset($_POST["email"])

        && isset($_POST["fecha_nacimiento"])

        && isset($_POST["user_id"])

        && isset($_POST["emails"])

        && isset($_POST["id_poblacion"])

        && isset($_POST["id_sector"])

        && isset($_POST["linkedin"])

        && isset($_POST["instagram"])

        && isset($_POST["tiktok"])

        && isset($_POST["x"])

        && isset($_POST["facebook"])

        && isset($_POST["forma_juridica"])

        && isset($_POST["nombre_juridico"])

        && isset($_POST["cif_juridico"])

        && isset($_POST["domicilio_fiscal"])

        && isset($_POST["codigo_contable"])

        && isset($_POST["codigo_gestor"])

        && isset($_POST["codigo_tramitador"])

        && isset($_POST["movil"])

        && isset($_POST["terminos"])
  && isset($_POST["pais"])
        && isset($_POST["provincia"])
        && isset($_POST["localidad"])
        // Nuevo campo

    ) {

        try {

            $fecha = date('Y-m-d');

            $estado = 'Potencial';

            $peluqueria = "No";



            foreach ($_POST as $key => $value) {

                $value = ($value == "null") ? null : $value;

                $value = ($value == "Si") ? true : $value;

                $value = ($value == "No") ? false : $value;

                $value = ($value == "true") ? 1 : $value;

                $value = ($value == "false") ? 0 : $value;

                $value = ($value == "") ? null : $value;

                $$key = $value;
            }

            $sqlCheck = "SELECT COUNT(*) FROM clientes WHERE codigo = :codigo";

            if (isset($_POST["client_id"])) {

                $sqlCheck .= " AND client_id != :client_id";
            }



            $stmtCheck = $dbConn->prepare($sqlCheck);

            $stmtCheck->bindValue(':codigo', $codigo);

            if (isset($_POST["client_id"])) {

                $stmtCheck->bindValue(':client_id', $client_id);
            }

            $stmtCheck->execute();

            $count = $stmtCheck->fetchColumn();



            if ($count > 0) {



                header("HTTP/1.1 500 Internal Server Error");

                echo json_encode(["error" => "Error al ejecutar la consulta"]);

                exit();
            }

            if (isset($_POST["client_id"])) {

                $client_id = $_POST["client_id"];

                $sql = "UPDATE clientes SET 
   pais = :pais,
                        provincia = :provincia,
                        localidad = :localidad,
                nombre = :nombre,

                id_poblacion = :id_poblacion,

                tipo = :tipo,

                web = :web,

                sexo = :sexo,

                emails = :emails,

                direccion = :direccion,

                telefono = :telefono,

                cp = :cp,

                cif = :cif,

                email = :email,

                fecha = :fecha,

                codigo_contable = :codigo_contable,

                codigo_gestor = :codigo_gestor,

                codigo_tramitador = :codigo_tramitador,

                user_id = :user_id,

                id_sector = :id_sector,

                linkedin = :linkedin,

                instagram = :instagram,

                tiktok = :tiktok,

                x = :x,

                facebook = :facebook,

                forma_juridica = :forma_juridica,

                nombre_juridico = :nombre_juridico,

                cif_juridico = :cif_juridico,

                domicilio_fiscal = :domicilio_fiscal,

                estado = :estado,

                fecha_nacimiento = :fecha_nacimiento,

                codigo = :codigo,

                peluqueria = :peluqueria,

                movil = :movil,

                terminos = :terminos

                WHERE client_id = :client_id";



                $statement = $dbConn->prepare($sql);

                $statement->bindValue(':client_id', $client_id);
            } else {

                $sql = "INSERT INTO clientes

                (codigo_contable,

                codigo_gestor,

                codigo_tramitador,

                nombre,

                id_poblacion,

                direccion,

                tipo,

                telefono,

                web,

                sexo,

                cp,

                cif,

                email,

                fecha,

                user_id,

                id_sector,

                linkedin,

                instagram,

                tiktok,

                x,

                facebook,

                forma_juridica,

                nombre_juridico,

                cif_juridico,

                domicilio_fiscal,

                estado,

                emails,

                fecha_nacimiento,

                codigo,

                peluqueria,

                movil,

                terminos, pais, provincia, localidad)

                VALUES

                (:codigo_contable,

                :codigo_gestor,

                :codigo_tramitador,

                :nombre,

                :id_poblacion,

                :direccion,

                :tipo,

                :telefono,

                :web,

                :sexo,

                :cp,

                :cif,

                :email,

                :fecha,

                :user_id,

                :id_sector,

                :linkedin,

                :instagram,

                :tiktok,

                :x,

                :facebook,

                :forma_juridica,

                :nombre_juridico,

                :cif_juridico,

                :domicilio_fiscal,

                :estado,

                :emails,

                :fecha_nacimiento,

                :codigo,

                :peluqueria,

                :movil,

                :terminos, :pais, :provincia, :localidad)";





                $statement = $dbConn->prepare($sql);
            }



            // Bind valores
   $statement->bindValue(':pais', $pais);
            $statement->bindValue(':provincia', $provincia);
            $statement->bindValue(':localidad', $localidad);
            $statement->bindValue(':codigo', $codigo);

            $statement->bindValue(':tipo', $tipo);

            $statement->bindValue(':nombre', $nombre);

            $statement->bindValue(':id_poblacion', $id_poblacion);

            $statement->bindValue(':emails', $emails);

            $statement->bindValue(':sexo', $sexo);

            $statement->bindValue(':web', $web);

            $statement->bindValue(':direccion', $direccion);

            $statement->bindValue(':telefono', $telefono);

            $statement->bindValue(':cp', $cp);

            $statement->bindValue(':cif', $cif);

            $statement->bindValue(':email', $email);

            $statement->bindValue(':fecha', $fecha);

            $statement->bindValue(':user_id', $user_id);

            $statement->bindValue(':estado', $estado);

            $statement->bindValue(':fecha_nacimiento', $fecha_nacimiento);

            $statement->bindValue(':peluqueria', $peluqueria);

            $statement->bindValue(':codigo_contable', $codigo_contable);

            $statement->bindValue(':codigo_gestor', $codigo_gestor);

            $statement->bindValue(':codigo_tramitador', $codigo_tramitador);

            $statement->bindValue(':id_sector', $id_sector);

            $statement->bindValue(':linkedin', $linkedin);

            $statement->bindValue(':instagram', $instagram);

            $statement->bindValue(':tiktok', $tiktok);

            $statement->bindValue(':x', $x);

            $statement->bindValue(':facebook', $facebook);

            $statement->bindValue(':forma_juridica', $forma_juridica);

            $statement->bindValue(':nombre_juridico', $nombre_juridico);

            $statement->bindValue(':cif_juridico', $cif_juridico);

            $statement->bindValue(':domicilio_fiscal', $domicilio_fiscal);

            $statement->bindValue(':movil', $movil); // Nuevo campo

            $statement->bindValue(':terminos', $terminos); // Asocia el valor de 'terminos' con la consulta







            $statement->execute();

            if (!isset($_POST["client_id"])) {

                $id_cliente = $dbConn->lastInsertId();

                $carpetaNuevaAlumno = '../clientes/' . $id_cliente;

                $carpetaArchivosAlumno = '../clientes/' . $id_cliente . '/contratos';

                mkdir($carpetaNuevaAlumno, 0777, true);

                mkdir($carpetaArchivosAlumno, 0777, true);
            }

            if (isset($_FILES['archivos'])) {

                $archivos = $_FILES['archivos'];

                if (isset($_POST["client_id"])) {

                    $id_cliente = $_POST["client_id"];

                    $carpetaEliminar = '../clientes/' . $id_cliente . '/contratos';

                    eliminarContenidoCarpeta($carpetaEliminar);



                    for ($i = 0; $i < count($archivos['name']); $i++) {

                        $nombreArchivo = $archivos['name'][$i];

                        $tipoArchivo = $archivos['type'][$i];

                        $archivoTemporal = $archivos['tmp_name'][$i];

                        $tamañoArchivo = $archivos['size'][$i];





                        $Archivo = '../clientes/' . $id_cliente . '/contratos/' . $nombreArchivo;

                        move_uploaded_file($archivoTemporal, $Archivo);
                    }
                } else {







                    for ($i = 0; $i < count($archivos['name']); $i++) {

                        $nombreArchivo = $archivos['name'][$i];

                        $tipoArchivo = $archivos['type'][$i];

                        $archivoTemporal = $archivos['tmp_name'][$i];

                        $tamañoArchivo = $archivos['size'][$i];





                        $Archivo = '../clientes/' . $id_cliente . '/contratos/' . $nombreArchivo;

                        move_uploaded_file($archivoTemporal, $Archivo);
                    }
                }
            }





            $input["id"] = $id_cliente;

            $input["nombre"] = $nombre;

            $input["sexo"] = $sexo;

            $input["direccion"] = $direccion;

            $input["telefono"] = $telefono;

            $input["cp"] = $cp;

            $input["cif"] = $cif;

            $input["email"] = $email;

            $input["terminos"] = $terminos;

            header("HTTP/1.1 200 OK");

            echo json_encode($input);

            exit();
        } catch (PDOException $e) {

            // Manejar el error

            header("HTTP/1.1 500 Internal Server Error");

            echo "Error al ejecutar la consulta: " . $e->getMessage();

            exit();
        }
    } elseif (isset($_POST["client_id"]) && isset($_POST["sms_habilitado"])) {



        $client_id = $_POST["client_id"];

        $sms_habilitado = $_POST["sms_habilitado"];



        $sql = "UPDATE clientes SET sms_habilitado = :sms_habilitado WHERE client_id = :client_id";

        $statement = $dbConn->prepare($sql);

        $statement->bindValue(':client_id', $client_id);

        $statement->bindValue(':sms_habilitado', $sms_habilitado);



        $statement->execute();

        $object = [

            'id' => $client_id,

            'sms_habilitado' => $sms_habilitado,



        ];

        header("HTTP/1.1 200 OK");

        echo json_encode($object);

        exit();
    } elseif (isset($_POST['ids']) && isset($_POST['accion'])) {

        $ids = isset($_POST['ids']) ? $_POST['ids'] : null;

        $accion = isset($_POST['accion']) ? $_POST['accion'] : null;

        $email_marketing_value = ($accion === 'habilitar') ? 1 : 0;



        // Construir la consulta SQL

        $placeholders = implode(',', array_fill(0, count($ids), '?'));

        $sql = "UPDATE clientes SET email_marketing = ? WHERE client_id IN ($placeholders)";



        try {

            $stmt = $dbConn->prepare($sql);

            $params = array_merge([$email_marketing_value], $ids);

            $stmt->execute($params);



            if ($stmt->rowCount() > 0) {

                header("HTTP/1.1 200 OK");

                echo json_encode(['success' => true, 'message' => 'Clientes actualizados correctamente.']);
            } else {

                header("HTTP/1.1 404 Not Found");

                echo json_encode(['error' => 'No se encontraron clientes con los IDs proporcionados.']);
            }
        } catch (PDOException $e) {

            header("HTTP/1.1 500 Internal Server Error");

            echo json_encode(['error' => 'Error al actualizar los clientes.', 'details' => $e->getMessage()]);
        }

        exit();
    } elseif (isset($_POST['ids_sms']) && isset($_POST['accion'])) {

        $ids = isset($_POST['ids_sms']) ? $_POST['ids_sms'] : null;

        $accion = isset($_POST['accion']) ? $_POST['accion'] : null;

        $email_marketing_value = ($accion === 'habilitar') ? 1 : 0;



        // Construir la consulta SQL

        $placeholders = implode(',', array_fill(0, count($ids), '?'));

        $sql = "UPDATE clientes SET sms_habilitado = ? WHERE client_id IN ($placeholders)";



        try {

            $stmt = $dbConn->prepare($sql);

            $params = array_merge([$email_marketing_value], $ids);

            $stmt->execute($params);



            if ($stmt->rowCount() > 0) {

                header("HTTP/1.1 200 OK");

                echo json_encode(['success' => true, 'message' => 'Clientes actualizados correctamente.']);
            } else {

                header("HTTP/1.1 404 Not Found");

                echo json_encode(['error' => 'No se encontraron clientes con los IDs proporcionados.']);
            }
        } catch (PDOException $e) {

            header("HTTP/1.1 500 Internal Server Error");

            echo json_encode(['error' => 'Error al actualizar los clientes.', 'details' => $e->getMessage()]);
        }

        exit();
    }
}



//Borrar

if ($_SERVER['REQUEST_METHOD'] == 'DELETE') {

    $data = json_decode(file_get_contents('php://input'), true);

    if (isset($data['contrato_url'])) {

        $filePath = $data['contrato_url'];



        if (file_exists($filePath) && unlink($filePath)) {

            echo json_encode(['status' => 1, 'message' => 'Archivo eliminado exitosamente.']); // Archivo eliminado exitosamente

        } else {

            echo json_encode(['status' => 0, 'message' => 'Error al eliminar el archivo o archivo no existe.']); // Error al eliminar el archivo

        }
    } else {

        echo json_encode(['status' => 0, 'message' => 'Datos faltantes.']); // Datos faltantes

    }

    if (isset($_GET['id'])) {

        $id = $_GET['id'];

        $statement = $dbConn->prepare("DELETE FROM clientes where client_id=:id");

        $statement->bindValue(':id', $id);

        $statement->execute();

        header("HTTP/1.1 200 OK");

        $carpetaEliminar = '../clientes/' . $id;

        eliminarCarpeta($carpetaEliminar);

        exit();
    }
}



//Actualizar

if ($_SERVER['REQUEST_METHOD'] == 'PUT') {

    $input = $_GET;

    $postId = $input['id'];

    $fields = getParams($input);



    $sql = "

          UPDATE posts

          SET $fields

          WHERE id='$postId'

           ";



    $statement = $dbConn->prepare($sql);

    bindAllValues($statement, $input);



    $statement->execute();

    header("HTTP/1.1 200 OK");

    exit();
}

function eliminarCarpeta($rutaCarpeta)

{

    // Obtener una lista de archivos y subcarpetas dentro de la carpeta

    $archivos = glob($rutaCarpeta . '/*');



    // Eliminar cada archivo encontrado

    foreach ($archivos as $archivo) {

        if (is_file($archivo)) {

            unlink($archivo);
        } elseif (is_dir($archivo)) {

            eliminarCarpeta($archivo);
        }
    }



    // Eliminar la carpeta

    if (is_dir($rutaCarpeta)) {

        rmdir($rutaCarpeta);
    }
}

function eliminarContenidoCarpeta($carpeta)

{

    // Verificar si la carpeta existe

    // Obtener una lista de archivos y subcarpetas dentro de la carpeta

    $archivos = glob($carpeta . '/*');



    // Eliminar cada archivo encontrado

    foreach ($archivos as $archivo) {

        if (is_file($archivo)) {

            unlink($archivo);
        } elseif (is_dir($archivo)) {

            eliminarCarpeta($archivo);
        }
    }







    return true; // Contenido de la carpeta eliminado con éxito

}

//En caso de que ninguna de las opciones anteriores se haya ejecutado

header("HTTP/1.1 400 Bad Request");