<?php



include "utils.php";



$dbConn = connect($db);

$personalizacion = json_decode(file_get_contents('../personalizacion.json'), true);

/*

listar todos los posts o solo uno

 */

if ($_SERVER['REQUEST_METHOD'] == 'GET') {



    if (isset($_GET['id_cita'])) {
        // Mostrar una cita específica
        $sql = $dbConn->prepare("
        SELECT 
            citas.*, 
            clientes.nombre AS cliente,
            users.user_full_name AS usuario,
            servicio.nombre AS servicio,
                users.color AS user_color
        FROM 
            citas
        INNER JOIN 
            clientes ON citas.client_id = clientes.client_id
        INNER JOIN 
            users ON citas.user_id = users.user_id
        INNER JOIN 
            servicio ON citas.id_servicio = servicio.id_servicio
        WHERE 
            id_cita = :id_cita
    ");

        $sql->bindValue(':id_cita', $_GET['id_cita']);
        $sql->execute();
        $cita = $sql->fetch(PDO::FETCH_ASSOC);

        // Determinar el color según estado
       $color = $cita['user_color'] ?? htmlentities($personalizacion["color_elementos"], ENT_QUOTES);

        // Estructura de respuesta compatible con FullCalendar
        $cita2 = [
            'id' => $cita['id_cita'],
            'title' => $cita['servicio'],
            'start' => $cita['fecha_i'],
            'end' => $cita['fecha_f'],
            'color' => $color,
            'extendedProps' => [
                'usuario' => $cita['usuario'],
                'cliente' => $cita['cliente'],
                'servicio' => $cita['servicio'],
                'estado' => $cita['estado'],
                'user_id' => $cita['user_id'],
                'tiempo' => $cita['tiempo'],
                'id_servicio' => $cita['id_servicio'],
                'color' => $color,
                'client_id' => $cita['client_id']
            ]
        ];

        header("HTTP/1.1 200 OK");
        echo json_encode($cita2);
        exit();
    } else {
        $sql = $dbConn->prepare("
    SELECT 
        citas.*, 
        users.user_full_name AS usuario,
        clientes.nombre AS cliente,
        servicio.nombre AS servicio,
            users.color AS user_color
    FROM 
        citas
    INNER JOIN 
        users ON citas.user_id = users.user_id
    INNER JOIN 
        clientes ON citas.client_id = clientes.client_id
    INNER JOIN 
        servicio ON citas.id_servicio = servicio.id_servicio
");
        $sql->execute();
        $sql->setFetchMode(PDO::FETCH_ASSOC);
        $datos = $sql->fetchAll();

        $eventos = [];
        $totalCitas = 0;
        $citasHoy = 0;
        $citasFuturas = 0;

        $hoy = date('Y-m-d');

        foreach ($datos as $cita) {
            $totalCitas++;

            $fechaInicio = date('Y-m-d', strtotime($cita['fecha_i']));

            if ($fechaInicio == $hoy) {
                $citasHoy++;
            } elseif ($fechaInicio > $hoy) {
                $citasFuturas++;
            }

            // Color por estado
           $color = $cita['user_color'] ?? htmlentities($personalizacion["color_elementos"], ENT_QUOTES);

            $eventos[] = [
                'id' => $cita['id_cita'],
                'title' => $cita['cliente'] . ' - ' . $cita['servicio'],
                'start' => $cita['fecha_i'],
                'end' => date('Y-m-d\TH:i:s', strtotime($cita['fecha_f'])),
                'color' => $color,

                "backgroundColor" => $color,
                "borderColor" => $color,
                'extendedProps' => [
                    'usuario' => $cita['usuario'],
                    'cliente' => $cita['cliente'],
                    'servicio' => $cita['servicio'],
                    'estado' => $cita['estado'],
                    'user_id' => $cita['user_id'],
                    'tiempo' => $cita['tiempo'],
                    'color' => $color,
                    'client_id' => $cita['client_id'],
                    'id_servicio' => $cita['id_servicio']
                ]
            ];
        }

        header('Content-Type: application/json');
        echo json_encode([
            'eventos' => $eventos,
            'totales' => [
                'total' => $totalCitas,
                'hoy' => $citasHoy,
                'futuras' => $citasFuturas
            ]
        ]);
        exit;
    }
}















// Crear un nuevo post

if ($_SERVER['REQUEST_METHOD'] == 'POST') {

if (isset($_POST["user_id"]) && isset($_POST["color"])) {
    $user_id = $_POST["user_id"];
    $color = $_POST["color"];

    try {
        $sql = "UPDATE users SET color = :color WHERE user_id = :user_id";
        $statement = $dbConn->prepare($sql);
        $statement->bindValue(':color', $color);
        $statement->bindValue(':user_id', $user_id);
        $statement->execute();

        $response = array(
            'success' => true,
            'title' => 'Color actualizado',
            'message' => 'El color del usuario se ha actualizado correctamente.'
        );

        header("HTTP/1.1 200 OK");
        echo json_encode($response);
        exit();
    } catch (PDOException $e) {
        $response = array(
            'success' => false,
            'title' => "Error al actualizar color",
            'message' => "Hubo un problema al actualizar el color: " . $e->getMessage()
        );

        header("HTTP/1.1 200 OK");
        echo json_encode($response);
        exit();
    }
}


    if (
        isset($_POST["fecha_i"]) &&
        isset($_POST["fecha_f"]) &&
        isset($_POST["user_id"]) &&
        isset($_POST["id_servicio"]) &&
        isset($_POST["client_id"]) &&
        isset($_POST["estado"]) &&
        isset($_POST["tiempo"])
    ) {
        foreach ($_POST as $key => $value) {
            $value = ($value == "") ? null : $value;
            $value = ($value == "No") ? null : $value;
            $$key = $value;
        }

        try {

            if (isset($_POST["id_cita"])) {
                // UPDATE
                $id_cita = $_POST["id_cita"];
                $sql = "UPDATE citas SET 
                        client_id = :client_id,
                        id_servicio = :id_servicio,
                         fecha_i = :fecha_i,
                        fecha_f = :fecha_f,
                        user_id = :user_id,
                        estado = :estado,
                        tiempo = :tiempo
                    WHERE id_cita = :id_cita";
                $statement = $dbConn->prepare($sql);
                $statement->bindValue(':id_cita', $id_cita);
            } else {
                // INSERT
                $sql = "INSERT INTO citas
                        (tiempo,client_id, id_servicio,fecha_i, fecha_f, user_id, estado)
                    VALUES
                        (:tiempo,:client_id, :id_servicio,:fecha_i, :fecha_f, :user_id, :estado)";
                $statement = $dbConn->prepare($sql);
            }

            // Valores comunes para ambas operaciones
            $statement->bindValue(':tiempo', $tiempo);
            $statement->bindValue(':client_id', $client_id);
            $statement->bindValue(':id_servicio', $id_servicio);
            $statement->bindValue(':fecha_i', $fecha_i);
            $statement->bindValue(':fecha_f', $fecha_f);
            $statement->bindValue(':user_id', $user_id);
            $statement->bindValue(':estado', $estado);

            $statement->execute();

            $response = array(
                'success' => true,
                'title' => isset($id_cita) ? 'Cita actualizada.' : 'Cita registrada.',
                'message' => isset($id_cita)
                    ? 'La cita se ha actualizado correctamente.'
                    : 'La cita se ha registrado correctamente.'
            );

            header("HTTP/1.1 200 OK");
            echo json_encode($response);
            exit();
        } catch (PDOException $e) {
            $response = array(
                'success' => false,
                'title' => "Error en la operación.",
                'message' => "Hubo un problema al guardar los datos: " . $e->getMessage()
            );

            header("HTTP/1.1 200 OK");
            echo json_encode($response);
            exit();
        }
    }
}





if ($_SERVER['REQUEST_METHOD'] == 'DELETE') {

    $id = $_GET['id_cita'];

    $statement = $dbConn->prepare("DELETE FROM citas where id_cita =:id");

    $statement->bindValue(':id', $id);

    $statement->execute();

    header("HTTP/1.1 200 OK");

    exit();
}



//Actualizar

if ($_SERVER['REQUEST_METHOD'] == 'PUT') {

    $input = $_GET;

    $postId = $input['id'];

    $fields = getParams($input);



    $sql = "

          UPDATE posts

          SET $fields

          WHERE id='$postId'

           ";



    $statement = $dbConn->prepare($sql);

    bindAllValues($statement, $input);



    $statement->execute();

    header("HTTP/1.1 200 OK");

    exit();
}



//En caso de que ninguna de las opciones anteriores se haya ejecutado

header("HTTP/1.1 400 Bad Request");