<?php

include "utils.php";

$dbConn = connect($db);

// GET: obtener uno o todos los camiones
if ($_SERVER['REQUEST_METHOD'] == 'GET') {
    if (isset($_GET['recordatorios_camiones'])) {
        if (isset($_GET['id_camion'])) {
            $sql = $dbConn->prepare("SELECT * FROM recordatorios_camiones WHERE id_camion = :id_camion");
            $sql->bindValue(':id_camion', $_GET['id_camion']);
        } else {
            $sql = $dbConn->prepare("SELECT * FROM recordatorios_camiones");
        }

        $sql->execute();
        $sql->setFetchMode(PDO::FETCH_ASSOC);

        header("HTTP/1.1 200 OK");
        echo json_encode($sql->fetchAll());
        exit();
    }
    if (isset($_GET['id_camion_archivos'])) {

        $id_factura_proveedor = $_GET["id_camion_archivos"];

        $images = glob('../archivos/camiones/' . $id_factura_proveedor . '/*.{png,jpg,pdf}', GLOB_BRACE);

        $fileObjects = array();

        foreach ($images as $image) {

            $fileInfo = pathinfo($image);

            $fileObject = new stdClass(); // Crear un objeto vacío para almacenar los datos

            $fileObject->url = $image; // Almacenar la URL del archivo

            $fileObject->extension = $fileInfo['extension']; // Almacenar la extensión del archivo

            $fileObject->nombre = $fileInfo['basename']; // Almacenar la extensión del archivo

            $fileObjects[] = $fileObject; // Agregar el objeto al arreglo

        }

        header("HTTP/1.1 200 OK");

        echo json_encode($fileObjects);

        exit();
    }
    if (isset($_GET['id_camion'])) {
        // Obtener un solo camión
        $sql = $dbConn->prepare("SELECT * FROM camiones WHERE id_camion = :id_camion");
        $sql->bindValue(':id_camion', $_GET['id_camion']);
        $sql->execute();

        header("HTTP/1.1 200 OK");
        echo json_encode($sql->fetch(PDO::FETCH_ASSOC));
        exit();
    } else if (isset($_GET['calendario'])) {
        $intervalos = [];

        // Revisar si hay filtro por id_camion y si no es "No"
        if (isset($_GET['id_camion_calendario']) && $_GET['id_camion_calendario'] !== "No") {
            $id_camion_filtro = $_GET['id_camion_calendario'];
            $sql = $dbConn->prepare("SELECT * FROM eventos2 WHERE id_camion = :id_camion");
            $sql->bindParam(':id_camion', $id_camion_filtro);
            $sql->execute();
        } else {
            // Si no hay filtro o es "No", devolver todos
            $sql = $dbConn->prepare("SELECT * FROM eventos2");
            $sql->execute();
        }

        $sql->setFetchMode(PDO::FETCH_ASSOC);
        $eventos = $sql->fetchAll();

        foreach ($eventos as $evento2) {
            $matricula = "Ninguno";

            if (!empty($evento2['id_camion'])) {
                // Obtener información del camión si existe
                $sqlCamion = $dbConn->prepare("SELECT * FROM camiones WHERE id_camion = :id_camion");
                $sqlCamion->bindParam(':id_camion', $evento2['id_camion']);
                $sqlCamion->execute();
                $camion = $sqlCamion->fetch(PDO::FETCH_ASSOC);

                if ($camion && isset($camion['matricula'])) {
                    $matricula = $camion['matricula'];
                }
            }

            // Parsear días
            $dias = json_decode($evento2['dias'], true);
            if (!$dias || count($dias) === 0) continue;

            // Ordenar días
            sort($dias);

            // Agrupar días consecutivos
            $grupo = [];
            for ($i = 0; $i < count($dias); $i++) {
                $grupo[] = $dias[$i];

                $actual = strtotime($dias[$i]);
                $siguiente = isset($dias[$i + 1]) ? strtotime($dias[$i + 1]) : null;

                if (!$siguiente || $siguiente !== strtotime('+1 day', $actual)) {
                    $intervalos[] = [
                        'id' => $evento2['id_evento'],
                        'title' => $matricula,
                        'start' => $grupo[0],
                        'end' => date('Y-m-d', strtotime(end($grupo) . ' +1 day')),
                        'color' => '#000000',
                        'extendedProps' => [
                            'tipo' => 'eventos',
                            'tipo2' => 'eventos',
                            'descripcion' => $evento2['nombre']
                        ]
                    ];
                    $grupo = [];
                }
            }
        }

        header("HTTP/1.1 200 OK");
        echo json_encode($intervalos);
        exit();
    }else if (isset($_GET['calendariocamiones'])) {
        $intervalos = [];

            // Si no hay filtro o es "No", devolver todos
            $sql = $dbConn->prepare("SELECT * FROM camiones");
            $sql->execute();
        

        $sql->setFetchMode(PDO::FETCH_ASSOC);
        $camiones = $sql->fetchAll();

        foreach ($camiones as $c) {
            $matricula = "Ninguno";

         
                    $intervalos[] = [
                        'id' => $c['id_camion'],
                        'title' => $c['matricula'],
                       
                        'start' => date('Y-m-d', strtotime($c['itv'])),
                        'end' => date('Y-m-d', strtotime($c['itv'] . ' +1 day')),
                        'color' => '#000000',
                        'extendedProps' => [
                            'tipo' => 'camiones',
                            'tipo2' => 'camiones',
                            'descripcion' => $c['id_camion']
                        ]
                    ];
                    $grupo = [];
                

             
            
        }

        header("HTTP/1.1 200 OK");
        echo json_encode($intervalos);
        exit();
    } else {
        // Listar todos los camiones
        $sql = $dbConn->prepare("SELECT * FROM camiones");
        $sql->execute();
        $sql->setFetchMode(PDO::FETCH_ASSOC);

        header("HTTP/1.1 200 OK");
        echo json_encode($sql->fetchAll());
        exit();
    }
}

// POST: crear nuevo camión
if ($_SERVER['REQUEST_METHOD'] == 'POST') {
        // ➕ Crear nuevo recordatorio de camión
    if (
        isset($_POST['fecha']) &&
        isset($_POST['hora']) &&
        isset($_POST['id_camion']) &&
        isset($_POST['estado']) &&
        isset($_POST['asunto']) &&
        isset($_POST['cuerpo'])
    ) {
        $sql = "INSERT INTO recordatorios_camiones (fecha, hora, id_camion, estado, asunto, cuerpo)
                VALUES (:fecha, :hora, :id_camion, :estado, :asunto, :cuerpo)";
        $stmt = $dbConn->prepare($sql);
        $stmt->bindValue(':fecha', $_POST['fecha']);
        $stmt->bindValue(':hora', $_POST['hora']);
        $stmt->bindValue(':id_camion', $_POST['id_camion']);
        $stmt->bindValue(':estado', $_POST['estado']);
        $stmt->bindValue(':asunto', $_POST['asunto']);
        $stmt->bindValue(':cuerpo', $_POST['cuerpo']);

        $stmt->execute();

        $response = [
            'id_recordatorio' => $dbConn->lastInsertId(),
            'accion' => 'recordatorio_creado'
        ];

        header("HTTP/1.1 200 OK");
        echo json_encode($response);
        exit();
    }

    if (

        isset($_POST["id_camion_archivos"]) && isset($_FILES['archivo']) && isset($_POST['extension'])

        && isset($_POST['nombre'])

    ) {

        $nombre = $_POST["nombre"];

        $extension = $_POST["extension"];

        $id_factura_proveedor = $_POST["id_camion_archivos"];

        $archivo = $_FILES['archivo'];

        $baseUrl = ($_SERVER['HTTPS'] ? 'https://' : 'http://') . $_SERVER['HTTP_HOST'] . '/';

        $rutaArchivoTemporal = isset($_FILES['archivo']) ? $_FILES['archivo']['tmp_name'] : null;

        $Archivo = '../archivos/camiones/' . $id_factura_proveedor . '/' . $nombre . '.' . $extension;

        if (file_exists($Archivo)) {

            header("HTTP/1.1 200 OK");

            echo 0;

            exit();
        } else {

            if ($rutaArchivoTemporal && !empty($rutaArchivoTemporal)) {

                move_uploaded_file($rutaArchivoTemporal, $Archivo);
            }

            header("HTTP/1.1 200 OK");

            exit();
        }
    }
    if (isset($_POST["matricula"])) {
        $matricula = $_POST["matricula"];
        $itv = isset($_POST["itv"]) ? $_POST["itv"] : null;

        if (isset($_POST["id_camion"])) {
            // 🔄 UPDATE si viene id_camion
            $id = $_POST["id_camion"];

            $sql = "UPDATE camiones SET matricula = :matricula, itv = :itv WHERE id_camion = :id";
            $statement = $dbConn->prepare($sql);

            $statement->bindValue(':matricula', $matricula);
            $statement->bindValue(':itv', $itv);
            $statement->bindValue(':id', $id);

            $statement->execute();

            $response = [
                'id_camion' => $id,
                'matricula' => $matricula,
                'itv' => $itv,
                'accion' => 'actualizado'
            ];
        } else {
            // ➕ INSERT si no viene id_camion
            $sql = "INSERT INTO camiones (matricula, itv) VALUES (:matricula, :itv)";
            $statement = $dbConn->prepare($sql);

            $statement->bindValue(':matricula', $matricula);
            $statement->bindValue(':itv', $itv);

            $statement->execute();

            $id = $dbConn->lastInsertId();

            $response = [
                'id_camion' => $id,
                'matricula' => $matricula,
                'itv' => $itv,
                'accion' => 'creado'
            ];
        }
        if (!isset($_POST["id_camion"])) {
            $carpetaNuevaAlumno = '../archivos/camiones/' . $dbConn->lastInsertId();

            mkdir($carpetaNuevaAlumno, 0777, true);
        }
        header("HTTP/1.1 200 OK");
        echo json_encode($response);
        exit();
    }
}

// DELETE: eliminar camión
if ($_SERVER['REQUEST_METHOD'] == 'DELETE') {
  
    
    if (isset($_GET['id_recordatorio'])) {
        $id = $_GET['id_recordatorio'];

        $stmt = $dbConn->prepare("DELETE FROM recordatorios_camiones WHERE id_recordatorio = :id");
        $stmt->bindValue(':id', $id);
        $stmt->execute();

        header("HTTP/1.1 200 OK");
        echo json_encode(['accion' => 'recordatorio_eliminado']);
        exit();
    }

    if (isset($_GET['id'])) {
        $id = $_GET['id'];
        $statement = $dbConn->prepare("DELETE FROM camiones WHERE id_camion = :id");
        $statement->bindValue(':id', $id);
        $statement->execute();
        $carpetaEliminar = '../archivos/camiones/' . $id;

        eliminarCarpeta($carpetaEliminar);
        header("HTTP/1.1 200 OK");
        exit();
    }
    if (isset($_GET["url"])) {

        $url = $_GET['url'];

        $carpetaEliminar = '.' . $url;

        header("HTTP/1.1 200 OK");

        unlink($carpetaEliminar);

        echo $carpetaEliminar;

        exit();
    }
}

// PUT: actualizar camión
if ($_SERVER['REQUEST_METHOD'] == 'PUT') {

    parse_str(file_get_contents("php://input"), $input);

    if (isset($input['id'])) {
        $id = $input['id'];

        $fields = [];
        if (isset($input['matricula'])) $fields['matricula'] = $input['matricula'];
        if (isset($input['itv'])) $fields['itv'] = $input['itv'];

        $setClause = implode(", ", array_map(fn($k) => "$k = :$k", array_keys($fields)));

        $sql = "UPDATE camiones SET $setClause WHERE id_camion = :id";

        $statement = $dbConn->prepare($sql);
        $statement->bindValue(':id', $id);
        foreach ($fields as $key => $value) {
            $statement->bindValue(":$key", $value);
        }

        $statement->execute();

        header("HTTP/1.1 200 OK");
        exit();
    }
}
function eliminarCarpeta($rutaCarpeta)

{

    // Obtener una lista de archivos y subcarpetas dentro de la carpeta

    $archivos = glob($rutaCarpeta . '/*');

    // Eliminar cada archivo encontrado

    foreach ($archivos as $archivo) {

        if (is_file($archivo)) {

            unlink($archivo);
        } elseif (is_dir($archivo)) {

            eliminarCarpeta($archivo);
        }
    }

    // Eliminar la carpeta

    if (is_dir($rutaCarpeta)) {

        rmdir($rutaCarpeta);
    }
}
// Si no coincide ninguna petición válida
header("HTTP/1.1 400 Bad Request");